/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/data/RCS/xemprc.c,v 5.2 1995/09/08 07:15:54 jpo Exp $
    $Date: 1995/09/08 07:15:54 $
    $Author: jpo $
    $Id: xemprc.c,v 5.2 1995/09/08 07:15:54 jpo Exp $
    $Locker:  $
    $Log: xemprc.c,v $
    Revision 5.2  1995/09/08 07:15:54  jpo
    cost stuff

 * Revision 5.1  93/03/14  16:46:47  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:22:34  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:35:48  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "xrc.h"

#ifdef TERMC_VERSION
#include "tc_type.h"
#endif /* VERSION */

static bool AssignDo (line)
char * line;
{
	char word [50];
	char * ptr;
	int stat;

	ptr = index (line, '=');
	if (ptr == (char *) 0)
		return False;
	
	ptr ++;
	if (! ScanFmt ((ConstVP)& ptr, word, "a-zA-Z"))
		return False;

	if (StrEQ (word, "Confirm") || StrEQ (word, "confirm"))
		stat = DO_CONFIRM;
	else if (StrEQ (word, "Yes") || StrEQ (word, "yes"))
		stat = DO_YES;
	else if (StrEQ (word, "No") || StrEQ (word, "no"))
		stat = DO_NO;
	else
		return False;
	
	if (StrEQ (line, "Keep announce"))
		xrc. keep_announce = stat;
	else if (StrEQ (line, "Keep send"))
		xrc. keep_send = stat;
	else if (StrEQ (line, "Delete mailbox"))
		xrc. delete_mail = stat;
	else if (StrEQ (line, "Rescan show"))
		xrc. rescan_show = stat == DO_YES;
	else if (StrEQ (line, "Rescan sonar"))
		xrc. rescan_sonar = stat == DO_YES;
	else if (StrEQ (line, "Rescan land radar"))
		xrc. rescan_land_radar = stat == DO_YES;
	else if (StrEQ (line, "Rescan ship radar"))
		xrc. rescan_ship_radar = stat == DO_YES;
	else if (StrEQ (line, "Rescan lookout"))
		xrc. rescan_lookout = stat == DO_YES;
	else if (StrEQ (line, "Rescan coastwatch"))
		xrc. rescan_coastwatch = stat == DO_YES;
	else if (StrEQ (line, "Rescan satellite"))
		xrc. rescan_satellite = stat == DO_YES;
	else if (StrEQ (line, "Include planes not at airfield"))
		xrc. dist_planes = stat == DO_YES;
	else if (StrEQ (line, "Compress"))
		xrc. compress = stat == DO_YES;
	else if (StrEQ (line, "Silent timeout"))
		xrc. silent_timeout = stat == DO_YES;
	else if (StrEQ (line, "Space is next"))
		xrc. space_is_next = stat == DO_YES;
	else
		return False;

	return True;
}
	

static bool AssignString (line)
char * line;
{
	char * ptr;
	char word [50];
	int sx, sy;

	ptr = index (line, '=');
	if (ptr == (char *) 0)
		return False;
	
	ptr ++;
	SkipBlank ((ConstVP)& ptr);
	if (! ScanFmt ((ConstVP)& line, word, "-A-Za-z_"))
		return False;

	if (strcmp (word, "Progdir") == 0)
		xrc. progdir = Str (ptr);
	else if (strcmp (word, "Font") == 0)
		xrc. normal_font = Str (ptr);
	else if (strcmp (word, "Bold") == 0)
		xrc. bold_font = Str (ptr);
	else if (strcmp (word, "Player") == 0)
		xrc. player = Str (ptr);
	else if (strcmp (word, "Country") == 0)
		xrc. country = Str (ptr);
	else if (strcmp (word, "Mapwindow") == 0)
		xrc. map_win_size = Str (ptr);
	else if (strcmp (word, "Empirewindow") == 0)
		xrc. emp_win_size = Str (ptr);
	else if (strcmp (word, "Port") == 0)
		xrc. port = Str (ptr);
	else if (strcmp (word, "Host") == 0)
		xrc. host = Str (ptr);
	else if (strcmp (word, "Savelines") == 0)
		xrc. savelines = Str (ptr);
	else if (strcmp (word, "Worldsize") == 0)
		xrc. worldsize = Str (ptr);
	else if (strcmp (word, "Timeout") == 0)
		xrc. timeout = atoi (ptr);
	else if (strcmp (word, "Signature") == 0)
		xrc. signature = Str (ptr);
	else if (strcmp (word, "Capab") == 0)
		xrc. capab = Str (ptr);
	else if (strcmp (word, "Savefile") == 0)
		xrc. savefile = Str(ptr);
	else if (strcmp (word, "Savedir") ==0)
		xrc. savedir = Str(ptr);

	else if (strcmp (word, "Move-prefix") == 0)
	{
#ifdef TERMC_VERSION
		move_prefix = * ptr;
#endif /* TERMC_VERSION */
		;
	}
	else if (strcmp (word, "Buffer") == 0)
	{
		if (strcmp (ptr, "Off") == 0)
			xrc. buffering = NORMAL_STATE;
		else if (strcmp (ptr, "On") == 0)
			xrc. buffering = BUFFER_STATE;
		else if (strcmp (ptr, "Force") == 0)
			xrc. buffering = FORCE_BUF_STATE;
		else 
			(void) fprintf (stderr, "Buffer=[On | Off | Force]\n");
	}
	else if (strcmp (word, "Position") == 0)
	{
		if (sscanf (ptr, " %d, %d", & sx, & sy) != 2)
			(void) fprintf (stderr, "Position=x,y\n");
		else 
		{
			xrc. startup_x = sx;
			xrc. startup_y = sy;
		}
	}
	else
		return False;
	
	return True;
}

void ReadRc ()
{
	FILE * fp;
	char * home;
	char * ptr;
	char * term;
	char buffer [BUFSIZ],
	     word [BUFSIZ],
	     key [BUFSIZ];

	xrc. keep_announce = DO_CONFIRM;
	xrc. keep_send = DO_CONFIRM;
	xrc. delete_mail = DO_CONFIRM;
	xrc. dist_planes = DO_YES;
	xrc. compress = DO_YES;
	xrc. silent_timeout = DO_YES;
	xrc. rescan_coastwatch =
		xrc. rescan_lookout = True;
	xrc. rescan_show = 
		xrc. rescan_land_radar =
		xrc. rescan_ship_radar =
		xrc. space_is_next =
		xrc. rescan_sonar = False;
	xrc. timeout = 60;
	xrc. startup_x = 2;
	xrc. startup_y = 2;
	xrc. buffering = NORMAL_STATE;
	xrc. country =
		xrc. player =
		xrc. normal_font =
		xrc. bold_font =
		xrc. map_win_size =
		xrc. emp_win_size =
		xrc. port =
		xrc. host =
		xrc. savelines =
		xrc. worldsize =
 		xrc. savefile =
 		xrc. savedir =
		xrc. signature = (char *) 0;
	xrc. progdir = "./";

	home = getenv ("HOME");
	if (home == (char *) 0)
		return;

	fp = fopen (".xemprc", "r");
	if (fp == (FILE *) 0)
	{
		fp = fopen (Fmt ("%s/.xemprc", home), "r");
		if (fp == (FILE *) 0)
			return;
	}
	while (fgets (buffer, BUFSIZ, fp) != (char *) 0)
	{
		if (* buffer == '#')
			continue;

		if (strlen (buffer) == 1)	/* newline */
			continue;

		NoNl (buffer);
		ptr = buffer;

		if (strncmp (buffer, "TC ", 3) == 0)
#ifdef X_VERSION
			continue;
#else /* TERMC_VERSION */
			ptr += 3;
#endif /* VERSION */
		else if (strncmp (buffer, "X ", 2) == 0)
#ifdef X_VERSION
			ptr += 2;
#else /* TERMC_VERSION */
			continue;
#endif /* VERSION */

		if (strncmp (ptr, "Coun (", 6) == 0)
		{
			if (cname == (char *) 0)
				continue;
			
			if (strncmp (ptr + 6, cname, strlen (cname)) != 0)
				continue;

			if (buffer [strlen (cname) + 6] != ')')
				continue;
			
			ptr = index (buffer, ')') + 2;
		}

		if (strncmp (ptr, "Term (", 6) == 0)
		{
			term = getenv ("TERM");
			if (term == (char *) 0)
				continue;
			
			if (strncmp (ptr + 6, term, strlen (term)) != 0)
				continue;

			
			if (* (ptr + strlen (term) + 6) != ')')
				continue;
			
			ptr = index (buffer, ')') + 2;
		}

		if (AssignString (ptr))
			continue;

		if (AssignDo (ptr))
			continue;

		if (! ScanWord ((ConstVP)& ptr, word))
			continue;

		if (strcmp (word, "Bind") == 0)
		{
			/*
			 *	usage: Bind ^A to center map
			 */
			
			if (! ScanWordQuot ((ConstVP)& ptr, key) ||
			    ! ScanWord ((ConstVP)& ptr, word) ||
			    strcmp (word, "to") != 0)
			{
				fprintf (stderr, "Bad line in .xemprc: %s\n",
						buffer);
				fprintf (stderr, "Example: Bind Z to quit\n");
				continue;
			}

			SkipBlank ((ConstVP)& ptr);

			ptr = AddBindingKey (key, ptr);

			if (ptr != (char *) 0)
			{
				fprintf (stderr,
					"Incorrect Bind line in .xemprc: %s\n",
					ptr);
				fprintf (stderr,
					"Line: %s\n", buffer);
			}
		}
		else
		{
			fprintf (stderr, "Bad line in .xemprc: %s\n", buffer);
			continue;
		}
	}

	fclose (fp);
}
