/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/commands/RCS/demob.c,v 5.2 1995/09/08 07:07:14 jpo Exp $
    $Date: 1995/09/08 07:07:14 $
    $Author: jpo $
    $Id: demob.c,v 5.2 1995/09/08 07:07:14 jpo Exp $
    $Locker:  $
    $Log: demob.c,v $
    Revision 5.2  1995/09/08 07:07:14  jpo
    fix for prototypes

 * Revision 5.1  93/03/14  16:44:02  etienne
 * fixed small bug, shows now correct numbers.
 * 
 * Revision 5.0  93/02/06  09:18:04  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:32:23  greyhelm
 * Client for ASCII /X Empire client
 * Added RCS header - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "sector.h"
#include "nation.h"

static char last_reser;
static int last_quant;

void RedoDemob ()
{
	DoDemob (CrdStr (cursct), last_quant, last_reser);
}

	/* ARGSUSED */
void BindDemob (x, y, str)		/* demob (#, yn) */
int x, y;
char * str;
{
	int nr;
	int number;
	char reser [5];
	char * ans;

	if (str == (char *) 0)
		SingleDemob ();
	else
	{
		nr = sscanf (str, " ( %d , %s ) ", & number, reser);
		
		switch (nr)
		{

		case 0:
			SingleDemob ();
			return;

		case 1:
			ans = InputAtMessage (
				"New civilians on active reserve [y]: ", 
				1, GS_YN);

			if (ans == (char *) 0 || interrupt)
			{
				Message ("Demobilize cancelled");
				interrupt = False;
				return;
			}

			DoDemob (CrdStr (cursct), number,
					* ans == '\0' ? 'y' : * ans);
			return;

		case 2:
			if (* reser != 'y' && * reser != 'n')
			{
				Message ("Incorrect binding 'demob (#, [yn])'");
				Bell ();
				return;
			}

			DoDemob (CrdStr (cursct), number, * reser);
			return;
		}
	}
}

void DoDemob (realm, number, reser)
char * realm;
int number;
char reser;
{
	int x, y;
	int sx, ex, sy, ey;
	int nr, newv;
	char * ptr;
	Sector sct;
	int tot_demob, deltamil;
	char * ans;

	tot_demob = 0;
	SetAgain (RedoDemob);
	last_quant = number;
	last_reser = reser;

	if (command_state == TEST_STATE || command_state == FORCE_BUF_STATE)
	{
		if (command_state == FORCE_BUF_STATE)
			FeedCommand (Fmt ("demobilize %s %d %s",
						realm,
						number,
						reser == 'y' ? "yes" : "no"),
				     PRINT);

		(void) ConvRealmToCoord (realm, & sx, & sy, & ex, & ey);
		for (y = sy; y <= ey; y ++)
			for (x = sx; x <= ex; x ++)
			{
				sct = World (x, y, S_EXIST);
				if (sct == (Sector) 0 || ! s_owned (sct)
						      || s_eff (sct) < 60
						      || s_occ (sct) == '*')
					continue;

				if (number < 0)
					deltamil = s_mil (sct) + number;
				else
				{
					deltamil = s_mil (sct);
					if (deltamil > number)
						deltamil = number;
				}
				
				if (deltamil <= 0)
					continue;

				tot_demob += deltamil;
				set_civ (sct, s_civ (sct) + deltamil);
				set_mil (sct, s_mil (sct) - deltamil);

				if (reser == 'y')
					n_mil_res (nation) += (long) deltamil;
			}

		DrawMapPart (sx, sy, ex, ey);
		if (tot_demob == 0)
		  Message ("No eligible sectors/military for demobilization\n");
		else
			Message (Fmt ("Total new civilians: %d", tot_demob));
		return;
	}

	FeedEmpire (Fmt ("demobilize %s %d %c", realm, number, reser), PRINT);

	for (;;)
	{
		ptr = ReadEmpire (PRINT);
		if (EmpireStatus () == E_COMMAND)
		{
			PrintAtEmpire (ptr);
			break;
		}
		else if (EmpireStatus () == E_QUESTION)	/* treaty violation */
		{
			PrintAtEmpire (ptr);
			ans = InputAtMessage (ptr, 10, GS_TEXT);
			if (ans == (char *) 0 || interrupt)
			{
				interrupt = False;
				FeedEmpire ("aborted", PRINT);
				(void) WaitForPrompt (PRINT);
				return;
			}

			FeedEmpire (ans, PRINT);
			continue;
		}

		if (StrEQ (ptr, "No eligible sectors"))
		{
			Bell ();
			Message (ptr);
			continue;
		}


		if (sscanf (ptr, "%d demobilized in %d,%d (%d mil left)",
			& nr, & x, & y, & newv) == 4)
		{
			Message (ptr);
			tot_demob += nr;

			sct = World (x, y, S_EXIST);

			if (sct == (Sector) 0)
				continue;
			
			set_mil (sct, newv);
			set_civ (sct, s_civ (sct) + nr);

			if (sct == cursct)
				Census ();
			
			continue;
		}
	}

	n_mil_res (nation) += tot_demob;

	if (s_des (cursct) == 'c')
		Census ();
}

void SingleDemob ()
{
	char * ans;
	int quant;

	ans = InputAtMessage (Fmt("# to demoblize [%d]: ",max_mil), 4, GS_NUMBER);

	if (ans == (char *) 0 || interrupt)
	{
		interrupt = False;
		ClearMes ();
		return;
	}

	if (*ans == '\0')
		quant = max_mil;
	else
	{
		quant = atoi (ans);
		if (quant <= 0)
		{
			ClearMes ();
			return;
		}
	}

	ans = InputAtMessage ("New civilians on active reserve [y]: ", 
								1, GS_YN);
	
	if (ans == (char *) 0 || interrupt)
	{
		interrupt = False;
		ClearMes ();
		return;
	}

	DoDemob (CrdStr (cursct), quant,
				(* ans == 'n' || * ans == 'N') ? 'n' : 'y');
	Census ();
	DrawSector (cursct);
}

void MultiDemob (x, y)
int x, y;
{
	char * ans;
	char ch;

	ans = InputAtMessage ("New civilians on active reserve [y]: ", 
								1, GS_YN);

	if (interrupt || ans == (char *) 0)
	{
		interrupt = False;
		Message ("Multi demobilize cancelled");
		return;
	}

	ch = * ans == '\0' ? 'y' : * ans;
	MultiCommand (x, y, "# to demobilize", "demobilize", max_mil,
		      DoDemob, ch);
}
