/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/commands/RCS/attack.c,v 5.1 1993/03/14 16:42:45 etienne Exp $
    $Date: 1993/03/14 16:42:45 $
    $Author: etienne $
    $Id: attack.c,v 5.1 1993/03/14 16:42:45 etienne Exp $
    $Locker:  $
    $Log: attack.c,v $
    Revision 5.1  1993/03/14 16:42:45  etienne
    added stuff for landunits (not fully done)

 * Revision 5.0  93/02/06  09:18:04  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:32:23  greyhelm
 * Client for ASCII /X Empire client
 * Added RCS header - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "sector.h"
#include "var.h"
#include "ship.h"
#include "land.h"

#define MAX_ASS_SHIPS	127

void Attack ()
{
	char *movein, *answer;
	char *line, *ptri;
	Sector lastsct;
	Land land;
	int x, y, nr;

	FeedEmpire (Fmt ("attack %s", CrdStr (cursct)), PRINT);
	SetAgain (Attack);
	line = ReadEmpire (PRINT);
	if (line == (char *) 0)
		return;

	if (EmpireStatus () != E_QUESTION)
	{
		Message ("Attack failed");
		Bell ();
		(void) WaitForPrompt (PRINT);
		return;
	}

	PrintAtEmpire (line);
	movein = InputAtMessage (line, 1, GS_NAME);

	if (interrupt || movein == (char *) 0)
	{
		interrupt = False;
		Message ("Chicken !!!");
		FeedEmpire ("aborted", PRINT);
		(void) WaitForPrompt (PRINT);
		return;
	}

	*movein = (*movein == 'n' || *movein == 'N') ? 'n' : 'y';

	FeedEmpire (Fmt ("%c", *movein), PRINT);

	lastsct = (Sector) 0;
	while (line = ReadEmpire (PRINT))
	{
		if (line == (char *) 0)
			return;

		if (EmpireStatus () == E_QUESTION)
	    	{
			PrintAtEmpire (line);
			if (strncmp (line, "Number of troops from", 21) == 0)
			{
				ptri = line + 21;
				while (strncmp (ptri, " at ", 4) != 0 &&
								*ptri != '\0')
					ptri++;

				if (*ptri != '\0' &&
				    sscanf (ptri, " at %d, %d ", &x, &y) == 2)
				{

					if (lastsct != (Sector) 0)
						UnmarkSector (lastsct);

					lastsct = World (x, y, S_EXIST);
					MarkSector (lastsct);
				}
				answer = InputAtMessage (line+10, 3, GS_PNUMBER);
			}
			else {
				ptri = index(line, '#');
				sscanf (ptri, "#%d ", & nr);
				land = NrToLand (nr);
				if (lastsct != (Sector) 0)
					UnmarkSector (lastsct);

				lastsct = World (ld_xcd (land), ld_ycd (land), S_EXIST);
				MarkSector (lastsct);
				
				answer = InputAtMessage (line, 5, GS_NAME);
			}

			if (interrupt)
			{
				interrupt = False;
				Message ("Attack cancelled");
				while (EmpireStatus () != E_COMMAND)
				{
					FeedEmpire ("aborted", PRINT);
					(void) WaitForPrompt (PRINT);
				}
				UnmarkSector (lastsct);
				return;
			}
			else if (answer == (char *) 0)
				answer = "0";

			FeedEmpire (answer, PRINT);
			continue;
		}

		if (EmpireStatus () == E_COMMAND)
		{
			Bell ();
			Message ("Unexpected answer from empire. Failed ?");
			UnmarkSector (lastsct);

			PrintAtEmpire (line);
			return;
		}

		if (StrEQ (line, "You have been defeated"))
		{
			Bell ();
			Message ("Sorry Boss, seems we've been defeated");
			break;
		}

		if (StrEQ (line, "We have captured"))
		{
			Bell ();
			Message ("Veni Vedi Vici !!!");
			break;
		}

		if (StrEQ (line, "No troops for attack"))
		{
			Bell ();
			Message ("Attack has failed, Enemy has been notified");
			break;
		}
	}

	UnmarkSector (lastsct);

	(void) WaitForPrompt (PRINT);

	FScanDump (Fmt ("%d:%d,%d:%d", s_xcd (cursct) - 2,
				       s_xcd (cursct) + 2, 
				       s_ycd (cursct) - 1, 
				       s_ycd (cursct) + 1), PRINT);

	FScanMap (Fmt ("%d:%d,%d:%d", s_xcd (cursct) - 2, s_xcd (cursct) + 2,
				      s_ycd (cursct) - 1, s_ycd (cursct) + 1),
		  DONT_PRINT);

	if (land_units) {
		DumpLand (Fmt ("%d:%d,%d:%d", s_xcd (cursct) - 2, s_xcd (cursct) + 2,
			s_ycd (cursct) - 1, s_ycd (cursct) + 1),
		DONT_PRINT);
	}

	DrawNeighbours (cursct);
}
