/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/clients/RCS/client.c,v 5.8 1996/02/16 08:38:12 jpo Exp $
    $Date: 1996/02/16 08:38:12 $
    $Author: jpo $
    $Id: client.c,v 5.8 1996/02/16 08:38:12 jpo Exp $
    $Locker:  $
    $Log: client.c,v $
    Revision 5.8  1996/02/16 08:38:12  jpo
    Some touch ups

    Revision 5.7  1996/01/29 08:06:35  jpo
    Send client protocol

    Revision 5.6  1995/09/14 20:00:29  jpo
    Fix up INFORM and FLASH

    Revision 5.5  1995/09/13 07:03:43  jpo
    Added AwaitSomething

    Revision 5.4  1995/09/12 18:15:19  jpo
    Removed the ifdef X_VERSION for CheckRefreshEvents

    Revision 5.3  1995/09/10 16:26:06  jpo
    Some tweaks for test mode

    Revision 5.2  1995/09/08 07:00:40  jpo
    added some consts
    make connections failures less traumatic
    added support for flash and inform (broken still)
    some touch ups for test mode
    some renaming and reworking for configuration

 * Revision 5.1  93/03/14  16:42:28  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:17:27  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.5  1993/02/06  07:55:46  greyhelm
 * Test of GNUmake checkin
 *
 * Revision 4.4  1993/02/06  04:34:59  greyhelm
 * Added RCS header - Karl Hagen
 *

*/
	/*
	 *	Emptool				<file: client.c>
	 *	
	 *	Written by HJ. Visscher. Part of the code copied from
	 *	the original client-program written by Dave Pare.
	 *
	 *	int InitClient (cname, pname, host, port, logfile)
	 *		Initializes empire with "cname" as countryname and
	 *		"pname" as representive. The server must be at "port"
	 *		at "host". All commands are written onto "logfile".
	 *		When everyting succeeds, True is returned.
	 *
	 *	char *ReadEmpire ()
	 *		Reads and returns a line from empire
	 *
	 *	void FeedEmpire (command)
	 *
	 *	char *WaitForPrompt ()
	 *		Wait until a prompt is shown, return the line
	 *
	 *	int EmpireStatus ()
	 *		returns the status of empire.
	 *
	 *	void SkipNLines (i)
	 *		skipps n lines from empire.
	 */

#include "type.h"
#include "emp_proto.h"
#include "main.h"
#include "func.h"
#include "nation.h"

#include <pwd.h>
#include <signal.h>
#include <errno.h>
#include <netdb.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/file.h>
#include <sys/time.h>
#include <netinet/in.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAVE_SYS_SELECT_H
#include <sys/select.h>
#endif

#ifndef EMPIREPORT
#define	EMPIREHOST	"chainsaw.ecn.purdue.edu"
#define EMPIREPORT	"1617"
#endif

struct	fn
{
	int	(*func)();
	char	*name;
	int	value;
};
static void WatchEmpire _PROTO((void));

static FILE *log_fp = (FILE *) 0;
static FILE *red_fp = (FILE *) 0;
static int sock;
int emp_status = E_DEAD;
static struct sockaddr_in sin;
bool buffer_commands = False;
bool buffer_move = False;
static Strings buffer_str;

	/*	From original: host.c	*/

static int HostAddr (name, addr)
char *name;
struct sockaddr_in *addr;
{
	extern u_long inet_addr();
	struct hostent *hp;

	if (name == (char *) 0 || *name == '\0')
		return False;

	if (isdigit (*name))
		addr->sin_addr.s_addr = inet_addr (name);
	else
	{
		hp = gethostbyname (name);

		if (hp == (struct hostent *) 0)
		{
			(void) fprintf(stderr, "%s: No such host\n", name);
			return False;
		}

		bcopy ((char *) hp-> h_addr, (char *) & addr-> sin_addr,
			(unsigned) sizeof (addr-> sin_addr));
	}

	return True;
}

static int HostPort (name, addr)
char *name;
struct sockaddr_in *addr;
{
	struct servent *sp;

	if (name == (char *) 0)
		return False;

	if (*name == '\0')
		return False;

	if (isdigit (*name))
		addr-> sin_port = htons (atoi (name));
	else
	{
		sp = getservbyname (name, "tcp");

		if (sp == (struct servent *) 0)
			return False;

		addr-> sin_port = sp-> s_port;
	}

	return True;
}

bool HostConnect ()
{
#ifdef CHECK_CON
	int len;
	struct sockaddr_in peer;
#endif

	sock = socket (AF_INET, SOCK_STREAM, 0);

	if (sock < 0)
	{
		perror ("socket");
		return False;
	}

	sin. sin_family = AF_INET;

	if (connect (sock, (struct sockaddr *)& sin, sizeof (sin)) < 0)
	{
#ifndef TERMC_VERSION
		perror ("connect");
#endif
		(void) close(sock);
		return False;
	}
#ifdef CHECK_CON

	len = sizeof(struct sockaddr);
	if (getpeername(sock, &peer, &len) == -1)
	  perror("getpeername");

        printf("Connected to: %s, port %d\n",
		inet_ntoa(peer.sin_addr), peer.sin_port);
#endif CHECK_CON

	return True;
}

/* wait for something to happen on descriptor n, but if anything happens
   on the empire connection process that meanwhile */
void AwaitSomething (fd)
int fd;				/* another fd (X for e.g.) */
{
	int nfd;
	fd_set mask;
	int n;

	for (;;) {
		FD_ZERO (&mask);
		FD_SET (fd, &mask);
		nfd = fd + 1;
		if (emp_status != E_DEAD) {
			FD_SET (sock, &mask);
			if (sock > fd)
				nfd = sock + 1;
		}
		n = select (nfd, &mask, (fd_set *) 0, (fd_set *) 0, NULL);
		if (n == -1) {
			if (errno != EINTR) {
				perror ("select ");
				leave0 ();
			}
			continue;
		}
		if (FD_ISSET (sock, &mask)) {
			WatchEmpire ();
		}
		if (FD_ISSET (fd, &mask))
			return;
	}
}
	
static void WaitForInput ()
{
	fd_set mask;
	static struct timeval tt = { 5L, 0L };
	int n;

	for (;;) {
		FD_ZERO (&mask);
		FD_SET (sock, &mask);
		n = select (sock + 1, &mask, (fd_set *) 0, (fd_set *) 0, &tt);
		if (n == -1) {
			if (errno != EINTR) {
				perror ("select ");
				leave0 ();
			}
			continue;
		}
		if (n == 0) {
			CheckRefreshEvents ();
			continue;
		}
		if (FD_ISSET (sock, &mask))
			return;
	}
}

static char * GetLineFromHost ()
{
	static char buf[BUFSIZ];
	static int  nr_left = 0, nr_last_time = 0;
	char *p, *ptr;
	int n, size;
	bool gotline;

	if (nr_left > 0 && nr_last_time > 0)
		bcopy (buf + nr_last_time, buf, nr_left);

	ptr = buf;
	n = nr_left;
	size = BUFSIZ - 1;
	gotline = False;

	CheckRefreshEvents ();

	while (size > 0 && ! gotline) {
		if (n == 0) {
			WaitForInput ();
			if ((n = read (sock, ptr, size)) <= 0)
			{
				if (n != 0)
					perror("read failed ");
				else
		fprintf (stderr, "Bad connection to empire host : timed out\n");

				PrintAtEmpire ("Bad connection to empire host");
				(void) sprintf (buf, "%x Connection died",
						C_EXIT);
				return buf;
  			}
		}
			
		ptr [n] = '\0';
		if ((p = index(ptr , '\n')) != (char *) 0) {
			nr_last_time = p - buf + 1;
			nr_left = ptr + n - buf - nr_last_time;
			*p = '\0';
			gotline = True;
			break;
		} else
		{
			ptr += n;
			size -= n;
			n = 0;
		}
	}

	if (! gotline)
	{
		PrintAtEmpire ("Line from Empire To long\n");
		fprintf (stderr, "Line from Empire To long (> %d)\n", BUFSIZ);
		leave ();
	}

	return (buf);
}
	
static bool Expect (match, buf)
int match;
char *buf;
{
	int code;

	strcpy (buf, GetLineFromHost ());

	if (!isxdigit (*buf))
	{
		(void) fprintf (stderr, "Expecting %d, got %s\n", match, buf);
		return False;
	}

	if (isdigit (*buf)) 
		code =  *buf - '0';
	else if (isupper (*buf))
		code =  10 + *buf - 'A';
	else
		code =  10 + *buf - 'a';

	if (code == match)
		return True;

	while (*buf != '\0' && ! isspace (*buf))
		buf++;

	fprintf (stderr, "empire : %s\n", *buf == '\0' ?
			Fmt ("Expected code %d got %d\n", match, code) : buf);
	return False;
}

static bool SendCmd (cmd, arg)
char *cmd;
char *arg;
{
	char buf [120];
	int cc, len;

	(void) sprintf (buf, "%s %s\n", cmd, arg != (char *) 0 ? arg : "");
	len = strlen (buf);
	cc = write (sock, buf, len);

	if (cc < 0) {
		perror ("sendcmd: write");
		return False;
	}

	if (cc != len) {
		(void) fprintf (stderr, "sendcmd: int write (%d not %d)\n",
				cc, len);
		return False;
	}

	return True;
}

/* based on original login from login.c */

int Login ()
{
	char buf[BUFSIZ];
	extern const char *version_str;

	if (! Expect (C_INIT, buf))
		return False;

	if (! SendCmd ("client", version_str)) return False;
	(void) GetLineFromHost (); /* ignore the return */

	if (! SendCmd ("user", user_name) || ! Expect (C_CMDOK, buf))
		return False;

	if (! SendCmd ("coun", cname) || ! Expect (C_CMDOK, buf))
		return False;

	if (! SendCmd ("pass", pname) || ! Expect (C_CMDOK, buf))
		return False;

	if (! SendCmd ("play", (char *) 0) || ! Expect (C_INIT, buf))
		return False;

	if (atoi (buf) != CLIENTPROTO)
	{
		(void) fprintf (stderr,
				"Emptool out of date; get new version!\n");
		(void) fprintf (stderr,
				"   this version: %d, current version: %d\n",
			CLIENTPROTO, atoi (buf));
		return False;
	}

	emp_status = E_PRINTING;

	return True;
}

void Reconnect ()
{
	extern bool silent_con;
	extern bool connecting;

	char * ans;

	if (emp_status != E_DEAD)
		return;
	
	if (command_state == TEST_STATE)
	{
		Error ("Trying to connect to empire while in test mode");
		leave0 ();
	}

	if (! silent_con)
		Message ("Reconnecting to Empire Host");

	BusyCursor ();

	connecting = True;

	for (;;)
	{

		if (! HostConnect () || ! Login ())
		{
			if (sock < 0)
				PrintAtEmpire ("Login failed");
			else
				PrintAtEmpire
					("Cannot reconnect to Empire Host");

			do {
				ResetCursor ();
				interrupt = False;
				ans = InputAtMessage (
					"Cannot reconnect, quit [n]:", 1, "yn");
			}
			while (interrupt || ans == (char *) 0);

			if (* ans == 'y')
			{
				Bell ();
				leave0 ();
			}
			Message ("Trying to reconnect...");

			BusyCursor ();
		}
		else
			break;
	}

	ResetCursor ();

	if (! silent_con)
		Message ("Reconnected");

	emp_status = E_PRINTING;

	SaveTillPrompt ();

	if (! silent_con)
	{
		FeedEmpire ("", DONT_PRINT);
		(void) WaitForPrompt (silent_con ? DONT_PRINT : PRINT);
	}

	connecting = False;

	FeedBufCommands ();
}

bool InitClient (host, port, logfile)
char *host, *port, *logfile;
{
	struct passwd *pwd;
	char country[64];

	/* 	Get uid of player		*/

	pwd = getpwuid (getuid ());
	if (pwd == (struct passwd *) 0)
	{
		(void) fprintf (stderr, "Go away! (you don't exist)!\n");
		return False;
	}

	/*	Get port, host & connect	*/

	if (! HostPort (port, & sin) &&
	    ! HostPort (getenv ("EMPIREPORT"), & sin) &&
	    ! HostPort (EMPIREPORT, &sin) &&
	    ! HostPort ("empire", & sin))
	{
		(void) fprintf (stderr, "No empire port\n");
		return False;
	}

	if (! HostAddr (host, & sin) &&
	    ! HostAddr (getenv ("EMPIREHOST"), & sin) &&
	    ! HostAddr (EMPIREHOST, &sin))
	{
		(void) fprintf (stderr, "No empire host\n");
		return False;
	}

	user_name = Str (pwd-> pw_name);

	if (cname == (char *) 0)
		cname = getenv ("COUNTRY");

	if (cname == (char *) 0)
	{
		cname = country;
		(void) printf ("Country name? ");
		*cname = '\0';
		if (gets (cname) == (char *) 0 || *cname == '\0')
			return False;
	}
	cname = Str (cname);

	if (pname == (char *) 0)
		pname = getenv ("PLAYER");

	if (pname == (char *) 0)
	{
		pname = getpass ("Your name? ");
		if (pname == (char *) 0 || *pname == '\0')
			return False;
	}

	buffer_str = InitStrings ();

	pname = Str (pname);


	/*	Open logfile			*/

	if (logfile != (char *) 0)
	{
		if ((log_fp = fopen (logfile, "a")) == (FILE *) 0)
		{
			perror ("fopen");
			return False;
		}
	}
	else
		log_fp = (FILE *) 0;

	return True;
}

void CloseConnection ()
{
	(void) close (sock);
}

#define FM_APPEND	0
#define	FM_NEW		1
#define	FM_FORCE	2

extern bool connecting;

static char *Read_Empire (flag)
int flag;
{
	extern bool disconnecting;
	static char buffer [BUFSIZ];
	char *buf;
	char *ptr;
	int nbtu, nmin;
	int mode;
	char code;

	static int err = 0;

	NoConTimeout ();

	if (emp_status == E_DEAD)
		Reconnect ();

	buf = GetLineFromHost ();

	ResetConTimeout ();

	code = buf [0];
	if (code >= '0' && code <= '9')
		code -= '0';
	else
		code = code - 'a' + 10;

	ptr = buf + 2;

	switch (code)
	{

	case C_REDIR:			/* which mode ?? */
		err = 0;
		emp_status = E_PRINTING;
		mode = FM_NEW;
		ptr ++;
		if (*ptr == '>')
		{
			mode = FM_APPEND;
			ptr ++;
		}
		else if (*ptr == '!')
		{
			mode = FM_FORCE;
			ptr ++;
		}

		while (*ptr == ' ')
			ptr ++;
		
		if (*ptr == '\0')
		{
			if (flag == PRINT)
				PrintAtEmpire ("Null redirection");
			return (char *) 0;
		}

		if (mode == FM_NEW && !access (ptr, F_OK))
		{
			if (flag == PRINT)
				PrintAtEmpire (Fmt ("%s already exists", ptr));
			return (char *) 0;
		}
		
		if ((red_fp = fopen (ptr, (mode == FM_APPEND) ? "a" : "w"))
					== (FILE *) 0 && flag == PRINT)
				PrintAtEmpire (Fmt ("can't open %s", ptr));
		return (char *) 0;
				
	case C_PIPE:
	case C_EXECUTE:
	case C_NOECHO:
		err = 0;
		Bell ();
		sprintf (buffer, "Command code '%d' not implemented", code);

		if (log_fp != (FILE *) 0)
		{
			(void) fprintf (log_fp, "%s\n", buffer);
			(void) fflush (log_fp);
		}

		emp_status = E_PRINTING;
		return buffer;

	case C_FLUSH:	/* A prompt, but not the command-prompt */

		err = 0;
		if (log_fp != (FILE *) 0)
		{
			(void) fprintf (log_fp, ptr);
			(void) fflush (log_fp);
		}

		emp_status = E_QUESTION;
		return ptr;

	case C_BADCMD:
		err = 0;
		(void) sprintf (buffer, "Error: %s\n", ptr);
		if (log_fp != (FILE *) 0)
		{
			(void) fprintf (log_fp, buffer);
			(void) fflush (log_fp);
		}
		emp_status = E_PRINTING;
		return buffer;

	case C_ABORT:
		err = 0;
		if (log_fp != (FILE *) 0)
		{
			(void) fprintf (log_fp, "Aborted\n");
			(void) fflush (log_fp);
		}
		emp_status = E_PRINTING;
		return "Aborted\n";

	case C_EXIT:
		err = 0;
		(void) sprintf (buffer, "Disconnected, exit code : %s\n", ptr);
		if (log_fp != (FILE *) 0)
		{
			(void) fprintf (log_fp, buffer);
			(void) fflush (log_fp);
		}
		emp_status = E_DEAD;
		(void) close (sock);
		if (disconnecting)
			return "Disconnected";
		else {
			if (connecting)
			{
				PrintSaved ();
				fprintf (stderr, buffer);
			}
			leave0 ();
		}
		
		/* NOTREACHED */

	case C_DATA:
		err = 0;
		emp_status = E_PRINTING;
		if (log_fp != (FILE *) 0)
		{
			(void) fprintf (log_fp, "%s\n", ptr);
			(void) fflush (log_fp);
		}

		if (red_fp != (FILE *) 0)
		{
			(void) fprintf (red_fp, "%s\n", ptr);
			(void) fflush (red_fp);
			return (char *) 0;
		}

		return ptr;

	case C_PROMPT:
		err = 0;
		if (red_fp != (FILE *) 0)
		{
			(void) fclose (red_fp);
			red_fp = (FILE *) 0;
		}

		if (sscanf (ptr, " %d %d", &nbtu, &nmin) != 2)
		{
			(void) fprintf (stderr, "Bad prompt\n");
			(void) strcpy (buffer, "[??:??] Command : ");
		} else
			(void) sprintf (buffer, "[%d:%d] Command : ",
						nbtu, nmin);

		if (log_fp != (FILE *) 0)
		{
			(void) fprintf (log_fp, buffer);
			(void) fflush (log_fp);
		}

		emp_status = E_COMMAND;

		if (flag == PRINT)
			PrintAtEmpire ("");

		return buffer;

	    case C_INFORM:
	    case C_FLASH:
		PrintAtEmpire (ptr);
		PrintAtEmpire ("");
		if (emp_status == E_PRINTING)
			return Read_Empire (flag);
		return ptr;

	default:
		if (log_fp != (FILE *) 0)
		{
			(void) fprintf (log_fp, "\"%s\" : EHEH??\n", buffer);
			(void) fflush (log_fp);
		}

		/* emp_status = E_PRINTING; */
		/* should test connection here */
		if (++err == 5)
		{
			(void) fprintf (stderr,
				"To many repeating errors, exiting\n");
			leave0 ();
		}
		sprintf (buffer, "ERROR (server) %s", buf);
		return buffer;
	}
}

bool IsEmpireMessage (ptr)
char *ptr;
{
	double cost;

	if (ptr == (char *) 0 || connecting)
		return False;
	if (! strncmp (ptr, "Waiting on lock", 15))
		return True;
	if (sscanf (ptr, "That just cost you $%lf", &cost) == 1)
	{
		n_treas (nation) -= cost;
		return True;
	}
	if (sscanf (ptr, "You just made $%lf", &cost) == 1)
	{
		n_treas (nation) += cost;
		return True;
	}
	if (! strncmp (ptr, "Max minutes per day limit exceeded", 34))
		return True;
	if (! strncmp (ptr, "See \"info syntax\"?", 18))
		return True;
	if (! strncmp (ptr, "Try \"list of commands\",", 23))
		return True;
	if (! strncmp (ptr, "You ", 4))
	{
		if (! strncmp (ptr + 4, "are ", 4))
		{
			if (! strncmp (ptr + 8, "now broke", 9))
				return True;
			if (! strncmp (ptr + 8, "no longer broke", 15))
				return True;
		}
		else if (! strncmp (ptr + 4, "have ", 5))
		{
			if (! strncmp (ptr + 9, "a new telegram waiting", 22))
				return True;

			if (! strncmp (ptr + 9, "a new announcement waiting", 26))
				return True; 

			ptr += 9;

			if (ScanWord ((ConstVP)&ptr, (char *) 0))
			{
				SkipBlank ((ConstVP)&ptr);
				if (! strncmp (ptr,"new telegrams waiting", 21))
					return True;
			}
			if (ScanWord ((ConstVP)&ptr, (char *) 0))
			{
				SkipBlank ((ConstVP)&ptr);
				if (! strncmp (ptr, "new announcements waiting", 25))
					return True;
			}
		}
		else if (! strncmp (ptr + 4, 
			     "lost your capital... better designate one", 41))
				return True;
	}

	return False;
}
char *ReadEmpire (flag)
int flag;
{
	char *ptr;

	if (command_state == TEST_STATE)
	    return "";
	BusyCursor ();

	for (;;)
	{
		if (emp_status == E_COMMAND || emp_status == E_QUESTION ||
		    emp_status == E_DEAD)
		{
			PrintAtEmpire ("Emptool sync error, Reading while waiting for input");
			PrintAtEmpire ("");
			Bell ();
			FlushWindow (empire_win);
			interrupt = True;
			ResetCursor ();
			return "";
		}


		ptr = DelTabs (Read_Empire (flag));

		if (IsEmpireMessage (ptr)) {
			PrintAtEmpire ("");
			PrintAtEmpire (ptr);
			continue;
		}

		if (ptr != (char *) 0 || emp_status != E_PRINTING)
			break;
	}

	ResetCursor ();

	if (flag == PRINT)
		if (emp_status == E_PRINTING)
			PrintAtEmpire (ptr);

	return ptr;
}

void FeedEmpire (str, flag)
const char *str;
int flag;
{
	int n, i;
	char *tmp, *ptr;

	if (command_state == TEST_STATE) {
		PrintAtEmpire (str);
		return;
	}

	ptr = StrNl (str);
	tmp = ptr;
	n = strlen (ptr);

	NoConTimeout ();

	if (emp_status == E_DEAD)
		Reconnect ();

	if (emp_status == E_PRINTING)
		(void) WaitForPrompt (flag);

	if (log_fp != (FILE *) 0)
		(void) fprintf (log_fp, ptr);

	if (flag == PRINT)
		ReprintAtEmpire (str);


	CheckRefreshEvents ();

	BusyCursor ();
	while (n > 0)
	{
		i = write (sock, ptr, n);
		if (i <= 0)
		{
			perror ("Write server socket");
			leave0 ();
		}
		n -= i;
		ptr += i;
	}
	ResetCursor ();

	free (tmp);
	emp_status = E_PRINTING;

	ResetConTimeout ();
}

void FeedCommand (com, flag)
const char * com;
int flag;
{
	if (command_state == TEST_STATE) {
		PrintAtEmpire (com);
		return;
	}

	if (emp_status != E_DEAD || command_state == NORMAL_STATE)
	{
		FeedEmpire (com, flag);
		(void) WaitForPrompt (flag);
	}
	else
		AddString (buffer_str, com);
}

void ShowBufCommands (x, y)
int x, y;
{
	Pager pager;

	if (StringsSize (buffer_str) == 0)
	{
		Bell ();
		Message ("No buffered commands");
		return;
	}

	pager = InitPager (buffer_str, "Buffered commands");
	AddPagerFunc (pager, "Write", WRITEFUNC);
	AddPagerFunc (pager, "Done", DONEFUNC);

	MapPagerFromTop (pager, map_win, x, y);
	ShowPager (pager);
	FreePager (pager);
}

void DeleteBufCommands ()
{
	while (StringsSize (buffer_str) > 0)
		DeleteFirstString (buffer_str);
}

void SaveBufCommands (fp)
FILE * fp;
{
	const char * ptr;

	InitStringList (buffer_str);
	while ((ptr = GetNextString (buffer_str)) != (char *) 0)
		fprintf (fp, "%s\n", ptr);

	fprintf (fp, "END OF BUFFERED COMMANDS\n");
}

void ReadBufCommands (fp)
FILE * fp;
{
	char buffer [80];
	char * ptr;

	for (;;)
	{
		ptr = fgets (buffer, 80, fp);
		if (ptr == (char *) 0 ||
					StrEQ (ptr, "END OF BUFFERED COMMANDS"))
			return;

		buffer [strlen (buffer) - 1] = '\0';
		AddString (buffer_str, buffer);
	}
}

bool BufferdCommands ()
{
	return (StringsSize (buffer_str) > 0);
}

void FeedBufCommands ()
{
	const char * ptr;
	char *cp;
	static int nr = 0;
	bool rescan_planes;

	rescan_planes = False;
	if (nr++ != 0)
	{
		fprintf (stderr, "Recursive FeedBufCommands !!\n");
		return;
	}

	if (StringsSize (buffer_str) > 0)
	{
		Message ("Feeding buffered commands");
		ptr = GetFirstString (buffer_str);

		while (ptr != (char *) 0)
		{
			if (! rescan_planes && StrEQ (ptr, "build plane"))
				rescan_planes = True;
			FeedEmpire (ptr, PRINT);
			do
				cp = ReadEmpire (PRINT);
			while (EmpireStatus () == E_PRINTING);
			PrintAtEmpire (cp);
			DeleteFirstString (buffer_str);
			if (StringsSize (buffer_str) > 0)
				ptr = GetFirstString (buffer_str);
			else
				ptr = (char *) 0;

			while (EmpireStatus () != E_COMMAND)
			{
				if (ptr != (char *) 0 && * ptr == '*')
				{
					FeedEmpire (ptr + 1, PRINT);
					DeleteFirstString (buffer_str);
					if (StringsSize (buffer_str) > 0)
						ptr = GetFirstString
							(buffer_str);
					else
						ptr = (char *) 0;
				}
				else
					FeedEmpire ("aborted", PRINT);

				(void) WaitForPrompt (PRINT);
			}
		}
	}
	nr--;

	if (rescan_planes)
	{
		Message ("Redumping (all) planes");
		DumpPlanes ("*", PRINT);
		Census ();
		DrawSector (cursct);
	}
}

char * WaitForPrompt (flag)
int flag;
{
	char *ptr = (char *) 0;
	int lines;
	extern int empire_height;
	int prflag = flag;
	extern bool enable_empire_more;

	if (command_state == TEST_STATE)
	    return "";

	lines = 0;
	while (emp_status == E_PRINTING)
	{
		
		/*
		 *	Using termcap, we have a very small window,
		 *	So one line extra really counts.
		 */

#ifdef X_VERSION
		if (prflag == PRINT && ++ lines % (empire_height - 2) == 0)
#else
		if (prflag == PRINT && ++ lines % (empire_height - 1) == 0)
#endif
		{
			if (enable_empire_more && !EmpireMore ())
				prflag = DONT_PRINT;
		}
		ptr = ReadEmpire (prflag);
	}

	if (ptr != (char *) 0 && emp_status != E_PRINTING && flag == PRINT)
		PrintAtEmpire (ptr);

	return ptr;
}

int EmpireStatus ()
{
	return emp_status;
}

bool SkipNLines (n, flag)
int n;
int flag;
{
	while (n--)
		if (emp_status == E_PRINTING)
			(void) ReadEmpire (flag);
		else
			return False;
	
	return True;
}

static void WatchEmpire ()
{
	(void) Read_Empire (PRINT);
}
