/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/census/RCS/census.c,v 5.4 1996/01/29 08:08:43 jpo Exp $
    $Date: 1996/01/29 08:08:43 $
    $Author: jpo $
    $Id: census.c,v 5.4 1996/01/29 08:08:43 jpo Exp $
    $Locker:  $
    $Log: census.c,v $
    Revision 5.4  1996/01/29 08:08:43  jpo
    Minor fixup

    Revision 5.3  1995/10/25 13:54:33  jpo
    Call new window stuff

    Revision 5.2  1995/09/08 06:57:40  jpo
    some clean ups

 * Revision 5.1  93/03/14  16:41:13  etienne
 * added/changed some things for chain 3.0
 * 
 * Revision 5.0  93/02/06  09:16:27  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.5  1993/02/06  07:48:54  greyhelm
 * Added gnumake mods to allow checkin and Checkout
 *
 * Revision 4.4  1993/02/06  04:21:26  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "sector.h"
#include "nation.h"
#include "census.h"
#include "var.h"
#include "ship.h"

static void CensusNewCommandMode _PROTO((int mode));

WinInfo census_win;
int command_mode = NORMAL_MODE;
int last_layout = SHIP_MODE;

int census_height = CENSUS_HEIGHT;

#define	NR_COMM		12

void CensusLayTop ()
{
	CenLineText (NL_SY_SCT - 1, "Census");
	CenPuts (0, NL_SY_SCT,     "Sct");
	CenPuts (0, NL_SY_SCT + 1, "Des");
	CenPuts (0, NL_SY_CENSUS, "Eff      Mob      Ava");
	CenPuts (0, NL_SY_CENSUS + 1, "Civ      Mil      Wor");

#ifdef X_VERSION

	CenLineText (NL_SY_RESOUR - 1, "Resources");
	CenPuts (0, NL_SY_RESOUR,     "Min      Oil      Fer");
	CenPuts (0, NL_SY_RESOUR + 1, "Gol      Ura");
	CenLineText (NL_SY_CRAFTS - 1, "Crafts");
	if (land_units)
		CenPuts (0, NL_SY_CRAFTS, "S      P      L      N  ");
	else
		CenPuts (0, NL_SY_CRAFTS, "Shi      Pla      Nuk");
	CenLine (NL_SY_CRAFTS + 1);
	CenLine (NL_SY_DISTR + 1); 

#endif /* X_VERSION */
}

static void CensusNewCommandMode (mode)
int mode;
{
	ClearWindow (census_win);

	CensusLayTop ();

	switch (mode) {

	case NORMAL_MODE:
		CensusLayNormal ();
		break;

	case SHIP_MODE:
		CensusLayShip ();
		break;
	
	case FLEET_MODE:
		CensusLayFleet ();
		break;

	case PLANE_MODE:
		CensusLayPlane ();
		break;

	case WING_MODE:
		CensusLayWing ();
		break;

	case LAND_MODE:
		CensusLayLand ();
		break;

	case ARMY_MODE:
		CensusLayArmy ();
		break;

	case INFO_MODE:
		break;

	case PLAN_MODE:
		CensusLayPlan ();
		break;

	case NUKE_MODE:
		CensusLayNuke ();
		break;
		
	}
}

void DoCensus (sct, ship, fleet, plane, wing, nuke, land, army, layout)
Sector sct;
Ship ship;
char fleet;
Plane plane;
char wing;
Land land;
char army;
Nuke nuke;
int layout;
{
	int next_mode = last_layout;

	if (sct == (Sector) 0 || NO_INFO (sct))
		return;
	
	switch (layout)
	{

	case NORMAL_MODE:
		next_mode = NORMAL_MODE;
		break;

	case SHIP_MODE:
		next_mode = (ship == (Ship) 0) ? NORMAL_MODE : SHIP_MODE;
		break;

	case PLANE_MODE:
		next_mode = (plane == (Plane) 0) ? NORMAL_MODE : PLANE_MODE;
		break;

	case FLEET_MODE:
		next_mode = (fleet == '\0') ? NORMAL_MODE : FLEET_MODE;
		break;

	case LAND_MODE:
		next_mode = (land == '\0') ? NORMAL_MODE : LAND_MODE;
		break;

	case ARMY_MODE:
		next_mode = (army == '\0') ? NORMAL_MODE : ARMY_MODE;
		break;

	case NUKE_MODE:
		next_mode = (nuke == (Nuke) 0) ? NORMAL_MODE : NUKE_MODE;
		break;

	case WING_MODE:
		next_mode = (wing == '\0') ? NORMAL_MODE : WING_MODE;
		break;

	case INFO_MODE:
		next_mode = INFO_MODE;
		break;
	
	case PLAN_MODE:
		next_mode = PLAN_MODE;
		break;
	}

	if (last_layout != next_mode)
	{
		CensusNewCommandMode (next_mode);
		last_layout = next_mode;
	}

	CensusTop (sct);

#ifdef X_VERSION

	CensusResources (sct);
	CensusCrafts (sct);

#endif /* X_VERSION */

	switch (next_mode)
	{

	case NORMAL_MODE:
		SectorCensus (sct);
		break;


	case SHIP_MODE:
		ShipCensus (ship);
		break;

	case FLEET_MODE:
		FleetCensus (fleet);
		break;

	case LAND_MODE:
		LandCensus (land);
		break;

	case ARMY_MODE:
		ArmyCensus (army);
		break;

	case PLANE_MODE:
		PlaneCensus (plane);
		break;

	case WING_MODE:
		WingCensus (wing);
		break;

	case INFO_MODE:
		CensusAddit (sct);
		break;

	case NUKE_MODE:
		NukeCensus (nuke);
		break;

	case PLAN_MODE:
		PlanCensus (sct);
		break;
	}

	FlushWindow (census_win);
	Refresh ();
}

void Census ()
{
	curnuketype = -1;
	DoCensus (cursct, curship, curfleet, curplane, curwing,
		  curnuke, curland, curarmy, command_mode);
}

void CensusSct (sct)
Sector sct;
{
	DoCensus (sct, curship, curfleet, curplane, curwing,
		  curnuke, curland, curarmy, NORMAL_MODE);
}

void CensusShip (ship)
Ship ship;
{
	DoCensus (cursct, ship, curfleet, curplane, curwing,
		  curnuke, curland, curarmy, SHIP_MODE);
}

void CensusFleet (fleet)
char fleet;
{
	DoCensus (cursct, curship, fleet, curplane, curwing,
		  curnuke, curland, curarmy, FLEET_MODE);
}

void CensusSctShip (sct, ship)
Sector sct;
Ship ship;
{
	DoCensus (sct, ship, curfleet, curplane, curwing, curnuke,
		  curland, curarmy, SHIP_MODE);
}

void CensusLand (land)
Land land;
{
	DoCensus (cursct, curship, curfleet, curplane, curwing,
		  curnuke, land, curarmy, LAND_MODE);
}

void CensusArmy (army)
char army;
{
	DoCensus (cursct, curship, curfleet, curplane, curwing,
		  curnuke, curland, army, ARMY_MODE);
}

void CensusPlane (plane)
Plane plane;
{
	DoCensus (cursct, curship, curfleet, plane, curwing,
		  curnuke, curland, curarmy, PLANE_MODE);
}

void CensusWing (wing)
char wing;
{
	DoCensus (cursct, curship, curfleet, curplane, wing,
		  curnuke, curland, curarmy, WING_MODE);
}

void CensusNuke (nuke)
Nuke nuke;
{
	curnuketype = -1;
	DoCensus (cursct, curship, curfleet, curplane, curwing,
		  nuke, curland, curarmy, NUKE_MODE);
}

void CensusInfo ()
{
	DoCensus (cursct, curship, curfleet, curplane, curwing,
		  curnuke, curland, curarmy, INFO_MODE);
}

void InitCensus ()
{
	census_win = OpenCensusWindow (root_win);
	SetDefaultCursor (census_win, CR_ARROWS);
	command_mode = NORMAL_MODE;
	CensusNewCommandMode (command_mode);
	FlushWindow (census_win);
}

void CensusButton (x, y)
int x, y;
{
	char * ans;
	int new, num;
	char ch, *ptr;


	/* check mines */
	if (y == NL_SY_RESOUR + 1 && (s_des (cursct) == '.' ||
				      s_des (cursct) == '='))
	{
		CenClr (NL_SY_RESOUR + 1);
		PrintN (census_win, 0, NL_SY_RESOUR + 1, "# mines [?]: ");
		ans = GetString (census_win, 13, NL_SY_RESOUR + 1, 4, "0-9?");
		if (ans == (char *) 0 || interrupt)
		{
			Message ("Set mines cancelled");
			interrupt = False;
			Census ();
			return;
		}

		if (* ans == '\0')
			set_mines (cursct, 128);
		else
			set_mines (cursct, atoi (ans));

		Census ();
		return;
	}

	switch (last_layout)
	{

	case NORMAL_MODE:
		if (deity)
			CensusDeityButton (x, y);
		SectorCensusBut (x, y);
		return;

	case SHIP_MODE:
		ShipCensusBut (x, y);
		return;
	
	case FLEET_MODE:
		FleetCensusBut (x, y);
		return;

	case LAND_MODE:
		LandCensusBut (x, y);
		break;

	case ARMY_MODE:
		ArmyCensusBut (x, y);
		break;
	
	case PLANE_MODE:
		PlaneCensusBut (x, y);
		return;

	case WING_MODE:
		WingCensusBut (x, y);
		return;

#ifdef TERMC_VERSION

	case INFO_MODE:
		AdditCensusBut (x, y);
		return;

#endif TERMC_VERSION

	case PLAN_MODE:
		PlanCensusButton (x, y);
		FlushWindow (census_win);
		return;

	case NUKE_MODE:
		NukeCensusButton (x, y);
		return;

	}

	FlushWindow (census_win);
	Refresh ();
}
