/*
 * $Header: /nexor/users/jpo/xemp/xemp5.0/xt/RCS/xwindow.c,v 5.2 1995/09/08 07:51:45 jpo Exp jpo $
 * $Date: 1995/09/08 07:51:45 $
 * $Author: jpo $
 * $Id: xwindow.c,v 5.2 1995/09/08 07:51:45 jpo Exp jpo $
 * $Locker: jpo $
 * $Log: xwindow.c,v $
 *
 */

/* MOTIF variant of xemp */

#include <X11/keysym.h>
#include <X11/keysymdef.h>
#include <Xm/DrawingA.h>
#include <Xm/PanedW.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <Xm/Separator.h>
#include <Xm/Text.h>
#include <Xm/Form.h>
#include <Xm/List.h>
#include <Xm/MainW.h>
#include <Xm/ScrolledW.h>
#include <Xm/FileSB.h>
#include <Xm/Label.h>
#include <Xm/MessageB.h>
#include "type.h"
#include "xextern.h"
#include "main.h"
#include "sector.h"
#include "xemp_icon.h"
#include "func.h"

extern XtAppContext app_context;

struct region
{
	int low_x, low_y, high_x, high_y;
	int width, height;
};

char windowname[BUFSIZ];

struct s_wininfo {
	Widget widget;
	Widget shell;
	Pixmap pixmap;
	GC normal_gc;
	GC bold_gc;
	GC rev_gc;
	Cursor cursor;
	int curline, pixsavelines;
	struct region pix_dim;
	struct region char_dim;
	struct s_wininfo *next;
	int flags;
#define WFL_NONE	0x0
#define WFL_SECT	0x1
#define WFL_REGION	0x2
#define WFL_DONE	0x4
	int selx, sely;
	int button;
};

static WinInfo first_window = (WinInfo) 0;

static void AppendXText _PROTO((Widget w, const char *str, int nl));
extern Cursor cr_busy;	/* from xicons.c */

void InitXIcon(win)
WinInfo win;
{

	XWMHints wmhints;

	bzero ((char *)&wmhints, sizeof wmhints);
	wmhints.flags = IconPixmapHint;
	wmhints.icon_pixmap = XCreateBitmapFromData(display,
				root_window, xemp_icon_bits, 64, 48);
	XSetWMHints(display, root_window, &wmhints);
}

static void PixmapCopy_cb (w, client_data, call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	WinInfo win = (WinInfo)client_data;
	Arg args[3];
	Dimension width, height;
	XmDrawingAreaCallbackStruct *dcs =
	    (XmDrawingAreaCallbackStruct *)call_data;
	XExposeEvent *expose;

	if (dcs -> reason != XmCR_EXPOSE)
	    return;
	expose = &dcs -> event -> xexpose;
	XtSetArg(args[0], XmNheight, &height);
	XtSetArg(args[1], XmNwidth, &width);
	XtGetValues (w, args, 2);

	XCopyArea (XtDisplay(w),
		   win-> pixmap,
		   XtWindow(w),
		   gc_copy,
		   expose -> x, expose -> y,
		   expose -> width, expose -> height,
		   expose -> x, expose -> y);
}

static void AddWindow (win)
WinInfo win;
{
	WinInfo *wp;

	for (wp = & first_window; *wp; wp = &(*wp)->next)
		continue;
	*wp = win;
}

static WinInfo NewWindow ()
{
	WinInfo w;

	w = (WinInfo) doalloc(sizeof *w);
	bzero ((char *)w, sizeof *w);
	AddWindow(w);
	return w;
}

static void WindowInfo (w, width, height)
WinInfo w;
int width, height;
{
	w -> pix_dim.width = CharToPixelX(width);
	w -> pix_dim.height = CharToPixelY(height);
	w -> char_dim.width = width;
	w -> char_dim.height = height;

	w-> normal_gc = gc_normal;
	w-> rev_gc = gc_inv_normal;
	w-> bold_gc = gc_bold;
}

static WinInfo NewPopup (parent, name, width, height)
WinInfo parent;
char *name;
int width, height;
{
	WinInfo w;
	char buf[100];

	w = NewWindow ();

	WindowInfo (w, width, height);

	w -> shell = XtVaCreatePopupShell(name,
					  topLevelShellWidgetClass,
					  parent -> widget,
					  NULL);

	strcpy (buf, name);
	strcat(buf, "_draw");
	w -> widget = XtVaCreateManagedWidget (buf,
					       xmDrawingAreaWidgetClass,
					       w -> shell,
					       XmNheight, w -> pix_dim.height,
					       XmNwidth, w -> pix_dim.width,
					       NULL);

	w -> pixmap = XCreatePixmap (display,
				     root_window,
				     w -> pix_dim.width,   
				     w -> pix_dim.height,
				     depth);
	ClearWindow (w);
	XtAddCallback (w -> widget,
		       XmNexposeCallback,
		       PixmapCopy_cb,
		       w);

	XtPopup (w -> shell, XtGrabNone);
	return w;
}

void ClearWindow (win)
WinInfo win;
{
	XFillRectangle (display,
			win-> pixmap,
			gc_inv_normal,
			0, 0,
			win-> pix_dim.width,
			win-> pix_dim.height);
}

static void CensusSelect_cb (w, client_data, call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	XmDrawingAreaCallbackStruct *cbs =
		(XmDrawingAreaCallbackStruct *) call_data;
	XEvent *event = cbs -> event;

	if (event -> type == ButtonPress) {
		CensusButton (PixelToCharX (event-> xbutton. x),
			      PixelToCharY (event-> xbutton. y));
	}
}

WinInfo OpenCensusWindow (win)
WinInfo win;
{
    WinInfo w;

    w = NewPopup (win, "census", CENSUS_WIDTH, CENSUS_HEIGHT);
    XtAddCallback (w -> widget,
		   XmNinputCallback,
		   CensusSelect_cb,
		   w);
    return w;
}

static void MapSelSect_cb (w, client_data, call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	WinInfo win = (WinInfo)client_data;
	XmDrawingAreaCallbackStruct *cbs =
		(XmDrawingAreaCallbackStruct *) call_data;
	XEvent *event = cbs -> event;

	if ((win -> flags & WFL_SECT) == 0)
		return;

	if (event -> type == ButtonPress) {
		win -> button = event -> xbutton.button;
		win -> selx = event -> xbutton.x;
		win -> sely = event -> xbutton.y;
		win -> flags = WFL_DONE;
	}
}

static void MapEvent_cb (w, client_data, call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	WinInfo win = (WinInfo)client_data;
	XmDrawingAreaCallbackStruct *cbs =
		(XmDrawingAreaCallbackStruct *) call_data;
	XEvent *event = cbs -> event;
	Sector sct;

	if (win -> flags)
		return;

	if (event -> type == ButtonPress) {
		switch (event -> xbutton.button) {
		case Button1:
			sct = FindSector (event -> xbutton.x,
					  event -> xbutton.y);
			if (sct == (Sector)0)
				return;
			SetCurrent (sct);
			break;
		case Button2:
			GlobalCommands (PixelToCharX (event -> xbutton.x),
					PixelToCharY (event -> xbutton.y));
			break;
		case Button3:
			sct = FindSector (event -> xbutton.x,
					  event -> xbutton.y);
			if (sct == (Sector) 0 || NO_INFO (sct))
				return;

			if (sct != cursct)
				SetCurrent (sct);

			SectorCommands (PixelToCharX (event -> xbutton.x),
					PixelToCharY (event -> xbutton.y));
			break;
		default:
			break;
		}
	}
	else if (event -> type == KeyPress) {
		GlobalKey (event);
	}
		
}

static void MapDisplayEvent_cb (w, client_data, event, ctd)
Widget     w;
XtPointer  client_data;
XEvent     *event;
Boolean    *ctd;
{
	Widget sw = (Widget)client_data;
	Widget wig;
	int maximum;
	XMapEvent   *xmp = (XMapEvent*)event;

	if(xmp->type != MapNotify)
		return;

	XtRemoveEventHandler(w,
			     (StructureNotifyMask),
			     False,
			     MapDisplayEvent_cb,
			     client_data);

	XtVaGetValues (sw,
		       XmNhorizontalScrollBar, &wig,
		       NULL);
	if (wig) {
		XtVaGetValues (wig, XmNmaximum, &maximum, NULL);
		XtVaSetValues (wig,
			       XmNvalue, maximum / 2,
			       NULL);
	}
	XtVaGetValues (sw,
		       XmNverticalScrollBar, &wig,
		       NULL);
	if (wig) {
		XtVaGetValues (wig, XmNmaximum, &maximum, NULL);
		XtVaSetValues (wig,
			       XmNvalue, maximum / 2,
			       NULL);
	}
	*ctd = True;
}


WinInfo OpenMapWindow (parent, sx, sy, iw, ih, widthp, heightp)
WinInfo parent;
int sx, sy;
int iw, ih;
int *widthp, *heightp;
{
	WinInfo w;

	*widthp = MAX_X;
	*heightp = MAX_Y;

	w = NewWindow ();
	WindowInfo (w, *widthp, *heightp);
	w -> shell = XtVaCreateManagedWidget ("scroll",
					      xmScrolledWindowWidgetClass,
					      parent -> widget,
					      XmNscrollBarDisplayPolicy,
					      XmAS_NEEDED,
					      XmNscrollingPolicy,
					      XmAUTOMATIC,
					      XmNwidth, CharToPixelX(MAP_WIDTH),
					      XmNheight, CharToPixelY(MAP_HEIGHT),
					      NULL);
	w -> widget = XtVaCreateManagedWidget ("map",
					       xmDrawingAreaWidgetClass,
					       w -> shell,
					       XmNheight, w -> pix_dim.height,
					       XmNwidth, w -> pix_dim.width,
					       NULL);
	w -> pixmap = XCreatePixmap (display,
				     root_window,
				     w -> pix_dim.width,   
				     w -> pix_dim.height,
				     depth);
	XtAddEventHandler (w -> shell,
			   (StructureNotifyMask),
			   False,
			   MapDisplayEvent_cb,
			   (XtPointer)w->shell);

	ClearWindow(w);
	XtAddCallback (w -> widget,
		       XmNexposeCallback,
		       PixmapCopy_cb,
		       w);
	XtAddCallback (w -> widget,
		       XmNinputCallback,
		       MapEvent_cb,
		       w);
	return w;
}

static void EmpireEvent_cb (w, client_data, call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	XmDrawingAreaCallbackStruct *cbs =
		(XmDrawingAreaCallbackStruct *) call_data;
	XEvent *event = cbs -> event;

	if (event -> type !=  ButtonPress ||
	    event -> xbutton.button != LEFT_BUTTON)
		return;

	InputToEmpire ();
	Census ();
}

WinInfo OpenEmpireWindow (parent, inc_y, inc_width, inc_height, savelines,
			  widthp, heightp)
WinInfo parent;
int inc_y, inc_width, inc_height;
int savelines;
int *widthp, *heightp;
{
	WinInfo w;

	*heightp = EMPIRE_HEIGHT + inc_height;
	*widthp = ROOT_WIDTH + inc_width - (savelines > 0 ? 1 : 0);

	w = NewWindow();
	WindowInfo (w, *widthp, *heightp);
	w -> widget = XmCreateScrolledText (parent->widget,
					    "empire", NULL, 0);

	XtVaSetValues (w -> widget,
		       XmNeditable, False,
		       XmNeditMode, XmMULTI_LINE_EDIT,
		       XmNcolumns, 40,
		       XmNrows, 10,
		       NULL);
	XtManageChild(w -> widget);
	XtRealizeWidget (parent->shell);
	return w;
}

WinInfo OpenMessageWindow (parent, iw, widthp)
WinInfo parent;
int iw;
int *widthp;
{
	WinInfo w;
	*widthp = ROOT_WIDTH - CENSUS_WIDTH - 2 + iw;

	w = NewWindow ();
	WindowInfo (w, *widthp, 2);
	w -> widget = XtVaCreateManagedWidget ("message",
					       xmDrawingAreaWidgetClass,
					       parent -> widget,
					       XmNheight, w -> pix_dim.height,
					       XmNwidth, w -> pix_dim.width,
					       NULL);
	w -> pixmap = XCreatePixmap (display,
				     root_window,
				     w -> pix_dim.width,   
				     w -> pix_dim.height,
				     depth);
	ClearWindow(w);
	XtAddCallback (w -> widget,
		       XmNexposeCallback,
		       PixmapCopy_cb,
		       w);
	return w;
}

WinInfo OpenVersionWindow (parent, x, y)
WinInfo parent;
int x, y;
{
	WinInfo win;

	win = NewPopup(parent, "version", x, y);
	return win;
}

WinInfo OpenBaseWindow (x, y, width, height)
int x, y;
int width, height;
{
	WinInfo base;
	Widget menubar, mainw;

	/* 
	 *	initialize the X-server with the fonts (normal & bold)
	 */

	InitIcons ();
	base = NewWindow();
	base -> shell = XtAppCreateShell("xtemp", "XTemp", 
					 applicationShellWidgetClass,
					 display, NULL,0);
	
	mainw = XtVaCreateManagedWidget("main",
					xmMainWindowWidgetClass,
					base -> shell,
					XmNshowSeparator, True,
					NULL);
	
	menubar = XtVaCreateManagedWidget("menubar",
					  xmRowColumnWidgetClass,
					  mainw,
					  XmNrowColumnType, XmMENU_BAR,
					  XmNtopAttachment, XmATTACH_FORM,
					  XmNleftAttachment, XmATTACH_FORM,
					  XmNrightAttachment, XmATTACH_FORM,
					  NULL);
	CreateXMenubar (menubar, mainw);
	base -> widget =
		XtVaCreateManagedWidget ("pane",
					 xmPanedWindowWidgetClass,
					 mainw,
					 NULL);
	XmMainWindowSetAreas (mainw, menubar,
			      NULL, NULL, NULL,
			      base -> widget);
	InitXIcon (base);
	return base;
}


void DestroyWindow (win)
WinInfo win;
{
	WinInfo prev, curr;
	int found;

	prev = (WinInfo) 0;
	curr = first_window;
	found = False;

	while (! found && curr != (WinInfo) 0)
		if (curr == win)
		{
			found = True;
			if (prev == (WinInfo) 0)
				first_window = win -> next;
			else
				prev-> next = win -> next;
		} else {
			prev = curr;
			curr = curr-> next;
		}

	if (! found) {
		(void) fprintf (stderr,
			"DestroyWindow, error: wininfo not found\n");
		leave ();
	}

	if (win -> shell)
		XtDestroyWidget (win->shell);
	else
		XtDestroyWidget (win-> widget);
	XFreePixmap (display, win-> pixmap);
	(void) free ((char *) win);
}
	
	 /*	WinInfo XFindWindow (Window win)
	  *		Finds the WinInfo structure of win.
	  */

static WinInfo FindWindow (window)
Window window;
{
	WinInfo win;

	for (win = first_window; win != (WinInfo) 0; win = win-> next)
		if (XtWindow(win-> widget) == window) 
			return win;

	return (WinInfo) 0;
}

WinInfo EventWindow (event)
XEvent *event;
{
	return FindWindow (event-> xany. window);
}

void SetCursor (win, cursor)
WinInfo win;
Cursor cursor;
{
	win-> cursor = cursor;
	if (XtIsRealized(win -> widget))
		XDefineCursor (XtDisplay(win -> widget),
			       XtWindow(win-> widget), cursor);
}

void BusyCursor ()
{
	
	register WinInfo ptr;

	if (! xstarted)
		return;

	for (ptr = first_window; ptr != (WinInfo) 0; ptr = ptr-> next) {
		XDefineCursor (XtDisplay(ptr -> widget),
			       XtWindow(ptr-> widget), cr_busy);
	}

	Refresh ();
}

void ResetCursor ()
{
	register WinInfo ptr;

	if (! xstarted)
		return;

	for (ptr = first_window; ptr != (WinInfo) 0; ptr = ptr-> next) {
		SetCursor (ptr, ptr -> cursor);
		/* XSelectInput (display, ptr-> window, ptr-> events); */
	}

	Refresh ();
}

	 /*
	  *	RefreshWindow (Wininfo win, x, y, width, height)
	  *		Draws the given area at the window (from the pixmap).
	  */

static void RefreshWindow (win, x, y, width, height)
WinInfo win;
int x, y, width, height;
{
	if (!XtIsRealized (win -> widget))
		return;

	XCopyArea (XtDisplay(win -> widget),
		   win-> pixmap,
		   XtWindow(win-> widget),
		   gc_copy,
		   x, y,
		   width, height,
		   x, y);

	Refresh ();
}

void RefreshEvent (event)
XEvent *event;
{
	WinInfo win;

	if ((win = FindWindow (event-> xany. window)) == (WinInfo) 0)
		return;
	
	RefreshWindow (
		win,
		event-> xexpose. x,
		event-> xexpose. y,
		event-> xexpose. width,
		event-> xexpose. height);

/*	DrawScrollBar (win); */
}

void PrintMarkedAtPixmap (win, x, y, text, mode)
WinInfo win;
int x, y;
const char * text;
int mode;
{
	XDrawImageString (
		display,
		win-> pixmap,
		mode == NORMAL ? win-> normal_gc : win-> bold_gc,
		CharToPixelX (x),
		CharToPixelYB (y),
		text,
		strlen (text));
	
	XDrawRectangle (
		display,
		win-> pixmap,
		win-> normal_gc,
		CharToPixelX (x),
		CharToPixelY (y),
		CharToPixelX (strlen (text)) - 1,
		CharToPixelY (1) - 1);
}

void PrintAtPixmapN (win, x, y, text)
WinInfo win;
int x, y;
const char *text;
{
	if (win == empire_win) {
		AppendXText (win -> widget, text, 0);
		return;
	}

	XDrawImageString (
		display,
		win-> pixmap,
		win-> normal_gc,
		CharToPixelX (x),
		CharToPixelYB (y),
		text,
		strlen (text));
}

void PrintAtPixmapB (win, x, y, text)
WinInfo win;
int x, y;
const char *text;
{
	if (win == empire_win) {
		AppendXText (win -> widget, text, 0);
		return;
	}
	XDrawImageString (
		display,
		win-> pixmap,
		win-> bold_gc,
		CharToPixelX (x),
		CharToPixelYB (y),
		text,
		strlen (text));
}

int GetPixmapPosY (win, y)
WinInfo win;
int y;
{
	return PixelToCharY (y + win-> curline);
}

	/* ARGSUSED */
int GetPixmapPosX (win, x)
WinInfo win;
int x;
{
	return PixelToCharX (x);
}

void ClearLine (win, y)
WinInfo win;
int y;
{
	Print (win, 0, y, Fmt ("%*s", win-> char_dim.width, ""), NORMAL);
}

void Print (win, x, y, text, mode)
WinInfo win;
int x,y;
const char *text;
int mode;
{
	if (! xstarted)
		return;

	if (win == empire_win) {
		AppendXText (win -> widget, text, 0);
		return;
	}
	win-> curline = win-> pixsavelines;

	XDrawImageString (display,
			  win-> pixmap,
			  mode == NORMAL ? win-> normal_gc : 
			  mode == REVERSED ?
			  win-> rev_gc :
			  win-> bold_gc,

			  CharToPixelX (x),
			  CharToPixelYB (y) + win-> pixsavelines,
			  text,
			  strlen (text));
}

void SetToBot (win)
WinInfo win;
{
	win-> curline = win-> pixsavelines;
}

void SetToTop (win)
WinInfo win;
{
	win-> curline = 0;
}

void PrintB (win, x, y, text)
WinInfo win;
int x,y;
const char *text;
{
	Print (win, x, y, text, BOLD);
}

void PrintN (win, x, y, text)
WinInfo win;
int x,y;
const char *text;
{
	Print (win, x, y, text, NORMAL);
}

void PrintR (win, x, y, text)
WinInfo win;
int x, y;
const char * text;
{
	if (bold_is_reversed)
		Print (win, x, y, text, REVERSED);
	else
		Print (win, x, y, text, BOLD);
}

void ReverseWindow (win)
WinInfo win;
{
	if (! xstarted)
		return;

	XCopyArea (
		XtDisplay(win -> widget),
		win-> pixmap, 
		XtWindow(win-> widget),
		gc_inv_copy,
		0, win-> curline,
		win-> pix_dim.width, win-> pix_dim.height,
		0, 0);

/*	DrawScrollBar (win); */

	Refresh ();
}

void FlushWindow (win)
WinInfo win;
{
	if (! xstarted || !XtIsRealized(win->widget))
		return;

	if (win == empire_win)
	    return;
	XCopyArea (XtDisplay(win -> widget),
		   win-> pixmap, 
		   XtWindow(win-> widget),
		   gc_copy,
		   0, win-> curline,
		   win-> pix_dim.width, win-> pix_dim.height,
		   0, 0);

/*	DrawScrollBar (win); */

	Refresh ();
}

void DrawRect (win, x, y, width, height)
WinInfo win;
int x, y, width, height;
{
	win-> curline = win-> pixsavelines;

	XDrawRectangle (
		display,
		win-> pixmap,
		win-> normal_gc,
		x, y + win-> pixsavelines,
		width, height);
}

void PrintPixmap (win, x, y, pixmap)
WinInfo win;
int x, y;
Pixmap pixmap;
{
	win-> curline = win-> pixsavelines;

	XCopyArea (
		display,
		pixmap,
		win-> pixmap,
		reversed ? gc_inv_small : gc_small,
		0, 0,
		DESPIX_WIDTH,
		DESPIX_HEIGHT,
		x, y + win-> pixsavelines);
}

void PrintMarked (win, x, y, text, mode)
WinInfo win;
int x, y;
const char *text;
int mode;
{
	Print (win, x, y, text, mode);

	DrawRect (win, CharToPixelX (x), CharToPixelY (y),
		CharToPixelX (strlen (text)) - 1, CharToPixelY (1) - 1);
}

void Line (win, sx, sy, ex, ey)
WinInfo win;
int sx, sy, ex, ey;
{
	win-> curline = win-> pixsavelines;

	XDrawLine (display,
		   win-> pixmap,
		   win-> normal_gc,
		   sx, sy + win-> pixsavelines,
		   ex, ey + win-> pixsavelines);
}

void DrawHorizontal (win, pos)
WinInfo win;
int pos;
{
	int y;

	y = CharToPixelY (pos) + CharToPixelY (1) / 2;

	Line (win, 0, y - 3, win-> pix_dim.width, y - 3);
	Line (win, 0, y - 2, win-> pix_dim.width, y - 2);
	Line (win, 0, y, win-> pix_dim.width, y);
	Line (win, 0, y + 2, win-> pix_dim.width, y + 2);
	Line (win, 0, y + 3, win-> pix_dim.width, y + 3);
}

char * GetString (win, x, y, maxlen, form)
WinInfo win;
int x, y, maxlen;
const char * form;
{
	extern char erasechar, eraseword, eraseline;
	int len = 0;
	static char ret [BUFSIZ];
	XEvent event;
	Sector sct;
	char *ptr;
	int cont;
	char ch;
	char buffer [BUFSIZ];
	KeySym keysym;
	XComposeStatus comp_status;
	extern WinInfo map_win;

	if (maxlen + x > win-> char_dim.width)
		maxlen = win-> char_dim.width - x;

	cont = True;
	Print (win, x, y, "_", BOLD);
	FlushWindow (win);
	*ret = '\0';

	while (cont)
	{
		XtAppNextEvent (app_context, &event);

		switch (event. type)
		{

		case KeyPress:
			if (XLookupString (
				& (event. xkey),
				buffer,
				BUFSIZ - 1,
				&keysym,
				&comp_status) == 0) break;

			ch = buffer [0];

			if (ch == erasechar)
			{
				if (len != 0)
				{
					len --;
					ret [ len ] = '\0';
					PrintB (win, x, y, Fmt ("%s_ ", ret));
				}
				break;
			}

			cont = (keysym != XK_Return &&
				keysym != XK_KP_Enter &&
				keysym != XK_Escape);

			if (!cont)
				break;

			if (ch == eraseword)
			{
				int j;

				j = len;

				while (j > 0 && isspace (ret [--j]))
					ret [j] = '\0';

				while (j > 0 && !isspace (ret [--j]))
					ret [j] = '\0';

				if (j > 0) j++;

				if  (j == len)
					break;

				PrintN (win, x, y, Fmt ("%*s ", maxlen, ""));
				len = j;
				break;
			}
			else if (ch == eraseline)
			{
				len = 0;
				ret [len] = '\0';
				PrintN (win, x, y, Fmt ("%*s ", maxlen, ""));
				break;
			}
			else if (CharInFormat (ch, form) && len < maxlen)
			{
				ret [len] = ch;
				ret [++ len] = '\0';
			}
			break;

		case ButtonPress:

			if (EventWindow (& event) == map_win)
				sct = FindSector (event. xbutton. x,
						event. xbutton. y);
			else
				sct = (Sector) 0;

			switch (event. xbutton. button)
			{

			case LEFT_BUTTON:
				if (sct == (Sector) 0 || NO_INFO (sct))
					break;

				CensusSct (sct);
				break;

/* 
 * 			case MIDDLE_BUTTON:
 * 				if (! CharInFormat (',', form))
 * 					break;
 * 				if (sct == (Sector) 0 || NO_INFO (sct))
 * 					break;
 * 				if (sct != cursct && ! Adjacent (sct, cursct))
 * 					break;
 * 				
 * 				if (sct == cursct)
 * 				{
 * 					ret [len ++] = 'h';
 * 					ret [len ++] = ' ';
 * 					ret [len] = '\0';
 * 				}
 * 				else
 * 				{
 * 					ret [len ++] = GiveDirChar (cursct,
 * 									sct);
 * 					ret [len] = '\0';
 * MJH : ik wil geen SetCurrents mee op vreemde plaatsen dit maak deze
 * toch al niet bruikbare feature totaal onmogenlijk. (mischien laatste
 * onthouden ?)
 * 					SetCurrent (sct);
 * 				}
 * 				break;
 */

			case RIGHT_BUTTON:
				if (sct == (Sector) 0 || NO_INFO (sct))
					sct = cursct;

				ptr = CrdStr (sct);
				if (len > 0 && ret [len - 1] != ' ')
					ret [len ++] = ' ';
				while (*ptr != '\0')
					ret [len ++] = *ptr ++;
				ret [len ++] = ' ';
				ret [len] = '\0';
				break;
			}
			break;
		default:
			XtDispatchEvent (&event);
			break;
		}

		if (cont && (event. type == KeyPress ||
			     event. type == ButtonPress))
	     	{

			PrintB (win, x, y, Fmt ("%s_", ret));
			FlushWindow (win);
		}

	}

	if (interrupt || keysym == XK_Escape)
	{
		PrintN (win, x, y, Fmt ("%*s ", maxlen, ""));
		FlushWindow (win);
		return (char *) 0;
	}
	else
	{
		PrintB (win, x, y, Fmt ("%s ", ret));
		FlushWindow (win);
		return ret;
	}
}

void DrawArrow (win, x, y, dir)
WinInfo win;
int x, y;
char dir;
{
	int deltx, delty;

	x = CharToPixelX (x);
	y = CharToPixelY (y);

	deltx = CHAR_WIDTH / 2;
	delty = CHAR_HEIGHT / 2;

	/*		y   u
	 *	      g   .   j
	 *		b   n
	 */

	if (dir == 'b' || dir == 'u')
	{
		Line (win, x + CHAR_WIDTH - 2, y + 1,
			x + 1, y + CHAR_HEIGHT - 2);
		if (dir == 'b')
		{
			Line (win, x + 1, y + CHAR_HEIGHT - 2,
				x + 1 + deltx, y + CHAR_HEIGHT - 2);
			Line (win, x + 1, y + CHAR_HEIGHT - 2,
				x + 1, y + CHAR_HEIGHT - 1 - delty);
			return;
		}
		else
		{
			Line (win, x + CHAR_WIDTH - 2, y + 1,
				x + CHAR_WIDTH - 2 - deltx, y + 1);
			Line (win, x + CHAR_WIDTH - 2, y + 1,
				x + CHAR_WIDTH - 2, y + 1 + delty);
			return;
		}
	}
	else if (dir == 'y' || dir == 'n')
	{
		Line (win, x + 1, y + 1,
			x + CHAR_WIDTH - 2, y + CHAR_HEIGHT - 2);
		if (dir == 'y')
		{
			Line (win, x + 1, y + 1,
				x + 1 + deltx, y + 1);
			Line (win, x + 1, y + 1,
				x + 1, y + 1 + delty);
			return;
		}
		else
		{
			Line (win, x + CHAR_WIDTH - 2, y + CHAR_HEIGHT - 2,
				x + CHAR_WIDTH - 2 - deltx,
				y + CHAR_HEIGHT - 2);
			Line (win, x + CHAR_WIDTH - 2, y + CHAR_HEIGHT - 2,
				x + CHAR_WIDTH - 2,
				y + CHAR_HEIGHT - 2 - delty);
			return;
		}
	}
	else if (dir == 'g')
	{
		Line (win, x + 1, y + CHAR_HEIGHT / 2,
			x + CHAR_WIDTH - 1, y + CHAR_HEIGHT / 2);
		Line (win, x + 1, y + CHAR_HEIGHT / 2,
			x + 1 + deltx, y + CHAR_HEIGHT / 2 + delty);
		Line (win, x + 1, y + CHAR_HEIGHT / 2,
			x + 1 + deltx, y + CHAR_HEIGHT / 2 - delty);
		return;
	}
	else if (dir == 'j')
	{
		Line (win, x + 1, y + CHAR_HEIGHT / 2,
			x + CHAR_WIDTH - 1, y + CHAR_HEIGHT / 2);
		Line (win, x + CHAR_WIDTH - 2, y + CHAR_HEIGHT / 2,
			x + CHAR_WIDTH - 2 - deltx,
			y + CHAR_HEIGHT / 2 - delty);
		Line (win, x + CHAR_WIDTH - 2, y + CHAR_HEIGHT / 2,
			x + CHAR_WIDTH - 2 - deltx,
			y + CHAR_HEIGHT / 2 + delty);
	}
	else
		return;
}

void WarpPointer (win, x, y)
WinInfo win;
int x, y;
{
	XWarpPointer (
		XtDisplay(win -> widget),
		root_window,
		XtWindow(win-> widget),
		0, 0, 0, 0,
		x, y);
}

WinInfo OpenWinForWM (name, x, y, width, height, base, savelines)
const char * name;
int x, y, width, height, savelines;
int base;
{
	WinInfo w;

	w = NewPopup (first_window -> shell, name, width, height);

	return w;
}

WinInfo OpenRelToRoot (from, x, y, width, height, base, savelines)
WinInfo from;
int x, y, width, height, savelines;
int base;
{
	return NewPopup (from, "unknown", width, height);
}

#define TIMES 4

void FlashWindow (win)
WinInfo win;
{
	int i;

	if (! xstarted)
		return ;

	win-> curline = win-> pixsavelines;

	i = TIMES;

	while (i-- != 0) {

		ReverseWindow (win);
		FlushWindow (win);
	}
}
	
void Bell ()
{
	if (xstarted)
		XBell (display, 0);
}

bool WinHasScrollBar (win)
WinInfo win;
{
	return (win-> pixsavelines > 0);
}

void RaiseWindow (win)
WinInfo win;
{
	if (win -> shell)
		XRaiseWindow (XtDisplay(win->shell), XtWindow(win-> shell));
	else
		XRaiseWindow (XtDisplay(win->widget), XtWindow(win-> widget));

	CheckRefreshEvents ();
}

void LowerWindow (win)
WinInfo win;
{
	XLowerWindow (XtDisplay(win->widget), XtWindow(win-> widget));
}

void XorLine (win, psx, psy, pex, pey)
WinInfo win;
int psx, psy, pex, pey;
{
	XDrawLine (
		display,
		win-> pixmap,
		gc_xor,
		psx, psy, pex, pey);
}

void XorBox (win, psx, psy, pex, pey)
WinInfo win;
int psx, psy, pex, pey;
{
		/*
		 *	Should be done with XDrawLines
		 *
		 *
		 *	sx,sy		ex,sy
		 *
		 *
		 *
		 *	sx,ey		ex,ey
		 */

	XDrawRectangle (
		XtDisplay(win -> widget),
		win-> pixmap,
		gc_xor,
		psx, psy + win-> pixsavelines,
		pex - psx + 1, pey - psy + 1);
}

int WinHeight (win)
WinInfo win;
{
	return win-> pix_dim. height;
}

int WinWidth (win)
WinInfo win;
{
	return win-> pix_dim. width;
}

void LowerAll ()
{
	LowerWindow (empire_win);
	LowerWindow (map_win);
	LowerWindow (census_win);
	LowerWindow (mes_win);
}

void RaiseAll ()
{
	RaiseWindow (empire_win);
	RaiseWindow (map_win);
	RaiseWindow (census_win);
	RaiseWindow (mes_win);
}



void Scroll (win, lines)
WinInfo win;
int lines;
{
    if (win == empire_win)
	    AppendXText (win -> widget, "", 1);
}

WinInfo OpenWindow (from, x, y, width, height, base, menuflag, savelines)
WinInfo from;
int x, y, width, height;
int menuflag, base;
int savelines;
{
}

void SelectEvents (win, events)
WinInfo win;
unsigned long events;
{
}

bool ScrollEvent (pevent)
XEvent *pevent;
{
}

static void SetValue_cb (w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
	XtVaGetValues (w, XmNuserData, client_data, NULL);
}

#define MENU_CANCELLED	(-1)
#define MENU_ACTIVE	(-2)

static void Cancel_cb (w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
	int *id = (int *)client_data;

	if (*id == MENU_ACTIVE) *id = MENU_CANCELLED;
	XtDestroyWidget (w);
}


int DoXPagerMenu (parent, strings, title, x, y, funcp)
WinInfo parent;
Strings strings;
const char *title;
int x, y;
int *funcp;
{
	Widget menu;
	Widget w;
	const char *ptr;
	int id;
	static int ret;
	char buf[BUFSIZ];
	Position px, py;

	strcpy (buf, title);
	menu = XmCreatePopupMenu (parent -> widget,
				  buf,
				  NULL, 0);
	XtAddCallback (XtParent(menu),
		       XmNpopdownCallback, Cancel_cb, &ret);

	XtTranslateCoords (parent -> widget,
			   CharToPixelX(x), CharToPixelY(y),
			   &px, &py);
	XtVaSetValues (menu,
		       XmNx, px,
		       XmNy, py,
		       NULL);

	w = XtVaCreateManagedWidget (buf,
				     xmLabelWidgetClass,
				     menu,
				     NULL);
	w = XtVaCreateManagedWidget ("sep",
				     xmSeparatorWidgetClass,
				     menu,
				     NULL);
	InitStringList (strings);
	while ((ptr = GetNextStringID (strings, &id)) != NULL) {
		Widget item;

		strcpy (buf, ptr);

		item = XtVaCreateManagedWidget (buf,
						xmPushButtonWidgetClass,
						menu,
						XmNuserData, id,
						NULL);
		XtAddCallback (item,
			       XmNactivateCallback, SetValue_cb, &ret);


	}
	

	XtManageChild (menu);
					 
	ret = MENU_ACTIVE;
	while (ret == MENU_ACTIVE) {
		XEvent event;

		XtAppNextEvent (app_context, &event);
		XtDispatchEvent (&event);
	}
	return ret;
}

bool GetXSector (x, y, button)
int *x, *y;
int *button;
{
	XtAddGrab (map_win -> widget, False, False);
	XtAddCallback (map_win -> widget,
		       XmNinputCallback, MapSelSect_cb, map_win);
	map_win -> flags |= WFL_SECT;
	while ((map_win -> flags & WFL_DONE) == 0) {
		XEvent event;

		XtAppNextEvent (app_context, &event);
		XtDispatchEvent (&event);
		
	}
	map_win -> flags = WFL_NONE;
	XtRemoveCallback (map_win -> widget,
			  XmNinputCallback, MapSelSect_cb, map_win);
	XtRemoveGrab (map_win->widget);
	*x = map_win -> selx;
	*y = map_win -> sely;
	*button = map_win -> button;
	return True;
}

WinInfo CreateXDialog (title, strings, n, names, ids)
char *title;
Strings strings;
int n;
char *names[];
int ids[];
{
	WinInfo w = NewWindow ();

	w -> widget = XmCreateBulletinBoardDialog (first_window -> shell, 
						   title,
						   NULL,
						   0);
	return w;
}

static void DeletePopup_cb (w, client_data, call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	XtDestroyWidget ((Widget)client_data);
}

static void save_file_cb (w, client_data, call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	Widget fsb = (Widget)client_data;
	XmString xm_filename;
	char *fname, *str;
	Widget text;
	FILE *fp;

	XtVaGetValues (fsb,
		       XmNtextString,        &xm_filename,
		       NULL);

	XmStringGetLtoR(xm_filename, XmSTRING_DEFAULT_CHARSET, &fname);
	if ((fp = fopen(fname, "w")) == NULL)
		Message (Fmt("Can't write to %s", fname));
	else {
		XtVaGetValues (w,
			       XmNuserData, &text,
			       NULL);
		XtVaGetValues (text,
			       XmNvalue, &str,
			       NULL);
		fputs (str, fp);
		fclose (fp);
		free (str);
	}
	free(fname);
	XtDestroyWidget (fsb);
}

static void SaveText_cb (w, client_data, call_data)
Widget w;
XtPointer client_data;		/* the text widget */
XtPointer call_data;
{
	Widget fsb, temp;
	Widget text = (Widget)client_data;

	fsb = XmCreateFileSelectionDialog(text, "Select File", NULL, 0);

	temp = XmFileSelectionBoxGetChild(fsb, XmDIALOG_OK_BUTTON);
	XtVaSetValues(temp, XmNuserData, text, NULL);
	XtAddCallback (temp, XmNactivateCallback, save_file_cb, fsb);

	temp = XmFileSelectionBoxGetChild (fsb, XmDIALOG_CANCEL_BUTTON);
	XtAddCallback (temp, XmNactivateCallback, DeletePopup_cb, fsb);

	XtManageChild (fsb);
}

void ShowStringsInPager (strings, header)
Strings strings;
const char *header;
{
	Widget top, button, sbutton, w, text;
	const char *ptr;
	int height, width;
	Arg args[2];

	XtSetArg (args[0], XmNautoUnmanage, False);
	top = XmCreateFormDialog (first_window -> widget,
				  header,
				  args,
				  1);
	

	button = XtVaCreateManagedWidget ("Done",
					  xmPushButtonWidgetClass,
					  top,
					  XmNbottomAttachment, XmATTACH_FORM,
					  NULL);

	XtAddCallback (button, XmNactivateCallback,
		       DeletePopup_cb, top);

	sbutton = XtVaCreateManagedWidget ("Save",
					   xmPushButtonWidgetClass,
					   top,
					   XmNbottomAttachment, XmATTACH_FORM,
					   XmNrightAttachment, XmATTACH_FORM,
					   NULL);

	w = XtVaCreateManagedWidget ("separator",
				     xmSeparatorWidgetClass,
				     top,
				     XmNbottomAttachment, XmATTACH_WIDGET,
				     XmNbottomWidget, button,
				     NULL);

	text = XmCreateScrolledText (top, "text", NULL, 0);
	XtAddCallback (sbutton, XmNactivateCallback,
		       SaveText_cb, text);
	XtVaSetValues (XtParent(text),
		       XmNleftAttachment, XmATTACH_FORM,
		       XmNrightAttachment, XmATTACH_FORM,
		       XmNtopAttachment, XmATTACH_FORM,
		       XmNbottomAttachment, XmATTACH_WIDGET,
		       XmNbottomWidget,  w,
		       NULL);

	height = StringsSize(strings) + 1;
	if (height > 20) height = 20;
	width = MaxStringLen(strings);
	if (width > 80)
		width = 80;
	XtVaSetValues (text,
		       XmNeditable, 	False,
		       XmNeditMode, 	XmMULTI_LINE_EDIT,
		       XmNcolumns,	width,
		       XmNrows,		height,
		       NULL);
	XtManageChild(text);

	InitStringList (strings);
	while ((ptr = GetNextString (strings)) != NULL)
		AppendXText (text, ptr, 1); 

	XtVaSetValues (top,
		       XmNdefaultButton, button,
		       NULL);
	XtManageChild (top);
}

static void AppendXText (w, str, nl)
Widget w;
const char *str;
int nl;
{
	XmTextPosition pos = XmTextGetLastPosition(w);
	XmTextInsert (w, pos, str);
	if (nl) {
		pos = XmTextGetLastPosition(w);
		XmTextInsert (w, pos, "\n");
	}
}

static void ListSelect_cb (w, client_data, call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	XmListCallbackStruct *lcs = (XmListCallbackStruct *)call_data;
	Strings strings = (Strings)client_data;
	const char *ptr;
	int id;
	int i, j;

	InitStringList (strings);
	for (i = 1; (ptr = GetNextStringID (strings, &id)) != NULL; i++) {
	    for (j = 0; j < lcs -> selected_item_count; j++) {
		if (i == lcs->selected_item_positions[j]) {
		    SetStringFlag (strings, id, TRUE);
		    break;
		}
	    }
	    if (j >= lcs -> selected_item_count)
		SetStringFlag (strings, id, FALSE);
	}
}

static void ListSelectSingle_cb (w, client_data, call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	XmListCallbackStruct *lcs = (XmListCallbackStruct *)call_data;
	Strings strings = (Strings)client_data;
	const char *ptr;
	int id;
	int i;

	InitStringList (strings);
	for (i = 1; (ptr = GetNextStringID (strings, &id)) != NULL; i++) {
		if (i == lcs -> item_position)
			SetStringFlag (strings, id, TRUE);
		else
			SetStringFlag (strings, id, FALSE);
	}
}

int MultiSelectPager (strings, title, middle, mfunc, proc)
Strings strings;
const char *title;
const char *middle;
int mfunc;
InfoProc proc;
{
	Widget top, bok, bcancel, list, w, w2;
	int status = 1;
	const char *ptr;
	int vis;
	bool flag;

	top = XmCreateFormDialog (first_window -> widget,
				  title,
				  NULL,
				  0);

	bok = XtVaCreateManagedWidget ("OK",
				       xmPushButtonWidgetClass,
				       top,
				       XmNbottomAttachment, XmATTACH_FORM,
				       XmNuserData,	DONEFUNC,
				       NULL);
	XtAddCallback (bok,
		       XmNactivateCallback,
		       SetValue_cb,
		       &status);

	bcancel = XtVaCreateManagedWidget ("Cancel",
					   xmPushButtonWidgetClass,
					   top,
					   XmNbottomAttachment, XmATTACH_FORM,
					   XmNleftAttachment, XmATTACH_WIDGET,
					   XmNleftWidget, bok,
					   XmNuserData, CANCELFUNC,
					   NULL);
	XtAddCallback (bcancel,
		       XmNactivateCallback,
		       SetValue_cb,
		       &status);

	if (mfunc) {
		w2 = XtVaCreateManagedWidget (middle,
					      xmPushButtonWidgetClass,
					      top,
					      XmNbottomAttachment, XmATTACH_FORM,
					      XmNleftAttachment, XmATTACH_WIDGET,
					      XmNleftWidget, bcancel,
					      XmNuserData, mfunc,
					      NULL);
		XtAddCallback (w2,
			       XmNactivateCallback,
			       SetValue_cb,
			       &status);
	}

	w = XtVaCreateManagedWidget ("separator",
				     xmSeparatorWidgetClass,
				     top,
				     XmNbottomAttachment, XmATTACH_WIDGET,
				     XmNbottomWidget, bok,
				     NULL);
	list = XmCreateScrolledList (top, "list", NULL, 0);

	XtVaSetValues (XtParent(list),
		       XmNleftAttachment, XmATTACH_FORM,
		       XmNrightAttachment, XmATTACH_FORM,
		       XmNtopAttachment, XmATTACH_FORM,
		       XmNbottomAttachment, XmATTACH_WIDGET,
		       XmNbottomWidget,  w,
		       NULL);

	vis = StringsSize(strings);
	if (vis > 10) vis = 10;
	XtVaSetValues (list,
		       XmNselectionPolicy, XmMULTIPLE_SELECT,
		       XmNvisibleItemCount, vis,
		       NULL);
	XtAddCallback (list,
		       XmNmultipleSelectionCallback,
		       ListSelect_cb,
		       strings);
	XtManageChild(list);

	
	InitStringList (strings);
	while ((ptr = GetNextStringFlag (strings, &flag)) != NULL) {
		XmString xs = XmStringCreateLtoR (ptr,
						  XmFONTLIST_DEFAULT_TAG);
		if (flag) {
			XmListAddItem (list, xs, 0);
			XmListSelectItem (list, xs, False);
		}
		else
			XmListAddItemUnselected (list, xs, 0);
	}

	XtVaSetValues (top,
		       XmNcancelButton, bcancel,
		       XmNdefaultButton, bok,
		       XmNdialogStyle, XmDIALOG_APPLICATION_MODAL,
		       NULL);

	XtManageChild (top);

	while (status == 1) {
		XEvent event;

		XtAppNextEvent (app_context, &event);
		XtDispatchEvent (&event);
	}
	XtDestroyWidget (top);
	return status;
}

struct pd_data {
	Strings strings;
	void *data;
	Widget list;
	FuncListFnx fptr;
};

static void CallFnx_cb (w, client_data, call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	FuncListFnx fptr = (FuncListFnx)client_data;
	struct pd_data *pdata;
	int *list;
	int lcount;
	int i, j;
	const char *ptr;
	int id;

	XtVaGetValues (w, XmNuserData, &pdata, NULL);
	if (XmListGetSelectedPos (pdata -> list, &list, &lcount) == False)
		return;

	InitStringList (pdata -> strings);
	for (i = 1;
	     (ptr = GetNextStringID (pdata -> strings, &id)) != NULL;
	     i++) {
		XmString xs;
		for (j = 0; j < lcount; j++)
			if (list[j] == i)
				break;
		if (j >= lcount)
			continue;
		(*fptr) (pdata -> strings, id, pdata -> data);
		xs = XmStringCreateLtoR (GiveIdString (pdata -> strings, id),
					 XmFONTLIST_DEFAULT_TAG);
		XmListReplacePositions (pdata -> list, &list[j], &xs, 1);
	}
	free (list);
}

int MakePickDialog (strings, title, flist, data, parent, x, y, multi)
Strings strings;
const char *title;
FuncList flist[];
void *data;
WinInfo parent;
int x, y;
bool multi;
{
	Widget top, sep, list;
	Widget prev = NULL;
	int ret;
	struct pd_data pdata;
	FuncList *fp;
	int vis;
	const char *ptr;
	bool flag;
	Arg args[1];

	pdata.strings = strings;
	pdata.data = data;
	pdata.list = NULL;

	XtSetArg (args[0], XmNautoUnmanage, False);
	top = XmCreateFormDialog (parent -> widget, title, args, 1);

	for (fp = flist; fp -> funcname; fp ++) {
		Widget w;

		w = XtVaCreateManagedWidget (fp -> funcname,
					     xmPushButtonWidgetClass,
					     top,
					     XmNbottomAttachment, XmATTACH_FORM,
					     NULL);
		if (prev)
			XtVaSetValues (w,
				       XmNleftAttachment, XmATTACH_WIDGET,
				       XmNleftWidget, prev,
				       NULL);
		else
			XtVaSetValues (top,
				       XmNdefaultButton, w,
				       NULL);
		if (fp -> funcptr == NULL) {
			XtVaSetValues (w, XmNuserData, fp -> funcid, NULL);
			XtAddCallback (w, XmNactivateCallback,
				       SetValue_cb, &ret);
		}
		else {
			XtVaSetValues (w, XmNuserData, &pdata, NULL);
			XtAddCallback (w, XmNactivateCallback,
				       CallFnx_cb, fp -> funcptr);
		}
			
		prev = w;
	}
	sep = XtVaCreateManagedWidget ("separator",
				       xmSeparatorWidgetClass,
				       top,
				       XmNbottomAttachment, XmATTACH_WIDGET,
				       XmNbottomWidget, prev,
				       NULL);

	list = XmCreateScrolledList (top, "list", NULL, 0);
	pdata.list = list;

	XtVaSetValues (XtParent(list),
		       XmNleftAttachment, XmATTACH_FORM,
		       XmNrightAttachment, XmATTACH_FORM,
		       XmNtopAttachment, XmATTACH_FORM,
		       XmNbottomAttachment, XmATTACH_WIDGET,
		       XmNbottomWidget,  sep,
		       NULL);

	vis = StringsSize(strings);
	if (vis > 10) vis = 10;
	if (multi) {
		XtVaSetValues (list,
			       XmNselectionPolicy, XmMULTIPLE_SELECT,
			       XmNvisibleItemCount, vis,
			       NULL);
		XtAddCallback (list,
			       XmNmultipleSelectionCallback,
			       ListSelect_cb,
			       strings);
	}
	else {
		XtVaSetValues (list,
			       XmNselectionPolicy, XmSINGLE_SELECT,
			       XmNvisibleItemCount, vis,
			       NULL);
		XtAddCallback (list,
			       XmNsingleSelectionCallback,
			       ListSelectSingle_cb,
			       strings);
	}
	XtManageChild(list);

	
	InitStringList (strings);
	while ((ptr = GetNextStringFlag (strings, &flag)) != NULL) {
		XmString xs = XmStringCreateLtoR (ptr,
						  XmFONTLIST_DEFAULT_TAG);
		if (flag) {
			XmListAddItem (list, xs, 0);
			XmListSelectItem (list, xs, False);
		}
		else
			XmListAddItemUnselected (list, xs, 0);
	}
	XtVaSetValues (top,
		       XmNdialogStyle, XmDIALOG_APPLICATION_MODAL,
		       NULL);
	XtManageChild (top);

	ret = 1;
	while (ret == 1) {
		XEvent event;

		XtAppNextEvent (app_context, &event);
		XtDispatchEvent (&event);
	}
	XtDestroyWidget (top);
	return ret;
}


Strings EditText (title, strings, action, parent, x, y)
const char *title;
Strings strings;
const char *action;
WinInfo parent;
int x, y;
{
    	Widget top, button, cbutton, sbutton, w, text;
	const char *ptr;
	int height, width;
	Arg args[2];
	int status;
	char *str;
	char *bp, *cp;

	XtSetArg (args[0], XmNautoUnmanage, False);
	top = XmCreateFormDialog (first_window -> widget,
				  title,
				  args,
				  1);
	

	button = XtVaCreateManagedWidget (action,
					  xmPushButtonWidgetClass,
					  top,
					  XmNbottomAttachment, XmATTACH_FORM,
					  XmNuserData, DONEFUNC,
					  NULL);

	XtAddCallback (button, XmNactivateCallback,
		       SetValue_cb, &status);

	cbutton = XtVaCreateManagedWidget ("Cancel",
					   xmPushButtonWidgetClass,
					   top,
					   XmNbottomAttachment, XmATTACH_FORM,
					   XmNleftAttachment, XmATTACH_WIDGET,
					   XmNleftWidget, button,
					   XmNuserData, CANCELFUNC,
					   NULL);

	XtAddCallback (cbutton, XmNactivateCallback,
		       SetValue_cb, &status);


	sbutton = XtVaCreateManagedWidget ("Save",
					   xmPushButtonWidgetClass,
					   top,
					   XmNbottomAttachment, XmATTACH_FORM,
					   XmNleftAttachment, XmATTACH_WIDGET,
					   XmNleftWidget, cbutton,
					   NULL);

	w = XtVaCreateManagedWidget ("separator",
				     xmSeparatorWidgetClass,
				     top,
				     XmNbottomAttachment, XmATTACH_WIDGET,
				     XmNbottomWidget, button,
				     NULL);

	text = XmCreateScrolledText (top, "text", NULL, 0);
	XtAddCallback (sbutton, XmNactivateCallback,
		       SaveText_cb, text);
	XtVaSetValues (XtParent(text),
		       XmNleftAttachment, XmATTACH_FORM,
		       XmNrightAttachment, XmATTACH_FORM,
		       XmNtopAttachment, XmATTACH_FORM,
		       XmNbottomAttachment, XmATTACH_WIDGET,
		       XmNbottomWidget,  w,
		       NULL);

	height = StringsSize(strings) + 1;
	if (height > 20) height = 20;
	width = MaxStringLen(strings);
	if (width > 80)
		width = 80;
	XtVaSetValues (text,
		       XmNeditable, 	True,
		       XmNeditMode, 	XmMULTI_LINE_EDIT,
		       XmNcolumns,	width,
		       XmNrows,		height,
		       NULL);
	XtManageChild(text);

	InitStringList (strings);
	while ((ptr = GetNextString (strings)) != NULL)
		AppendXText (text, ptr, 1); 

	XtVaSetValues (top,
		       XmNcancelButton, cbutton,
		       XmNdefaultButton, button,
		       XmNdialogStyle, XmDIALOG_APPLICATION_MODAL,
		       NULL);

	XtManageChild (top);
	FreeStrings (strings);

	status = 1;
	while (status == 1) {
		XEvent event;

		XtAppNextEvent (app_context, &event);
		XtDispatchEvent (&event);
	}
	if (status == CANCELFUNC) {
	    XtDestroyWidget (top);
	    return NULL;
	}
	strings = InitStrings ();
	XtVaGetValues (text,
		       XmNvalue, &str,
		       NULL);
	for (bp = cp = str; cp = index(bp, '\n'); bp = cp) {
	    *cp ++ = '\0';
	    AddString (strings, bp);
	}
	XtDestroyWidget (top);
	free(str);
	return strings;
}

int PopupYesNo (strings, title)
Strings strings;
const char *title;
{
	Widget quest;
	Widget button;
	XmString base = NULL;
	const char *ptr;
	int status = 0;
	XmString ts, xs;

	quest = XmCreateQuestionDialog (map_win -> widget, title, NULL, 0);
 	InitStringList (strings);
	while ((ptr = GetNextString (strings)) != NULL) {
		xs = XmStringCreateLtoR (ptr,
						  XmFONTLIST_DEFAULT_TAG);
		if (base == NULL)
			base = xs;
		else {
			ts = XmStringConcat (base, xs);
			XmStringFree (base);
			XmStringFree (xs);
			base = ts;
		}
	}
	XtVaSetValues (quest,
		       XmNmessageString, base,
		       XmNokLabelString,
		       ts = XmStringCreateLtoR ("Yes", XmFONTLIST_DEFAULT_TAG),
		       XmNcancelLabelString,
		       xs = XmStringCreateLtoR ("No", XmFONTLIST_DEFAULT_TAG),
		       NULL);
	XmStringFree (ts);
	XmStringFree (xs);

        /* remove the help button */
        button = XmMessageBoxGetChild(quest, XmDIALOG_HELP_BUTTON);
        XtUnmanageChild(button);

        button = XmMessageBoxGetChild(quest, XmDIALOG_OK_BUTTON);
	XtAddCallback(button, XmNactivateCallback,
		      SetValue_cb, &status);
	XtVaSetValues (button, XmNuserData, DONEFUNC, NULL);
 
        button = XmMessageBoxGetChild(quest, XmDIALOG_CANCEL_BUTTON);
	XtAddCallback(button, XmNactivateCallback,
		      SetValue_cb, &status);
	XtVaSetValues (button, XmNuserData, CANCELFUNC, NULL);

	XtManageChild (quest);

	while (status == 0) {
		XEvent event;

		XtAppNextEvent (app_context, &event);
		XtDispatchEvent (&event);
	}
	XtDestroyWidget (quest);
	return status;
}

int PopupInform (strings, title)
Strings strings;
const char *title;
{
	Widget info;
	Widget button;
	XmString base = NULL;
	XmString ts;
	const char *ptr;
	int status = 0;

	info = XmCreateInformationDialog (map_win -> widget, title, NULL, 0);
 	InitStringList (strings);
	while ((ptr = GetNextString (strings)) != NULL) {
		XmString xs = XmStringCreateLtoR (ptr,
						  XmFONTLIST_DEFAULT_TAG);
		if (base == NULL)
			base = xs;
		else {
			ts = XmStringConcat (base, xs);
			XmStringFree (base);
			XmStringFree (xs);
			base = ts;
		}
	}
	XtVaSetValues (info,
		       XmNmessageString, base,
		       XmNokLabelString,
		       ts = XmStringCreateLtoR ("Yes", XmFONTLIST_DEFAULT_TAG),
		       NULL);
	XmStringFree (ts);
	XmStringFree (base);
	
        /* remove the help button */
        button = XmMessageBoxGetChild(info, XmDIALOG_HELP_BUTTON);
        XtUnmanageChild(button);

        button = XmMessageBoxGetChild(info, XmDIALOG_OK_BUTTON);
	XtAddCallback(button,
		      XmNactivateCallback,
		      SetValue_cb, &status);
	XtVaSetValues (button, XmNuserData, DONEFUNC, NULL);
 
        button = XmMessageBoxGetChild(info, XmDIALOG_CANCEL_BUTTON);
	XtUnmanageChild (button);

	XtManageChild (info);

	while (status == 0) {
		XEvent event;

		XtAppNextEvent (app_context, &event);
		XtDispatchEvent (&event);
	}
	XtDestroyWidget (info);
	return status;
}

int SelectString (strings, title, parent, x, y)
Strings strings;
const char *title;
WinInfo parent;
int x, y;
{
	Widget top, sel, cancel, sep, list;
	int ret;
	const char *ptr;
	bool flag;
	Arg args[1];
	int vis;

	XtSetArg (args[0], XmNautoUnmanage, False);
	top = XmCreateFormDialog (parent -> widget, title, args, 1);

	sel = XtVaCreateManagedWidget ("Select",
				       xmPushButtonWidgetClass,
				       top,
				       XmNbottomAttachment, XmATTACH_FORM,
				       NULL);
	XtVaSetValues (sel, XmNuserData, DONEFUNC, NULL);
	XtAddCallback (sel, XmNactivateCallback, SetValue_cb, &ret);
	cancel = XtVaCreateManagedWidget ("Cancel",
					  xmPushButtonWidgetClass,
					  top,
					  XmNbottomAttachment, XmATTACH_FORM,
					  XmNleftAttachment, XmATTACH_WIDGET,
					  XmNleftWidget, sel,
					  NULL);
	XtVaSetValues (cancel, XmNuserData, CANCELFUNC, NULL);
	XtAddCallback (cancel, XmNactivateCallback, SetValue_cb, &ret);
	sep = XtVaCreateManagedWidget ("separator",
				       xmSeparatorWidgetClass,
				       top,
				       XmNbottomAttachment, XmATTACH_WIDGET,
				       XmNbottomWidget, sel,
				       NULL);

	list = XmCreateScrolledList (top, "list", NULL, 0);

	XtVaSetValues (XtParent(list),
		       XmNleftAttachment, XmATTACH_FORM,
		       XmNrightAttachment, XmATTACH_FORM,
		       XmNtopAttachment, XmATTACH_FORM,
		       XmNbottomAttachment, XmATTACH_WIDGET,
		       XmNbottomWidget,  sep,
		       NULL);

	vis = StringsSize(strings);
	if (vis > 10) vis = 10;
	XtVaSetValues (list,
		       XmNselectionPolicy, XmSINGLE_SELECT,
		       XmNvisibleItemCount, vis,
		       NULL);
	XtAddCallback (list,
		       XmNsingleSelectionCallback,
		       ListSelectSingle_cb,
		       strings);
	XtManageChild(list);

	
	InitStringList (strings);
	while ((ptr = GetNextStringFlag (strings, &flag)) != NULL) {
		XmString xs = XmStringCreateLtoR (ptr,
						  XmFONTLIST_DEFAULT_TAG);
		if (flag) {
			XmListAddItem (list, xs, 0);
			XmListSelectItem (list, xs, False);
		}
		else
			XmListAddItemUnselected (list, xs, 0);
	}
	XtVaSetValues (top,
		       XmNdialogStyle, XmDIALOG_APPLICATION_MODAL,
		       NULL);
	XtManageChild (top);

	ret = 1;
	while (ret == 1) {
		XEvent event;

		XtAppNextEvent (app_context, &event);
		XtDispatchEvent (&event);
	}
	XtDestroyWidget (top);
	if (ret == DONEFUNC) {
		InitStringList (strings);
		ret = 0;
		while ((ptr = GetNextStringFlag (strings, &flag)) != NULL) {
			if (flag)
				return ret;
			ret ++;
		}
	}
	return CANCELFUNC;
}
