/*
 * $Header: /nexor/users/jpo/xemp/xemp5.0/xt/RCS/xwindow.c,v 5.2 1995/09/08 07:51:45 jpo Exp jpo $
 * $Date: 1995/09/08 07:51:45 $
 * $Author: jpo $
 * $Id: xwindow.c,v 5.2 1995/09/08 07:51:45 jpo Exp jpo $
 * $Locker: jpo $
 * $Log: xwindow.c,v $
 *
 */

/* MOTIF variant of xemp */

#include "type.h"
#include "main.h"
#include "xemp.h"
#include <Xm/Xm.h>
#include <Xm/CascadeB.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <Xm/Separator.h>


static void DoCall_cb (w, client_data, call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
    void (*proc)() = client_data;

    (*proc) ();
}

struct menuitems {
    const char *str;
    void (*proc)();
};

static struct menuitems FileMenuItems[] = {
{	"About...", ShowVersion },
{	"Save",	StoreData },
{	"-",	NULL },
{	"Quit (and save)", DoQuit },
{	"Exit (no save)",  FastQuit },
{ NULL }
};


static Widget create_file_menu (parent)
Widget parent;
{
    Widget menu, item;
    struct menuitems *mp;

    menu = XmCreatePulldownMenu (parent, "File", NULL, 0);
    for (mp = FileMenuItems; mp -> str; mp ++) {
	if (mp -> proc == NULL) {
	    item = XtVaCreateManagedWidget (mp -> str,
					    xmSeparatorWidgetClass,
					    menu,
					    NULL);
	}
	else {
	    item = XtVaCreateManagedWidget (mp -> str,
					    xmPushButtonWidgetClass,
					    menu,
					    NULL);
	    XtAddCallback (item, XmNactivateCallback, DoCall_cb, mp -> proc);
	}
    }

    return menu;
}

static void Raise_cb (w, client_data, call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
    WinInfo *win = (WinInfo *)client_data;
    RaiseWindow (*win);
}

static Widget create_window_menu (parent)
Widget parent;
{
    Widget menu, item;

    menu = XmCreatePulldownMenu (parent, "File", NULL, 0);

    item = XtVaCreateManagedWidget ("Census",
				    xmPushButtonWidgetClass,
				    menu,
				    NULL);
    XtAddCallback (item, XmNactivateCallback, Raise_cb, &census_win);

    return menu;
}

void CreateXMenubar (mbar, parent)
Widget mbar;
Widget parent;
{
    Widget menu;

    menu = create_file_menu (parent);

    XtVaCreateManagedWidget ("File",
			     xmCascadeButtonWidgetClass,
			     mbar,
			     XmNsubMenuId, menu,
			     NULL);
    menu = create_window_menu (parent);
    XtVaCreateManagedWidget ("Windows",
			     xmCascadeButtonWidgetClass,
			     mbar,
			     XmNsubMenuId, menu,
			     NULL);
}

