/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/xm/RCS/xicons.c,v 5.1 1993/03/14 16:35:51 etienne Exp jpo $
    $Date: 1993/03/14 16:35:51 $
    $Author: etienne $
    $Id: xicons.c,v 5.1 1993/03/14 16:35:51 etienne Exp jpo $
    $Locker: jpo $
    $Log: xicons.c,v $
    Revision 5.1  1993/03/14 16:35:51  etienne
    *** empty log message ***

 * Revision 5.0  93/02/06  09:26:31  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:00:52  greyhelm
 * Add RCS logging - Karl Hagen
 *

*/
	/*
	 *	Emptool				<file: xicons.c>
	 *	
	 *	Written by Hj Visscher.
	 *
	 *	InitIcons ()
	 *		Create all pixmaps and cursors needed.
	 *
	 */

#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "type.h"
#include "main.h"
#include "xextern.h"

extern bool reversed;

/* include other icons */

#include "arrows.h"
#include "distr.h"
#include "hjv.h"
#include "map.h"
#include "menu.h"
#include "scroll.h"
#include "busy.h"
#include "icon.h"
#include "smiley.h"


	/* Pixmaps of cursors which must not be changed */

static Pixmap pm_arrows;
static Pixmap pm_distr;
static Pixmap pm_hjv;
static Pixmap pm_map;
static Pixmap pm_menu;
static Pixmap pm_busy;
static Pixmap pm_smiley;
static Pixmap pm_scroll;
static Pixmap pm_scrollmask;

Pixmap pm_icon;

Cursor cr_arrows;
Cursor cr_distr;
Cursor cr_hjv;
Cursor cr_map;
Cursor cr_menu;
Cursor cr_scroll;
Cursor cr_busy;
Cursor cr_smiley;

void InitIcons ()
{
	pm_distr = XCreateBitmapFromData (
		display,
		root_window,
		distr_bits,
		distr_width,
		distr_height);

	pm_arrows = XCreateBitmapFromData (
		display,
		root_window,
		arrows_bits,
		arrows_width,
		arrows_height);

	pm_hjv = XCreateBitmapFromData (
		display,
		root_window,
		hjv_bits,
		hjv_width,
		hjv_height);

	pm_map = XCreateBitmapFromData (
		display,
		root_window,
		map_bits,
		map_width,
		map_height);

	pm_menu = XCreateBitmapFromData (
		display,
		root_window,
		menu_bits,
		menu_width,
		menu_height);

	pm_smiley = XCreateBitmapFromData (
		display,
		root_window,
		smiley_bits,
		smiley_width,
		smiley_height);

	pm_busy = XCreateBitmapFromData (
		display,
		root_window,
		busy_bits,
		busy_width,
		busy_height);

	pm_scroll = XCreateBitmapFromData (
		display,
		root_window,
		scroll_bits,
		scroll_width,
		scroll_height);

	pm_scrollmask = XCreateBitmapFromData (
		display,
		root_window,
		scroll_mask,
		scroll_width,
		scroll_height);

	pm_icon = XCreateBitmapFromData (
		display,
		root_window,
		icon_bits,
		icon_width,
		icon_height);

	cr_arrows = XCreatePixmapCursor (
		display,
		pm_arrows,
		pm_arrows,
		reversed ? & white_color : & black_color,
		reversed ? & black_color : & white_color,
		arrows_x_hot,
		arrows_y_hot);

	cr_distr = XCreatePixmapCursor (
		display,
		pm_distr,
		pm_distr,
		reversed ? & white_color : & black_color,
		reversed ? & black_color : & white_color,
		distr_x_hot,
		distr_y_hot);

	cr_hjv = XCreatePixmapCursor (
		display,
		pm_hjv,
		pm_hjv,
		reversed ? & white_color : & black_color,
		reversed ? & black_color : & white_color,
		hjv_x_hot,
		hjv_y_hot);

	cr_map = XCreatePixmapCursor (
		display,
		pm_map,
		pm_map,
		reversed ? & white_color : & black_color,
		reversed ? & black_color : & white_color,
		map_x_hot,
		map_y_hot);

	cr_busy = XCreatePixmapCursor (
		display,
		pm_busy,
		pm_busy,
		reversed ? & white_color : & black_color,
		reversed ? & black_color : & white_color,
		busy_x_hot,
		busy_y_hot);

	cr_smiley = XCreatePixmapCursor (
		display,
		pm_smiley,
		pm_smiley,
		reversed ? & black_color : & white_color,
		reversed ? & white_color : & black_color,
		smiley_x_hot,
		smiley_y_hot);

	cr_menu = XCreatePixmapCursor (
		display,
		pm_menu,
		pm_menu,
		reversed ? & black_color : & white_color,
		reversed ? & white_color : & black_color,
		menu_x_hot,
		menu_y_hot);

	cr_scroll = XCreatePixmapCursor (
		display,
		pm_scroll,
		pm_scrollmask,
		reversed ? & black_color : & white_color,
		reversed ? & white_color : & black_color,
		scroll_x_hot,
		scroll_y_hot);
}

void SetDefaultCursor (win, type)
WinInfo win;
int type;
{
	if (win == root_win)
		return;

	switch (type)
	{

	case CR_ARROWS:
		SetCursor (win, cr_arrows);
		return;

	case CR_HJV:
		SetCursor (win, cr_hjv);
		return;

	case CR_MAP:
		SetCursor (win, cr_map);
		return;

	case CR_MENU:
		SetCursor (win, cr_menu);
		return;

	case CR_DISTR:
		SetCursor (win, cr_distr);
		return;

	case CR_SMILEY:
		SetCursor (win, cr_smiley);
		return;

	default:
		fprintf (stderr, "SetDefaultCursor, Illegal type\n");
		leave ();

	}
}

void ReverseCursor (type, reverse)
int type;
bool reverse;
{
	Cursor cursor;

	switch (type)
	{
	case CR_ARROWS:	{ cursor = cr_arrows; break; }
	case CR_HJV: 	{ cursor = cr_hjv; break; }
	case CR_MAP: 	{ cursor = cr_map; break; }
	case CR_MENU: 	{ cursor = cr_menu; break; }
	case CR_DISTR: 	{ cursor = cr_distr; break; }
	case CR_SMILEY:	{ cursor = cr_smiley; break; }
	default:
		fprintf (stderr, "ReverseCursor, Illegal type\n");
		leave ();
	}

	XRecolorCursor (display, cursor, reverse ? &white_color : &black_color,
					 reverse ? &black_color : &white_color);
}
