/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/xm/RCS/xevents.c,v 5.2 1995/09/13 07:04:18 jpo Exp jpo $
    $Date: 1995/09/13 07:04:18 $
    $Author: jpo $
    $Id: xevents.c,v 5.2 1995/09/13 07:04:18 jpo Exp jpo $
    $Locker: jpo $
    $Log: xevents.c,v $
    Revision 5.2  1995/09/13 07:04:18  jpo
    Call AwaitSomething to listen for flash messages etc.

    Revision 5.1  1993/03/14 16:35:49  etienne
    *** empty log message ***

 * Revision 5.0  93/02/06  09:26:31  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:00:52  greyhelm
 * Add RCS logging - Karl Hagen
 *

*/
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <X11/keysymdef.h>

#include "type.h"
#include "main.h"
#include "xextern.h"
#include "sector.h"
#include "census.h"
#include <X11/Intrinsic.h>

extern WinInfo root_win;
extern WinInfo nation_win;
extern WinInfo census_win;
extern WinInfo empire_win;
extern WinInfo map_win;
extern XtAppContext app_context;


bool StandardEvent (pevent)
XEvent *pevent;
{
	char buffer [BUFSIZ];
	KeySym keysym;
	XComposeStatus comp_status;

	if (ScrollEvent (pevent))
		return True;

	if (SetInterrupt (pevent))
		return True;

	if (PagerEvent (pevent))
		return True;

	switch ((int) pevent-> xany. type)
	{

	case Expose:
		RefreshEvent (pevent);
		return True;
	
	case KeyPress:
		XLookupString (& (pevent-> xkey),
				    buffer,
				    BUFSIZ - 1,
				    &keysym,
				    &comp_status);

		switch ((int) keysym)
		{
			
		case XK_Up:
			ShiftField (0, -1);
			return True;

		case XK_Down:
			ShiftField (0, 1);
			return True;

		case XK_Right:
			ShiftField (1, 0);
			return True;

		case XK_Left:
			ShiftField (-1, 0);
			return True;

		case XK_F1:
			RaiseAll ();
			break;
		
		case XK_F2:
			LowerAll ();
			break;

		}

		return False;
	}

	return False;
}

void CheckRefreshEvents ()
{
	XEvent event;

	if (! xstarted)
		return;

	while (XtAppPending (app_context) > 0)
	{
		XtAppNextEvent (app_context, & event);
		XtDispatchEvent (&event);
	}
}

void HandelWaitingEvents ()
{
	XEvent event;

	if (! xstarted)
		return;

	while (XtAppPending (app_context) > 0)
	{
		XtAppNextEvent (app_context, & event);
		XtDispatchEvent (&event);
	}
}

static void MapButton (pevent)
XEvent *pevent;
{
	int button;
	Sector sct;
	int x, y;

	extern Sector FindSector ();
	
	button = pevent-> xbutton. button;
	x = pevent-> xbutton. x;
	y = pevent-> xbutton. y;

	if (button == LEFT_BUTTON)
	{
		sct = FindSector (x, y);

		if (sct == (Sector) 0 || NO_INFO (sct))
			return;

		SetCurrent (sct);
		return;
	}
	else if (button == MIDDLE_BUTTON)
	{
		GlobalCommands (PixelToCharX (x), PixelToCharY (y));
		return;
	}
	else if (button == RIGHT_BUTTON)
	{
		sct = FindSector (x, y);

		if (sct == (Sector) 0 || NO_INFO (sct))
			return;

		if (sct != cursct)
			SetCurrent (sct);

		SectorCommands (PixelToCharX (x), PixelToCharY (y));
		return;
	}
}

static void EmpireButton (pevent)
XEvent *pevent;
{
	int button;
	
	button = pevent-> xbutton. button;

	if (button == LEFT_BUTTON)
		InputToEmpire ();

	Census ();
}

void MainLoop ()
{
	XEvent event;
	WinInfo win;

	for (;;)
	{
		FreeFmts ();

		if (XtAppPending (app_context) == 0)
			AwaitSomething (ConnectionNumber (display));

		XtAppNextEvent (app_context, & event);
		XtDispatchEvent (&event);
		interrupt = False;
	}
}
