/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/util/RCS/relat.c,v 5.5 1995/09/12 18:51:29 jpo Exp $
    $Date: 1995/09/12 18:51:29 $
    $Author: jpo $
    $Id: relat.c,v 5.5 1995/09/12 18:51:29 jpo Exp $
    $Locker:  $
    $Log: relat.c,v $
    Revision 5.5  1995/09/12 18:51:29  jpo
    Change to use strings

    Revision 5.4  1995/09/12 18:14:24  jpo
    Fix up a buglet

    Revision 5.3  1995/09/12 18:12:31  jpo
    Add freindly and better parsing

    Revision 5.2  1993/03/14 16:52:59  etienne
    *** empty log message ***

 * Revision 5.1  93/02/06  11:09:12  greyhelm
 * Fixed minor bug in relation scan for Chainsaw
 * 
 * Revision 5.0  1993/02/06  09:24:11  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 *
 * Revision 4.4  1993/02/06  04:45:54  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "main.h"
#include "nation.h"
#include "version.h"

#define	UNKNOWN		-1
#define	ALLIED		0
#define	NEUTRAL		1
#define	HOSTILE		2
#define	ATWAR		3
#define MOBILIZING      4
#define SITZKRIEG       5
#define FRIENDLY	6

typedef struct s_relinfo RELINFO;
struct s_relinfo
{
	int as;
	int his [MAX_NATIONS];
	int theirs [MAX_NATIONS];
	int allied, hostile, atwar, mobilizing, sitzkrieg, friendly;
};

static int FindRelStatus (stat)
char * stat;
{
	char buf[128];

	if (ScanWord ((ConstVP)&stat, buf) == False)
		buf[0] = 0;

	if (strncmp (buf, "Allied", 6) == 0)
		return ALLIED;	
	else if (strncmp (buf, "Neutral", 7) == 0)
		return NEUTRAL;
	else if (strncmp (buf, "Hostile", 7) == 0)
		return HOSTILE;
	else if (strncmp (buf, "At War", 6) == 0)
		return ATWAR;
	else if (strncmp (buf, "Sitzkrieg", 9) == 0)
		return SITZKRIEG;
	else if (strncmp (buf, "Mobilizing", 10) == 0)
		return MOBILIZING;
	else if (strncmp (buf, "Friendly", 8) == 0)
		return FRIENDLY;
	else
	{
		PrintAtEmpire (Fmt ("Unknown status found (%7.7s)",
				stat));
		Bell ();
		return UNKNOWN;
	}
}

RelInfo ScanRelationsAs (country)
int country;
{
	RelInfo info;
	char * ptr;
	int i;

	info = (RelInfo) doalloc ((unsigned) sizeof (RELINFO));
	for (i = 0; i < MAX_NATIONS; i ++)
		info-> his [i] = info-> theirs [i] = UNKNOWN;
	
	info-> allied = 0;
	info-> hostile = 0;
	info-> atwar = 0;
	info-> sitzkrieg = 0;
	info-> mobilizing = 0;

	info-> as = country;

	FeedEmpire (Fmt ("relations %s", CountryName (country)), PRINT);
	PrintAtEmpire ("xemp: scanning relations");
	for (;;)
	{
		ptr = ReadEmpire (DONT_PRINT);
		if(chainsaw_version) {
			(void) SkipNLines (3, DONT_PRINT);
		}

		if (EmpireStatus () == E_COMMAND)
		{
			PrintAtEmpire (ptr);
			break;
		}

		if (EmpireStatus () == E_QUESTION)
		{
			if (! HandleQuestion (ptr))
			{
				Message ("Relations aborted");
				FreeRelInfo (info);
				return (RelInfo) 0;
			}
		}

		i = atoi (ptr);
		if (i == 0)
			continue;
		if (chainsaw_version) {
		    info-> his    [i] = FindRelStatus (ptr + 27);
		    info-> theirs [i] = FindRelStatus (ptr + 37);
		}
		else
		{
		    info-> his    [i] = FindRelStatus (ptr + 27);
		    info-> theirs [i] = FindRelStatus (ptr + 37);
		}

		if (info-> theirs [i] == info-> his [i])
		{
			switch (info-> theirs [i])
			{

			case ALLIED:	 info-> allied ++; break;
			case HOSTILE:	 info-> hostile ++; break;
			case ATWAR:	 info-> atwar ++; break;
			case SITZKRIEG:	 info-> sitzkrieg ++; break;
			case MOBILIZING: info-> mobilizing ++; break;
			case FRIENDLY:	 info-> friendly ++; break;
			}
		}
		else if (info-> theirs [i] == HOSTILE &&
			 info-> his [i] == ATWAR)
			info-> atwar ++;
		else if (info-> theirs [i] == ATWAR &&
			 info-> his [i] == HOSTILE)
			info-> hostile ++;
		else if (info-> theirs [i] == MOBILIZING &&
			 info-> his [i] == HOSTILE)
			info-> mobilizing ++;
		else if (info-> theirs [i] == HOSTILE &&
			 info-> his [i] == MOBILIZING)
			info-> mobilizing ++;
	}

	return info;
}

void FreeRelInfo (rel)
RelInfo rel;
{
	(void) free ((char *) rel);
}

int RelLines (rel)
RelInfo rel;
{
	int lines;

	lines = 2 + rel-> allied + rel-> hostile + rel-> atwar;
	if (lines == 2)
		lines = 3;
	
	return lines;
}

void PrintRelations (strings, rel)
Strings strings;
RelInfo rel;
{
	int i;

	AddString (strings, "Relation info: ");
	AddString (strings, "");

	if (rel-> allied + rel-> hostile + rel-> atwar == 0)
	{
		AddString (strings, "No relations.");
		return;
	}
	

	if (rel-> allied > 0)
	{
		AddString (strings, "Allied:");
		for (i = 0; i < MAX_NATIONS; i ++)
			if (rel-> his [i] == ALLIED &&
			    rel-> theirs [i] == ALLIED)
				AddString (strings, CountryName (i));
	}
	if (rel-> friendly > 0)
	{
		AddString (strings, "Friendly:");
		for (i = 0; i < MAX_NATIONS; i ++)
			if (rel-> his [i] == FRIENDLY &&
			    rel-> theirs [i] == FRIENDLY)
				AddString (strings, CountryName (i));
	}

	if (rel-> hostile > 0)
	{
		AddString (strings, "Hostile:");
		for (i = 0; i < MAX_NATIONS; i ++)
			if (rel-> his [i] == HOSTILE &&
			    (rel-> theirs [i] == ATWAR ||
			     rel-> theirs [i] == HOSTILE))
				AddString (strings,
					Fmt ("%s%s",
						CountryName (i),
						rel-> theirs [i] == ATWAR
							? " (*)"
							: ""));
	}

	if (rel-> atwar > 0)
	{
		AddString (strings, "At War:");
		for (i = 0; i < MAX_NATIONS; i ++)
			if (rel-> his [i] == ATWAR &&
			    (rel-> theirs [i] == ATWAR ||
			     rel-> theirs [i] == HOSTILE))
				AddString (strings,
					Fmt ("%s%s",
						CountryName (i),
						rel-> theirs [i] == HOSTILE
							? " (*)"
							: ""));
	}
}
