/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/util/RCS/prog.c,v 5.3 1996/01/29 08:57:50 jpo Exp $
    $Date: 1996/01/29 08:57:50 $
    $Author: jpo $
    $Id: prog.c,v 5.3 1996/01/29 08:57:50 jpo Exp $
    $Locker:  $
    $Log: prog.c,v $
    Revision 5.3  1996/01/29 08:57:50  jpo
    Rewritten for new interface

    Revision 5.2  1995/09/08 07:49:15  jpo
    const

 * Revision 5.1  93/03/14  16:52:59  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:24:11  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:45:54  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "sector.h"
#include "parser.h"
#include "xrc.h"
#include "func.h"

	/*
	 *	usage: xemp -u prog:land.p:#1
	 */

void UtilRunProg (arg)
char * arg;
{
	char * ptr, * progf, * realm;
	int sx, sy, ex, ey;
	register int x;
	register int y;
	Strings prog_str, outp_str, send_str;
	Program program;
	Sector sct;

	ptr = index (arg, ':');
		
	if (ptr == (char *) 0)
	{
		realm = "#";
		progf = arg;
	}
	else
	{
		realm = ptr + 1;
		progf = Str (arg);
		ptr = index (progf, ':');
		* ptr = '\0';
	}
		
	if (! ConvRealmToCoord (realm, & sx, & sy, & ex, & ey))
	{
		fprintf (stderr, "xemp run prog: Illegal realm specified\n");
		return;
	}

	prog_str = InitStrings ();
	if (! LoadStrings (prog_str, progf))
	{
		fprintf (stderr, "xemp run prog: Can't open %s\n", progf);
		return;
	}

	program = ParseProgram (prog_str);
	if (program == (Program) 0)
	{
		fprintf (stderr,
			"xemp run prog: Program '%s' contains errors\n",
			progf);
		FreeStrings (prog_str);
		return;
	}
	
	printf ("Running program\n");

	send_str = InitStrings ();
	outp_str = InitStrings ();

	for (y = sy; y <= ey; y ++)
		for (x = sx; x <= ex; x ++)
		{
			sct = World (x, y, S_EXIST);
			if (sct == (Sector) 0)
				continue;
			
			if (RunProgram (sct, program, outp_str, send_str)
								== P_ABORTED)
			{
				fprintf (stderr,
					"xemp run prog: program aborted");
				printf ("\nOutput of program:\n\n");
				DumpStrings (outp_str);
				printf ("\nEnd output\n");
				printf ("\nSend of program:\n\n");
				DumpStrings (send_str);
				printf ("\nSend output\n");
				FreeStrings (outp_str);
				FreeStrings (send_str);
				FreeStrings (prog_str);
				return;
			}
		}

	if (StringsSize (outp_str) == 0)
	{
		printf ("No output");
	}
	else
	{
		printf ("\nOutput of program:\n\n");
		DumpStrings (outp_str);
		printf ("\nEnd output\n");
	}

	if (StringsSize (send_str) > 0)
		AddMail (send_str, Fmt ("=== Output of '%s' (%s)", progf,
				DateFmt (time ((time_t *) 0))));

	FreeStrings (outp_str);
	FreeStrings (send_str);
	FreeStrings (prog_str);
	return;
}

static const char *selprog_strs [] = 
{
	"Run from program directory",
	"Edit program",
	"Edit new"
};

#define	SP_RUNDIR	0
#define	SP_EDITDIR	1
#define	SP_EDITNEW	2

#define	SP_MAX		3

#define PC_RUN		0
#define	PC_EDIT		1
#define	PC_CANCEL	2

#define PC_MAX		3

static const char *prog_choices [] =
{
	"Run program",
	"Edit program",
	"Cancel"
};

int ProgChoice (x, y)
int x, y;
{
	Strings strings;
	int i;

	strings = InitStrings ();
	AddStringsID (strings, prog_choices, PC_MAX, 0);
	i = ChooseMenu (strings, "What next?", map_win, x, y, NULL);
	FreeStrings (strings);

	return (int) (i < 0 ? PC_CANCEL : i);
}

const char * ProgFile (file)
const char * file;
{
	if (* file == '/')
		return file;

	if (xrc. progdir == (char *) 0)
		return file;
	else
		return Fmt ("%s/%s", xrc. progdir, file);
}

bool FileExists (file)
const char * file;
{
	return (access (file, 0) == 0);
}

char * SelectProgramFromDir (x, y)
int x, y;
{
	Strings strings;
	char * ret;
	int i;

	strings = PopenStrings (Fmt ("ls -1 %s", xrc. progdir));
	i = ChooseMenu (strings, "Which program?", map_win, x, y, NULL);
	if (i < 0)
	{
		FreeStrings (strings);
		return (char *) 0;
	}

	ret = Fmt ("%s", GiveIdString (strings, i));
	FreeStrings (strings);
	return ret;
}

Program SelectProgram (x, y)
int x, y;
{
	Strings strings, prog_strings = NULL, stripped;
	Program program;
	Pager pager;
	bool cont;
	char * ans, * file;
	int i, choice;

	strings = InitStrings ();
	AddStringsID (strings, selprog_strs, SP_MAX, 0);
	i = ChooseMenu (strings, "Which?", map_win, x, y, NULL);
	FreeStrings (strings);

	if (i < 0)
		return (Program) 0;

	switch (i)
	{

	case SP_RUNDIR:
		file = SelectProgramFromDir (x + 2, y + 2);
		if (file == (char *) 0)
			return (Program) 0;

		prog_strings = InitStrings ();
		if (! LoadStrings (prog_strings, ProgFile (file)))
		{
			Message ("Load failed");
			Bell ();
			return (Program) 0;
		}
		program = ParseProgram (prog_strings);
		FreeStrings (prog_strings);
		return program;
	
	case SP_EDITDIR:
		file = SelectProgramFromDir (x + 2, y + 2);
		if (file == (char *) 0)
			return (Program) 0;

		prog_strings = InitStrings ();
		if (! LoadStrings (prog_strings, ProgFile (file)))
		{
			Message ("Load failed");
			Bell ();
			FreeStrings (prog_strings);
			return (Program) 0;
		}
		break;

	case SP_EDITNEW:
		prog_strings = InitStrings ();
		break;
	}

	for (;;) {
	    prog_strings = EditText ("Enter your program", prog_strings,
				     "Done", map_win, x, y);
	    if (strings == NULL) {
		return (Program)0;
	    }
	    choice = ProgChoice (x, y);
	    switch (choice) {
	    case PC_CANCEL:
	    default:
		FreeStrings (prog_strings);
		return (Program)0;

	    case PC_EDIT:
		break;

	    case PC_RUN:
		program = ParseProgram (prog_strings);
		if (program == NULL)
		    continue;
		FreeStrings (prog_strings);
		return program;
	    }
	}
}
