/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/ship/RCS/set.c,v 5.1 1993/03/14 16:51:43 etienne Exp $
    $Date: 1993/03/14 16:51:43 $
    $Author: etienne $
    $Id: set.c,v 5.1 1993/03/14 16:51:43 etienne Exp $
    $Locker:  $
    $Log: set.c,v $
    Revision 5.1  1993/03/14 16:51:43  etienne
    *** empty log message ***

 * Revision 5.0  93/02/06  09:23:42  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:43:25  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "sector.h"
#include "var.h"
#include "ship.h"

void SetShip (ship)
Ship ship;
{
	char * ans;
	int price;
	double mult;
	int i;

	if (! s_owned (ship))
	{
		Message (
		    "For some strange reason you can only sell your own ships");
		Bell ();
		return;
	}

	price = shiptypes [sh_type (ship)]. cos * sh_eff (ship) / 100;
	for (i = 1; i < V_MAX; i ++)
		price += ProdCost (i) * GiveShipQuant (ship, ItemChar (i));

	Bell ();
	ans = InputAtMessage (
	       Fmt ("Set at what price [cost you $%d]: ", price),
	       5, "*.0-9");
	
	if (ans == (char *) 0 || interrupt)
	{
		Message ("Set cancelled");
		return;
	}

	if (* ans == '*')
	{
		if (sscanf (ans + 1, "%lf", & mult) != 1)
		{
			Message ("Illegal entry, usage: '* mult'");
			Bell ();
			return;
		}

		price = (int) (price * mult);
	}
	else if (*ans == '\0')
	  ; /* price is set to default already */
	else
		price = atoi (ans);
		

	FeedCommand (Fmt ("set ship %d %d", sh_nr (ship), price), PRINT);
	Message (Fmt ("%s #%d set at $%d",
					ShipName (ship), sh_nr (ship), price));
}
