/*
	$Header: /nexor/users/jpo/xemp/xemp5.0/lib/ship/RCS/mission.c,v 1.6 1996/01/29 08:31:11 jpo Exp $
	$Date: 1996/01/29 08:31:11 $
	$Author: jpo $
	$Id: mission.c,v 1.6 1996/01/29 08:31:11 jpo Exp $
	$Locker:  $
	$Log: mission.c,v $
	Revision 1.6  1996/01/29 08:31:11  jpo
	New menu stuff

	Revision 1.5  1995/09/10 17:44:13  jpo
	Added prototype

	Revision 1.4  1995/09/10 16:22:46  jpo
	Changed missions to be more generic
	added support for fleet mode census and setting

	Revision 1.3  1995/09/08 07:43:14  jpo
	const

	Revision 1.2  1995/08/15 07:54:38  jpo
	Added lots of mission support

 * Revision 1.1  93/03/14  16:51:36  etienne
 * Initial revision
 * 
*/

#include "main.h"
#include "sector.h"
#include "ship.h"

static const char *mission_types[] = {
	"Delete Mission",
	"Interdict",
	(char *)0
};
#define MISSION_MAX	2

static const char type2mission[] = "\0i";

static bool ShipMission _PROTO((const char *ships, int range,
				Sector sct, char *missp, int *rangep));

static bool ShipMission (ships, range, sct, missp, rangep)
const char *ships;
int range;
Sector sct;
char *missp;
int *rangep;
{
	int i;
	Strings strings;
	char *answer;

	strings = InitStrings ();
	AddStringsID (strings, mission_types, MISSION_MAX, 0);
	i = ChooseMenu (strings, "Mission Type?", map_win, 5, 5, NULL);

	FreeStrings (strings);

	if (i < 0 || interrupt) {
		interrupt = False;
		Message ("Set mission cancelled");
		return False;
	}
	
	if (i == 0) {
		*missp = type2mission[i];
		*rangep = 0;
		FeedCommand (Fmt ("mission ship %s c", ships), PRINT);
		return True;
	}
	answer = InputAtMessage (Fmt  ("Range [%d]: ",range),
				 3, GS_PNUMBER);
	if (interrupt || answer == (char *)0) {
		interrupt = False;
		Message ("Mission cancelled");
		return False;
	}
	if (*answer != '\0')
		range = atoi (answer);
		
	*rangep = range;
	*missp = type2mission[i];
	FeedCommand (Fmt ("mission ship %s %c %s %d",
			  ships, *missp,
			  CrdStr(sct), range), PRINT);
	return True;
}

void SMission (ship)
Ship ship;
{
	Sector sct;
	int range;
	char miss;

	if (!sh_owned (ship)) {
		Message ("Not your ship !!");
		return;
	}
	range = ShipFireRange(ship);
	if (ShipMission (Fmt ("%d", sh_nr(ship)),
			 range,
			 ShipSector (ship),
			 &miss, &range) == True) {
		set_sh_mission (ship, miss);
		ship -> radius = range;
		Message (Fmt ("Ship %d now on %c mission", sh_nr (ship),
			      miss));
	}
	return;
}

void FScanShipMission (list, flag)
const char *list;
int flag;
{
	FeedEmpire (Fmt ("mission ship %s q", list), flag);

	ScanShipMission (flag);
	(void) WaitForPrompt (flag);
}

void ScanShipMission (flag)
int flag;
{
	char *ptr, *ind;
	int mind, sno;
	Ship ship;

	if (EmpireStatus () != E_PRINTING)
		return;
	if (flag == PRINT)
		PrintAtEmpire ("Empiretool: scanning ship missions");

	ptr = ReadEmpire (DONT_PRINT);
	if ((ind = StrStr (ptr, "mission")) == NULL) {
		PrintAtEmpire (Fmt ("Mission scan failed on %s", ptr));
		return;
	}
	mind = ind - ptr;
	
	for (;;) {
		ptr = ReadEmpire (DONT_PRINT);

		if (EmpireStatus () != E_PRINTING) {
			if (flag == PRINT)
				PrintAtEmpire (ptr);
			return;
		}
		
		if ((ind = index (ptr, '#')) == NULL)
			continue;

		ind ++;
		if (!ScanDigit ((ConstVP)&ind, &sno) ||
		    (ship = NrToShip (sno)) == (Ship)0) {
			PrintAtEmpire (Fmt ("#%d Unknown ship (rescan ships!)",
					    sno));
			Bell ();
			(void) EmpireMore ();
			continue;
		}
		if (match_str (ptr, "has no mission", NULL, 0) == 0)
		    set_sh_mission (ship, '\0');
		else 
		    switch (ptr[mind]) {
		    case 'i':
			set_sh_mission (ship, 'i');
			break;
		    case 'h':
			set_sh_mission (ship, '\0');
			break;
		    default:
			PrintAtEmpire (Fmt ("Unknown mission type %s",
					    ptr + mind));
			Bell ();
			break;
		    }
	}
}

const char *FleetHasMission (fleet)
char fleet;
{
	Ship ptr;
	char mistype = '~';	/* bogus */
	const char *cp;

	for (ptr = shiplist; ptr != (Ship) 0; ptr = ptr-> next)
		if (ptr-> fleet == fleet && sh_mission(ptr) != mistype) {
			if (mistype == '~')
				mistype = sh_mission(ptr);
			else
				return "Mixed";
		}
	if (mistype == '\0')
		return "None";

	for (cp = type2mission + 1; *cp; cp++)
		if (*cp == mistype)
			return mission_types[cp - type2mission];
	return "Unknown";
}

void ChangeFleetMission (fleet)
char fleet;
{
	Ship ptr;
	int range = 0;
	char miss;
	
	if (FleetEmpty (fleet) == True) {
		Message ("No ships in fleet!");
		return;
	}
	if (FleetColocated (fleet) != True) {
		Message ("Fleet not colocated");
		return;
	}
	for (ptr = shiplist; ptr != (Ship) 0; ptr = ptr-> next)
		if (ptr-> fleet == fleet) {
			int r = ShipFireRange (ptr);
			if (r > range)
				range = r;
		}

	if (ShipMission (Fmt ("%c", fleet),
			 range,
			 FleetSector (fleet),
			 &miss, &range) == True) {
		const char *cp;

		for (ptr = shiplist; ptr != (Ship) 0; ptr = ptr-> next)
			if (ptr-> fleet == fleet) {
				set_sh_mission (ptr, miss);
				ptr -> radius = range;
			}
		Message (Fmt ("Fleet %c now on %s mission",
			      fleet,
			      FleetHasMission (fleet)));
		CensusFleet (fleet);
	}
}
