#include "regex.h"

int match_str (str, pattern, matches, nmat)
const char *str;
const char *pattern;
regmatch_t matches[];
int nmat;
{
    regex_t re;
    int n;
    char buf[100];
 
    if ((n = regcomp (&re, pattern, REG_EXTENDED|REG_ICASE)) != 0) {
        regerror (n, &re, buf, sizeof buf);
        fprintf (stderr, "regex error: %s\n", buf);
        return -1;
    }
 
    n = regexec (&re, str, nmat, matches, 0);

    regfree (&re);
    return n;
}

