/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/plane/RCS/wing.c,v 5.3 1996/01/29 08:29:18 jpo Exp $
    $Date: 1996/01/29 08:29:18 $
    $Author: jpo $
    $Id: wing.c,v 5.3 1996/01/29 08:29:18 jpo Exp $
    $Locker:  $
    $Log: wing.c,v $
    Revision 5.3  1996/01/29 08:29:18  jpo
    Lint stuff

    Revision 5.2  1995/09/08 07:41:18  jpo
    rework plane next stuff

 * Revision 5.1  93/03/14  16:51:23  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:23:20  greyhelm
 * y
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:42:01  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "plane.h"
#include "sector.h"

bool WingEmpty (wing)
char wing;
{
	Plane plane;

	for (plane = first_plane; plane != (Plane) 0; plane = pl_next (plane))
		if (pl_wing (plane) == wing)
			return False;

	return True;
}

bool WingColocated (wing)
char wing;
{
	Plane plane;
	int x, y;
	bool found;

	x = y = 0;

	found = False;
	for (plane = first_plane; plane != (Plane) 0; plane = pl_next (plane))
		if (pl_wing (plane) == wing)
			if (found)
			{
				if (pl_xcd (plane) != x || pl_ycd (plane) != y)
					return False;
			}
			else
			{
				found = True;
				x = pl_xcd (plane);
				y = pl_ycd (plane);
			}
	return True;
}

Sector WingSector (wing)
char wing;
{
	Plane plane;

	for (plane = first_plane; plane != (Plane) 0; plane = pl_next (plane))
		if (pl_wing (plane) == wing)
			return World (pl_xcd (plane), pl_ycd (plane), S_DESIG);
	
	return (Sector) 0;
}

char NextWingInSct (sct, wing)
Sector sct;
char wing;
{
	char next;
	Plane ptr;

	next = '\0';

	for (ptr = s_fplane (sct); ptr != (Plane) 0; ptr = pl_nxtsct (ptr))
		if (next == '\0')
		{
			if (pl_wing (ptr) > wing)
				next = pl_wing (ptr);
		}
		else if (next > pl_wing (ptr) && pl_wing (ptr) > wing)
			next = pl_wing (ptr);

	return next;
}

char FirstWingInSct (sct)
Sector sct;
{
	Plane ptr;
	char first;

	if (s_fplane (sct) == (Plane) 0)
		return '\0';

	first = '~';
	for (ptr = s_fplane (sct); ptr != (Plane) 0; ptr = pl_nxtsct (ptr))
		if (pl_wing (ptr) < first)
			first = pl_wing (ptr);
			
	return first;
}

void WingJoin (from, to)
char from, to;
{
	Plane ptr;

	for (ptr = first_plane; ptr != (Plane) 0; ptr = pl_next (ptr))
		if (pl_wing (ptr) == from)
			set_pl_wing (ptr, to);
}

char GiveEscortWing ()
{
	Plane ptr;

	for (ptr = s_fplane (cursct); ptr != (Plane) 0; ptr = pl_nxtsct (ptr))
		if (BIT_SET (planetypes [pl_type (ptr)]. flags, P_F) &&
						pl_wing (ptr) != '~')
			return pl_wing (ptr);
	
	return '\0';
}

static void CalcFreeWings (upper, lower)
bool upper [], lower [];
{
	Plane ptr;
	register i;

	for (i = 0; i < 26; i ++)
		upper [i] = lower [i] = True;
	

	for ALL_PLANES (ptr)
		if (isupper (pl_wing (ptr)))	
			upper [pl_wing (ptr) - 'A'] = False;
		else if (islower (pl_wing (ptr)))
			lower [pl_wing (ptr) - 'a'] = False;
	
}

void ShowFreeWings ()
{
	char * ptr;
	bool upper [26], lower [26];

	CalcFreeWings (upper, lower);
	ptr = MakeFreeString (upper, lower);

	if (strlen (ptr) == 0)
		Message ("No free wings");
	else
		Message (Fmt ("Free wings: %s", ptr));
}

char FirstFreeWing ()
{
	int i;
	bool upper [26], lower [26];

	CalcFreeWings (upper, lower);

	for (i = 0; i < 26; i ++)
		if (lower [i])
			return 'a' + i;

	for (i = 0; i < 26; i ++)
		if (upper [i])
			return 'A' + i;

	return '\0';
}

char GiveNextWingInSct (sct, wing)
Sector sct;
char wing;
{
	char next;
	Plane ptr;

	next = 0177;

	for (ptr = s_fplane (sct); ptr != (Plane) 0; ptr = pl_nxtsct (ptr))
		if (pl_wing (ptr) < next && pl_wing (ptr) > wing)
			next = pl_wing (ptr);

	if (next < 0177)
		return next;
	return '\0';
}

char * WingId ()
{
	bool first;
	static char buffer [1024];
	Plane ptr;

	if (! WingColocated (curwing))
	{
		buffer [0] = '\0';
		first = True;

		for (ptr = s_fplane (cursct); ptr != (Plane) 0;
							ptr = pl_nxtsct (ptr))
			if (pl_wing (ptr) == curwing)
			{
				if (first)
					first = False;
				else
					strcat (buffer, "/");
				
				strcat (buffer, Fmt ("%d", pl_nr (ptr)));
			}
		
		return buffer;
	}
	else
		return Fmt ("%c", curwing);
}
