/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/parse/RCS/stack.h,v 5.1 1993/03/14 16:50:53 etienne Exp $
    $Date: 1993/03/14 16:50:53 $
    $Author: etienne $
    $Id: stack.h,v 5.1 1993/03/14 16:50:53 etienne Exp $
    $Locker:  $
    $Log: stack.h,v $
    Revision 5.1  1993/03/14 16:50:53  etienne
    *** empty log message ***

 * Revision 5.0  93/02/06  09:23:02  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:40:53  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
/*
 * stack.h
 */

typedef struct _Stack {
	int type;
	struct _Stack *next;
	union _u_stack {
		struct _u_push {
			int type;
			int modifier;
			union _p_u {
				char   *p_u_text;
				double p_u_constant;
				char   p_u_character;
				int    p_u_token;
			} p_u;
		} u_push;
		struct _u_calc {
			int c_u_operator;
			int c_u_calctype;
		} u_calc;
		struct _u_expr {
			int e_u_old_modifier;
			int e_u_new_modifier;
		} u_expr;
		struct _Stack *tail;
	} u_stack;
} STACK;

#define s_tail		u_stack.tail
#define c_calctype	u_stack.u_calc.c_u_calctype
#define c_operator	u_stack.u_calc.c_u_operator
#define e_old_modifier	u_stack.u_expr.e_u_old_modifier
#define e_new_modifier	u_stack.u_expr.e_u_new_modifier
#define p_type		u_stack.u_push.type
#define p_modifier	u_stack.u_push.modifier
#define p_text		u_stack.u_push.p_u.p_u_text
#define p_constant	u_stack.u_push.p_u.p_u_constant
#define p_character	u_stack.u_push.p_u.p_u_character
#define p_token		u_stack.u_push.p_u.p_u_token

#define S_HEAD		0
#define S_SUBEXPRSTART	1
#define S_SUBEXPREND	2
#define S_PUSH		3
#define S_CALC		4

#define D0	(double) 0
#define D1	(double) 1

/* Error codes */
#define E_EVAL		0
#define E_OR_TYPE	1
#define E_AND_TYPE	2
#define E_LHS		3
#define E_RHS		4
#define E_ARG		5
#define E_MOD		6
#define E_SECA1		7
#define E_SECA2		8
