/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/parse/RCS/prog_defs.h,v 5.2 1995/09/08 07:36:34 jpo Exp $
    $Date: 1995/09/08 07:36:34 $
    $Author: jpo $
    $Id: prog_defs.h,v 5.2 1995/09/08 07:36:34 jpo Exp $
    $Locker:  $
    $Log: prog_defs.h,v $
    Revision 5.2  1995/09/08 07:36:34  jpo
    redefine types - stop clashes

 * Revision 5.1  93/03/14  16:50:53  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:23:02  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:40:53  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
/*
 * Prog_defs.h
 */

/*
 * Instruction/program types.
 */
#define I_FOREVER	0		/* Program types     */
#define I_EXECUTE	1
#define I_EVAL		2		/* Instruction types */
#define I_ACTION	3
#define I_LABEL		4
#define I_GOTO		5
#define I_SET_COUNT	6
#define I_TEST_COUNT	7
#define I_STOP_PROGRAM	8
#define I_ABORT		9

#define S_OK		0
#define	S_FAIL		1
#define S_ERROR		2



/*
 * Label types.
 */
typedef union _u_label {
	int value;			/* Phase1: label value   */
	struct _Instruction *address;	/* Phase2: Label address */
} LABEL;

/*
 * Statement types.
 */
#define ST_BLOCK	0
#define ST_SINGLE	1

/*
 * Double linked list with tail->link pointing to NIL and head->prev pointing
 * to tail.
 */
typedef struct _Instruction {
#if defined(DUMP)
	int nr;
#endif
	int type;
	Stack expression;
	struct _Action *action;
	struct _Instruction *link;	/* Link to next logic instr           */
	struct _Instruction *prev;	/* During phase1: previous instr      */

	LABEL next_label;		/* Label info on true/next condition  */
	LABEL false_label;		/* Label info on false condition      */
					/* Lblinfo on error clause in I_ACTION*/
	LABEL fail_label;		/* Fail clause in I_ACTION statement  */
	int *loop_count;		/* Address to loop count	      */

	int number;			/* Label value/loop executions        */
	struct _Instruction *label_list;

	bool referenced;		/* Phase2 reachability data           */
} *Instruction;

#define next_address	next_label.address
#define next_value	next_label.value

#define true_address	next_label.address
#define true_value	next_label.value
#define false_address	false_label.address
#define false_value	false_label.value
#define fail_address	fail_label.address
#define fail_value	fail_label.value

/*
 * Function prototypes.
 */
static void AddInstructionEval(), AddInstructionAction(), AddInstructionLabel(),
	    AddInstructionGoto();
static Instruction LinkInstruction ();

static void RunPhase2();
static Instruction FindShortCut(), FindLabelAddress();

/*
 * Action record definitions.
 */

typedef struct _ExprList {
	union u_exprlist {
		Stack u_e_expr;
		struct _ExprList *u_e_tail;
	} u_exprlist;
	struct _ExprList *next;
} EXPRLIST, *ExprList;

#define e_expr	u_exprlist.u_e_expr
#define e_tail	u_exprlist.u_e_tail

typedef struct _Location {
	int type;
	union _u_location {
		Stack    u_l_sector_expr;
		ExprList u_l_where_list;
	} u_location;
} LOCATION, *Location;

#define	l_sector_expr	u_location.u_l_sector_expr
#define	l_where_list	u_location.u_l_where_list

#define LOC_NONE	0
#define LOC_SECTOR	1
#define LOC_WHERE	2

typedef struct _Simple {
	Stack sector_expr;
	Stack quantity;
	int   flag;
} *Simple;
typedef struct _Simple *Designate;
typedef struct _Simple *Demobilize;
typedef struct _Simple *Enlist;
typedef struct _Simple *Convert;
typedef struct _Simple *Shoot;
typedef struct _Simple *Threshold;
typedef struct _Simple *Cutoff;
typedef struct _Simple *Territory;

typedef struct _MoveAct {
	Stack	 quantity;
	int	 commodity;
	LOCATION from_loc;
	ExprList via_list;
	LOCATION to_loc;
} *MoveAct;

typedef struct _DistributeAct {
	Stack sector_expr;
	LOCATION to_loc;
} *DistributeAct;

typedef struct _DeliverAct {
	Stack sector_expr;
	Stack dest_sector;
	int commodity;
} *DeliverAct;

typedef struct _Outp {
	int   format;
	struct _Outp *next;
	union _u_output {
		Stack u_o_expr;
		struct _Outp *u_o_tail;
	} u_outp;
} *Output;
#define o_expr	u_outp.u_o_expr
#define o_tail	u_outp.u_o_tail

typedef struct _Action {
	int type;
	union _u_action {
		Simple		u_a_simple;
		MoveAct		u_a_move;
		Designate	u_a_designate;
		Demobilize	u_a_demobilize;
		Enlist		u_a_enlist;
		Convert		u_a_convert;
		Shoot		u_a_shoot;
		DistributeAct	u_a_distribute;
		Threshold	u_a_threshold;
		Cutoff		u_a_cutoff;
		DeliverAct	u_a_deliver;
		Territory	u_a_territory;

		Output		u_a_output;
		Output		u_a_print;
		Output		u_a_send;
	} u_action;
} ACTION, *Action;

#define u_simple	u_action.u_a_simple
#define u_move		u_action.u_a_move
#define u_designate	u_action.u_a_designate
#define u_demobilize	u_action.u_a_demobilize
#define u_enlist	u_action.u_a_enlist
#define u_convert	u_action.u_a_convert		
#define u_shoot		u_action.u_a_shoot
#define u_distribute	u_action.u_a_distribute
#define u_threshold	u_action.u_a_threshold		
#define u_cutoff	u_action.u_a_cutoff
#define u_deliver	u_action.u_a_deliver
#define u_territory	u_action.u_a_territory		

#define u_output	u_action.u_a_output		
#define u_print		u_action.u_a_print		
#define u_send		u_action.u_a_send
