/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/nuke/RCS/dump.c,v 5.1 1993/03/14 16:50:17 etienne Exp $
    $Date: 1993/03/14 16:50:17 $
    $Author: etienne $
    $Id: dump.c,v 5.1 1993/03/14 16:50:17 etienne Exp $
    $Locker:  $
    $Log: dump.c,v $
    Revision 5.1  1993/03/14 16:50:17  etienne
    *** empty log message ***

 * Revision 5.0  93/02/06  09:22:49  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:40:08  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "main.h"
#include "nuke.h"
#include "sector.h"

void AddStockToSct (sct, stock)
Sector sct;
Stockp stock;
{
	int total;
	int i;

	total = 0;
	for (i = 0; i < nr_nuke_types; i ++)
		total += sp_nukamt (stock, i);
	
	set_nuk (sct, total);
	set_stock (sct, stock);
}

void BinDumpNukes (fp)
File fp;
{
	int size;
	Stockp dummy, ptr;

	size = sizeof (struct s_nuke);
	fwrite ((char *) & size, sizeof (int), 1, fp);

	for (ptr = spl_head; ptr != (Stockp) 0; ptr = sp_next (ptr))
		(void) fwrite ((char *) ptr, size, 1, fp);

	dummy = NewStockPile ();
	set_sp_nr (dummy, -1);
	(void) fwrite ((char *) dummy, size, 1, fp);
	FreeStockPile (dummy);
}

bool BinRestoreNukes (fp)
File fp;
{
	int size;
	Stockp ptr;
	Sector sct;

	fread ((char *) & size, sizeof (size), 1, fp);
	if (size != sizeof (struct s_nuke))
		return False;

	for (;;)
	{
		ptr = NewStockPile ();
		fread ((char *) ptr, size, 1, fp);
		set_sp_next (ptr, (Stockp) 0);

		if (sp_nr (ptr) < 0)
			break;

		sct = World (sp_x (ptr), sp_y (ptr), S_EXIST);
		if (sct != (Sector) 0)
			AddStockToSct (sct, ptr);
	}

	FreeStockPile (ptr);
	return True;
}
