/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/misc/RCS/version.c,v 5.11 1996/02/16 08:38:30 jpo Exp $
    $Date: 1996/02/16 08:38:30 $
    $Author: jpo $
    $Id: version.c,v 5.11 1996/02/16 08:38:30 jpo Exp $
    $Locker:  $
    $Log: version.c,v $
    Revision 5.11  1996/02/16 08:38:30  jpo
    Version number inc

    Revision 5.10  1996/01/29 08:24:05  jpo
    Change version to be proper window
    Make version available as a string

    Revision 5.9  1995/10/25 13:53:58  jpo
    Call new window stuff

    Revision 5.8  1995/10/12 07:24:14  jpo
    Major and minor numbers

    Revision 5.7  1995/10/10 07:25:49  jpo
    Some more regexp stuff.

    Revision 5.6  1995/09/28 08:25:00  jpo
    Save extra bits of info - in extensible format

    Revision 5.5  1995/09/27 16:16:56  jpo
    Check for empire 2.3

    Revision 5.4  1995/09/20 07:38:39  jpo
    New stuff and setting new features.

    Revision 5.3  1995/09/08 07:32:35  jpo
    emp3 server
    emp3 options
    changed the message too

 * Revision 5.2  93/03/14  16:49:48  etienne
 * changed the whole options scanning.
 * 
 * Revision 5.1  93/02/06  10:11:03  greyhelm
 * Made minor change to MOTD
 * 
 * Revision 5.0  1993/02/06  09:18:49  greyhelm
 * y
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 *
 * Revision 4.4  1993/02/06  04:37:47  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "main.h"
#include "sector.h"
#include "version.h"
#include "regex.h"

#define VERSION "Xemp Version 5.2(beta) Empire 3(beta) Compliant"
const char *version_str = VERSION;

static void EMPSetOption _PROTO((long opt));

const char *ver_str[] = {
    VERSION,
    " ",
    "Version 4.09 Written by:",
    "    Henk-Jan Visscher",
    " ",
    "Version 5.0 Written by:",
    "    Stefan Hauser <etienne@imp.ch>",
    "    Karl S. Hagen <greyhelm@cis.ksu.edu>",
    " ",
    "Version 5.1 Written by:",
    "    Julian Onions <j.onions@nexor.co.uk>",
    " ",
    "ftp://ftp.empire.net/pub/empire/player/clients/xemp",
    "",
};
#define NV_STR 14

void ShowVersion ()
{
	Strings strings;

	strings = InitStrings ();
	AddStringsID (strings, ver_str, NV_STR, 0);
	AddStringID (strings, Fmt ("Compiled: %s", COM_DATE), NV_STR+1);
	ShowStringsInPager (strings, "About Xemp");
	FreeStrings (strings);
}

static unsigned long *options_defined;
static int numopts=0;

static void KSUSetOption (option)
long option;
{
	EMPSetOption (option);
}

static void EMPSetOption (option)
long option;
{
	int ltm;
	unsigned long bit;

	bit = option % 32;
	ltm = option / 32;
	if(ltm >= numopts)
	{
		/* allocate new option entry */
		if(!numopts)
		{
			options_defined = (unsigned long *)malloc(sizeof(long));
			numopts = 1;
			*options_defined = 0;
		}
		else
		{
			numopts++;
			options_defined = (unsigned long *)realloc(options_defined, numopts * sizeof(long));
			options_defined[numopts-1] = 0;
		}
	}
	options_defined[ltm] |= 1<<bit;
}

bool KSUOption (option)
long option;
{
	EMPOption (option);
}

bool EMPOption (option)
long option;
{
	int ltm;
	unsigned long bit;

	bit = option % 32;
	ltm = option / 32;
	if(ltm >= numopts)
		return 0;
	else
		return ((options_defined[ltm] & (1<<bit)) ? 1 : 0);
}

struct s_option
{
	char * name;
	long option;
};

/* WARNING .. the following list must match the list defined in version.h */
static struct s_option emp_options [] =
{
		{ "ABM",			ABM },
		{ "ALLYHARBOR",			ALLYHARBOR },
		{ "ALLYHARBORWORK",		ALLYHARBORWORK },
		{ "ALLYUPGRADE",		ALLYUPGRADE },
		{ "ALL_BLEED",			ALL_BLEED },
		{ "ASW_PLANES",			ASW_PLANES },
		{ "AUTONAV",			AUTONAV },
		{ "BABY_NUKES",			BABY_NUKES },
		{ "BAN",			BAN },
		{ "BETTERABM",			BETTERABM },
		{ "BETTERARMOR",		BETTERARMOR },
		{ "BIG_CITY",			BIG_CITY },
		{ "BIND",			BIND },
		{ "BLITZ",			BLITZ },
		{ "BMAP",			BMAP },
		{ "BUDGET",			BUDGET },
		{ "CHOPPER_STEALTH",		CHOPPER_STEALTH },
		{ "CONVASAT",			CONVASAT },
		{ "DAVYJONES",			DAVYJONES },
		{ "DEMANDUPDATE",		DEMANDUPDATE },
		{ "DRNUKE",			DRNUKE },
		{ "DROPANY",			DROPANY },
		{ "EASY_BRIDGES",		EASY_BRIDGES },
		{ "FALLOUT",			FALLOUT },
		{ "FUEL",			FUEL },
		{ "GRIND",			GRIND },
		{ "HARBOR_POLICE",		HARBOR_POLICE },
		{ "MERC",			MERC },
		{ "MINE_PLANES",		MINE_PLANES },
		{ "MISSDEF",			MISSDEF },
		{ "MISSINGMISSILES",		MISSINGMISSILES },
		{ "MOVEMAP",			MOVEMAP },
		{ "MULTIFIRE",			MULTIFIRE },
		{ "NEUTRON",			NEUTRON },
		{ "NEWFISH",			NEWFISH },
		{ "NEWPOWER",			NEWPOWER },
		{ "NEWREPORT",			NEWREPORT },
		{ "NEWSUBS",			NEWSUBS },
		{ "NOFOOD",			NOFOOD },
		{ "NOGODS",			NOGODS },
		{ "NOMOBCOST",			NOMOBCOST },
		{ "NONUKESUB",			NONUKESUB },
		{ "NUKEFAILDETONATE",		NUKEFAILDETONATE },
		{ "ORBIT",			ORBIT },
		{ "OWNASSAULT",			OWNASSAULT },
		{ "PARAFLAG",			PARAFLAG },
		{ "PINPOINTMISSILE",		PINPOINTMISSILE },
		{ "RANGEEDIT",			RANGEEDIT },
		{ "REALM_IN_NAT",		REALM_IN_NAT },
		{ "REJECTS",			REJECTS },
		{ "RETREAT",			RETREAT },
		{ "SAIL",			SAIL },
		{ "SCUTTLE",			SCUTTLE },
		{ "SEMILAND",			SEMILAND },
		{ "SHIPCHOPPERS",		SHIPCHOPPERS },
		{ "SHIPNAMES",			SHIPNAMES },
		{ "SHIPSAM",			SHIPSAM },
		{ "SHIPTORP",			SHIPTORP },
		{ "SHOWPLANE",			SHOWPLANE },
		{ "SLOW_WAR",			SLOW_WAR },
		{ "STEALTHV",			STEALTHV },
		{ "SUPER_BARS",			SUPER_BARS },
		{ "SWEEP_PLANES",		SWEEP_PLANES },
		{ "TACARGO",			TACARGO },
		{ "TRADESHIPS",			TRADESHIPS },
		{ "UPDATESCHED",		UPDATESCHED },
		{ "WING_LOAD",			WING_LOAD },
		{ "WIRE",			WIRE },
		{ "XLIGHT",			XLIGHT },
		{ "STOP",			STOP },
		{ "RES_POP",			RES_POP },
		{ "NO_PLAGUE",			NO_PLAGUE },
		{ "GRAB_THINGS",		GRAB_THINGS },
		{ "CARRIER_WORK",		CARRIER_WORK },
		{ "NEW_WORK",			NEW_WORK },
		{ "NEW_STARVE",			NEW_STARVE },
		{ "SNEAK_ATTACK",		SNEAK_ATTACK },
		{ (char *) 0,			(long) 0 }
};
void KSUNotDefined (option)
long option;
{
	EMPNotDefined (option);
}

void EMPNotDefined (option)
long option;
{
	struct s_option * ptr;
	char * option_name;

	option_name = (char *) 0;
	for (ptr = emp_options; ptr-> name != (char *) 0; ptr ++)
		if (ptr-> option == option)
		{
			option_name = ptr-> name;
			break;
		}
	
	if (option_name == (char *) 0)
		Message ("This option is not enabled in this game!");
	else
		Message (Fmt("Option \"%s\" is not enabled in this game",
			     option_name));
	Bell ();
}

void FScanVersion ()
{
	char * line;
	bool scan_options;
	register struct s_option * ptr;
	regmatch_t rmatch[10];

	bool size_set, sec_per_etu_set, etu_per_update_set, fgrate_set;
	bool fcrate_set, obrate_set, uwbrate_set , eatrate_set, babyeat_set;
	bool bankint_set, mon_cset, mon_mset;
	bool max_mob_set, mob_gain_set, eff_gain_set;

	size_set = sec_per_etu_set = etu_per_update_set = fgrate_set = 
	fcrate_set = obrate_set = uwbrate_set  = eatrate_set =
	babyeat_set = bankint_set = mon_cset = mon_mset = 
	max_mob_set = mob_gain_set = eff_gain_set = False;

	FeedEmpire ("version", PRINT);
	PrintAtEmpire ("xemp scanning version info");

	scan_options = False;
	ksu_version = False;
	chainsaw_version = False;
	land_units = False;
	emp3server = False;

	for (;;)
	{
		line = ReadEmpire (DONT_PRINT);

		if (StrStr (line, "KSU") != (char *) 0) {
			ksu_version = True;
			fprintf(stderr, "KSU-1.04/Merc-2 Code Enabled\n");
		}

		if (StrStr (line, "Empire 2 beta") != (char *)0) {
			fprintf (stderr, "Empire 2 beta version enabled\n");
			emp3server = 1;
		}
		if (match_str (line, "empire\\s+(\\d+)\\.(\\d+)",
			       rmatch, 10) == 0) {
			int maj, min;
			maj = atoi(line + rmatch[1].rm_so);
			min = atoi(line + rmatch[2].rm_so);
			if (maj > 2 || (maj == 2 && min >= 3)) {
				emp3server = 2;
				fprintf (stderr,
					 "Empire %d.%d version enabled\n",
					 maj, min);
			}
		}
		if (StrStr (line, "Chainsaw") != (char *) 0) {
		        chainsaw_version = True;
			fprintf(stderr, "Chainsaw Code Enabled\n");
			if (StrStr (line, "3") != (char *) 0) {
		        	land_units = True;
				fprintf(stderr,"Chainsaw Land Units enabled\n");
			}
		}

		if (EmpireStatus () == E_COMMAND || line == (char *) 0)
			break;
		
		if (*line == '\0' || *line == '\n')
			continue;

		if (! size_set &&
		    sscanf (line, "World size is %d by %d",
			    &ver_max_x, &ver_max_y) == 2) {
			size_set = True;
			if (ver_max_x != MAX_X || ver_max_y != MAX_Y) {
				fprintf (stderr, "%s %dx%d instead of %dx%d\n",
					 "Version reports worldsize of",
					 ver_max_x, ver_max_y, MAX_X, MAX_Y);
				MAX_X = ver_max_x;
				MAX_Y = ver_max_y;
			}
			continue;
		}

		if (! sec_per_etu_set &&
			sscanf (line, "An Empire time unit is %d", 
					&sec_per_etu) == 1) {
			sec_per_etu_set = True;
			continue;
		}

		if (! etu_per_update_set &&
		    sscanf (line, "An update consists of %d",
			    & etu_per_update) == 1)
		{
			etu_per_update_set = True;
			continue;
		}

		if (! bankint_set &&
		    sscanf (line, "Banks pay $%lf", & bankint) == 1)
		{
			bankint /= 1000;
			bankint_set = True;
			continue;
		}

		if (! mon_cset &&
		    sscanf (line,
			    "1000 civilians generate $%lf, uncompensated workers $%lf each",
			    & money_civ, & money_uw) == 2)
		{
			money_civ /= 1000;
			money_uw /= 1000;
			mon_cset = True;
			continue;
		}

		if (! mon_mset &&
	sscanf (line, "1000 active military cost $%lf, reserves cost $%lf",
			& money_mil, & money_res) == 2)
		{
			money_mil /= - 1000;
			money_res /= - 1000;
			mon_mset = True;
			continue;
		}


		if (! fgrate_set &&
		    sscanf (line,
			    "A non-aggi, 100 fertility sector can grow %lf",
			    &fgrate) == 1) {
			fgrate_set = True;
			fgrate = fgrate / 100.0;
			continue;
		}

		if (! fcrate_set &&
		    sscanf (line, "1000 civilians will harvest %lf",
			    &fcrate) == 1) {
			fcrate_set = True;
			fcrate = fcrate / 1000.0;
			continue;
		}

		if (! obrate_set &&
		    sscanf (line, "1000 civilians will give birth to %lf",
			    &obrate) == 1)
		{
			obrate_set = True;
			obrate = obrate / 1000.0;
			continue;
		}

		if (! uwbrate_set &&
		    sscanf (line,
			    "1000 uncompensated workers will give birth to %lf",
			    &uwbrate) == 1) {
			uwbrate_set = True;
			uwbrate = uwbrate / 1000.0;
			continue;
		}

		if (! eatrate_set && 
		    strcmp (line, "No food is needed!!") == 0) {
			eatrate = 0.0;
			no_food = eatrate_set = True;
		}

		if (! eatrate_set &&
		    sscanf (line, "In one time unit, 1000 people eat %lf",
			    &eatrate) == 1) {
			eatrate_set = True;
			eatrate = eatrate / 1000.0;
			continue;
		}
	
		if (! babyeat_set &&
		    sscanf (line, "1000 babies eat %lf", &babyeat) == 1) {
			babyeat_set = True;
			babyeat = babyeat / 1000.0;
			continue;
		}
		if (!max_mob_set && 
		    sscanf (line, "Maximum mobility %d %d %d %d",
			    &sect_mob_max, &ship_mob_max, &plane_mob_max,
			    &land_mob_max) == 4) {
			max_mob_set = True;
			continue;
		}
		if (!mob_gain_set &&
		    sscanf (line, "Max mob gain per update %d %d %d %d",
			    &sect_mob_gain, &ship_mob_gain, &plane_mob_gain,
			    &land_mob_gain) == 4) {
			mob_gain_set = True;
	/* scale is only meanigful for things, that use something to get */
	/* mob. sectors/planes get always full mob (at least till now)   */
	/* landunits/ships use fuel (if FUEL is defined)		 */
	/* so scale gets calculated in the simul. update only if fuel is */
	/* used 							 */
			continue;
		}
		if (!eff_gain_set &&
		    sscanf (line, "Max eff gain per update %#s %f %f %f",
			    &ship_eff_gain, &plane_eff_gain,
			    &land_eff_gain) == 3) {
			eff_gain_set = True;
		}

		if ((ksu_version || chainsaw_version) && ! scan_options &&
		    StrStr (line, "Options enabled"))
		{
			scan_options = True;
			continue;
		}
		if (!land_units &&
		    StrStr (line, "Planes") &&
		    StrStr (line, "Units"))
			land_units = True;


		if (scan_options)
			for (ptr = emp_options; ptr-> name != (char *) 0; ptr ++)
				if (StrStr (line, ptr-> name))
					EMPSetOption (ptr-> option);
	}
	if (EmpireStatus () == E_COMMAND) {
		PrintAtEmpire ("");
		PrintAtEmpire (line);
	} else
		(void) WaitForPrompt (PRINT);
	if (emp3server) {
		EMPSetOption(STOP);
		EMPSetOption(BUDGET);
		EMPSetOption(MULTIFIRE);
		EMPSetOption(NEWSUBS);
		EMPSetOption(OWNASSAULT);
	}
	UpdateDstr ();

	if (size_set && sec_per_etu_set && etu_per_update_set && fgrate_set &&
	    obrate_set && uwbrate_set  && eatrate_set && babyeat_set &&
	    bankint_set && mon_cset && mon_mset && max_mob_set &&
	    mob_gain_set && eff_gain_set)
		return;

	Bell ();

	if (! size_set) {
		PrintAtEmpire ("Version Warning: can't get worldsize");
		ver_max_x = MAX_X;
		ver_max_y = MAX_Y;
	}

	if (! sec_per_etu_set)
		PrintAtEmpire ("Version Warning: can't get # seconds per etu");
	if (! etu_per_update_set)
		PrintAtEmpire ("Version Warning: can't get # etu per update");
	if (! fgrate_set || ! fcrate_set || ! eatrate_set || ! babyeat_set)
	      PrintAtEmpire ("Version Warning: can't get food growth/eat info");
	if (! obrate_set || ! uwbrate_set)
		PrintAtEmpire ("Version Warning: can't get birth rate info");
	if (! bankint_set)
		PrintAtEmpire ("Version Warning: can't get bank interest");
	if (! mon_cset)
		PrintAtEmpire ("Version Warning: can't get taxes for civs/uws");
	if (! mon_mset)
		PrintAtEmpire ("Version Warning: can't get taxes for mils/res");

	Pause ();
}

struct tblvars {
	const char *tb_name;	/* var name */
	int tb_fmt;		/* fmt */
#define TB_END	1		/* end of list */
#define TB_INT	2		/* integer format  */
#define TB_DOUBLE 3		/* float format */
	void *tb_ptr;		/* generic pointer */
};

struct tblvars tbl_vars[] = {
{"happy_req",	TB_DOUBLE,	&happy_req},
{"safe_uw",	TB_INT,		&safe_uw },
{"safe_civs",	TB_INT,		&safe_civ },
{"max_civ_uw",	TB_INT,		&max_civ_uw},
{"END",		TB_END,		0 },
{ 0}
};

static void RestVars (fp)
FILE *fp;
{
	char buffer[BUFSIZ];
	char word[BUFSIZ];
	char *ptr;
	struct tblvars *tp;
	int num;
	int *ip;
	double *dp;
	double d;

	while (fgets (buffer, sizeof buffer, fp) != (char *)0) {
		ptr = buffer;
		if (ScanWord ((ConstVP)&ptr, word) == False)
			break;
		for (tp = tbl_vars; tp -> tb_name; tp ++)
			if (strcmp (word, tp -> tb_name) == 0)
				break;
		if (tp == NULL) continue; /* obsoleted word? */

		switch (tp -> tb_fmt) {
		    case TB_END:
			break;

		    case TB_INT:
			ip = (int *) tp -> tb_ptr;
			if (ScanDigit ((ConstVP)&ptr, &num) == True)
				*ip = num;
			continue;
		    case TB_DOUBLE:
			dp = (double *)tp -> tb_ptr;
			if (sscanf (ptr, " %g", &d) == 1)
				*dp = d;
			continue;
		    default:	/* shouldn't happen - skip */
			continue;
		}
		break;		/* out of here */
			
	}
}

static void SaveVars (fp)
FILE *fp;
{
	struct tblvars *tp;

	for (tp = tbl_vars; tp -> tb_name; tp ++) {
		switch (tp -> tb_fmt) {
		    case TB_END:
			fprintf (fp, "%s end\n", tp -> tb_name);
			break;
		    case TB_INT:
			fprintf (fp, "%s %d\n", tp -> tb_name,
				 *(int *)tp -> tb_ptr);
			continue;
		    case TB_DOUBLE:
			fprintf (fp, "%s %g\n", tp -> tb_name,
				 *(double *)tp -> tb_ptr);
			continue;
		    default:	/* skip */
			continue;
		}
		break;
	}
}

void SaveVersion (fp)
FILE *fp;
{
	int i;

	SET_BIT(savedbits, SAVE_VARS); /* set it */
	fprintf (fp,
	"%dx%d %d %d %lf %lf %lf %lf %lf %lf %lf %lf %lf %lf %lf %d %ld %d %d %d %d\n",
		 ver_max_x, ver_max_y, etu_per_update, sec_per_etu,
		 fgrate, fcrate, eatrate, babyeat, obrate, uwbrate,
		 bankint, money_civ, money_uw, money_mil, money_res,
		 ksu_version, savedbits, chainsaw_version,
		 other_version, land_units, emp3server);
	fprintf(fp,"%d\n", numopts);
	for(i=0;i<numopts;i++)
		fprintf(fp, "%d\n", options_defined[i]);
	SaveVars (fp);
}

void RestoreVersion (fp)
FILE *fp;
{
	char buffer[BUFSIZ];
	int ksu,chain,other,land;

	if (fgets (buffer, BUFSIZ, fp) != (char *) 0)
		if (sscanf (buffer,
	"%dx%d %d %d %lf %lf %lf %lf %lf %lf %lf %lf %lf %lf %lf %d %ld %d %d %d %d",
			    &ver_max_x, &ver_max_y, &etu_per_update,
			    &sec_per_etu, &fgrate, &fcrate, &eatrate,
			    &babyeat, &obrate,
			    &uwbrate, & bankint, & money_civ, & money_uw,
			    & money_mil, & money_res, & ksu,
			    & savedbits, &chain, &other, &land, &emp3server) != 21)
		{
			PrintAtEmpire ("Bad version info in datafile");
			PrintAtEmpire (Fmt ("Skipping Line \"%s\"", buffer));
			PrintAtEmpire ("");
			fprintf (stderr, "Skipping Line \"%s\"", buffer);
		}

	ksu_version = ksu;
	chainsaw_version = chain;
	other_version = other;
	land_units = land;
	if (fgets (buffer, BUFSIZ, fp) != (char *) 0)
	{
		sscanf(buffer,"%d",&numopts);
		if((numopts > 16) || (numopts < 0))
		{
			numopts = 0;
			printf("WRONG EMPversion bits information, skipping line\n");
		}
		else
		{
			int i;
		
			options_defined = (unsigned long *)
				malloc(numopts * sizeof(long));
			for(i=0;i<numopts;i++)
			{
				options_defined[i] = 0;
				fgets (buffer, BUFSIZ, fp);
				sscanf(buffer, "%ld", &options_defined[i]);
			}
		}
	}
	if (eatrate == 0.0)
		no_food = True;
	if (BIT_SET(savedbits, SAVE_VARS))
		RestVars (fp);
	UpdateDstr ();
}

void FScanCommandlist ()
{
	char * line;

	market = False;
	trade = False;
	budget = False;

	FeedEmpire ("list of commands", PRINT);

	PrintAtEmpire ("Scanning commandlist");

	for (;;)
	{

		line = ReadEmpire (DONT_PRINT);

		if (EmpireStatus () == E_COMMAND || line == (char *) 0)
			break;

		if (*line == '\0' || *line == '\n')
			continue;


		if (StrStr (line, "market") != (char *) 0) {
		    market = True;
		    fprintf(stderr, "Market Enabled\n");
		}

		if (StrStr (line, "trade") != (char *) 0) {
		    trade = True;
		    fprintf(stderr, "Trade Enabled\n");
		}
		if (StrStr (line, "budget") != (char *)0) {
		    budget = True;
		}
	}

	if (EmpireStatus () == E_COMMAND) {
		PrintAtEmpire ("");
		PrintAtEmpire (line);
	} else
		(void) WaitForPrompt (PRINT);

	if (!market && !trade)
		fprintf(stderr, "Market & Trade Disabled\n");
}
