/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/misc/RCS/info.c,v 5.6 1996/01/29 08:19:52 jpo Exp $
    $Date: 1996/01/29 08:19:52 $
    $Author: jpo $
    $Id: info.c,v 5.6 1996/01/29 08:19:52 jpo Exp $
    $Locker:  $
    $Log: info.c,v $
    Revision 5.6  1996/01/29 08:19:52  jpo
    New selection interface
    attempt to cope with empire 3 syntax too

    Revision 5.5  1995/09/18 17:01:26  jpo
    Added budget

    Revision 5.4  1995/09/13 07:09:11  jpo
    Add power command

    Revision 5.3  1995/09/08 07:28:34  jpo
    const

    Revision 5.2  1995/08/04 06:55:42  jpo
    fixed up strings for remote case

 * Revision 5.1  93/03/14  16:49:22  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:18:49  greyhelm
 * y
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:37:47  greyhelm
 * Added RCS headers - Karl Hagen
 */


#include <sys/types.h>
#ifdef DIRENT_INSYS
#include <sys/dirent.h>
#else
#include <dirent.h>
#endif
	/*
	 *	or (mta)
	 *	#include <dirent.h>
	 */

#include <sys/stat.h>
#include <sys/file.h>

#include "type.h"
#include "main.h"
#include "func.h"


static char * xemp_info_dir = XEMPINFO;
static char *emp_info_dir = EMPINFO;

#define OWN  		0
#define ENEMY           1


bool local_info = True;

Strings ListDir (dir)
char *dir;
{
	Strings strings;
	FILE *fp;
	char buffer[BUFSIZ];

	strings = InitStrings ();

	fp = popen (Fmt ("/bin/ls %s", dir), "r");

	if (fp == (FILE *) 0)
		AddString (strings, "couln't not execute /bin/ls");

	else if (fgets (buffer, BUFSIZ, fp) == (char *) 0
		 || (emp_info_dir &&
		     strncmp (buffer, emp_info_dir, strlen (dir)) == 0))
	{
		AddString (strings,
			Fmt ("couldn't not list %s", dir));
		pclose (fp);
	}
	else
	{
		do
			AddString (strings,
				DelNewline (DelTabs (buffer)));
		while (fgets (buffer, BUFSIZ, fp) != (char *) 0);
		pclose (fp);
	}

	return strings;
}

	/* ARGSUSED */
Strings FileToStrings (x, y, filename)
int x, y;
const char *filename;
{
	Strings strings;
	FILE *fp;
	const char *p;
	char *ptr, buffer[BUFSIZ];
	int len;
	bool first_pass;

	strings = InitStrings ();

	p = strrchr (filename, '/');
	if (p == (char *) 0) p = filename;
	else p++;

	if ((fp = fopen (filename, "r")) == (FILE *) 0)
		AddString (strings, Fmt ("No info on %s", p));
	else
	{
		if (fgets (buffer, BUFSIZ, fp) == (char *) 0)
			AddString (strings, Fmt ("No info on %s", p));
		else
			do
			{
				ptr = DelControl (
					DelNewline (DelTabs (buffer)));
				len = strlen (ptr);
				first_pass = True;
				while (len > 0 || first_pass)
				{
					first_pass = False;
					if (len > 80)
						AddString (strings,
							Fmt ("%.80s", ptr));
					else
						AddString (strings, ptr);
					ptr += 80;
					len -= 80;
				}
			}
			while (fgets (buffer, BUFSIZ, fp) != (char *) 0);

		fclose (fp);
	}

	return strings;
}

void InfoFile (x, y, file, iscom)
int x, y;
const char *file;
bool iscom;
{
	Strings strings;
	const char *com;

	if (iscom)
	{
		if ((com = strrchr (file, '/')) == (char *) 0)
			com = file;
		else
			com++;
	} else
		com = file;

	strings = FileToStrings (x + 2, y + 2, file);
	ShowStringsInPager (strings, Fmt ("info %s", com));
}

struct iddata {
	int x, y;
	char *dir;
	char *header;
};

static void InfoDirFnx (strings, ind, data)
Strings strings;
int ind;
void *data;
{
	const char *sp = GiveIdString (strings, ind);
	struct iddata *ip = (struct iddata *)data;
	struct stat stat_ent;
	char *entry;

	entry = Str (Fmt ("%s/%s", ip -> dir, sp));
	if (stat (entry, & stat_ent) < 0) {
		Message (Fmt ("Can't stat %s !!", entry));
		Bell ();
		free (entry);
		return;
	}
		
	if ((stat_ent. st_mode & S_IFDIR) == S_IFDIR) /* directory */
		InfoDir (ip -> x + 2, ip -> y + 2, entry, ip -> header);
	else
		InfoFile (ip -> x + 2, ip -> y + 2, entry, False);
	free (entry);
}

static FuncList infodir_fnxs[] = {
	{"Done", DONEFUNC, NULL},
	{"Choose", SELECTFUNC, InfoDirFnx },
	{ NULL},
};


bool InfoDir (x, y, dir, header)
int x, y;
char * dir, * header;
{
	Strings strings;
	int func;
	struct iddata iddata;

	strings = ListDir (dir);

	iddata.dir = dir;
	iddata.header = header;
	iddata.x = x;
		
	func = MakePickDialog (strings, header, infodir_fnxs,
			       &iddata, map_win, x, y, False);
	FreeStrings (strings);

	return False;
}

void XempInfo (x, y)
int x, y;
{
	char *ptr;


	if ((ptr = getenv ("XEMPINFO")) != (char *) 0)
		xemp_info_dir = ptr;
	
	(void) InfoDir (x, y, xemp_info_dir, "xemp/tcemp info");
}

struct idata {
	int x, y;
};

static void InfoFnx (strings, ind, data)
Strings strings;
int ind;
void *data;
{
	const char *sp = GiveIdString (strings, ind);
	const char *ptr;
	struct idata *ip = (struct idata *)data;

	if (! local_info)
	{
		Strings str;
		ptr = Fmt ("info %s", sp);
		FeedEmpire (ptr, PRINT);
		str = InitStrings ();
		ReadEmpireStrings (str);
		ShowStringsInPager (str, ptr);
		FreeStrings (str);
	}
	else
		InfoFile (ip -> x + 2, ip -> y  + 2,
			  Fmt ("%s/%s", emp_info_dir, sp), True);
}

static FuncList info_fnxs[] = {
	{ "Done", DONEFUNC, NULL },
	{ "Choose", SELECTFUNC, InfoFnx },
	{ NULL}
};


void EmpInfo (x, y)
int x, y;
{
	Strings strings;
	static Strings empstrings = NULL;
	char *buf, *ptr;
	int func;
	struct idata idata;

	if (! local_info)
	{
		if (empstrings == NULL) {
			if (emp3server > 1)
				FeedEmpire ("info all", PRINT);
			else	FeedEmpire ("info", PRINT);
			SkipNLines (1, DONT_PRINT);
			PrintAtEmpire ("Empiretool: scanning info");
			empstrings = InitStrings ();
			ReadEmpireWords (empstrings);
		}
		strings = empstrings;
	}
	else
	{
		if ((ptr = getenv ("EMPINFO")) != (char *) 0)
			emp_info_dir = ptr;

		if (emp_info_dir == NULL) {
		    Message ("No local empire directory (in EMPINFO environment)");
		    return;
		}
		strings = ListDir (emp_info_dir);
	}

	idata.x = x;
	idata.y = y;
	func = MakePickDialog (strings, "Info Empire", info_fnxs,
			       &idata, map_win, x, y, False);

	if (strings != empstrings)
		FreeStrings (strings);
}

#define XINFO_ABOUT	0
#define	XINFO_INFOCOMS	1
#define	EINFO_INFOCOMS	2
#define SHOWNATION	3
#define SHOWPOWER	4
#define SHOWBUDGET	5
#define SHIPSCB		6
#define PLANESCB	7
#define LANDCSB         8
#define PLANELIST	9
#define SHIPLIST	10
#define LANDLIST        11
#define ENEMYSHIPS	12
#define ENEMYUNIT	13
#define ENEMYPLANE	14
#define	CHINF_INFOCOMS	15

#define	MAX_INFOCOMS	16

static const char *info_menu [] =
{
	"About Xemp",
	"Xemp info",
	"Empire info",
	"nation",
	"power",
	"budget",
	"ships cap & build",
	"planes cap & build",
	"land cap, stat, & build",
	"list of planes",
	"list of ships",
	"list of land units",
	"list of enemy ships",
	"list of enemy units",
	"list of enemy planes",
	"get info from host (now local)",
	(char *) 0
};

void InfoCommands (x, y)
int x, y;
{
	Strings strings;
	int r, func;

	strings = InitStrings ();
	AddStringsID (strings, info_menu, MAX_INFOCOMS, 0);

	if (! local_info)
		ChangeString (strings, CHINF_INFOCOMS, 
					"get info local (now from host)");

	r = ChooseMenu (strings, "Empire Info commands", map_win, x, y, NULL);
	switch (r) {
	case XINFO_ABOUT:
		ShowVersion ();
		break;

	case CHINF_INFOCOMS:
		if (local_info)
			Message ("get info local (now from host)");
		else
			Message ("get info from host (now local)");

		local_info = ! local_info;
		break;
	case XINFO_INFOCOMS:
		XempInfo (x + 2, y + 2);
		break;

	case EINFO_INFOCOMS:
		EmpInfo (x + 2, y + 2);
		break;

	case SHOWNATION:
		ShowNation ();
		break;

	case SHOWPOWER:
		DisplayPower ();
		break;

	case SHOWBUDGET:
		DoBudget ();
		break;

	case SHIPSCB:
		PageShowShipCBs ();
		break;

	case PLANESCB:
		PageShowPlaneCBs ();
		break;

	case PLANELIST:
		ListPlanes (x + 2, y + 2);
		break;

	case ENEMYPLANE:
/*			ListPlanes (x + 2, y + 2); */
		break;

	case SHIPLIST:
		ListShips (x + 2, y + 2, OWN);
		break;

	case ENEMYSHIPS:
		ListShips (x + 2, y + 2, ENEMY);
		break;

	case LANDLIST:
		ListLand (x + 2, y + 2, OWN);
		break;

	case ENEMYUNIT:
		ListLand (x + 2, y + 2, ENEMY);
		break;

	case LANDCSB:
		PageShowLandCSBs ();
		break;

	}
	FreeStrings (strings);

	return;
}
