/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/land/RCS/select.c,v 5.3 1996/01/29 08:17:57 jpo Exp $
    $Date: 1996/01/29 08:17:57 $
    $Author: jpo $
    $Id: select.c,v 5.3 1996/01/29 08:17:57 jpo Exp $
    $Locker:  $
    $Log: select.c,v $
    Revision 5.3  1996/01/29 08:17:57  jpo
    New interface for selections

    Revision 5.2  1995/09/08 07:20:43  jpo
    const

 * Revision 5.1  93/03/14  16:48:38  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:18:30  greyhelm
 * y
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:47:37  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "var.h"
#include "land.h"
#include "ship.h"
#include "sector.h"
#include "func.h"
#include "nation.h"


char * SelectLands (x, y, ldtask, quest)
int x, y;
LdTask ldtask;
const char * quest;
{
	extern int last_layout;

	static char buffer [200];

	Strings strings;
	Land ptr, land;
	bool flag, first;
	int func;
	int i;
	int nr = 0, cnt;

	strings = InitStrings ();
	AddStringID (strings, 
		      "Land                   Fl Eff  Mob Civ Mil Foo Tec", -2);

	for (ptr = s_fland (cursct); ptr != (Land) 0; ptr = ld_nxtsct (ptr))
	{
		if (! ld_owned (ptr))
			continue;

		if (ldtask == LD_MARCH && ld_mob (ptr) <= 0)
			continue;

		if (ldtask == LD_LLOADXPLANE && ld_xpln (ptr) > landtypes [ld_type (ptr)]. xpl)
			continue;

		if (ldtask == LD_LANDTOSHIP && !PortableLand (ptr) && !sh_nr (ptr) >= 0 ) {
			continue;
		}
		
		AddStringID (strings, Fmt (
			"%-4d %-16.16s  %c %-3d%% %-3d %-3d %-3d %-3d %-4d",
				ld_nr (ptr),
				LandName (ptr),
				ld_army (ptr),
				ld_eff (ptr),
				ld_mob (ptr),
				ld_xpln (ptr),
				ld_she (ptr),
				ld_foo (ptr),
				ld_tech (ptr)),
			ld_nr (ptr));

		nr = ld_nr (ptr);
	}

	if (StringsSize (strings) == 1)
	{
		FreeStrings (strings);
		Message ("No available lands.");
		Bell ();
		return (char *) 0;
	}
	else if (StringsSize (strings) == 2)
	{
		FreeStrings (strings);
		return Fmt ("%d", nr);
	}

	if (last_layout == LAND_MODE)
		SetStringFlag (strings, ld_nr (curland), True);
	else if (last_layout == ARMY_MODE)
		for (ptr = s_fland (cursct); ptr != (Land) 0;
							ptr = ld_nxtsct (ptr))
			if (ld_army (ptr) == curarmy)
				SetStringFlag (strings, ld_nr (ptr), True);

	switch (MultiSelectPager(strings, quest, NULL, NOFUNC, NULL)) {
	default:
	case CANCELFUNC:
		FreeStrings (strings);
		return NULL;

	case DONEFUNC:
		break;
	}
	
	InitStringList (strings);
	buffer [0] = '\0';
	first = True;
	cnt = 0;
	while ((nr = GetNextSelectedId (strings)) != -1)
	{
		if (nr == -2)
			continue;

		if (first) 
			first = False;
		else 
			strcat (buffer, "/");

		cnt++;
		strcat (buffer, Fmt ("%d", nr));
	}

	FreeStrings (strings);
	if (first)
	{
		Message ("No lands selected");
		return (char *) 0;
	} else {
		return buffer;
	}
}
