/*
	$Header: /nexor/users/jpo/xemp/xemp5.0/lib/land/RCS/retreat.c,v 1.4 1996/01/29 08:17:30 jpo Exp $
	$Date: 1996/01/29 08:17:30 $
	$Author: jpo $
	$Id: retreat.c,v 1.4 1996/01/29 08:17:30 jpo Exp $
	$Locker:  $
	$Log: retreat.c,v $
	Revision 1.4  1996/01/29 08:17:30  jpo
	New interface for selections

	Revision 1.3  1995/09/10 17:39:58  jpo
	Add army support and display

	Revision 1.2  1995/09/08 07:20:27  jpo
	retreat stuff

 * Revision 1.1  93/03/14  16:48:27  etienne
 * Initial revision
 * 
*/

#include "main.h"
#include "version.h"
#include "sector.h"
#include "land.h"
#include "func.h"

extern const char *retreatcond[];
extern const char retreat_n2cond[];

static bool LandRetreat _PROTO((const char *lands,
				uchar cond,
				Sector sct,
				short *rtrxp, short *rtryp,
				uchar *condp));

static bool LandRetreat (lands, cond, sct, rtrxp, rtryp, condp)
const char *lands;
uchar cond;
Sector sct;
short *rtrxp, *rtryp;
uchar *condp;
{
	Strings strings;
	char buf[10];
	char *cp;
	int nr;
	Sector to;
	int i;
	char *path;

	strings = InitStrings ();
	AddStringsID (strings, retreatcond,  RETREAT_MAXSTR, 0);
	MakeStringIndex (strings);
	for (i = 0; i < RETREAT_MAX; i++)
		if (cond & (1 << i))
			SetIthFlag (strings, i, 1);
	
	switch (MultiSelectPager (strings, "Retreat Conditions",
				  "Delete", DELETEFUNC, NULL)) {
	case DELETEFUNC:
		FreeStrings (strings);
		FeedCommand (Fmt ("lretreat %s h C", lands),
			     PRINT);
		*condp = RETREAT_NONE;
		return True;

	case CANCELFUNC:
	default:
		FreeStrings (strings);
		return False;

	case DONEFUNC:
		break;
	}
	InitStringList (strings);
	cp = buf;
	cond = RETREAT_NONE;
	while ((nr = GetNextSelectedId (strings)) != -1) {
		*cp ++ = retreat_n2cond[nr];
		cond |= (1 << nr);
	}
	*cp = '\0';
	FreeStrings (strings);

	Message (Fmt ("Retreat land %s to sector?", lands));
	to = ChooseLandDest (sct, &path);
	if (to == NULL) {
		return False;
	}
	*condp = cond;
	*rtrxp = s_xcd (to);
	*rtryp = s_ycd (to);
	FeedCommand ( Fmt ("lretreat %s %s %s", lands, path, buf),
		      PRINT);
	return True;
}
 


void LRetreat (land)
Land land;
{
	short rx, ry;
	uchar cond;

	if (!ld_owned (land)) {
		Message ("Not your unit !!");
		return;
	}

	if (LandRetreat (Fmt ("%d", ld_nr(land)),
			 land -> rtrcond,
			 World (ld_xcd(land), ld_ycd(land), S_DESIG),
			 &rx, &ry,
			 &cond) == True) {
		land -> rtrcond = cond;
		land -> rtrtx = rx;
		land -> rtrty = ry;
	}
}

void FScanLandRetreat (list, flag)
const char *list;
int flag;
{
	FeedEmpire (Fmt ("lretreat %s", list), flag);

	ScanLandRetreat (flag);
	(void) WaitForPrompt (flag);
}

void ScanLandRetreat (flag)
int flag;
{
	char *ptr, *ind;
	Land land;
	int sno;
	int flagoff, pathoff;
	int x, y;

	if (EmpireStatus () != E_PRINTING)
		return;
	if (flag == PRINT)
		PrintAtEmpire ("Empiretool: scanning land retreats");
	
	ptr = ReadEmpire (DONT_PRINT);
	if ((ind = StrStr (ptr, "unit type")) == NULL) {
		PrintAtEmpire (Fmt ("Order scan failed on %s", ptr));
		return;
	}
	if ((ind = StrStr (ptr, "path")) == NULL) {
		PrintAtEmpire (Fmt ("No path in %s", ptr));
		return;
	}
	pathoff = ind - ptr;

	if ((ind = StrStr (ptr, "flags")) == NULL) {
		PrintAtEmpire (Fmt ("No flags in %s", ptr));
		return;
	}
	flagoff = ind - ptr;
	for (;;) {
		Sector to;
		ind = ptr = ReadEmpire (DONT_PRINT);

		if (EmpireStatus () != E_PRINTING) {
			if (flag == PRINT)
				PrintAtEmpire (ptr);
			return;
		}
		
		if (ScanDigit ((ConstVP)&ind, &sno)) /* land name? */
			continue;
		if (strncmp (ind, "land", 4) == 0) /* %d lands */
			break;
		if (strlen(ptr) < flagoff)
			continue;
		if ((land = NrToLand (sno)) == (Land)0) {
			PrintAtEmpire (Fmt ("#%d Unknown unit (rescan lands!)",
					    sno));
			Bell ();
			(void) EmpireMore ();
			continue;
		}
		land -> rtrcond = RETREAT_NONE;
		for (ind = &ptr[flagoff]; *ind; ind ++) {
			char *cp;
			if ((cp = index (retreat_n2cond, *ind)) == NULL)
				continue;
			land -> rtrcond |= (1 << (cp - retreat_n2cond));
		}
		ind = &ptr[pathoff];
		to = FollowPath (World(ld_xcd(land), ld_ycd(land), S_DESIG),
				 ind);
		land -> rtrtx = s_xcd (to);
		land -> rtrty = s_ycd (to);
	}
}



Sector ChooseLandDest (sct, pathp)
Sector sct;
char **pathp;
{
	int button;
	Sector to;

	MesBut ("View", "Cancel", "Set");
	for (;;) {
		to = SelectSector (&button);
		
		if (interrupt || button == MIDDLE_BUTTON) {
			interrupt = False;
			Message ("Cancelled");
			MesClearBut ();
			return NULL;
		}
		if (to == (Sector)0)
			continue;

		if (button == LEFT_BUTTON) {
			CensusSct (to);
			continue;
		}
		if (to == sct)
			continue;
		if (s_mines (to) > 0 || s_des(to) == '.') {
			Message ("Not a good navigable sector!");
			continue;
		}
		if ((*pathp = BestTmpDistPath (sct, to)) == NULL) {
			Message ( Fmt("I don't see a path from %s to %s",
				      CrdStr(sct), CrdStr(to)));
			return NULL;
		}
		MesClearBut ();
		return to;
	}
}

const char *ArmyHasRetreat (army)
char army;
{
	Land ptr;
	uchar rcond = 0;
	int first = 0;

	for (ptr = landlist; ptr != (Land) 0; ptr = ptr-> next)
		if (ptr-> army == army) {
			if (first++ == 0) 
				rcond = ld_retreat(ptr);
			else if (rcond != ld_retreat(ptr))
				return "Mixed";
		}
	
	if (rcond == RETREAT_NONE)
		return "No";
	return RtrtList (rcond);
}

void ChangeArmyRetreat (army)
char army;
{
	Land ptr;
	int first = 0;
	int rcond = 0;
	Sector sct;
	short rx, ry;
	uchar cond;

	if (ArmyEmpty (army) == True) {
		Message ("Empty army");
		return;
	}

	
	for (ptr = landlist; ptr != (Land) 0; ptr = ptr-> next)
		if (ptr-> army == army) {
			if (first++ == 0) 
				rcond = ld_retreat(ptr);
			else if (rcond != ld_retreat(ptr)) {
				rcond = 0;
				break;
			}
		}
	
	if ((sct = ArmySector (army)) == NULL)
		return;

	if (LandRetreat (Fmt ("%c", army),
			  rcond,
			  sct,
			  &rx, &ry,
			  &cond) == True) {
		for (ptr = landlist; ptr != (Land) 0; ptr = ptr-> next)
			if (ptr-> army == army) {
				ptr -> rtrcond = cond;
				ptr -> rtrtx = rx;
				ptr -> rtrty = ry;
			}
		CensusArmy (army);
	}
}
