/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/land/RCS/march.c,v 5.2 1995/09/08 07:19:32 jpo Exp $
    $Date: 1995/09/08 07:19:32 $
    $Author: jpo $
    $Id: march.c,v 5.2 1995/09/08 07:19:32 jpo Exp $
    $Locker:  $
    $Log: march.c,v $
    Revision 5.2  1995/09/08 07:19:32  jpo
    touch up
    ,

 * Revision 5.1  93/03/14  16:47:34  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:18:30  greyhelm
 * y
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:47:37  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "var.h"
#include "land.h"
#include "sector.h"
#include "plane.h"

#define HOW_SELECT	0	/* via menu */
#define HOW_CURRENT	1	/* via redo */
#define HOW_BOTH	2	/* via bind */

void DoMarch (x, y, how)
int x, y;
int how;
{
	char * ptr;

	if (last_layout == LAND_MODE && how != HOW_SELECT)
	{
		if (! ld_owned (curland))
		{
			Message ("Not your unit !");
			Bell ();
			return;
		}

		March (Fmt ("%d", ld_nr (curland)));
	}
	else if (last_layout == ARMY_MODE && how != HOW_SELECT)
		March (Fmt ("%c", curarmy));
	else
	{
		if (how == HOW_CURRENT)
		{
			Message ("No current land/army");
			Bell ();
			return;
		}

		ptr = SelectLands (x, y, LD_MARCH, "March which units ?");
		if (ptr == (char *) 0)
			return;
		March (ptr);
	}
}

void RedoMarch ()
{
	DoMarch (10, 10, HOW_CURRENT);
}

void BindMarch (x, y, str)
int x, y;
char * str;
{
	static char buf [100];

	if (sscanf (str, " ( %s ) ", buf) == 1)
		March (buf);
	else
		DoMarch (x, y, HOW_BOTH);
}

void Mar (x, y)
int x, y;
{
	DoMarch (x, y, HOW_SELECT);
}

void March (march_what)
char *march_what;
{
	int nx, ny;
	Land land;
	Sector sct, next;
	char * ptr, * ptri;
	int minmob;
	double newmob;
	int rad;
	int button;
	char * path;
	char * answer;
	int best_rad;

	UnmarkAllLands ();
	MarkLands (march_what);
	SetAgain (RedoMarch);

	minmob = MinMobMarkedLands (& land);
	if (minmob < 0)
	{
		if (land == (Land) 0)
		{
			Message ("No lands selected to march !");
			Bell ();
			return;
		}
		else	/* if (! deity) */
		{
			Message (Fmt ("%s #%d out of mobility",
				LandName (land), ld_nr (land)));
			return;
		}
	}

	if (! LMarkedColocated ())
	{
		Message ("Selected lands are not colocated");
		Bell ();
		return;
	}

	sct = SctMarkedLands ();
	if (sct == (Sector) 0)
	{
		Message ("You don't know anything about this sector");
		Bell ();
		return;
	}

	UnmarkSector (cursct);
	MarkSector (sct);
	FeedEmpire (Fmt ("march %s", march_what), PRINT);
	ptr = WaitForPrompt (PRINT);

	if ( EmpireStatus  () == E_COMMAND ||
				sscanf (ptr, "<%*f:%lf", & newmob) != 1)
	{

		PrintAtEmpire (ptr);
		Message ("March failed");
		Bell ();
		cursct = sct;
		return;
	}
	
	rad = MaxLRadarMarked (& best_rad);
	if (best_rad == -1)
		best_rad = FirstMarkedLandnr ();

	Message (Fmt ("march: now at %s (mob %.1f)",
		CrdStr (sct), newmob));

	for (;;)
	{
		if (EmpireStatus () == E_COMMAND)
		{
			Message ("Marching stopped");
			MesClearBut ();
			CheckLands (march_what);
			DoLLookout (sct, best_rad, False, PRINT, False);
			cursct = sct;
			return;
		}

		MesBut ("View", "Extended Commands", "Move");

		DoLLookout (sct, best_rad, True, PRINT, False);

		(void) SelectSctCrd (& nx, & ny, & button);

		if (interrupt)
		{
			interrupt = False;
			FeedEmpire ("aborted", PRINT);
			continue;
		}

		if (button == RIGHT_BUTTON)
			next = World (nx, ny, S_DESIG);
		else
			next = World (nx, ny, S_EXIST);
		
		if (next == (Sector) 0)
			continue;

		if (button == LEFT_BUTTON)
		{
			CensusSct (next);
			continue;
		}
			
		if (button == MIDDLE_BUTTON)
		{
			MesBut (
				(deity || landtypes [ld_type (land)]. spy  > 0&& LandHas (land, L_RADAR)) ? Fmt ("Radar (%d)", rad) :
					             "---",
				"---",
				"Lookout");

			WaitButtonPress (&button);
			if (interrupt)
			{
				interrupt = False;
				continue;
			}

			if (button == LEFT_BUTTON)
			{
				if (! deity && rad < 0)
					continue;

				FeedEmpire (Fmt ("r %d", best_rad), PRINT);
				ScanRadar ();
			}
			else if (button == MIDDLE_BUTTON)
			{
			}
			else if (button == RIGHT_BUTTON)
			{
				FeedEmpire (Fmt ("l %d", best_rad), PRINT);
				ScanLookout ();
				/* you should always know your neighbours */
			}

			(void) WaitForPrompt (PRINT);
			DrawMap ();

			continue;
		}

		if (button == RIGHT_BUTTON && sct == next)
		{
			FeedEmpire ("h", PRINT);
			(void) WaitForPrompt (PRINT);

			Message (Fmt ("Marching stopped @ %s", CrdStr (sct)));
			MesClearBut ();

			CheckLands (march_what);
			cursct = sct;
			return;
		}
		
		/* if (button == RIGHT_BUTTON)  -> true */

		if (s_mines (next) > 0  && s_des (next) != 'h' && 
		    s_des (next) != '=' && ! Confirm (
			"Captain, mines here, still go there ?", False))
					continue;

		path =  BestTmpDistPath (sct, next);
		if (path == (char *) 0)
		{
			Message ("Couldn't find a path !");
			Bell ();
			continue;
		}

		MarkPath (sct, path);
		FeedEmpire (Fmt ("%s", path), PRINT);
		UnmarkPath (sct, path);

		for (;;)
		{
			ptr = ReadEmpire (DONT_PRINT);

			if (EmpireStatus () == E_QUESTION)
			{
				PrintAtEmpire (ptr);
				if (sscanf (ptr, "<%*lf:%lf: %d,%d",
					& newmob, & nx, & ny) != 3)
				{

					answer = InputAtMessage (ptr,
								20, GS_NAME);

					if (interrupt || answer == (char *) 0)
					{
						FeedEmpire ("aborted", PRINT);
						Bell ();
						MesClearBut ();
						(void) WaitForPrompt (PRINT);
						CheckLands (march_what);
						if (NO_INFO (next))
							FreeSector (next);
						cursct = sct;
						DoLLookout (sct, best_rad,
							False, PRINT, False);
						return;
					}

					FeedEmpire (answer, PRINT);
					continue;
				} else
					break;
			}

			if (EmpireStatus () == E_COMMAND)
			{
				PrintAtEmpire (ptr);
				Message ("Marching failed");
				Bell ();
				MesClearBut ();
				CheckLands (march_what);
				if (NO_INFO (next))
					FreeSector (next);
				cursct = sct;
				DoLLookout (sct, best_rad, False, PRINT, False);
				return;
			}

			if (StrEQ (ptr, "Sweep"))
			{
				Message ("Sweeping mines... -- MORE --");
				Bell ();
				Pause ();
				continue;
			}

			if (strncmp (ptr, "\007Kawhomp!", 9) == 0)
			{
	/* Mark sector mine was actually hit in, not originating sector */
				Sector sct1;
				int x1, y1;

				PrintAtEmpire (ptr + 1);
				sscanf(ptr+1,
	"Kawhomp! landmines detected by %*[^(](#%*d) in %d,%d!",&x1,&y1);
				sct1 = World (x1, y1, S_DESIG);
				if (s_mines (sct1) == 0)
					set_mines (sct1, 128);
				else if (s_mines (sct1) < 127)
					set_mines (sct1, s_mines (sct1) - 1);
				else
					set_mines (sct1, s_mines (sct1) + 1);
				CensusSct (sct1);
				Message ("You hit a mine !!");
				Bell ();
				Pause ();
				continue;
			}

			PrintAtEmpire (ptr);

			ptri = index (ptr, '#');
			if (ptri == (char *) 0)
				continue;
			
			ScanFmt ((ConstVP)& ptri, (char *) 0, ")#0-9 \t");

			if (StrEQ (ptri, "can't go to")) 
			{
				if (NO_INFO (next))
					(void) UpdateSectorDes
						(next, '?', False);

				Warning ("You can't go there");
				Bell ();
				DrawSector (next);
				continue;
			}

			if (sscanf (ptri,
				"stopped at %d , %d", & nx, & ny) == 2) 
			{
				(void) UpdateSectorDes (next, '.', False);
				Message ("Out of mobility");
				Bell ();
				MesClearBut ();
				if (EmpireStatus () != E_COMMAND)
				{
					if (EmpireStatus () == E_PRINTING)
						(void) WaitForPrompt (PRINT);
					while (EmpireStatus () != E_COMMAND)
					{
						FeedEmpire ("aborted", PRINT);
						(void) WaitForPrompt (PRINT);
					}
				}
				next = World (nx, ny, S_DESIG);
				LMoveMarkedTo (next);
				UnmarkSector (sct);
				MarkSector (next);
				CheckLands (march_what);
				cursct = next;
				DoLLookout (next, best_rad, False, PRINT, False);
				return;
			}
		}
					
		/* Move is oke */

		next = World (nx, ny, S_DESIG);
		(void) UpdateSectorDes (next, '.', False);
		LMoveMarkedTo (next);
		UnmarkSector (sct);
		sct = next;
		MarkSector (sct);

		Message (Fmt ("march: now at %s (mob %.1f)",
			CrdStr (sct), newmob));
	}
}
