/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/land/RCS/landscan.c,v 5.7 1996/01/29 17:32:11 jpo Exp $
    $Date: 1996/01/29 17:32:11 $
    $Author: jpo $
    $Id: landscan.c,v 5.7 1996/01/29 17:32:11 jpo Exp $
    $Locker:  $
    $Log: landscan.c,v $
    Revision 5.7  1996/01/29 17:32:11  jpo
    fix up

    Revision 5.6  1996/01/29 17:29:21  jpo
    Fixup from rk@Unify.Com (Ron Kuris)
    modified by jpo, auto detect parsing stuff

    Revision 5.5  1996/01/29 08:16:35  jpo
    lint stuff

    Revision 5.4  1995/09/27 13:22:24  jpo
    Added flak units

    Revision 5.3  1995/09/21 06:23:28  jpo
    Patrick Kenney - change scan position

    Revision 5.2  1995/09/08 07:19:06  jpo
    const stuff

 * Revision 5.1  93/03/14  16:47:29  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:18:30  greyhelm
 * y
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:47:37  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "sector.h"
#include "nation.h"
#include "var.h"
#include "land.h"
#include "version.h"

void FScanShowLandBuild ()
{
	
	char *line;
	char *bptr, buffer [BUFSIZ];
	int nrt = 0;
	int i;
	LdType tmp;

	FeedEmpire ("show land build", PRINT);
	(void) SkipNLines (1, DONT_PRINT);

	MessageAtEmpire ("scanning land build data");

	for (;;)
	{
		line = ReadEmpire (DONT_PRINT);

		if (StrStr("lcm hcm mil", line))
		   continue;
			/* last line ? */
		if (EmpireStatus () != E_PRINTING)
		{
			PrintAtEmpire ("");
			PrintAtEmpire (line);
			landtypes [nrt]. nam = (char *) 0;
			return;
		}
		
		strncpy (buffer, line, 24);
		buffer [24] = '\0';
		bptr = buffer + 23;

		while (*bptr == ' ')
			bptr --;
		* ++bptr = '\0';


		if (landtypes [nrt]. nam != (char *) 0)
			free (landtypes [nrt]. nam);

		landtypes [nrt]. nam = Str (buffer);
		if (sscanf (line + 25, " %d %d %d %d %d %d %d $%d",
		               & (landtypes [nrt]. lcm),
		               & (landtypes [nrt]. hcm),
		               & (landtypes [nrt]. mil),
		               & (landtypes [nrt]. guns),
		               & (landtypes [nrt]. shells),
		               & (landtypes [nrt]. ava),
		               & (landtypes [nrt]. tec),
		               & (landtypes [nrt]. cos)) != 8) {
			PrintAtEmpire(Fmt("Scanning land failed \"%s\"",
					line));
			Bell ();
			(void) EmpireMore ();
			nrt --;
			}
		nrt ++;
	}
}

void FScanShowLandStats ()
{
	char *line, *ptri;
	char *bptr, buffer [BUFSIZ];
	char word [BUFSIZ];
	int nr = 0;
	int quant;
	char itemchar;
	int item;
	int i;
	LdType tmp;	

	FeedEmpire ("show land stats", PRINT);
	(void) SkipNLines (3, DONT_PRINT);

	MessageAtEmpire ("scanning land stats");

	for (;;)
	{
		line = ReadEmpire (DONT_PRINT);

		if (StrStr("def", line))
		   continue;

			/* last line ? */
		if (EmpireStatus () != E_PRINTING)
		{
			PrintAtEmpire ("");
			PrintAtEmpire (line);
			return;
		}
		
		if (sscanf (line + 24, " %f %f %d %d %d %d %d %d %d %d %d %d %d %d %d",
			     & (landtypes [nr]. att),
			     & (landtypes [nr]. def),
			     & (landtypes [nr]. vul),
			     & (landtypes [nr]. spd),
			     & (landtypes [nr]. vis),
			     & (landtypes [nr]. spy),
			     & (landtypes [nr]. rad),
			     & (landtypes [nr]. frg),
			     & (landtypes [nr]. acc),
			     & (landtypes [nr]. dam),
			     & (landtypes [nr]. amm),
			     & (landtypes [nr]. aaf),
			     & (landtypes [nr]. fcar),
			     & (landtypes [nr]. fuse),
			     & (landtypes [nr]. xpl)) != 15)
			{
		    	PrintAtEmpire (Fmt ("Scanning land failed \"%s\"",
					line));
		    	Bell ();
		    	(void) EmpireMore ();
			}

			/* Clear max cargoes */

		for (item = 0; item < V_MAX; item++)
			landtypes [nr]. car [item] = 0;

		landtypes [nr]. flags = 0L;

			/* Scan max cargoes */
		nr++;
	}
}
void FScanShowLandCap()
{
	char *line, *ptri;
	char *bptr, buffer [BUFSIZ];
	char word [BUFSIZ];
	int nr = 0;
	int quant;
	char itemchar;
	int item;
	int i;
	LdType tmp;	

        FeedEmpire ("show land cap", PRINT);
        MessageAtEmpire ("scanning land capabilities");

	(void) SkipNLines (1, DONT_PRINT);

	for (;;)
	{
                line = ReadEmpire (DONT_PRINT);

                        /* last line ? */
                if (EmpireStatus () != E_PRINTING)
                {
                        PrintAtEmpire ("");
                        PrintAtEmpire (line);
                        return;
                }

		ptri = line + 25;

		for (;;)
		{
			if (! ScanWord ((ConstVP)&ptri, word))
				break;

			if (sscanf (word, "%d%c", &quant, &itemchar) == 2)
			{
				item = CharToItem (itemchar);
				landtypes [nr]. car [item] = quant;
			}
			else if (strcmp (word, "supply") == 0)
				landtypes [nr]. flags |= L_SUPPLY;
			else if (strcmp (word, "light") == 0)
				landtypes [nr]. flags |= L_LIGHT;
			else if (strcmp (word, "assault") == 0)
				landtypes [nr]. flags |= L_ASSAULT;
			else if (strcmp (word, "recon") == 0)
				landtypes [nr]. flags |= L_RECON;
			else if (strcmp (word, "security") == 0)
				landtypes [nr]. flags |= L_SECURITY;
			else if (strcmp (word, "engineer") == 0)
				landtypes [nr]. flags |= L_ENGINEER;
			else if (strcmp (word, "radar") == 0)
				landtypes [nr]. flags |= L_RADAR;
			else if (strcmp (word, "marine") == 0)
				landtypes [nr]. flags |= L_MARINE;
			else if (strcmp (word, "xlight") == 0)
				landtypes [nr]. flags |= L_XLIGHT;
			else if (strcmp (word, "flak") == 0)
				landtypes [nr]. flags |= L_FLAK;
			else
			{
				PrintAtEmpire (Fmt (
					"Strange format in cargo \"%s\"",
					word));
				Bell ();
			}
		}
 		landtypes [nr]. flags |= L_KNOWN;
		/* sort the list by tech */
		for( i=nr; i > 0; i-- ) {
		    if (landtypes[i].tec < landtypes[i-1].tec) {
			bcopy(&landtypes[i-1], &tmp, sizeof(LdType));
			bcopy(&landtypes[i], &landtypes[i-1], sizeof(LdType));
			bcopy(&tmp, &landtypes[i], sizeof(LdType));
		    }
		}
		nr++;
	}
}

void RestoreShowLand (fp)
FILE *fp;
{
	int nr;
	register int j;
	char buffer [BUFSIZ];
	char name [BUFSIZ];
	register char *ptri;

	nr = 0;
	while (fgets (buffer, BUFSIZ, fp) != (char *) 0)
	{
		if (strncmp (buffer, "END OF SHOW LAND LIST", 21) == 0)
		{
			landtypes [nr]. nam = (char *) 0;
			break;
		}

		buffer [strlen (buffer) - 1] = '\0';	/* no newline */
		
		if (sscanf (buffer,"%s %d %d %d %d %d %d %d %d %f %f %d %d %d %d %d %d %d %d %d %d %d %d %d %ld",
			    name,
			    & (landtypes [nr]. lcm), & (landtypes [nr]. hcm),
			    & (landtypes [nr]. mil), & (landtypes [nr]. guns),
			    & (landtypes [nr]. shells), & (landtypes [nr]. ava),
			    & (landtypes [nr]. tec), & (landtypes [nr]. cos),
			    & (landtypes [nr]. att), & (landtypes [nr]. def),
			    & (landtypes [nr]. vul), & (landtypes [nr]. spd),
			    & (landtypes [nr]. vis), & (landtypes [nr]. spy),
			    & (landtypes [nr]. rad), & (landtypes [nr]. frg),
			    & (landtypes [nr]. acc), & (landtypes [nr]. dam),
			    & (landtypes [nr]. amm), & (landtypes [nr]. aaf),
			    & (landtypes [nr]. fuse), & (landtypes [nr]. fcar),
			    & (landtypes [nr]. xpl), 
			    & (landtypes [nr]. flags)) != 25)
				{
				PrintAtEmpire ("Bad Land info in datafile");
				Bell ();
				continue;
				}

		for (ptri = name; *ptri != '\0'; ptri ++)
			if (*ptri == '_')
				*ptri = ' ';

		landtypes [nr]. nam = Str (name);

		for (j = 1; j < V_MAX; j++)
			fscanf (fp, " %d ", & (landtypes [nr]. car [j]));

		fscanf (fp, "\n");
		nr ++;
	}
}

void SaveShowLand (fp)
FILE *fp;
{
	register int i, j;
	register char *ptri, *name;;

	for (i = 0; landtypes [i]. nam != (char *) 0; i ++)
	{
		name = Str (landtypes [i]. nam);
		for (ptri = name; *ptri != '\0'; ptri ++)
			if (*ptri == ' ')
				*ptri = '_';

		fprintf (fp, "%s %d %d %d %d %d %d %d %d %f %f %d %d %d %d %d %d %d %d %d %d %d %d %d %ld\n",
				name,
			 	landtypes [i]. lcm, landtypes [i]. hcm,
			 	landtypes [i]. mil, landtypes [i]. guns,
			 	landtypes [i]. shells, landtypes [i]. ava,
			 	landtypes [i]. tec, landtypes [i]. cos,
			 	landtypes [i]. att, landtypes [i]. def,
			 	landtypes [i]. vul, landtypes [i]. spd,
			 	landtypes [i]. vis, landtypes [i]. spy,
			 	landtypes [i]. rad, landtypes [i]. frg,
			 	landtypes [i]. acc, landtypes [i]. dam,
			 	landtypes [i]. amm, landtypes [i]. aaf,
			 	landtypes [i]. fuse, landtypes [i]. fcar,
			 	landtypes [i]. xpl, landtypes [i]. flags);

		for (j = 1; j < V_MAX; j++)
			fprintf (fp, "%d ", landtypes [i]. car [j]);

		fprintf (fp, "\n");
		free (name);
	}

	fprintf (fp, "END OF SHOW LAND LIST\n");
}
	
int DumpLand (list, flag)
const char *list;
int flag;
{
	int nr;

	nr = FScanLand (list, flag);
	if (nr > 0) {
		FScanLandCargo (list, flag);
		FScanLandMission (list, flag);
		FScanLandRetreat (list, flag);
	}
	return (nr);
}

int FScanLand (list, flag)
const char *list;
int flag;
{
	bool nr;

	FeedEmpire (Fmt ("lands %s", list), flag);
	nr = ScanLands (flag);
	(void) WaitForPrompt (flag);

	return nr;
}

int ScanLands (flag)
int flag;
{
	char *line, *ptri;
	int sx, sy, nr, owner, i, nr_of_lands;
	int eff, food, mob, tech, xpln, fuel, shipnr, fort, retr, arad; 
	Land new, last_land;
	Sector to;
	bool rescan;
	char landname[100];
	double mobcost;
	int lands;
	int effoff;

	if (EmpireStatus () != E_PRINTING)
		return 0;

	if (flag == PRINT)
		PrintAtEmpire ("Empiretool: scanning lands");

	line = ReadEmpire (DONT_PRINT);
	if ((ptri = StrStr (line, "eff")) != NULL)
	    effoff = (ptri - line) - 1;
	else {
	    PrintAtEmpire (Fmt ("Unknown format line \"%s\"", line));
	    Bell ();
	    EmpireMore ();
	    effoff = 34;
	}

	nr_of_lands = 0;
	last_land = (Land) 0;

	for (;;)
	{
		line = ReadEmpire (DONT_PRINT);

		if (EmpireStatus () != E_PRINTING)
		{
			PrintAtEmpire (line);
			return (nr_of_lands);
		}

		if (strlen (line) < 45)
		{
			if (sscanf (line, "%d unit", & lands) == 1)
			{ 
				if (lands != nr_of_lands)
				{ 
					PrintAtEmpire ("Bad Unit Count!!");
					return (nr_of_lands);
				} else {
					return (nr_of_lands);
				}
			} else 
				return 0;
		}

		if (deity)
		{
			owner = atoi (line);
			line += 4;
		} else {
			 owner = my_cnum;
		}

			/* read land#  */

		nr = atoi (line);

		if ((new = NrToLand (nr)) == (Land) 0)
		{
			new = (Land)
				doalloc ((unsigned) sizeof (struct l_land));

			bzero (new, sizeof (struct l_land));
			set_ld_nr (new, nr);
			rescan = False;
	  	} else {
			rescan = True;
		}

		set_ld_marked (new, False);
		set_ld_owner (new, owner);

			/* read landname */
		for (i = 5; i <= 24; i++)
			landname [i - 5] = *(line + i);

		i -= 5;
		while (landname [-- i] == ' ');

		landname [i + 1] = '\0';


			/* read position */
		if (sscanf (line + 25, "%d,%d", & sx, &sy) != 2)
		{
			if (! rescan)
				free ((char *) new);
			PrintAtEmpire (Fmt ("Bad unit %s", line));
			continue;
		}
			
		set_ld_army (new, *(line + 33));
		if (ld_army (new) == ' ')
			set_ld_army (new, '~');

		ptri = line + effoff;
		
		(void) ScanDigit ((ConstVP)&ptri, &eff);

		ptri++;  /* Get past % sign */

		(void) ScanDigit ((ConstVP)&ptri, &fort);
		(void) ScanDigit ((ConstVP)&ptri, &mob);
		(void) ScanDigit ((ConstVP)&ptri, &food);
		(void) ScanDigit ((ConstVP)&ptri, &fuel);
		(void) ScanDigit ((ConstVP)&ptri, &tech);
		(void) ScanDigit ((ConstVP)&ptri, &retr);
		ptri++;  /* Get past % sign */
		(void) ScanDigit ((ConstVP)&ptri, &arad);
		(void) ScanDigit ((ConstVP)&ptri, &xpln);

		if (!ScanDigit ((ConstVP)&ptri, &shipnr))
		{
			set_ld_shipnr (new, -1);
		} else {
			set_ld_shipnr (new, shipnr);
		}
		
		set_ld_eff (new, eff);
		set_ld_foo (new, food);
		set_ld_fort (new, fort);
		set_ld_retr (new, retr);
		set_ld_arad (new, arad);
		set_ld_xpln (new, xpln);
		set_ld_fuel (new, fuel);
		set_ld_mob (new, mob);
		set_ld_tech (new, tech);

/*		mobcost = ld_eff (new) * 0.01 * landtypes [ld_type (new)]. spd;
		mobcost = 480.0 / (mobcost + TechFact (ld_tech (new), mobcost));
		set_ld_moves (new, mob / mobcost + 0.99);
*/
		SetLandValues (new, landname);

		if (rescan)
		{
			MoveLand (new, World (sx, sy, S_DESIG));
		} else
		{
			to = World (sx, sy, S_DESIG);
			UpdateSectorDes (to, s_des( to) , False);
			AddLandToList (new);
			AddLandToSector (new, World (sx, sy, S_DESIG));
		}

		last_land = new;
		nr_of_lands++;
	}
}

void FScanLandCargo (list, flag)
const char *list;
int flag;
{
        FeedEmpire (Fmt ("lcargo %s", list), flag);
        ScanLandCargo (flag);
        (void) WaitForPrompt (flag);
}

void ScanLandCargo (flag)
int flag;
{
        char *line, *ptri, *tmp, *s = NULL, savechar;
        int nr;
        Land land;
        extern WinInfo empire_win;

        if (EmpireStatus () != E_PRINTING)
                return;

        if (flag == PRINT)
                PrintAtEmpire ("Empiretool: scanning cargo");

        (void) SkipNLines (1, DONT_PRINT);

        for (;;)
        {
                line = ptri = ReadEmpire (DONT_PRINT);

                if (EmpireStatus () != E_PRINTING)
                {
                        if (flag == PRINT)
                                PrintAtEmpire (line);
                        return;
                }

                if (strlen (line) < 70)
                {
                        if (sscanf (line, "%d unit", & nr) == 1)
                                return;
                        else
                                continue;
                }

                if (!ScanDigit ((ConstVP)&ptri, &nr) ||
                                (land = NrToLand (nr)) == (Land) 0)
                {
                        PrintAtEmpire (
                                Fmt ("#%d Unknown unit ? (rescan unit !)",
                                nr));
                        PrintAtEmpire (Fmt ("Skipping line \"%s\"", line));
                        if (! deity)
                        {
                                Bell ();
                                (void) EmpireMore ();
                        }
                        else
                                PrintAtEmpire ("Unit Destroyed :-)");
                        continue;
                }

                SkipBlank ((ConstVP)&ptri);

                ptri = index (ptri, '%');

                if (ptri != (char *) 0) {
                        ptri++;
                        for (s = "sgpidbolhr"; *s; s++)
                        {
                                SkipBlank ((ConstVP)&ptri);
                                tmp = ptri;
                                if (!ScanDigit ((ConstVP)&tmp, &nr))
                                        break;

                                if (tmp - ptri > 4)
                                {
                                        savechar = *(tmp - 4);
                                        * (tmp - 4) = '\0';
                                        (void) ScanDigit ((ConstVP)&ptri, &nr);
                                        * (tmp - 4) = savechar;
                                } else
                                        (void) ScanDigit ((ConstVP)&ptri, &nr);

                                SetLandQuant (land, *s, nr);
                        }
                }

                if (ptri == (char *) 0 || *s != '\0')
                {
                        PrintAtEmpire ("Bad cargo format");
                        PrintAtEmpire (Fmt ("Skipping line \"%s\"", line));
                        Bell ();
                        (void) EmpireMore ();
                        continue;
                }
        }
}

void FeedRadarLands ()
{
	char buffer [BUFSIZ];
	register char *bptr;
	register Land sptr;
	register int num;

	bptr = buffer;
	num = 0;
	for (sptr = landlist; sptr != (Land) 0; sptr = ld_next (sptr))
	{
		if (!deity && ! ld_owned (sptr))
			continue;

		if (GiveLandQuant (sptr, 'R') <= 1)
			continue;

		sprintf (bptr, "%d", sptr-> nr);

		while (*bptr) bptr++;

		* bptr++ = '/';
		num ++;
	}

	if (!num)
		return;

	*--bptr = '\0';

	FScanRadar (buffer);
}

void FScanLandReso ()
{
	Sector sct;
	int oil, fert, x, y;
	char *ptr;

	oil = fert = -1;

	FeedEmpire ("v", PRINT);

	for (;;)
	{
		ptr = ReadEmpire (PRINT);

		if (EmpireStatus () != E_PRINTING)
		{
			PrintAtEmpire (ptr);
			return;
		}

		SkipBlank ((ConstVP)&ptr);
		if (strncmp (ptr, "[fert:", 6) == 0)
		{
			fert = atoi (ptr + 6);
			ptr = strchr (ptr, ']');
			ptr ++;
			SkipBlank ((ConstVP)&ptr);
		}

		if (strncmp (ptr, "[oil:", 5) == 0)
		{
			oil = atoi (ptr + 5);
			ptr = strchr (ptr, ']');
			ptr ++;
			SkipBlank ((ConstVP)&ptr);
		}

		if ((ptr = strchr (ptr, '@')) != (char *) 0)
			if (sscanf (++ptr, " %d, %d", &x, &y) ==  2)
			{
				sct = World (x, y, S_DESIG);

				if (fert != -1)
				{
					set_fer (sct, fert);
					SET_INFO_FER (sct);
				}

				if (oil != -1)
				{
					set_oil (sct, oil);
					SET_INFO_OIL (sct);
				}
			}
	}
}

void CheckMarkedLands ()
{
	Land sptr;

	for (sptr = landlist; sptr != (Land) 0; sptr = ld_next (sptr))
	{
		if (!deity && ! ld_owned (sptr))
			continue;

		if (ld_marked (sptr))
		{
			Error (Fmt ("Your %s @ %d,%d has sunk/lost !",
				LandName (sptr), ld_xcd (sptr), ld_ycd (sptr)));
			DeleteLand (sptr);
		}
	}
}

void SearchMarkedLands (flag)
int flag;
{
	char buffer [BUFSIZ];
	register char *bptr;
	register Land sptr;
	register int num;

	bptr = buffer;
	num = 0;
	for (sptr = landlist; sptr != (Land) 0; sptr = ld_next (sptr))
	{
		if (! ld_owned (sptr) || ! ld_marked (sptr))
			continue;

		sprintf (bptr, "%d", sptr-> nr);

		while (*bptr) bptr++;

		* bptr++ = '/';
		num ++;
	}

	if (!num)
		return;

	*--bptr = '\0';

	DumpLand (buffer, flag);
	CheckMarkedLands ();
}

void MarkLandsInSct (sct)
Sector sct;
{
	Land sptr;

	for (sptr = s_fland (sct); sptr != (Land) 0; sptr = ld_nxtsct (sptr))
		set_ld_marked (sptr, True);
}

void MarkLand (land)
Land land;
{
	set_ld_marked (land, True);
}

void MarkAllLands ()
{
	Land sptr;

	for (sptr = landlist; sptr != (Land) 0; sptr = ld_next (sptr))
		set_ld_marked (sptr, True);
}

void RedumpLand (land, flag)
Land land;
int flag;
{
	char *aland;

	MarkLand (land);
	aland = Fmt ("%d", ld_nr (land));

	DumpLand (aland, flag);
	CheckMarkedLands ();
}

void RedumpArmy (army, flag)
char army;
int flag;
{
	char *aarmy;
	Land sptr;

	for (sptr = landlist; sptr != (Land) 0; sptr = ld_next (sptr))
		if (ld_army (sptr) == army)
			MarkLand (sptr);

	aarmy = Fmt ("%c", army);

	DumpLand (aarmy, flag);
	SearchMarkedLands (flag);
}

void DumpSctLands (sct, flag)
Sector sct;
int flag;
{
	MarkLandsInSct (sct);
	(void) DumpLand (CrdStr (sct), flag);
	SearchMarkedLands (flag);
}

void DumpRealmLands (realm, flag)
char *realm;
int flag;
{
	int sx, sy, ex, ey;
	Land sptr;

	if (realm == (char *) 0)
		return;

	if (ConvRealmToCoord (realm, &sx, &ex, &sy, &ey))
		for (sptr = landlist; sptr != (Land) 0; sptr = ld_next (sptr))
			if (ld_xcd (sptr) >= sx && ld_xcd (sptr) <= ex &&
			    ld_ycd (sptr) >= sy && ld_ycd (sptr) <= ey)
				MarkLand (sptr);

	(void) DumpLand (realm, flag);
	SearchMarkedLands (flag);
}
