/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/data/RCS/help.c,v 5.2 1996/01/29 08:14:19 jpo Exp $
    $Date: 1996/01/29 08:14:19 $
    $Author: jpo $
    $Id: help.c,v 5.2 1996/01/29 08:14:19 jpo Exp $
    $Locker:  $
    $Log: help.c,v $
    Revision 5.2  1996/01/29 08:14:19  jpo
    Change display stuff

    Revision 5.1  1993/03/14 16:46:46  etienne
    *** empty log message ***

 * Revision 5.0  93/02/06  09:22:34  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:35:48  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"

static FILE * help_fp = (FILE *) 0;

void Help (x, y, str)
int x, y;
char * str;
{
	char buffer [BUFSIZ];
	Strings strings;
	char * help_file;

	if (help_fp == (FILE *) 0)
	{
		help_file = Fmt ("%s/.help", XEMPINFO);
		help_fp = fopen (help_file, "r");
		if (help_fp == (FILE *) 0)
		{
			Message (Fmt ("Can't open %s", help_file));
			Bell ();
			return;
		}
	}

	rewind (help_fp);

	for (;;)
	{
		if (fgets (buffer, BUFSIZ, help_fp) == (char *) 0)
		{
			Message (Fmt ("Help on '%s' not found", str));
			Bell ();
			return;
		}

		NoNl (buffer);

		if (strcmp (buffer, str) == 0)
		{
			strings = InitStrings ();

			for (;;)
			{
				if (fgets (buffer, BUFSIZ, help_fp) ==
								(char *) 0)
				{
					Message (Fmt ("No '.' found by %s",
							str));
					FreeStrings (strings);
					Bell ();
					return;
				}

				if (strcmp (buffer, ".\n") == 0)
				{
					ViewPagerStrings ("Help", strings,
							  map_win, x, y);
					FreeStrings (strings);
					return;
				}

				NoNl (buffer);
				AddString (strings, buffer);
			}
		}

			/* skip to '.' */

		do {
			if (fgets (buffer, BUFSIZ, help_fp) == (char *) 0)
			{
				Message ("corrupted help-file");
				Bell ();
				return;
			}
		}
		while (strcmp (buffer, ".\n") != 0);
	}
}
