/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/commands/RCS/shoot.c,v 5.1 1993/03/14 16:46:21 etienne Exp $
    $Date: 1993/03/14 16:46:21 $
    $Author: etienne $
    $Id: shoot.c,v 5.1 1993/03/14 16:46:21 etienne Exp $
    $Locker:  $
    $Log: shoot.c,v $
    Revision 5.1  1993/03/14 16:46:21  etienne

 * Revision 5.0  93/02/06  09:18:04  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:32:23  greyhelm
 * Client for ASCII /X Empire client
 * Added RCS header - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "sector.h"

static int last_num;
static char last_comm;

#define	DEF_SHOOT	'c'

void RedoShoot ()
{
	DoShoot (CrdStr (cursct), last_num, last_comm);
}

	/* ARGSUSED */
void BindShoot (x, y, str)
int x, y;
char *str;
{
	int nr;
	int number;
	char comm;
	char * ans;

	if (str == (char *) 0)
		SingleShoot ();
	else
	{
		nr = sscanf (str, " ( %d , %c ) ", & number, & comm);
		
		switch (nr)
		{

		case 0:
			SingleShoot ();
			return;

		case 1:
			ans = InputAtMessage (
				Fmt ("Shoot (c)ivs or (u)ws [%c]", DEF_SHOOT),
				1, "cu");

			if (ans == (char *) 0 || interrupt)
			{
				Message ("Shoot cancelled");
				interrupt = False;
				return;
			}

			DoShoot (CrdStr (cursct), number,
					* ans == '\0' ? DEF_SHOOT : * ans);
						
			return;

		case 2:
			if (comm != 'u' && comm != 'c')
			{
				Message ("Incorrect binding 'shoot (#, [uc])'");
				Bell ();
				return;
			}

			DoShoot (CrdStr (cursct), number, comm);
			return;
		}
	}
}

void DoShoot (realm, number, comm)
char * realm;
int number;
char comm;
{
	int x, y;
	char * ptr;
	Sector sct;
	int sx, sy, ex, ey;
	int i;
	int mcost;

	(void) ConvRealmToCoord (realm, & sx, & sy, & ex, & ey);
	if (number > max_civ_uw)
		number = max_civ_uw;

	SetAgain (RedoShoot);
	last_num = number;
	last_comm = comm;

	if (command_state == TEST_STATE || command_state == FORCE_BUF_STATE)
	{
		if (command_state == FORCE_BUF_STATE)
			FeedCommand (Fmt ("shoot %s %s %d", realm,
				comm == 'c' ? "civilians" : "uws",
				number), PRINT);

		for (y = sy; y <= ey; y ++)
			for (x = sx; x <= ex; x ++)
			{
				sct = World (x, y, S_EXIST);

				if (sct == (Sector) 0 || ! s_owned (sct))
					continue;
				
				if (s_civ (sct) > 10 * s_mil (sct))
				{
					Warning (Fmt (
					  "Not enough military control in %s",
					  CrdStr (sct)));
					continue;
				}

				i = (comm == 'c') ? s_civ (sct) : q_uw (sct);

				if (i <= 0)
					continue;
				
				if (i > number)
					i = number;
				
				mcost = (int) ((i + 4) / 5);
				if (mcost > s_mob (sct))
				{
					i = 5 * s_mob (sct);
					mcost = s_mob (sct);
				}

				if (i <= 0)
					continue;
				
				set_mob (sct, s_mob (sct) - mcost);

				if (comm == 'c')
				{
					set_civ (sct, s_civ (sct) - i);
					if (s_civ (sct) == 0 &&
							s_occ (sct) == '*')
					{
						Message (Fmt (
						   "%s is now completely yours",
							CrdStr (sct)));
						set_occ (sct, '.');
					}
				}
				else
					set_q_uw (sct, q_uw (sct) - i);
			}

		DrawMapPart (sx, sy, ex, ey);
		return;
	}

	FeedEmpire (Fmt ("shoot %s %s %d", realm,
		comm == 'c' ? "civilians" : "uws", number), PRINT);
	do {
		ptr = ReadEmpire (DONT_PRINT);
		PrintAtEmpire (ptr);
	}
	while (EmpireStatus () != E_COMMAND);

	(void) WaitForPrompt (PRINT);

	Message ("Rescanning dump");
	FScanDump (realm, DONT_PRINT);
	ClearMes ();
	DrawMapPart (sx, sy, ex, ey);
}

void MultiShoot (x, y)
int x, y;
{
	char * ans;

	ans = InputAtMessage ("Shoot civilians or unc. workers: ", 1, "cu");
	if (ans == (char *) 0 || interrupt || * ans == '\0')
	{
		interrupt = False;
		Message ("Shoot cancelled");
		return;
	}

	MultiCommand (x, y, Fmt ("Shoot how many %s",
						ItemName (CharToItem (* ans))),
			"shoot", max_civ_uw, DoShoot, * ans);
}

void SingleShoot ()
{
	char * ans;
	int number;

	ans = InputAtMessage ("Quant to shoot? ", 3, GS_PNUMBER);
	if (ans == (char *) 0 || interrupt || * ans == '\0')
	{
		interrupt = False;
		Message ("Shoot cancelled");
		return;
	}
	number = atoi (ans);

	ans = InputAtMessage (Fmt ("Shoot (c)ivs or (u)ws [%c]: ", DEF_SHOOT),
								1, "uc");
	if (ans == (char *) 0 || interrupt)
	{
		interrupt = False;
		Message ("Shoot cancelled");
		return;
	}
		
	DoShoot (CrdStr (cursct), number, * ans == '\0' ? DEF_SHOOT : * ans);
	DrawSector (cursct);
	Census ();
}
