/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/commands/RCS/move.c,v 5.3 1996/01/29 08:12:44 jpo Exp $
    $Date: 1996/01/29 08:12:44 $
    $Author: jpo $
    $Id: move.c,v 5.3 1996/01/29 08:12:44 jpo Exp $
    $Locker:  $
    $Log: move.c,v $
    Revision 5.3  1996/01/29 08:12:44  jpo
    New menu stuff
    minor fixes

    Revision 5.2  1995/09/08 07:09:19  jpo
    prototypes
    allow exploring when it empties the sector

 * Revision 5.1  93/03/14  16:46:11  etienne
 * 
 * 
 * Revision 5.0  93/02/06  09:18:04  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:32:23  greyhelm
 * Client for ASCII /X Empire client
 * Added RCS header - Karl Hagen
 *

*/
#include <math.h>
#include "type.h"
#include "main.h"
#include "sector.h"
#include "var.h"
#include "nation.h"
#include "nuke.h"

#define	MAXSTOPS	20

extern WinInfo	map_win;

static int last_quant;
static char last_comm;
static int last_x, last_y;

static int last_explore_quant = 0;
static char last_explore_item = '\0';

void BindMove (x, y, str)	/* move (com, quant) */
int x, y;
char * str;
{
	char com [20];
	int quant;

	if (str == (char *) 0)
		DoMove (x, y, '\0', 0, (char *) 0);
	else
		switch (sscanf (str, " ( %[^,], %d )", com, & quant))
		{

		case 0:
			DoMove (x, y, '\0', 0, (char *) 0);
			return;
		
		case 1:
			if (CharToItem (* com) < 0)
			{
				Message ("Illegal bind: 'move (comm, #)'");
				Bell ();
				return;
			}

			DoMove (x, y, * com, 0, (char *) 0);
			return;
		
		case 2:
			if (CharToItem (* com) < 0 || quant <= 0)
			{
				Message ("Illegal bind: 'move (comm, #)'");
				Bell ();
				return;
			}

			DoMove (x, y, * com, quant, (char *) 0);
			return;
		}
}

	/*
	 *	RedoMove only redoes real moves, not transport
	 */

void RedoMove ()
{
    DoMove (s_xcd(cursct), s_ycd(cursct), last_comm, last_quant,
	    (char *) 0);
}

	/*
	 *	In case of moving planes, comm = 'P', quant = weight &
	 *	planeid is a strings like "a" or "152/67".
	 *
	 *	Sanity checks must be done before calling DoMove
	 */

void Move (x, y)
int x, y;
{
	DoMove (x, y, '\0', 0, (char *) 0);
}

void DoMove (x, y, comm, quant, planeid)
int x, y;
char comm;
int quant;
char * planeid;
{
	double mmult;
	double newmob;
	Sector stop [MAXSTOPS], nextsct;
	Sector sct;
	Stockp stockp;
	int mcost [MAXSTOPS];
	char *mpath [MAXSTOPS];
	char *path, *ptr;
	int nrstops;		/* number of stops */
	int i;
	int button;
	bool cont, nofuther;
	char itemchar;
	const char *itemname = NULL;
	int item = 0;
	int available;
	int packing;
	int fail, ny, nx;

	if (! s_owned (cursct))
	{
		Message ("This sector ain't yours !");
		Bell ();
		return;
	}

	Message ("Current command: move");

	sct = cursct;

	if (comm != 'P' && comm != 'N')	/* no planes and nukes */
	{
		if (comm == '\0')
			item = SelectAvaItem (x + 4, y + 4, sct, "Move what ?");
		else
			item = CharToItem (comm);

		if (item <= 0)
		{
			Message ("Nothing moved");
			return;
		}

		itemchar = ItemChar (item);
		itemname = ItemName (item);
		SetAgain (RedoMove);
		last_quant = 0;
		last_comm = itemchar;
		last_x = x;
		last_y = y;

		if ((itemchar == 'c') && (s_occ (sct) == '*'))
		{
			Message ("You can't move conquered populace");
			Bell ();
			return;
		}

		if ((itemchar != 'm') && (s_occ (sct) == '*') &&
					(s_mil (sct) * 10) < s_civ (sct))
		{
	Message ("Military control required to move goods (#mil > #civ * 10)");
			Bell ();
			return;
		}

		available = GiveQuant (sct, itemchar);

		if (available == 0)
		{
			Message (Fmt ("There is no (more) %s in this sector",
							itemname));
			Bell ();
			return;
		}

		if (itemchar == 'c' || itemchar == 'm')
			if ((itemchar == 'm' ? s_civ (sct) : s_mil (sct)) == 0)
				available--;

		if (available == 0)
		{
			Message ("Would leave sector unpopulated !!");
			Bell ();
			return;
		}

		if (quant <= 0)
		{
			if (available > 1)
			{
				ptr = InputAtMessage (Fmt (
					"Move how many %s [%d]:",
					itemname, available), 4, GS_PNUMBER);

				if (interrupt || ptr == (char *) 0)
				{
					interrupt = False;
					Message ("Changed your mind ??");
					return;
				}
				else if (* ptr == '\0')
				  	quant = available;
				else
					quant = atoi (ptr);

				if (quant == 0)
				{
					Message ("Changed your mind ??");
					return;
				}
			}
			else
				quant = 1;
		}


		if (quant > available)
		{
			quant = available;
			Error (Fmt (
				"Warning: only moving %d %s", quant, itemname));
			if (interrupt)
				return;
		}

		last_quant = quant;
		SetAgain (RedoMove);

		Message (Fmt ("Moving %d %s out of %s; mobility %d",
				quant, itemname, CrdStr (sct), s_mob (sct)));


		if ((itemchar == 'c') && (s_wor (sct) < 100))
			Error ("Warning: Civilians unrest");

/* mta Mon Dec  3 17:17:21 EET 1990 */
		if ( IsPlague( sct ))
		        Error ("Warning: Plague in sector");


	}
	else
	{
		itemchar = comm;
		if (quant <= 0)
		{
			if (itemchar == 'P')
			{
				Message (Fmt ("This must be very light planes !"));
				Bell ();
				return;
			}
			else
			{
				int max;

				max = sp_nukamt(curnuke,curnuketype);
				if (max > 1)
				{
					ptr = InputAtMessage (Fmt ("Transport how many %s nukes [%d/1]: ",
						nt_name(curnuketype), max), 4, GS_PNUMBER);

					if (interrupt || ptr == (char *) 0)
					{
						interrupt = False;
						Message ("Transport cancelled");
						return;
					}
					if (* ptr == '\0')
						quant = 1;
					else
						quant = atoi (ptr);

					if (quant == 0) {
						interrupt = False;
						Message ("Transport cancelled");
						return;
					}
					if (quant > max)
						quant = max;
				}
				else
				{
					quant = max;
				}
			}
		}

		Message (Fmt ("Moving %s out of %s; mobility %d",
			itemchar == 'P' ? "plane(s)" : "nuke(s)",
			CrdStr (sct), s_mob (sct)));
	}


	MesBut ("View", "Cancel last Set", "Set");
	stop [0] = sct;
	nrstops = 0;
	cont = True;
	nofuther = False;

	while (cont)
	{
		nextsct = SelectSector (& button);

		if (interrupt)
		{
			interrupt = False;
			Message ("Move cancelled");
			/* remove paths */

			for (i = 0; i < nrstops; i++)
			{
				UnmarkPath (stop [i], mpath [i]);
				free (mpath [i]);
			}

			MesClearBut ();
			return;
		}

		if (button == MIDDLE_BUTTON)
		{
			if (nrstops == 0)
			{
				MesClearBut ();
				Message ("Move cancelled");
				return;
			}

			-- nrstops;
			UnmarkPath (stop [nrstops], mpath [nrstops]);
			free (mpath [nrstops]);
			nofuther = False;

			if (nrstops != 0)
		Message (Fmt ("Used %d mob from %d; mobilty now %d",
					mcost [nrstops - 1],
					s_mob (stop [nrstops - 1]),
					s_mob (stop [nrstops])));
			else
				if (itemchar == 'P')
		Message (Fmt ("Moving planes from %s, mobility %d",
					CrdStr (sct), s_mob (sct)));
				else if (itemchar == 'N')
		Message (Fmt ("Moving nukes from %s, mobility %d",
					CrdStr (sct), s_mob (sct)));
				else
		Message (Fmt ("Moving %d %s from %s; mobility %d",
					quant, itemname,
					CrdStr (sct), s_mob (sct)));
			continue;
		}

		if (nextsct == (Sector) 0 || NO_INFO (nextsct))
			continue;


		if (button == LEFT_BUTTON)
		{
			CensusSct (nextsct);
			continue;
		}

		if (! s_owned (nextsct))
		{
			Bell ();
			Message ("You can't go there, it ain't yours !");
			continue;
		}

		if ((itemchar == 'c') && (s_occ (nextsct) == '*'))
		{
			Message ("Your civilians refuse to go there");
			Bell ();
			continue;
		}

		if (itemchar != 'P' && itemchar != 'N' &&
		    s_civ (nextsct) + 10 < quant/50)
		{
Message (Fmt ("Too little workers in this sector, try moving less (max %d)",
						(s_civ (nextsct) + 10) * 50));
			Bell ();
			continue;
		}

		CensusSct (nextsct);

		if (stop [nrstops] != nextsct)
		{

			if (nofuther)
			{
				Error ("You can't move out of this sector");
				continue;
			}

			Message ("Searching");
			path = BestLandPath (stop [nrstops], nextsct);

			if (path == (char *) 0)
			{
				Bell ();
				Message ("To far away/Not connected");
				continue;
			}

			if (itemchar != 'P' && itemchar != 'N')
			{
				if (s_eff (stop[nrstops]) < 60)
					packing = NPKG;
				else
					packing = SectorPacking (s_des
							    (stop [nrstops]));

				mmult = ((double) quant) *
						ItemWeight (item, packing);
			}
			else
				mmult = (double) quant;


			mcost [nrstops] = (int) (mmult *
				RealPathCost (stop [nrstops], path));

			if (mcost [nrstops] > (s_mob (stop [nrstops])))
			{
				Bell ();
		Message (Fmt ("Not enough mobility (has %d, need %d)",
					s_mob (stop [nrstops]),
					mcost [nrstops]));
				continue;
			}

			if (command_state == FORCE_BUF_STATE &&
				EmpireStatus () == E_DEAD &&
				mcost [nrstops] > 0.00 &&
				mcost [nrstops] == (s_mob (stop [nrstops])))
			{
				Bell ();
Warning (Fmt ("Buffered Move: might not have enough mobility (%d)",
						mcost [nrstops]));
				Pause ();
			}

			mpath [nrstops] = Str (path);
			MarkPath (stop [nrstops], mpath [nrstops]);

			Message (
			    Fmt ("Used %d mob (out of %d); cur mobilty %d",
				mcost [nrstops],
				s_mob (stop [nrstops]),
				s_mob (nextsct)));

			stop [++ nrstops] = nextsct;

			if ((itemchar == 'c') && (s_wor (stop [nrstops]) < 100))
				Error ("Warning: Civilians unrest");

			if ((itemchar != 'P' && itemchar != 'm') &&
				(s_occ (nextsct) == '*') &&
				(s_mil (nextsct) * 10) < s_civ (nextsct))
			{
Error ("Warning : Not enough mils to move the goods out of this sector");

				nofuther = True;
			}

			if (itemchar != 'P' && itemchar != 'N' &&
			    s_civ (nextsct) + 10 < quant/50)
			{
Error ("Warning : Too much traffic to move the goods out of this sector");
				nofuther = True;
			}
				
		}
		else
			cont = False;
	} 

	if (nrstops == 0)
	{
		Message ("Nothing moved");
		MesClearBut ();
		return;
	}

	Message (Fmt ("Ended at %d,%d, used %d mob (out of %d)",
			s_xcd (stop [nrstops]),
			s_ycd (stop [nrstops]),
			mcost [nrstops - 1],
			s_mob (stop [nrstops - 1])));

	/* Let's move */

	fail = 0;
	nx = s_xcd (stop [0]);
	ny = s_ycd (stop [0]);
	for (i = 0; i < nrstops; i ++)
	{
		if (command_state == FORCE_BUF_STATE &&
						EmpireStatus () == E_DEAD)
		{
			if (itemchar == 'P')
				FeedCommand (Fmt ("transport plane %s %sh",
					planeid, mpath [i]), PRINT);
			else if (itemchar == 'N') {
				FScanNukes (CrdStr(stop[i]), DONT_PRINT);
				stockp = s_stock(stop[i]);
				FeedCommand (Fmt ("transport nuke %d \"%s\" %d %sh",
					sp_nr(stockp), nt_name(curnuketype),
					quant, mpath [i]), PRINT);
				add_nuk(stop[i],-quant);
				if (s_nuk(stop[i]) == 0)
					set_stock(stop[i], 0);
				sp_nukamt(stockp,curnuketype) -= quant;
			}
			else
				FeedCommand (Fmt ("move %c %d,%d %d %sh",
					itemchar,
					s_xcd (stop [i]),
					s_ycd (stop [i]),
					quant,
					mpath [i]),
				     PRINT);

			set_mob (stop [i],
				(int) (s_mob (stop [i]) - mcost [i] - 0.99));

			nx = s_xcd (stop [i + 1]);
			ny = s_ycd (stop [i + 1]);
			UnmarkPath (stop [i], mpath [i]);
			free (mpath [i]);
			continue;
		}
			
		if (itemchar == 'P')
			FeedEmpire (Fmt ("transport plane %s %s",
				planeid, mpath [i]), PRINT);
		else if (itemchar == 'N') {
			FScanNukes (CrdStr(stop[i]), DONT_PRINT);
			stockp = s_stock(stop[i]);
			FeedEmpire (Fmt ("transport nuke %d \"%s\" %d %s",
				sp_nr(stockp), nt_name(curnuketype),
				quant, mpath [i]), PRINT);
			add_nuk(stop[i],-quant);
			if (s_nuk(stop[i]) == 0)
				set_stock(stop[i], 0);
			sp_nukamt(stockp,curnuketype) -= quant;
		}
		else
			FeedEmpire (Fmt ("move %c %d,%d %d %s",
				itemchar,
				s_xcd (stop [i]),
				s_ycd (stop [i]),
				quant,
				mpath [i]),
			     PRINT);

		ptr = WaitForPrompt (PRINT);

		/* fail :
		 *	1 or 2 means total move failed stranded where
		 *	started (== stop[i]);
		 *	3 move failed partly stranded somewhere inbetween
		 *	stop[i] and stop[i + 1]
		 *
		 *	nx and ny are set to the sector where the move
		 *	ended
		 */

		if (EmpireStatus () == E_COMMAND)
			fail = 1;
		else if (sscanf (ptr, "<%lf: %*c %d,%d", &newmob,
							&nx, &ny) != 3)
			fail = 2;
		else 
		{
			if (nx != s_xcd (stop [i + 1]) &&
			    ny != s_ycd (stop [i + 1]))
			{
				 fail = 3;
			}

			set_mob (stop [i], (int) (newmob + 0.5));
		}

		if (fail > 0)
		{
			int j;

			if (EmpireStatus () != E_COMMAND)
			{
				FeedEmpire ("aborted", PRINT);
				(void) WaitForPrompt (PRINT);
			}

			if (fail < 3)
			{
				/* total move failed set end coordinates of
				 * move to current sector
				 */
				nx = s_xcd (stop [i]);
				ny = s_ycd (stop [i]);
			}

			if (nx == s_xcd (stop [0]) && ny == s_ycd (stop [0]))
				Error ("Warning Move Failed, nothing moved");
			else
				Error (Fmt (
					"Warning Move Failed stranded at %d,%d",
					nx, ny));

			for (j = i; j < nrstops; j ++)
			{
				UnmarkPath (stop [j], mpath [j]);
				free (mpath [j]);
			}
			break;
		}

		FeedEmpire ("h", PRINT);
		(void) WaitForPrompt (PRINT);

		UnmarkPath (stop [i], mpath [i]);
		free (mpath [i]);
	}

	MesClearBut ();

	if (nx == s_xcd (stop [0]) && ny == s_ycd (stop [0]))
		/* nothing moved !! */
		return;

	if (itemchar == 'P')
	{
		UnmarkAllPlanes ();
		MarkPlanes (planeid);
		MoveMarkedPlanesTo (World (nx, ny, S_DESIG));
		return;
	}


	if (itemchar != 'N')
	{
		/* adjust quantities */

		SetQuant (stop [0], itemchar,
			GiveQuant (stop [0], itemchar) - quant);

		DrawSector (stop [0]);

		SetQuant (World (nx, ny, S_DESIG), itemchar,
			GiveQuant (World (nx, ny, S_DESIG), itemchar) + quant);

		DrawSector (World (nx, ny, S_DESIG));
		CensusSct (cursct);
	}
}

bool ParseExploreInfo (sct)
Sector sct;
{
	char *ptr;
	int start;
	int x, y;

	int min, gol, ura, oil, fer;

	x = s_xcd (sct);
	y = s_ycd (sct);

	do
	{
		ptr = ReadEmpire (PRINT);
	}
	while (StrEQ (ptr, "Warning") || (StrEQ(ptr, "Usage:")));
		
	start = 0;
	while (ptr [start] == ' ')
		start ++;

	if (StrEQ (ptr, "Usage:")) {
	    Message ("Explore failed");
	    Bell();
	    return False;
	}

	if (StrEQ (ptr, "You can't go there")) {
		Message ("You can't go there");
		Bell ();
		return False;
	}

	if (StrEQ (ptr, "Not enough mobility")) {
		Message ("Not enough mobility");
		Bell ();
		return False;
	}

	(void) UpdateSectorDes (World (x - 1, y - 1, S_DESIG),
					ptr [start], True);
	(void) UpdateSectorDes (World (x + 1, y - 1, S_DESIG),
					ptr [start + 2], True);

	ptr = ReadEmpire (PRINT);
	if (ptr == (char *) 0)
		return False;

	start = 0;
	while (ptr [start] == ' ')
		start ++;

	(void) UpdateSectorDes (World (x - 2, y, S_DESIG), ptr [start], True);

	(void) UpdateSectorDes (World (x + 2, y, S_DESIG), ptr [start + 4],
				True);

	if (sscanf (ptr + start + 6, " %d %d %d %d %d",
				& min, & gol, & fer, & oil, & ura) == 5)
	{
		if (! KNOW_RES (sct))	/* allocate next part of sector */
			sct = World (s_xcd (sct), s_ycd (sct), S_RESOU);

		set_min (sct, min);
		set_gol (sct, gol);
		set_fer (sct, fer);
		set_oil (sct, oil);
		set_ura (sct, ura);
		if (! KNOW_ALL (sct) && ! KNOW_SPY (sct) && ! KNOW_LOO (sct))
			set_owner (sct, 0);

		SET_INFO_RES (sct);
	}


	ptr = ReadEmpire (PRINT);

	start = 0;
	while (ptr [start] == ' ')
		start ++;

	(void) UpdateSectorDes (World (x - 1, y + 1, S_DESIG), ptr [start],
			True);
	(void) UpdateSectorDes (World (x + 1, y + 1, S_DESIG), ptr [start + 2],
			True);

	return True;
}

static const char *expl_str [] =
{
	"civilians",
	"military",
	(char *) 0
};

#define	MAX_ENTRIES	200

void DoExplore (x, y, itemchar, quant)
int x, y;
char itemchar;
int quant;
{
	Sector scts [MAX_ENTRIES];
	Sector from, nxt, lastsct;
	const char * itemname;
	int item;
	int max;
	int button;
	int nr, i;
	bool dontadjust;
	Strings strings;
	char * ptr;

	from = cursct;

	if (itemchar == '\0')
	{
		if (s_civ (cursct) == 0 && s_mil (cursct)== 0)
			return;
		else if (s_civ (cursct) == 0)
			itemchar = 'm';
		else if (s_mil (cursct) == 0)
			itemchar = 'c';
		else {
			int r;

			strings = InitStrings ();
			AddStringsID (strings, expl_str, 2, 0);
			r = ChooseMenu (strings, "Explode with ?", map_win,
					x, y, NULL);
			FreeStrings (strings);

			if (r < 0)
			{
				Message ("No one wants to explore");
				return;
			}

			itemchar = (r == 0) ? 'c' : 'm';
		}
	}
	else
	{
		switch (itemchar)
		{

		case 'c':
			if (s_civ (cursct) == 0)
			{
				Message ("No (more) civilians in this sector");
				Bell ();
				return;
			}
			break;
		
		case 'm':
			if (s_mil (cursct) == 0)
			{
				Message ("No (more) militairs in this sector");
				Bell ();
				return;
			}
			break;
		
		default:
			Message ("You can only explore with civs or mils!");
			Bell ();
			return;
		}
	}

	max = (itemchar == 'c') ? s_civ (cursct) : s_mil (cursct);
	item = CharToItem (itemchar);
	itemname = ItemName (item);

	if (itemchar == 'c' && s_occ (cursct) == '*')
	{
		Message ("You can't explore with conquered civilians");
		Bell ();
		return;
	}

	if ((itemchar == 'c') && (s_wor (cursct) < 100))
	{
		Error ("Warning: Civilian unrest");
		if (interrupt)
			return;
	}
	if (quant <= 0 && max == 1)
	    quant = 1;
	else if (max > 1 && quant <= 0)
	{
		ptr = InputAtMessage (Fmt ("Explore with how many %s [%d/1]: ",
			itemname, max), 4, GS_PNUMBER);

		if (interrupt || ptr == (char *) 0)
		{
			interrupt = False;
			Message ("Explore cancelled");
			return;
		}
		if (* ptr == '\0')
			quant = 1;
		else
			quant = atoi (ptr);
		if (quant == 0) {
			interrupt = False;
			Message ("Explore cancelled");
			return;
		}
		if (quant > max)
			quant = max;
	}
	else
	{
		if ((itemchar == 'm' && s_mil (cursct) < quant) ||
		    (itemchar == 'c' && s_civ (cursct) < quant))
		{
			Message ("Not enough (left) to explore");
			Bell ();
			return;
		}
	}

	if (((itemchar == 'm' ? s_civ (cursct) : s_mil (cursct)) == 0) &&
	    (quant == max)) {
	    Warning ( "Will depopulate sector !!" );
	}

	Message (Fmt ("Exploring with %d %s", quant, itemname));

	SetAgain (RedoExplore);
	last_explore_item = itemchar;
	last_explore_quant = quant;

	FeedEmpire (Fmt ("explore %c %s %d", itemchar, CrdStr (cursct), quant),
				PRINT);

	MesBut ("View", "End", "Explore");

	nr = 0;
	(void) ParseExploreInfo (cursct);
	(void) WaitForPrompt (PRINT);

	dontadjust = False;
	lastsct = cursct;
	for (;;)
	{
		nxt = SelectSector (& button);

		if (button == MIDDLE_BUTTON)
			nxt = lastsct;

		if (nxt == (Sector) 0 || NO_INFO (nxt))
			continue;

		if (button == LEFT_BUTTON)
		{
			CensusSct (nxt);
			continue;
		}

		if (nxt == lastsct)
		{
							/* end of explore */
			if ((itemchar == 'c') && KNOW_ALL (nxt) && 
						(s_occ (nxt) == '*'))
			{
				Message ("Your civilians refuse to stay here");
				Bell ();
				if (button != MIDDLE_BUTTON)
					continue;
				else
					dontadjust = True;
			}

			FeedEmpire ("h", PRINT);
			(void) WaitForPrompt (PRINT);

			for (i = 0; i < nr; i++)
				UnmarkSector (scts [i]);
			
			/* adjust quant */

			if (! dontadjust)
			{
				SetQuant (from, itemchar,
					GiveQuant (from, itemchar) - quant);

				RedumpSector (lastsct, PRINT);
				if (FScanDump (CrdStr (from), PRINT) == 0)
				{
				    set_owner (from, UNKNOWN_CNUM);
				    DEL_INFO (from);
				    SET_INFO_RES (from);
				}
			}

			Message ("End of explore");
			MesClearBut ();

			return;
		}

		if (! Adjacent (nxt, lastsct))
		{
			Bell ();
			continue;
		}
		
		if (nr >= MAX_ENTRIES)
		{
			Error ("Path becomes too long");
			continue;
		}

		if (s_des (nxt) == '.' || s_des (nxt) == 's' ||
		    s_des (nxt) == '\\')
		{
			Message ("Impossible to explore that, Sir !");
			Bell ();
			continue;
		}

		FeedEmpire (Fmt ("%c", GiveDirChar (lastsct, nxt)),
							PRINT);

		nxt = World (s_xcd (nxt), s_ycd (nxt), S_RESOU);

		if (ParseExploreInfo (nxt))
		{
			scts [nr ++] = nxt;
			CensusSct (nxt);
			MarkSector (nxt);
			DrawNeighbours (nxt);
			lastsct = nxt;
		}

		ptr = WaitForPrompt (PRINT);
		set_mob (from, (int) (atof (ptr + 1) +.5));
	}
}

void Explore (x, y)
int x, y;
{
	DoExplore (x, y, '\0', -1);
}

typedef struct n_nlist *NList;
static Sector ngoal;

struct n_nlist
{
	Sector sct;
	int dist;
	NList next;
};

static NList open_list;		/* all the open sectors	*/
static NList closed_list;	/* all the closed sectors */

static void FreeNlists ()
{
	NList ptr, tofree;

	for (ptr = open_list; ptr != (NList) 0; )
	{
		tofree = ptr;
		ptr = ptr-> next;
		free ((char *) tofree);
	}

	for (ptr = closed_list; ptr != (NList) 0; )
	{
		tofree = ptr;
		ptr = ptr-> next;
		free ((char *) tofree);
	}

	open_list = (NList) 0;
	closed_list = (NList) 0;
}

static NList NextFromOList ()
{
	NList onext;

	onext = open_list;
	if (open_list != (NList) 0)
	{
		open_list = open_list-> next;
		onext-> next = closed_list;
		closed_list = onext;
	}
	
	return onext;
}

static void AddToOList (sct)
Sector sct;
{
	NList ptr, prv;
	NList new;

				
	for (ptr = closed_list; ptr != (NList) 0; ptr = ptr-> next)
		if (ptr-> sct == sct)
			return;

		/* Make new structure */

	new = (NList) doalloc ((unsigned) sizeof (struct n_nlist));
	new-> sct = sct;
	new-> dist = Distance (sct, ngoal);

	prv = (NList) 0;
	for (ptr = open_list; ptr != (NList) 0; ptr = ptr-> next)
	{
		if (ptr-> sct == sct)
		{
			free ((char *) new);
			return;
		}
		if (ptr-> dist > new-> dist)
		{
			if (prv == (NList) 0)
			{
				new-> next = ptr;
				open_list = new;
				return;
			}
			else
			{
				prv-> next = new;
				new-> next = ptr;
				return;
			}
		}
		prv = ptr;
	}

	if (prv == (NList) 0) 
		open_list = new;
	else
		prv-> next = new;

	new-> next = (NList) 0;
}

static void AddNeighboursToOlist (sct)
Sector sct;
{
	Sector next;
	Neighb neighb;

	InitNeighbours (sct, & neighb);
	while (NextNeighbour (&next, S_DESIG, neighb))
	{
		if (next == (Sector) 0 || NO_INFO (next))
			continue;

		if (s_des (next) == '.' || s_des (next) == 's' ||
					s_des (next) == '\\')
			continue;

		AddToOList (next);
	}
}

static void InitOList (from)
Sector from;
{
	ngoal = from;
	open_list = (NList) 0;
	closed_list = (NList) 0;
	AddToOList (from);
	(void) NextFromOList ();
	AddNeighboursToOlist (from);
}

static void RedumpExploreCircle (from, dist)
Sector from;
int dist;
{
	int sx, sy, ex, ey;
	int x, y;
	char *ptr;
	Sector sct;

	sx = s_xcd (from) - 2 * dist;
	sy = s_ycd (from) - dist;
	ex = s_xcd (from) + 2 * dist;
	ey = s_ycd (from) + dist;

	ptr = Fmt ("%d:%d,%d:%d", sx, ex, sy, ey);

	(void) FScanDump (Fmt ("%s ?des=-", ptr), PRINT);
	(void) FScanDump (CrdStr (from), PRINT);
	FeedEmpire (Fmt ("des %s ?des=- +", ptr), PRINT);
	(void) WaitForPrompt (PRINT);

	for (x = sx; x <= ex; x++)
		for (y = sy; y <= ey; y++)
		{
			sct = World (x, y, S_EXIST);
			if (sct == (Sector) 0)
				continue;
			if (s_des (sct) == '-' && KNOW_ALL (sct))
			{
				set_des (sct, '+');
				if (s_eff (sct) == 0)
					set_nds (sct, '+');
			}
		}

	DrawMapPart (sx, sy, ex, ey);
}

#ifdef TERMC_VERSION

#define		UTIL_WIND_WIDTH		((screen_cols - 10 > 80) ? 80 \
						: (screen_cols - 10))

#else /* X_VERSION */

#define		UTIL_WIND_WIDTH		80

#endif /* VERSION */

void ExploreUtil ()
{
	WinInfo win;
	char * ptr, * ans;
	int x, y;
	int line;
	int lastdist;
	int max_mob, max_cm;
	bool changed;
	Sector from, sct;
	char explore_with;
	int explore_item;

	RaiseWindow (map_win);

	win = OpenRelToRoot (empire_win, 3, 0, UTIL_WIND_WIDTH, 10, CHARS, 0);

	line = 1;
	PrintB (win, 1, line, "-=[ Explore Utility ]=-");

	line += 2;

	if (s_owned (cursct))
		ptr = Fmt ("Explore from sector [%d,%d]: ",
				s_xcd (cursct), s_ycd (cursct));
	else
		ptr = "Explore from sector: ";

	ans = GetQuest (win, line ++, ptr, 10, GS_SECTOR);
			
	if (ans == (char *) 0 || interrupt)
	{
		interrupt = False;
		DestroyWindow (win);
		LowerWindow (map_win);
		return;
	}

	if (* ans == '\0')
		from = cursct;
	else
	{
		if (sscanf (ans, "%d, %d", & x, & y) != 2)
		{
			Message ("Incorrect sector fmt");
			DestroyWindow (win);
			LowerWindow (map_win);
			return;
		}

		from = World (x, y, S_EXIST);

	}

	if (from == (Sector) 0 || ! s_owned (from))
	{
		Message ("You don't own that sector !");
		Bell ();
		DestroyWindow (win);
		LowerWindow (map_win);
		return;
	}

	if (s_mob (from) <= 0)
	{
		Message ("Sector has no mobility left !");
		Bell ();
		DestroyWindow (win);
		LowerWindow (map_win);
		return;
	}

	if (s_civ (from) > 0 && s_mil (from) > 0)
	{
		ans = GetQuest (win, line ++,
			"Explore with civilians or militairs [c]: ", 1, "cm");
		
		if (ans == (char *) 0 || interrupt)
		{
			interrupt = False;
			DestroyWindow (win);
			LowerWindow (map_win);
			return;
		}

		if (* ans == '\0')
			explore_with = 'c';
		else
			explore_with = * ans;
	}
	else if (s_civ (from) == 0)
		explore_with = 'm';
	else
		explore_with = 'c';

	if (explore_with == 'c' && s_occ (from) == '*')
	{
		Message ("You can't explore with conquered populace");
		Bell ();
		DestroyWindow (win);
		LowerWindow (map_win);
		return;
	}

	if (s_wor (from) < 100)
	{
		if (! Confirm ("Warning: Civilians unrest, Continue", False))
		{
			Bell ();
			DestroyWindow (win);
			LowerWindow (map_win);
			return;
		}
	}

	explore_item = CharToItem (explore_with);

	if (s_mob (from) > 1)
	{
		ans = GetQuest (win, line ++, Fmt ("Use max mobility [%d]: ",
				s_mob (from)), 33, GS_PNUMBER);

		if (ans == (char *) 0 || interrupt)
		{
			interrupt = False;
			DestroyWindow (win);
			LowerWindow (map_win);
			return;
		}

		if (* ans == '\0')
		{
			max_mob = s_mob (from);
		}
		else
		{
			max_mob = atoi (ans);

			if (max_mob > s_mob (from))
			{
				Message (Fmt ("Only %d mobility to use",
					s_mob (from)));
				Bell ();
				max_mob = s_mob (from);
			}
		}
	}
	else
		max_mob = 1;
	
	max_cm = (explore_with == 'c') ? s_civ (from) : s_mil (from);
	if ((explore_with == 'm' ? s_civ (from) : s_mil (from)) == 0)
		max_cm--;

	if (max_cm <= 0)
	{
		Message ("Would leave sector unpopulated !!");
		Bell ();
		return;
	}

	if (max_cm > 1)
	{
		ans = GetQuest (win, line ++,
			Fmt ("Max number of %s to explore with [%d]: ",
			ItemName (explore_item),
			max_cm), 3, GS_PNUMBER);

		if (ans == (char *) 0 || interrupt)
		{
			interrupt = False;
			DestroyWindow (win);
			LowerWindow (map_win);
			return;
		}

		if (* ans != '\0')
			if (atoi (ans) <= max_cm)
				max_cm = atoi (ans);
	}
	
	ClearWindow (win);

	line = 0;
	PrintB (win, 1, line, "-=[ Explore Utility ]=-");

	line += 2;

	PrintN (win, 1, line ++,
		Fmt ("Exploring from sector %d,%d with max %d %s,",
			s_xcd (from), s_ycd (from), max_cm,
			ItemName (explore_item)));
	
	PrintN (win, 1, line ++,
		Fmt ("using at most %d mobility.", max_mob));

	ans = GetQuest (win, ++ line, "Continue [y]: ", 1, "yn");
	if (ans == (char *) 0 || interrupt || * ans == 'n')
	{
		interrupt = False;
		DestroyWindow (win);
		LowerWindow (map_win);
		return;
	}

	DoExploreUtil (win, from, max_mob, max_cm, explore_with,
			explore_item);
}

static void ExploreMessage (win, x, y, str)
WinInfo win;
int x, y;
char * str;
{
	static int lasty = -1;
	static int lastx = -1;

	if (win != (WinInfo) 0)
		PrintN (win, x, y, str);
	else
	{
		if (lasty == y && x > last_x)
			printf ("\n%s", str);
		else
			printf ("%s", str);
		lasty = y;
		lastx = x;
	}
}

void FlushExplore (win)
WinInfo win;
{
	if (win != (WinInfo) 0)
		FlushWindow (win);
}

void DoExploreUtil (win, from, max_mob, max_cm, explore_with, explore_item)
WinInfo win;
Sector from;
int max_mob, max_cm;
char explore_with;
int explore_item;
{
	int lastdist, old_mod;
	int old_mob;
	bool changed;
	NList next;
	int cost, total_cost, total_cm;
	char * path, * ptr;
	Sector sct;

	total_cm = 0;
	total_cost = 0;
	lastdist = 1;
	old_mob = s_mob (from);

	changed = False;
	if (win != (WinInfo) 0)
		ClearWindow (win);
	InitOList (from);
	for (;;)
	{
		next = NextFromOList ();
		if (next == (NList) 0)
		{
			ExploreMessage (win, 1, 6,
					"No more sectors to explore");
			FlushExplore (win);
			Bell ();
			Pause ();
			break;
		}
		if (next-> dist > lastdist)
		{
			if (changed)
			{
				RedumpExploreCircle (from, lastdist);
				total_cost = old_mob - s_mob (from);
				changed = False;
			}

			lastdist = next-> dist;
		}

		sct = next-> sct;
		ExploreMessage (win, 1, 1,
				Fmt ("Sector: %s (dist %d)   ", CrdStr (sct),
					next-> dist));

		ExploreMessage (win, 1, 2, Fmt ("mob's used: %4d", total_cost));

		ExploreMessage (win, 1, 3, Fmt ("%s used: %d  ",
				ItemName (explore_item), total_cm));

		ExploreMessage (win, 1, 5, "Exploring     ");
		FlushExplore (win);

		if (s_owned (sct))
		{
			ExploreMessage (win, 1, 5, "Already owned ");
			FlushExplore (win);
			AddNeighboursToOlist (sct);
			continue;
		}

		if (s_des (sct) != '-')
		{
			ExploreMessage (win, 1, 5, "Not wilderness");
			FlushExplore (win);
			continue;
		}
			
		path = BestLandPath (from, sct);

		if (path == (char *) 0)
		{
			ExploreMessage (win, 1, 5, "Can't reach it (Hehh?)");
			FlushExplore (win);
			continue;
		}

		cost = (int) (RealPathCost (from, path) *
				ItemWeight (explore_item, NPKG) + .99);
	
		total_cost += cost;

		if (total_cost > max_mob)
		{
			ExploreMessage (win, 1, 7, "Mobility used up !!");
			FlushExplore (win);
			Bell ();
			Pause ();
			break;
		}

		FeedEmpire (Fmt ("explore %c %s 1 %s", explore_with,
					CrdStr (from), path), PRINT);
		
		if (! ParseExploreInfo (sct))
		{
			(void) WaitForPrompt (PRINT);
			ExploreMessage (win, 1, 6,
					"Something went wrong, aborting");
			FlushExplore (win);
			if (EmpireStatus () == E_QUESTION)
			{
				FeedEmpire ("h", PRINT);
				(void) WaitForPrompt (PRINT);
			}
			if (win != (WinInfo) 0)
			{
				Bell ();
				Pause ();
			}
			break;
		}

		changed = True;

		ptr = WaitForPrompt (PRINT);
		set_mob (from, (int) (atof (ptr + 1)));
		total_cost = old_mob - s_mob (from);
		FeedEmpire ("h", PRINT);
		(void) WaitForPrompt (PRINT);

		if (++ total_cm >= max_cm)
		{
			ExploreMessage (win, 1, 6, Fmt ("%s used up",
						ItemName (explore_item)));
			FlushExplore (win);
			if (win != (WinInfo) 0)
			{
				Bell ();
				Pause ();
			}
			break;
		}

		/* for path search algorithm */
		set_owner (sct, my_cnum);
		AddNeighboursToOlist (sct);
	}

	if (changed)
		RedumpExploreCircle (from, lastdist);
	else
		RedumpSector (from, PRINT);

	FreeNlists ();
	if (win != (WinInfo) 0)
	{
		DestroyWindow (win);
		LowerWindow (map_win);
	}
}

int GiveMaxMove (from, to, item_char, thr_mob)
Sector from, to;
char item_char;
int thr_mob;
{
	int item;
	int mob;
	char * path;

	mob = s_mob (from) - thr_mob;
	if (mob <= 0)
		return 0;

	path = BestLandPath (from, to);
	if (path == (char *) 0)
		return -1;

	item = CharToItem (item_char);
	if (item < 0)
		return -1;

	return (int) (mob / (RealPathCost (from, path) *
			     ItemWeight (item, SectorPacking (s_des (from)))));
}

bool ExecMove (from, to, quant, item_char)
Sector from, to;
int quant;
char item_char;
{
	double newmob;
	int item;
	char * path, * ptr;
	int nx, ny;
	bool ret_value;
	double mcost;

	if (quant < 0)
		return False;

	path = BestLandPath (from, to);
	if (path == (char *) 0)
		return False;

	item = CharToItem (item_char);
	if (item < 0)
		return False;
	
	if (command_state == TEST_STATE || command_state == FORCE_BUF_STATE)
	{
		mcost = quant * RealPathCost (from, path) * ItemWeight (item,
				SectorPacking (s_des (from)));

		if (mcost < 0.0 || (int) (mcost + 0.99) > s_mob (from))
			return False;

		if (command_state == FORCE_BUF_STATE)
			FeedCommand (Fmt ("move %c %s %d %sh",
				item_char,
				CrdStr (from),
				quant,
				path), PRINT);

		SetQuant (from, item_char, GiveQuant (from, item_char) - quant);
		SetQuant (to, item_char, GiveQuant (to, item_char) + quant);
		set_mob (from, s_mob (from) - (int) (mcost + 0.99));
		return True;
	}
		
	FeedEmpire  (Fmt ("move %c %s %d %s",
		item_char,
		CrdStr (from),
		quant,
		path), PRINT);

	ptr = WaitForPrompt (PRINT);

	if (EmpireStatus () == E_COMMAND)
		return False;
	else if (sscanf (ptr, "<%lf: %*c %d,%d", & newmob, & nx, & ny) != 3)
	{
		FeedEmpire ("aborted", PRINT);
		(void) WaitForPrompt (PRINT);
		return False;
	}

	if (nx != s_xcd (to) || ny != s_ycd (to))
	{
		ret_value = False;
		to = World (nx, ny, S_DESIG);
	}
	else
		ret_value = True;

	set_mob (from, (int) newmob);
	SetQuant (from, item_char, GiveQuant (from, item_char) - quant);
	SetQuant (to, item_char, GiveQuant (to, item_char) + quant);
	FeedEmpire ("h", PRINT);
	(void) WaitForPrompt (PRINT);
	return ret_value;
}

	/*
	 *	Format: explore [(civ|mil)[, quant]]
	 */

void BindExplore (x, y, str)
int x, y;
char * str;
{
	int i;
	char buf [20];

	if (sscanf (str, "(%[^,], %d)", buf, & i) == 2)
	{
		DoExplore (x, y, buf [0], i);
	}
	else if (sscanf (str, "(%s)", buf) == 1)
	{
		DoExplore (x, y, buf [0], 0);
	}
	else
		DoExplore (x, y, '\0', 0);
}

void RedoExplore ()
{
	DoExplore (s_xcd(cursct), s_ycd(cursct), last_explore_item,
		   last_explore_quant);
}
