/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/commands/RCS/deli.c,v 5.1 1993/03/14 16:43:59 etienne Exp $
    $Date: 1993/03/14 16:43:59 $
    $Author: etienne $
    $Id: deli.c,v 5.1 1993/03/14 16:43:59 etienne Exp $
    $Locker:  $
    $Log: deli.c,v $
    Revision 5.1  1993/03/14 16:43:59  etienne

 * Revision 5.0  93/02/06  09:18:04  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:32:23  greyhelm
 * Client for ASCII /X Empire client
 * Added RCS header - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "sector.h"

static int last_item;
static int last_cutoff;
extern Sector cursct;

void RedoDeliver ()
{
	DoDeliver (s_xcd(cursct), s_ycd(cursct), last_item, last_cutoff);
}

void SetDelAgainCutoff (item, cutoff)
int cutoff;
int item;
{
	last_cutoff = cutoff;
	last_item = item;
}
	
void Deliver (x, y)
int x, y;
{
	int item;
	int cutoff;
	char * ans;

	item = SelectItem (x, y, "What commodity ?");
	if (item == -1)
		return;

	ans = InputAtMessage (
		Fmt("%s cutoff to [%d]: ",
			ItemName (item),
			GetCutoff (cursct,
			ItemChar (item))),
		4, GS_NUMBER);

	if (ans == (char *) 0 || interrupt)
	{
		interrupt = False;
		ClearMes ();
		return;
	}

	if (*ans == '\0')
		cutoff = GetCutoff (cursct, ItemChar (item));
	else
	{
		cutoff = atoi (ans);
		if (cutoff <= 0)
		{
			ClearMes ();
			return;
		}
	}

	DoDeliver (x, y, item, cutoff);
	SetAgain (RedoDeliver);
	SetDelAgainCutoff (item, cutoff);

}
	
void DoDeliver (x, y, item, cutoff)
int x, y, cutoff;
int item;

{
	Sector nxt;
	int button;

	if (item == -1)
		return;
	
	Message ("Select sector to deliver to");
	MesBut ("View", "Cancel", "Set");

	for (;;)
	{
		
		nxt = SelectSector (&button);

		if (interrupt || button == MIDDLE_BUTTON)
		{
			interrupt = False;
			Message ("Deliver cancelled");
			break;
		}

		if (nxt == (Sector) 0 || NO_INFO (nxt))
			continue;

		if (button == LEFT_BUTTON)
		{
			CensusSct (nxt);
			continue;
		}

		if (cursct == nxt)
		{
			FeedCommand (Fmt ("deliver %c %s h (0)",
				ItemChar (item), CrdStr (cursct)), PRINT);
			Message (Fmt ("Deliver at %s for %s deleted",
				CrdStr (cursct), ItemName (item)));
			SetDelDir (cursct, ItemChar (item), '.');
			break;
		}

		if (! s_owned (nxt))
		{
			 Message ("Not yours !");
			 Bell ();
			 continue;
		}

		if (! Adjacent (cursct, nxt))
		{
			 Message ("Not adjacent !");
			 Bell ();
			 continue;
		}

		MarkSector (nxt);
		FeedCommand (Fmt ("deliver %c %s %c (%d)",
			ItemChar (item),
			CrdStr (cursct),
			GiveDirChar (cursct, nxt),
			cutoff), PRINT);
		DrawSector (cursct);
		SetCutoff (cursct, ItemChar (item), cutoff);
		SetDelDir (cursct, ItemChar (item), GiveDirChar (cursct, nxt));
		Census ();
		UnmarkSector (nxt);
		Message (Fmt ("Deliver at %s for %s set to %s",
			CrdStr (cursct), ItemName (item), CrdStr (nxt)));
		break;
	}

	MesClearBut ();
}
