/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/commands/RCS/commands.c,v 5.6 1996/01/30 17:36:06 jpo Exp $
    $Date: 1996/01/30 17:36:06 $
    $Author: jpo $
    $Id: commands.c,v 5.6 1996/01/30 17:36:06 jpo Exp $
    $Locker:  $
    $Log: commands.c,v $
    Revision 5.6  1996/01/30 17:36:06  jpo
    Memory leak fix

    Revision 5.5  1996/01/29 08:10:40  jpo
    New pager interface

    Revision 5.4  1995/09/18 17:01:39  jpo
    Added rescan of budget

    Revision 5.3  1995/09/13 07:27:21  jpo
    Added rescan of power

    Revision 5.2  1995/09/08 07:05:38  jpo
    scattered consts
    army and land modes
    some cleanups
    trapped some bugs

 * Revision 5.1  93/03/14  16:43:20  etienne
 * added landunits stuff
 * 
 * Revision 5.0  93/02/06  09:18:04  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:32:23  greyhelm
 * Client for ASCII /X Empire client
 * Added RCS header - Karl Hagen
 *

*/
	/*
	 *	commands.c
	 */

#include "type.h"
#include "main.h"
#include "sector.h"
#include "nation.h"
#include "var.h"
#include "ship.h"
#include "land.h"
#include "version.h"

 /*****************************************************************************
 *			Buffer command					      *
 *****************************************************************************/

#define BF_TOGGLE	0
#define BF_SHOW		1
#define BF_FEED		2
#define	BF_TEST		3

#define BF_MAX		4

static const char *buf_str [] =
{
	"-------------------------",
	"show buffered commands         ",   /* Don't delete the extra ' ' */
	"feed buffered commands",
	"enter test mode",
	(char *) 0
};

void InfoBufferMenu (x, y, i)
int x, y, i;
{
	switch (i)
	{

	case BF_TOGGLE:
		Help (x, y, "Buffer Toggle");
		break;

	case BF_SHOW:
		Help (x, y, "Buffer Show");
		break;

	case BF_FEED:
		Help (x, y, "Buffer Feed");
		break;

	case BF_TEST:
		Help (x, y, "Buffer Test");
		break;

	default:
		Help (x, y, "No Help");
		break;
	}
}

void BufferMenu (x, y)
int x, y;
{
	Strings strings;
	bool cont;
	int i;

	strings = InitStrings ();
	AddStringsID (strings, buf_str, BF_MAX, 0);

	if (command_state == NORMAL_STATE)
		ChangeString (strings, BF_TOGGLE, "toggle buffering (now off)");
	else if (command_state == BUFFER_STATE)
		ChangeString (strings, BF_TOGGLE, "toggle buffering (now on)");
	else if (command_state == FORCE_BUF_STATE)
		ChangeString (strings, BF_TOGGLE,
				"toggle buffering (now force)");
	else if (command_state == TEST_STATE)
		ChangeString (strings, TEST_STATE, "reset save-files");

	switch (ChooseMenu (strings, "Buffering", map_win,
			    x, y, InfoBufferMenu)) {
	default:
	    break;

	case BF_TOGGLE:
	    if (command_state == NORMAL_STATE)
	    {
		command_state = BUFFER_STATE;
		Message ("toggle buffering (now on)");
	    }
	    else if (command_state == BUFFER_STATE)
	    {
		command_state = FORCE_BUF_STATE;
		Message ("toggle buffering (now force)");
	    }
	    else if (command_state == FORCE_BUF_STATE)
	    {
		command_state = NORMAL_STATE;
		Message ("toggle buffering (now off)");
	    }
	    else /* if (command_state == TEST_STATE) */
		Message ("Not yet implemented");
	    break;

	case BF_TEST:
	    command_state = TEST_STATE;
	    Message ("Now in test mode");
	    Disconnect (-1);
	    break;

	case BF_SHOW:
	    ShowBufCommands (x + 5, y + 5);
	    break;

	case BF_FEED:
	    if (! BufferdCommands ())
	    {
		Message ("No commands buffered");
		Bell ();
	    }
	    else
		Reconnect ();
	    break;
	}

	FreeStrings (strings);
}

/*******************************************************************************
*			Rescan Menu					       *
*******************************************************************************/

#define	RS_ALL		0
#define RS_MAPDUMP	1
#define	RS_DUMP		2
#define	RS_SHIPS	3
#define RS_PLANES	4
#define RS_UNITS	5
#define	RS_NUKES	6
#define	RS_LRADAR	7
#define	RS_SRADAR	8
#define	RS_LOOK		9
#define RS_CNAMES	10
#define	RS_MAP		11
#define RS_SHOWSHPL	12
#define RS_LANDSHOW	13
#define RS_NATION	14
#define RS_SATELLITE	15
#define RS_PRODUCTION	16
#define RS_BMAP		17
#define RS_VERSION      18
#define RS_POWER	19
#define RS_BUDGET	20

#define RS_MAX		21

static const char *resc_menu [] =
{
	"all",
	"map & dump",
	"dump",
	"ships & cargo",
	"planes",
	"units & cargo",
	"nukes",
	"land radars",
	"ship radars",
	"lookout & coastwatch",
	"other country names",
	"map",
	"show ship/plane/nuke c&b",
	"show land c&b&s",
	"nation",
	"satellite",
	"production",
	"bmap",
	"version",
	"power",
	"budget",
	(char *) 0
};

static void Rescan (x, y)
int x, y;
{
	int i;
	Strings strings;
	char * realm;

	strings = InitStrings ();
	AddStringsID (strings, resc_menu, RS_MAX, 0);

	switch (i = ChooseMenu (strings, "Rescan ?", map_win, x, y, NULL)) {
	default:
		break;

	case RS_SHOWSHPL:
		FScanShowShipBuild ();
		FScanShowShipCap ();  
		FScanShowPlaneBuild ();
		FScanShowPlaneCap ();
		FScanNukeShowBuild ();
		FScanNukeShowCap ();
		break;

	case RS_LANDSHOW:
		if (!land_units) {
			Message ("Land Units not in this Version");
			break;
		}
		FScanShowLandBuild();
		FScanShowLandStats();
		FScanShowLandCap();
		break;

	case RS_PLANES:
		DumpPlanes ("*", PRINT);
		break;

	case RS_UNITS:
		if (land_units)
			DumpLand ("*", PRINT);
		break;

	case RS_SHIPS:
		if (Confirm ("Delete enemy ships ?", True))
			DeleteEnemyShips ();
		MarkAllShips ();
		DumpShips ("*", PRINT);
		SearchMarkedShips (PRINT);
		break;


	case RS_POWER:
		ScanNewPower ();
		break;

	case RS_BUDGET:
		ScanNewBudget ();
		break;

	case RS_NUKES:
		FScanNukes ("*", PRINT);
		break;

	case RS_CNAMES:
		FindMyCnum ();
		break;

	case RS_SRADAR:
		FeedRadarShips ();
		DrawMap ();
		break;

	case RS_SATELLITE:
		FeedSatellite ();
		DrawMap ();
		break;

	case RS_VERSION:
		FScanVersion();
		break;

	case RS_PRODUCTION:
	{
		char *file;
		file = InputAtMessage ("Productionfile [- for mailbox]: ",
				       80, GS_TEXT);
		if (file == (char *) 0)
			Message ("Rescan production cancelled");
		else
			ReadProduction(file);
		break;
	}

	case RS_BMAP:
		FScanBmap("*", PRINT);
		DrawMap();
		break;

	case RS_NATION:
		FScanNation ();
		break;

	case RS_ALL:
		FScanNation ();
		FScanShowShipBuild ();
		FScanShowShipCap (); 
		FScanShowPlaneBuild ();
		FScanShowPlaneCap ();
		if (land_units) {
			FScanShowLandBuild ();
			FScanShowLandStats ();
			FScanShowLandCap ();
		}
		FScanNukeShowBuild ();
		FScanNukeShowCap ();
		DumpPlanes ("*", PRINT);
		DeleteEnemyShips ();
		MarkAllShips ();
		DumpShips ("*", PRINT);
		SearchMarkedShips (PRINT);
		if (land_units)
			DumpLand ("*", PRINT);
		FScanNukes ("*", PRINT);
		FeedRadarShips ();
		DrawMap ();
		FScanMap ("*",PRINT);
		(void) FScanDump("*",PRINT);
		MarkShips ("*");
		FScanCoastWatch("*");
		UnmarkAllShips();
		FScanRadar ("#");
		DrawMap ();
		break;

	case RS_MAP:
	case RS_MAPDUMP:
	case RS_DUMP:
	case RS_LOOK:
	case RS_LRADAR:
		RaiseAll ();
		Message ("Select realm to rescan");

		while ((realm = MySelRealm ()) != (char *) 0)
		{
			if (i == RS_MAP || i == RS_MAPDUMP)
				FScanMap (realm, PRINT);

			if (i == RS_DUMP || i == RS_MAPDUMP)
				(void) FScanDump (realm, PRINT);

			if (i == RS_LOOK)
			{
				MarkShips (realm);
				FScanCoastWatch (realm);
				FScanLookout (realm);
				/* DeleteMarkedEnemyShips (); */
				UnmarkAllShips();
				MarkLands (realm);
				if (land_units) {
					FScanLLookout (realm);
					UnmarkAllLands ();
				}
			}

			if (i == RS_LRADAR) {
				FScanRadar (realm);
				if (land_units)
					FScanLRadar (realm);
			}
			DrawMap ();
		}
		LowerAll ();
		break;
	}
	FreeStrings(strings);
}

/*******************************************************************************
*			Utility Menu					       *
*******************************************************************************/

#define UTIL_DISTR		0
#define UTIL_DISISL		1
#define UTIL_EXPLORE		2
#define UTIL_FERRY		3
#define UTIL_CHECK		4
#define UTIL_UPDATE		5
#define UTIL_COUNTRY		6
#define	UTIL_PLAN		7

#define UTIL_MAX		8

static const char *util_strs [] =
{
	"Distribute global",
	"Distribute realm",
	"Explore",
	"Ferry",
	"Check",
	"Simulate update",
	"Country information",
	"Plan utility",
	(char *) 0
};

void HelpOnUtils (x, y, i)
int x, y, i;
{
	switch (i)
	{

	case UTIL_DISTR:
		Help (x, y, "Distribute Utility");
		break;
	
	case UTIL_EXPLORE:
		Help (x, y, "Explore Utility");
		break;
	
	case UTIL_FERRY:
		Help (x, y, "Ferry Utility");
		break;
	
	case UTIL_CHECK:
		Help (x, y, "Check Utility");
		break;
	
	case UTIL_UPDATE:
		Help (x, y, "Update Utility");
		break;

	case UTIL_COUNTRY:
		Help (x, y, "Country Utility");
		break;

	default:
		Help (x, y, "No Help");
		break;
	}
}

static void Utils (x, y)
int x, y;
{
	char *path, *realm, *answer;
	Strings strings;
	int x1, x2, y1, y2;
	Sector to, from;
	int i;

	strings = InitStrings ();
	AddStringsID (strings, util_strs, UTIL_MAX, 0);
	i = ChooseMenu (strings, "Which Utility", map_win, x, y, HelpOnUtils);
	FreeStrings (strings);

	if (interrupt || i < 0)
	{
		interrupt = False;
		Message ("Utility cancelled");
		return;
	}

	switch (i)
	{

	case UTIL_DISTR:
		UtilDist (x + 2, y + 2);
		return;

	case UTIL_DISISL:
		DistributeRealm (cursct);
		return;

	case UTIL_EXPLORE:
		ExploreUtil ();
		return;

	case UTIL_FERRY:
		FerryUtil (x + 2, y + 2);
		break;

	case UTIL_CHECK:
		Check ();
		break;

	case UTIL_UPDATE:
		SimulateUpdate ("*");
		break;

	case UTIL_COUNTRY:
		UtilNatInfo (x + 2, y + 2);
		break;

	case UTIL_PLAN:
		PlanUtil (x, y);
		break;
	}
}


/*******************************************************************************
*			Make Map Menu					       *
*******************************************************************************/

static const char *str_savemapopts [] = {
    "Make map with coordinates",
    "Make map without coordinates",
    (char *)0,
};

#define MAP_NORM	0
#define MAP_NUM		1
#define MAP_DES		2

#define MAP_MAX	3

static const char *str_savemapmodes [] =
{
	"sea/land only",
	"sea/countrynum",
	"designation",
	(char *) 0
};

int GetSaveMode (x, y)
int x, y;
{
	Strings strings;
	int i;
	int flag;

	strings = InitStrings ();
	AddStringID (strings, str_savemapopts[0], W_COORD);
	AddStringID (strings, str_savemapopts[1], 0);
	flag = ChooseMenu (strings, "Map Coordinates", map_win, x, y, NULL);
	FreeStrings (strings);
	if (flag < 0)
	    return -1;
	

	strings = InitStrings ();
	AddStringsID (strings, str_savemapmodes, MAP_MAX, 0);
	i = ChooseMenu (strings, "Make a map", map_win, x, y, NULL);
	FreeStrings (strings);

	switch (i) {
	default:
	    return -1;

	case MAP_NORM:
		return (flag |  W_NORM);

	case MAP_NUM:
		return (flag |  W_COUN);

	case MAP_DES:
		return (flag |  W_DES);
	}
	/* NOTREACHED */

}

/*******************************************************************************
*			Change Mode Menu				       *
*******************************************************************************/

	/* in main.h you find the defines (NORMAL_MODE, SHIPMODE, etc) */

#define	MAX_MODES	11

static const char *mode_menu [] =
{
	"Normal mode",		/* 0 */
	"Ship mode",		/* 1 */
	"Plane mode",		/* 2 */
	"Nuke mode",		/* 3 */
	"Fleet mode",		/* 4 */
	"Wing mode",		/* 5 */
	"Ferry mode",		/* 6 */
	"Plan mode",		/* 7 */
	"Info mode",		/* 8 */
	"Army Mode",		/* 9 */
	"Land Mode",		/* 10 */
		
	(char *) 0
};

void InfoOnCensusMode (x, y, i)
int x, y, i;
{
	switch (i) {
	case NORMAL_MODE:
		Help (x, y, "Normal Mode");
		break;
	case SHIP_MODE  :
		Help (x, y, "Ship Mode");
		break;
	case PLANE_MODE :
		Help (x, y, "Plane Mode");
		break;
	case NUKE_MODE 	:
		Help (x, y, "Nuke Mode");
		break;
	case FLEET_MODE :
		Help (x, y, "Fleet Mode");
		break;
	case WING_MODE  :
		Help (x, y, "Wing Mode");
		break;
	case ARMY_MODE:
		Help (x, y, "Army Mode");
		break;
	case LAND_MODE:
		Help (x, y, "Land Mode");
		break;
	default		:
		Help (x, y, "No Help");
		break;
	}
}


void ChangeCommandMode (x, y)
int x, y;
{
	Strings strings;
	bool drawmap;
	int i;

	strings = InitStrings ();
	AddStringsID (strings, mode_menu, MAX_MODES, 0);
#ifdef X_VERSION
	DeleteString (strings, INFO_MODE);
#endif
	i = ChooseMenu (strings, "Which mode ?", map_win, x, y,
			InfoOnCensusMode);

	FreeStrings (strings);

	if (i < 0 || interrupt) {
		interrupt = False;
		return;
	}
	drawmap = (command_mode == PLAN_MODE);
	Message (Fmt ("Mode is now '%s'", mode_menu[i]));
	command_mode = i;

	Census ();
	if (command_mode == PLAN_MODE || drawmap)
		DrawMap ();
}

#define CC_CONNECT	0
#define CC_CONTIMEOUT	1
#define CC_DISCONNECT	2
#define CC_SILENTCON	3
#define CC_QUIT		4
#define CC_QUITNOSAVE	5

#define CC_NR		6

static const char *ccom [] =
{
	"connect",
	"set connect timeout (now XXXX)",
	"disconnect",
	"turn silent (dis)connect on (now off)",
	"quit",
	"quit, no save data",
	(char *) 0
};

void Connections (x, y)
int x, y;
{
	Strings strings;
	char *new;
	bool cont;
	bool save_con;
	extern unsigned con_timeout;
	extern bool silent_con;
	int i;

	strings = InitStrings ();
	AddStringsID (strings, ccom, CC_NR, 0);

	if (! silent_con)
		ChangeString (strings, CC_SILENTCON,
			      "turn silent (dis)connect on (now off)");

	ChangeString (strings, CC_CONTIMEOUT, con_timeout > MIN_CONTIMEOUT ?
		      Fmt ("set connect timeout (now %4d)", con_timeout) :
		      "set connect timeout (now off)");
	

	switch (i = ChooseMenu (strings, "Connection", map_win, x, y, NULL)) {
	default:
		break;

	case CC_SILENTCON:
		if (silent_con)
		{
			silent_con = False;
			Message("silent (dis)connect now off");
		}
		else
		{
			silent_con = True;
			Message ("silent (dis)connect now on");
		}
		break;
	case CC_CONTIMEOUT:
		new = InputAtMessage (
			Fmt ("new connect timeout (off is <= %d) ?",
			     MIN_CONTIMEOUT), 4, GS_PNUMBER);
		if (new == (char *) 0 || *new == '\0' || interrupt)
		{
			interrupt = False;
			Message ("Change connection timeout cancelled");
			break;
		}
		con_timeout = atoi (new);
		Message (con_timeout > MIN_CONTIMEOUT ?
			 Fmt ("connect timeout now %4d", con_timeout) :
			 "connect timeout now off");

		SetSignalsOn ();
		ResetConTimeout ();
		break;

	case CC_QUITNOSAVE:
		save_data = False;
		/* FALL THROUGH */

	case CC_QUIT:
		DoQuit ();
		break;

	case CC_DISCONNECT:
		if (EmpireStatus () == E_DEAD)
		{
			Message ("Already disconnected");
			Bell ();
			break;
		}
		save_con = silent_con;
		silent_con = False;
		Disconnect (-1);
		silent_con = save_con;
		break;

	case CC_CONNECT:
		if (EmpireStatus () != E_DEAD)
		{
			Message ("Already connected");
			Bell ();
			break;
		}
		save_con = silent_con;
		silent_con = False;
		Reconnect ();
		silent_con = save_con;
		break;
	}
	FreeStrings (strings);
	return;
}

#define DE_EDITSHIP	0
#define DE_EDITCOUNTRY	1
#define DE_ADDCOUNTRY	2
#define DE_NEWCAP	3

#define DE_MAX		4

static const char *deity_menu [] =
{
	"edit ship",
	"edit country",
	"add  nation",
	"newcap",
	(char *) 0
};

static void DeityCommands (x, y)
int x, y;
{
	Strings strings;

	strings = InitStrings ();
	AddStringsID (strings, deity_menu, DE_MAX, 0);

	switch (ChooseMenu (strings, "Deity commands", map_win, x, y, NULL))
	{

	case DE_EDITSHIP:
		DeityEditShips (x, y);
		break;

	case DE_EDITCOUNTRY:
		DeityEditCountry (x, y);
		break;

	case DE_ADDCOUNTRY:
		AddNation (x, y);
		break;

	case DE_NEWCAP:
		DoNewCap (x, y);
		break;
	}
	FreeStrings (strings);
}

/*******************************************************************************
*			Global Command Menu				       *
*******************************************************************************/

#define	GC_CENSUSMODE	0
#define	GC_COMMUN	1
#define GC_CONNECTIONS	2
#define	GC_DISPLAY	3
#define GC_MULTI	4
#define GC_PAGECOM	5
#define GC_INFO		6
#define	GC_RESCAN	7
#define GC_UTILITIES	8
#define GC_BUFFER	9

#define	GC_DEITY	10

#define GC_NR		11

static const char *gcom [] =
{
	"census mode",
	"communications",
	"connection",
	"display",
	"multi (realm) commands",
	"page empire commands",
	"info",
	"re-scan",
	"utilities",
	"buffered commands",
	"deity",
	(char *) 0
};

void GlobalCommands (x, y)
int x, y;
{
	Strings strings;
	int r;

	strings = InitStrings ();
	AddStringsID (strings, gcom, GC_NR - 1, 0);

	if (deity)
		AddStringID (strings, gcom [GC_DEITY], GC_DEITY);

	r = ChooseMenu (strings, "Command ?", map_win, x, y, NULL);

	switch (r)
	{

	case GC_DISPLAY:
		ChangeDisplay (x + 5, y + 5);
		break;

	case GC_CENSUSMODE:
		ChangeCommandMode (x + 5, y + 5);
		break;

	case GC_COMMUN:
		Commun (x + 2, y + 2);
		break;

	case GC_PAGECOM:
		WMPageCommand (x + 2, y + 2);
		break;

	case GC_MULTI:
		FreeStrings (strings);
		Multi (x + 2, y + 2);
		return;

	case GC_RESCAN:
		FreeStrings (strings);
		Rescan (x + 2, y + 2);
		return;

	case GC_INFO:
		InfoCommands (x + 2, y + 2);
		break;

	case GC_UTILITIES:
		FreeStrings (strings);
		Utils (x + 2, y + 2);
		Census ();
		return;

	case GC_CONNECTIONS:
		Connections (x + 2, y + 2);
		break;

	case GC_DEITY:
		DeityCommands (x + 5, y + 5);
		break;

	case GC_BUFFER:
		BufferMenu (x + 5, y + 5);
		break;
	}

	FreeStrings (strings);
	Census ();
}

#define MAX_COMMANDS 41

#define	CM_ASSAULT	0
#define CM_ATTACK	1
#define CM_BOARD	2
#define CM_BUILDSHIP	3
#define CM_BUILDPLANE	4
#define CM_BUILDBRIDGE	5
#define CM_BUILDNUKE	6
#define CM_CAPITOL	7
#define CM_COASTWATCH	8
#define CM_CONVERT	9
#define CM_DEMOBILIZE	10
#define CM_DESIGNATE	11
#define CM_DELIVER	12
#define CM_DISTR_LOC	13
#define CM_ENLIST	14
#define CM_EXPLORE	15
#define CM_SHOOT	16
#define CM_LANDFIRE	17
#define CM_LOOKOUT	18
#define CM_MOVE		19
#define CM_NAVIGATE	20
#define CM_LANDRADAR	21
#define CM_ORIGIN	22
#define CM_REDUMP	23
#define CM_SCRAP	24
#define CM_UPGRADE	25
#define CM_SHIPRADAR	26
#define CM_SHIPFIRE	27
#define CM_SPY		28
#define CM_FLY		29
#define CM_LAUNCH	30
#define CM_TRANSPORT	31
#define CM_BOMB		32
#define	CM_PARADROP	33
#define	CM_DROP		34
#define	CM_RECON	35
#define CM_FLEETADD	36
#define CM_WINGADD	37
#define CM_CHANGEOWNER	38
#define CM_SELL		39
#define CM_MULTI	40
#define CM_GRIND	41
#define CM_CEDE		42
#define CM_START	43
#define CM_STOP		44
#define CM_BUILDUNIT	45
#define CM_MARCH	46
#define CM_ARMYADD	47
#define CM_FORTIFY	48
#define CM_WORK		49
#define CM_LMINE	50
#define CM_LSCUTTLE	51
#define CM_LSCRAP	52
#define CM_SCUTTLE	53
#define CM_PMINE	54

static char * const sct_command [] =
{
	"assault",
	"attack",
	"board ship",
	"build ship",
	"build plane",
	"build bridge",
	"build nuke",
	"capitol",
	"coastwatch",
	"convert",
	"demobilize",
	"designate",
	"deliver",
	"distribute",
	"enlist",
	"explore",
	"shoot",
	"fire",
	"lookout",
	"move",
	"navigate",
	"landradar",
	"origin",
	"redump sector",
	"scrap ship",
	"upgrade",
	"radar",
	"fire",
	"spy",
	"fly",
	"launch",
	"transport",
	"bomb",
	"paradrop",
	"drop",
	"recon",
	"fleet add",
	"wing add",
	"change owner",
	"sell",
	"multi-fire",
	"grind",
	"cede",
	"start",
	"stop",
	"build landunit",
	"march",
	"army add",
	"fortify",
	"work",
	"landmine",
	"scuttle land",
	"scrap land",
	"scuttle ship",
	"airmine",
	(char *) 0
};

void SectorCommands (x, y)
int x, y;
{
	char *ptr;
	int r;
	Sector nxt;
	Neighb neighb;
	char * what;

	Strings strings;

	extern int capitol_x, capitol_y;
	extern int last_layout;
	extern void MultiFire();

	strings = InitStrings ();

#define ADD(X)	AddSortStringID (strings, sct_command [X], X)
/*
#define ADD(X)	AddStringID (strings, sct_command [X], X)
*/

		/*
		 *	First add all ship/fleet commands
		 */

	if (last_layout == SHIP_MODE || last_layout == FLEET_MODE)
	{
		if (SectorHasOwnedShips (cursct, 1))	/* could be enemy */
		{
			ADD (CM_NAVIGATE);

			if (s_des (cursct) == 'h' && (deity || (s_owned (cursct)
						     && s_eff (cursct) >= 60)))
			{
				ADD (CM_SCRAP);
				ADD (CM_UPGRADE);
				ADD (CM_FLEETADD);
			}
		}
	}

	if (last_layout == PLANE_MODE || last_layout == WING_MODE)
	{
		ADD (CM_WINGADD);
		ADD (CM_FLY);
		ADD (CM_TRANSPORT);
		ADD (CM_BOMB);
		ADD (CM_PARADROP);
		ADD (CM_DROP);
		ADD (CM_RECON);
		ADD (CM_PMINE);
	}

	if (last_layout == PLANE_MODE)
		ADD (CM_LAUNCH);

	ADD (CM_DESIGNATE);

	if (! s_owned (cursct) || deity)
		ADD (CM_CHANGEOWNER);

	if (!s_owned (cursct) && s_des (cursct) != '.' && s_des (cursct) != '\\')
	{
		InitNeighbours (cursct, & neighb);
		while (NextNeighbour (& nxt, S_OWNED, neighb))
		{
			if ((s_mob (nxt) > 0 && s_mil (nxt) > 0) || (s_land (nxt) > 0 )) {
				ADD (CM_ATTACK);
				free ((char *)neighb);
				break;
			}
		}
	}
	
	if (s_owned (cursct) || deity)
	{
		if (s_des (cursct) == 'h' && (deity || s_eff (cursct) >= 60))
			ADD (CM_BUILDSHIP);

		if (s_des (cursct) == '!' && (deity || s_eff (cursct) >= 60))
			ADD (CM_BUILDUNIT);

		if (s_des (cursct) == '*' && (deity || s_eff (cursct) >= 60))
			ADD (CM_BUILDPLANE);

		if (s_des (cursct) == '#' && s_eff (cursct) > 59 && !EMPOption(EASY_BRIDGES))
			ADD (CM_BUILDBRIDGE);

		if (IsCoast (cursct) && s_eff (cursct) > 59 && EMPOption(EASY_BRIDGES))
			ADD (CM_BUILDBRIDGE);

		if (s_des (cursct) == 'n' && (deity || s_eff (cursct) >= 60))
			ADD (CM_BUILDNUKE);

		if (s_des (cursct) == 'c' ||
		    (s_des(cursct) == '^' && emp3server))
			ADD (CM_CAPITOL);

		if (s_occ (cursct) == '*' && s_mob (cursct) > 0)
			ADD(CM_CONVERT);
		
		ADD (CM_DELIVER);

		if (s_eff (cursct) > 59 && s_mil (cursct) > 0)
			ADD (CM_DEMOBILIZE);

		ADD (CM_DISTR_LOC);

		if (n_mil_res (nation) > 0 && s_civ (cursct) > 0)
			ADD (CM_ENLIST);

		ADD (CM_MOVE);

		if (s_mob (cursct) > 0)
			ADD (CM_EXPLORE);

		if (s_mil (cursct) > 0 && s_mob (cursct) > 0)
			ADD (CM_SHOOT);

		if (s_des (cursct) == 'f' && q_gun (cursct) > 0 &&
							q_she (cursct) > 0) {
			ADD (CM_LANDFIRE);
			if (EMPOption(MULTIFIRE))
				ADD (CM_MULTI);
		}

		ADD (CM_COASTWATCH);
		
		if (s_des (cursct) == ')')
			ADD (CM_LANDRADAR);

		InitNeighbours (cursct, & neighb);
		while (NextNeighbour (& nxt, S_DESIG, neighb))
		{
			if ((deity || ! s_owned (nxt)) && s_des (nxt) != '.'
						&& s_des (nxt) != '\\')
			{
				if (s_mil (cursct) > 0)
					ADD (CM_SPY);
				if (s_mob (cursct) > 0)
					ADD (CM_CEDE);
				break;
			}
		}

		ADD (CM_ORIGIN);

		if (market)
			ADD (CM_SELL);

		if (q_bar (cursct) > 0 && s_eff (cursct) > 59 && s_ava (cursct) > 0 && EMPOption(GRIND))
		ADD (CM_GRIND);
	}

	if ((deity || ! s_owned (cursct)) && s_des (cursct) != '.' &&
					s_des (cursct) != '\\')
	{
		
		if (IsCoast (cursct) && !EMPOption(OWNASSAULT))
			ADD (CM_ASSAULT);

	}
	if (IsCoast (cursct) && EMPOption(OWNASSAULT))
		ADD (CM_ASSAULT);


	if (last_layout != SHIP_MODE && last_layout != FLEET_MODE)
	{
		if (SectorHasOwnedShips (cursct, 1))	/* could be enemy */
		{
			ADD (CM_NAVIGATE);
			ADD (CM_FLEETADD);

			if (s_des (cursct) == 'h' && (deity || (s_owned (cursct)
						     && s_eff (cursct) >= 60)))
			{
				ADD (CM_SCRAP);
				ADD (CM_UPGRADE);
			}
		}
	}
	if (last_layout != LAND_MODE && last_layout != ARMY_MODE) {
		if (SectorHasOwnedLands (cursct, 1)) {
			ADD (CM_MARCH);
			ADD (CM_ARMYADD);

			if (s_owned (cursct))
				ADD (CM_LSCRAP);
		}
	}
	

	if (last_layout != PLANE_MODE && last_layout != WING_MODE &&
							s_pla (cursct) > 0)
	{
		ADD (CM_WINGADD);
		ADD (CM_FLY);
		ADD (CM_TRANSPORT);
		ADD (CM_BOMB);
		ADD (CM_PARADROP);
		ADD (CM_DROP);
		ADD (CM_RECON);
		ADD (CM_PMINE);
	}

	ADD (CM_REDUMP);

	if (EMPOption(STOP) && s_owned (cursct) && !s_off (cursct)) 
		ADD (CM_STOP);
	
	if (EMPOption (STOP) && s_owned (cursct) && s_off (cursct))
		ADD (CM_START);

	r = ChooseMenu (strings, "Your command sir ?", map_win,
			x + 2, y + 2, NULL);
	FreeStrings (strings);

	switch (r)
	{

	case CM_MULTI:
		MultiFire ();
		break;

	case CM_ASSAULT:
		Assault (x + 2, y + 2);
		break;

	case CM_ATTACK:
		Attack ();
		break;

	case CM_BUILDSHIP:
		BuildShip (x + 5, y + 5);
		break;

	case CM_BUILDUNIT:
		BuildLand (x + 5, y + 5);
		break;

	case CM_BUILDPLANE:
		BuildPlane (x + 5, y + 5);
		return;

	case CM_BUILDBRIDGE:
		BuildBridge ();
		return;
	
	case CM_BUILDNUKE:
		BuildNuke (x + 5, x + 5);
		return;

	case CM_BOARD:
		Board (x + 2, y + 2);
		break;

	case CM_CAPITOL:
		FeedEmpire (Fmt ("capitol %s", CrdStr (cursct)), PRINT);
		ptr = ReadEmpire (PRINT);
		if (ptr == (char *) 0)
			return;
		Bell ();
		if (EmpireStatus () != E_PRINTING ||
				strncmp (ptr, "Capital now at", 14) != 0)
		{
			Message ("Capitol command failed");
			if (EmpireStatus () != E_PRINTING)
				PrintAtEmpire (ptr);
		}
		else {
			capitol_x = s_xcd (cursct);
			capitol_y = s_ycd (cursct);
			Message (ptr);
		}
		(void) WaitForPrompt (PRINT);
		break;

	case CM_COASTWATCH:
		FScanCoastWatch (CrdStr (cursct));
		DrawMap ();
		break;

	case CM_CONVERT:
		DeityChange (cursct);
		SingleConvert ();
		break;

	case CM_DEMOBILIZE:
		DeityChange (cursct);
		SingleDemob ();
		break;

	case CM_DESIGNATE:
		DeityChange (cursct);
		Design (cursct, x + 1, y + 1);
		break;

	case CM_DELIVER:
		DeityChange (cursct);
		Deliver (x, y);
		break;

	case CM_DISTR_LOC:
		DeityChange (cursct);
		Distribute (cursct, x, y);
		break;

	case CM_ENLIST:
		DeityChange (cursct);
		SingleEnlist ();
		break;

	case CM_EXPLORE:
		DeityChange (cursct);
		Explore (x, y);
		break;

	case CM_SHOOT:
		DeityChange (cursct);
		SingleShoot ();
		break;

	case CM_LANDFIRE:
		FireFromSector ();
		break;

	case CM_LANDRADAR:
		FScanRadar (CrdStr (cursct));
		DrawMap ();
		break;

	case CM_MOVE:
		Move (x, y);
		break;

	case CM_NAVIGATE:
		Navig (x, y);
		break;
	
	case CM_FLEETADD:
		FleetAdd (x, y);
		Census ();
		break;

	case CM_ORIGIN:
		ChangeOrigin (cursct);
		break;

	case CM_SCRAP:
		what = SelectShips (x, y, ST_SCRAP, "Scrap which ships ?");
		if (what != (char *) 0)
			ScrapShip (what);
		break;

	case CM_LSCRAP:
		what = SelectLands (x, y, LD_SCRAP, "Scrap which lands ?");
		if (what != (char *) 0)
			ScrapLand (what);
		break;

	case CM_UPGRADE:
		what = SelectShips (x, y, ST_UPGRADE, "Upgrade which ships ?");
		if (what != (char *) 0)
			UpgradeShip (what);
		break;

	case CM_SPY:
		FScanSpy (CrdStr (cursct));
		break;

	case CM_REDUMP:
		if (FScanDump (CrdStr (cursct), PRINT) == 0 &&
							KNOW_ALL (cursct))
		{
			PrintAtEmpire (Fmt ("Sector %s has been lost !!",
					CrdStr (cursct)));

			set_owner (cursct, UNKNOWN_CNUM);

			DEL_INFO (cursct);
			SET_INFO_RES (cursct);
		}

		if (s_shi (cursct) > 0)
			(void) DumpSctShips (cursct, PRINT);

		if (s_pla (cursct) > 0)
			(void) DumpSctPlanes (cursct, PRINT);

		if (s_land (cursct) > 0)
			(void) DumpSctLands (cursct, PRINT);

		break;

	case CM_FLY:
		Fly (x, y);
		break;
	
	case CM_DROP:
		DropOff (x, y);
		break;

	case CM_PMINE:
		DropOffMines (x,y);
		break;

	case CM_PARADROP:
		DoParadrop (x, y);
		break;
	
	case CM_BOMB:
		Bomb (x, y);
		break;

	case CM_LAUNCH:
		DoLaunch (curplane);
		break;

	case CM_TRANSPORT:
		DoTransport (x, y);
		break;

	case CM_WINGADD:
		WingAdd (x, y);
		break;
        case CM_RECON:		/* mta */
		DoRecon (x, y);
		break;
	case CM_CHANGEOWNER: /* - heinola 9/11/91. */
		ChangeOwner (cursct);
		break;
	case CM_SELL:		/* jpo */
		SingleSell (x, y);
		break;
	case CM_CEDE:
		Cede (cursct);
		break;
	case CM_GRIND:
		SingleGrind ();
		break;
	case CM_START:
		SingleStart (cursct);
		break;
	case CM_STOP:
		SingleStop (cursct);
		break;

	case CM_MARCH:
		Mar (10,10);
		break;

	case CM_ARMYADD:
		ArmyAdd (x,y);
		break;

	default:
		break;
	}

	Census ();
	DrawSector (cursct);
}
