/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/census/RCS/ship.c,v 5.6 1996/02/16 08:36:04 jpo Exp $
    $Date: 1996/02/16 08:36:04 $
    $Author: jpo $
    $Id: ship.c,v 5.6 1996/02/16 08:36:04 jpo Exp $
    $Locker:  $
    $Log: ship.c,v $
    Revision 5.6  1996/02/16 08:36:04  jpo
    Handle fueling at sea

    Revision 5.5  1995/09/28 08:25:49  jpo
    Change load syntax slightly.

    Revision 5.4  1995/09/27 13:21:33  jpo
    Added empire 3 beta stuff for loading/unloading syntax change

    Revision 5.3  1995/09/10 16:24:15  jpo
    Tweak some of the names

    Revision 5.2  1995/09/08 06:59:27  jpo
    added orders, missions, retreats cargoes etc

 * Revision 5.1  93/03/14  16:42:03  etienne
 * added/changed some things
 * 
 * Revision 5.0  93/02/06  09:16:27  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.5  1993/02/06  07:48:54  greyhelm
 * Added gnumake mods to allow checkin and Checkout
 *
 * Revision 4.4  1993/02/06  04:21:26  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "main.h"
#include "census.h"
#include "ship.h"
#include "sector.h"
#include "plane.h"
#include "version.h"
#include <stdio.h>

char comm_chars [] = "ufsgpibdolhr";

static bool ship_censenable [SCM_MAX];

#ifdef TERMC_VERSION

struct s_funcbutton ship_functions [] =
{
	{ SCM_RADAR,	"Radar", 	1,  SL_SY_FUNCBUT,		5 },
	{ SCM_SONAR,	"Sonar",	8,  SL_SY_FUNCBUT,		5 },
	{ SCM_LOOKOUT,	"Look",		15, SL_SY_FUNCBUT,		4 },
	{ SCM_FIRE,	"Fire",		21, SL_SY_FUNCBUT,		4 },
	{ SCM_NAVIGATE,	"Navig",	1,  SL_SY_FUNCBUT + 1,		5 },
	{ SCM_BOARD,	"Board",	8,  SL_SY_FUNCBUT + 1,		5 },
	{ SCM_TEND,	"Tend",		15, SL_SY_FUNCBUT + 1,		4 },
	{ SCM_SET,	"Set",		21, SL_SY_FUNCBUT + 1,		4 },
	{ SCM_SCRAP,	"Scrap",	1,  SL_SY_FUNCBUT + 2,		5 },
	{ SCM_UPGRADE,	"Upgra",	8,  SL_SY_FUNCBUT + 2,		5 },
	{ SCM_MINE,	"Mine",		15, SL_SY_FUNCBUT + 2,		4 },
	{ SCM_TORPEDO,	"Torp",		21, SL_SY_FUNCBUT + 2,		4 }
};

#else	/* X version */

struct s_funcbutton ship_functions [] = 
{
	{ SCM_RADAR,	"Radar",	3,  SL_SY_FUNCBUT,		5 },
	{ SCM_SONAR,	"Sonar",	10, SL_SY_FUNCBUT,		6 },
	{ SCM_LOOKOUT,	"Look",		18, SL_SY_FUNCBUT,		5 },
	{ SCM_NAVIGATE,	"Navig",	3,  SL_SY_FUNCBUT + 1,		5 },
	{ SCM_BOARD,	"Board",	10, SL_SY_FUNCBUT + 1,		6 },
	{ SCM_TEND,	"Tend",		18, SL_SY_FUNCBUT + 1,		5 },
	{ SCM_FIRE,	"Fire",		3,  SL_SY_FUNCBUT + 2,		5 },
	{ SCM_MINE,	"Mine",		10, SL_SY_FUNCBUT + 2,		6 },
	{ SCM_TORPEDO,	"Torp",		18, SL_SY_FUNCBUT + 2,		5 },
	{ SCM_UPGRADE,	"Upgra",	3,  SL_SY_FUNCBUT + 3,		5 },
	{ SCM_SCRAP,	"Scrap",	10, SL_SY_FUNCBUT + 3,		6 },
	{ SCM_SCUTTLE,	"Scut",		18, SL_SY_FUNCBUT + 3,		5 }
};

#endif 

static void CenPutShipHas (x, y, s, ship, c)
int x, y;
int s;
Ship ship;
char c;
{
	if (MaxShipCargo (ship, c) > 0)
		CenPutVal (x, y, Fmt ("%d", s));
	else
		CenPutVal (x, y, "---");
}
	
static void HandleCensusButtonForShip (button, ship)
int button;
Ship ship;
{
	Sector nxt;
	Neighb neighb;

	if (! ship_censenable [button])
		return;

	switch (button)
	{

	case SCM_RADAR:
		Message ("Scanning radar");
		FScanRadar (Fmt ("%d", sh_nr (ship)));
		DrawMap ();
		break;

	case SCM_SONAR:
		Message ("Scanning sonar");
		FeedEmpire (Fmt ("sonar %d", sh_nr (ship)), PRINT);
		ScanLookout ();
		InitNeighbours (cursct, & neighb);
		while (NextNeighbour (& nxt, S_DESIG, neighb))
			(void) UpdateSectorDes (nxt, '.', False);

		DrawMap ();
		break;

	case SCM_LOOKOUT:
		Message ("Scanning lookout");
		DoLookout (cursct, sh_nr (ship), False, PRINT, True);
		DrawMap ();
		break;

	case SCM_NAVIGATE:
		Navigate (Fmt ("%d", sh_nr (ship)));
		CensusShip (ship);
		break;

	case SCM_BOARD:
		Board (10, 10);
		CensusShip (ship);
		break;

	case SCM_TEND:
		Tend (10, 10, ship);
		CensusShip (ship);
		break;

	case SCM_FIRE:
		FireFromShip ();
		break;

	case SCM_MINE:
		Mine (Fmt ("%d", sh_nr (ship)));
		break;

	case SCM_TORPEDO:
		Torpedo();
		break;

	case SCM_UPGRADE:
		UpgradeShip (Fmt ("%d", sh_nr (ship)));
		break;

		/*
		 *	XXX: should curship not being set
		 *	     to zero? (after scrap)
		 */

	case SCM_SCRAP:
		ScrapShip (Fmt ("%d", sh_nr (ship)));
		break;

	case SCM_SCUTTLE:
		ScuttleShip (Fmt ("%d", sh_nr (ship)));
		break;

	case SCM_SET:
		SetShip (ship);
		break;

	default:
		break;
	}
}

	/*
	 *	This will so set x,y to the start of the commodity
	 */

static char WhichShipCommodity (x, y)
int * x, * y;
{
	if (* y == SL_SY_STATS + 1 ||
	    (* y == SL_SY_STATS + 3 && chainsaw_version) ||
	    (* y == SL_SY_STATS + 4 && land_units) ||
	    (* y == SL_SY_STATS + 5 && land_units))
	{
		if (ButtonPressed (* x, * y, 4, * y, 6) &&
		    * y == SL_SY_STATS + 1)
		{
			* x = 4;
			return 'c';
		}

		if (ButtonPressed (* x, * y, 12, * y, 6) &&
		    * y == SL_SY_STATS + 1)
		{
			* x = 13;
			return 'm';
		}

		if (ButtonPressed (* x, * y, 18, * y, 6) &&
		    * y == SL_SY_STATS + 1 && ShipHas (curship, M_PLANE))
		{
			if (sh_pln (curship) >= shiptypes [sh_type (curship)]. pla) {
				Message ("Max amount already on ship");
				Bell ();
			} else {
				SLoadPlane (curship, MIS_LOADPLANE);
				CensusShip (curship);
			}
		}

		if(chainsaw_version &&
		   ButtonPressed (* x, * y, 18, * y, 7) &&
		   * y == SL_SY_STATS + 3)
		{
			* x = 22;
			return 'e';
		}

		if(chainsaw_version &&
		   ButtonPressed (* x, * y, 4, * y, 6) &&
		   * y == SL_SY_STATS + 3)
		{
			if (shiptypes [sh_type (curship)]. hel)
				if (sh_heli (curship) >= shiptypes [sh_type (curship)]. hel) {
					Message ("Max amount already on ship");
					Bell ();
				} else {
					SLoadPlane (curship, MIS_LOADHELI);
					CensusShip (curship);
				}
			return '\0';
		}

		if(chainsaw_version &&
		   ButtonPressed (* x, * y, 12, * y, 6) &&
		   * y == SL_SY_STATS + 3)
		{
			if (shiptypes [sh_type (curship)]. xpl)
				if (sh_xpln (curship) >= shiptypes [sh_type (curship)]. xpl) {
					Message ("Max amount already on ship");
					Bell ();
				} else {
					SLoadPlane (curship, MIS_LOADXPLANE);
					CensusShip (curship);
				}
			return '\0';
		}

		if(land_units &&
		   ButtonPressed (* x, * y, 4, * y, 6) &&
		   * y == SL_SY_STATS + 4)
		{
			if (shiptypes [sh_type (curship)]. land)
				if (sh_land (curship) >= shiptypes [sh_type (curship)]. land) {
					Message ("Max amount already on ship");
					Bell ();
				} else {
					SLoadLand (curship);
					CensusShip (curship);
				}
			return '\0';
		}

		if(land_units &&
		   ButtonPressed (* x, * y, 12, * y, 6) &&
		   * y == SL_SY_STATS + 4)
		{
			SMission (curship);
			CensusShip (curship);
			return '\0';
		}

		if(chainsaw_version &&
		   ButtonPressed (* x, * y, 0, * y, 18) &&
		   * y == SL_SY_STATS + 5)
		{
			SRetreat (curship);
			CensusShip (curship);
			return '\0';
		}

	}
	else if (* y >= SL_SY_COM && * y < SL_SY_COM + 4)
	{
		if (ButtonPressed (* x, * y, 0, * y, 7))
		{
			* x = 4;
			return comm_chars [3 * (* y - SL_SY_COM)];
		}

		if (ButtonPressed (* x, * y, 9, * y, 7))
		{
			* x = 13;
			return comm_chars [3 * (* y - SL_SY_COM) + 1];
		}

		if (ButtonPressed (* x, * y, 18, * y, 7))
		{
			* x = 22;
			return comm_chars [3 * (* y - SL_SY_COM) + 2];
		}
	}

	return '\0';
}

static void ShipLoadUnload (ship, x, y, com)
Ship ship;
int x, y;
char com;
{
	char * ans;
	int item, petrol_oil;  /* petrol_oil determines which to fuel with */
	int in_sct, at_ship, delta, max, new, usedelta;
	bool tomuch;
	Ship oiler = NULL;

	if (! sh_owned (ship))
	{
		Message ("Not your ship !!");
		return;
	}

	if (s_des (cursct) != 'h' || s_eff (cursct) < 2 || ! s_owned (cursct)) 
	{
	    /* other rules for fuel... */
	    if (com == 'e' && s_des(cursct) == '.') {
		for (oiler = s_fship(cursct);
		     oiler != (Ship)0;
		     oiler = sh_nxtsct(oiler)) {
		    if (ShipHas (oiler, M_OILER) &&
			(sh_pet(oiler) > 0 || sh_oil(oiler) > 0))
			break;
		}
		if (oiler == NULL) {
		    Message ("No fuel here");
		    Bell ();
		    return;
		}
	    }
	    else {
		Message ("You can't (un)load here !!");
		Bell ();
		return;
	    }
	}

	if (com == 'c' && s_occ (cursct) == '*')
	{
		Message ("Cannot (un)load civilians in occ. harbor");
		return;
	}

	item = CharToItem (com);
	max = MaxShipCargo (ship, com);

	if (max == 0)
	{
		Message (Fmt ("The captain refuses to take %s on board",
					  ItemName (item)));
		Bell ();
		return;
	}

	PrintN (census_win, x, y, "    ");
	ans = GetString (census_win, x, y, 4, GS_PNUMBER);

	if (interrupt || ans == (char *) 0 || * ans == '\0')
	{
		interrupt = False;
		Message ("(Un)load cancelled");
		CensusShip (ship);
		return;
	}

	new = atoi (ans);

	if (new > max)
	{
		tomuch = True;
		new = max;
	}
	else
		tomuch = False;

	if(com == 'e') {
	    char *fromship;
	    
		petrol_oil = 0;	
		if (oiler == NULL) {
		    in_sct = GiveQuant(cursct,'p');
		    if(in_sct == 0) {
			in_sct = GiveQuant(cursct,'o');
			petrol_oil = 1;
		    }
		    fromship = "";
		}
		else {
		    in_sct = GiveShipQuant(oiler, 'p');
		    if (in_sct == 0) {
			in_sct = GiveShipQuant (oiler, 'o');
			petrol_oil = 1;
		    }
		    fromship = Fmt (" %d", sh_nr(oiler));
		}
		if(in_sct == 0) {
		    Message ("There is NO Petrol or Oil Here");
		    Bell();
		    return;
		}
		at_ship = GiveShipQuant(ship,com);
		if(at_ship == MaxShipCargo(ship,com)) {
			Message ("Ship is already fueled up");
			Bell();
			return;
		}
		delta = new - at_ship;
		if(delta <= 0) {
			CensusShip (ship);
			return;
		}
			
		if(petrol_oil) {
			usedelta = (int) (delta / 50 + 0.5);
		} else {
 			usedelta = (int) (delta / 5 + 0.5);
		}
		if (land_units)
			FeedCommand (Fmt ("fuel ship %d %d%s",
					  sh_nr (ship), delta, fromship),
				     PRINT);
		else
			FeedCommand (Fmt ("fuel %d %d%s",
					  sh_nr (ship), delta, fromship),
				     PRINT);

		Message (Fmt ("%d fuel taken on using %d %s", delta,
				 usedelta, petrol_oil ? "oil" : "petrol"));

		if(petrol_oil) {  /* Use oil */
			/* 1 oil = 50 fuel */
		    if (oiler)
			SetShipQuant(oiler, 'o', in_sct - usedelta);
		    else
			SetQuant (cursct, 'o', in_sct - usedelta);
		} else {
			/* 1 petrol = 5 fuel */
		    if (oiler)
			SetShipQuant (oiler, 'p', in_sct - usedelta);
		    else
			SetQuant (cursct, 'p', in_sct - usedelta);
		}
		SetShipQuant (ship, com, at_ship + delta);
		DrawSector (cursct);
		CensusShip (ship);
		return;
	}
	in_sct = GiveQuant (cursct, com);
	at_ship = GiveShipQuant (ship, com);
	delta = new - at_ship;

		/* (un)load nothing */
	if (delta == 0)
	{
		if (tomuch)
		{
			Message (Fmt ("Maximum # of %s already in ship",
					ItemName (item)));
			Bell ();
		}
		else
			Message ("It's already there, sir!");

		CensusShip (ship);
		return;
	}
		/* load */
	else if (delta > 0)
	{
		if (in_sct < delta)
		{
			if (in_sct == 0)
			{
				Message ("It ain't there captain");
				Bell ();
				CensusShip (ship);
				return;
			}
			else
			{
				delta = in_sct;
				tomuch = True;
				Message (Fmt ("Only %d left in harbor captain",
						in_sct));
			}
		}

		if ((com == 'c' && delta == s_civ (cursct)
				&& s_mil (cursct) == 0) ||
		    (com == 'm' && delta == s_mil (cursct)
				&& s_civ (cursct) == 0))
			if (! Confirm (
			    "This would leave the sector unpopulated, continue",
			    False))
			{
				CensusShip (ship);
				return;
			}
	}
	else
	{
		if (in_sct - delta > MAX_TO_LOAD)
		{
			delta = in_sct - MAX_TO_LOAD;
			tomuch = True;
			Error (Fmt (
			 "Max harbor capacity reached, unloading %d %s",
				delta, ItemName (item)));
		}
	}

	if (emp3server == 2)
		FeedCommand (Fmt ("%sload \"%s\" %d %d",
				  (delta > 0) ? "" : "un",
				  ItemName (item),
				  sh_nr(ship),
				  (delta > 0) ? delta : -delta),
			     PRINT);
	else
		FeedCommand (Fmt ("%sload %d %d \"%s\"",
				  (delta > 0) ? "" : "un",
				  sh_nr (ship),
				  (delta > 0) ? delta : -delta,
				  ItemName (item)),
			     PRINT);

	Message (Fmt ("%soaded %s %d %s",
			(delta > 0) ? "L" : "Unl",
			tomuch ? "(only) " : "",
			(delta > 0) ? delta : -delta,
			ItemName (item)));

	SetQuant (cursct, com, in_sct - delta);
	SetShipQuant (ship, com, at_ship + delta);
	DrawSector (cursct);
	CensusShip (ship);
}

static void CensusChangeFleet (ship)
Ship ship;
{
	char * ans;

	PrintN (census_win, 0, FL_SY_FLEET, Fmt ("%26s", ""));
	ShowFreeFleets ();
	PrintN (census_win, 0, FL_SY_FLEET, "Add to fleet: ");
	ans = GetString (census_win, 14, FL_SY_FLEET, 1, "a-zA-Z~");
	if (ans == (char *) 0 || interrupt || * ans == '\0')
		interrupt = False;
	else
	{
		FeedCommand (Fmt ("fleetadd %c %d", * ans,
					sh_nr (ship)), PRINT);

		set_sh_fleet (ship, * ans);
		Message (Fmt ("%s #%d added to fleet '%c'",
			ShipName (ship), sh_nr (ship), * ans));
	}

	CensusShip (ship);
}

void CensusLayShip ()
{
	CenLine (SL_SY_TYPE - 1);

	CenPuts (0, SL_SY_OWNER, "Owner");

	CenPuts (0, SL_SY_STATS,     "Eff      Mob      Tec");
	CenPuts (0, SL_SY_STATS + 1, "Civ      Mil      Pla");
	CenPuts (0, SL_SY_STATS + 2, "Rad      Son      Mov");
	if(chainsaw_version)
		CenPuts (0, SL_SY_STATS + 3, "Hel      Xpl      Fue");
	if (land_units) {
		CenPuts (0, SL_SY_STATS + 4, "Lnd      Mis         ");
		CenPuts (0, SL_SY_STATS + 5, "Ret                  ");
	}

	CenLineText (SL_SY_COM - 1, "Ship Commodities");

	CenPuts (0, SL_SY_COM,     "uw       foo      she");
	CenPuts (0, SL_SY_COM + 1, "gun      pet      iro");
	CenPuts (0, SL_SY_COM + 2, "bar      dus      oil");
	CenPuts (0, SL_SY_COM + 3, "lcm      hcm      rad");

	CenLine (SL_SY_BUT - 1);
	CenButton (SL_SX_SECTOR, SL_SY_BUT, "Sector", 6, False);
	CenLine (SL_SY_BUT + 1);
	CenButton (SL_SX_FLEET,  SL_SY_BUT,  "Fleet",  5, False);
	CenButton (SL_SX_NEXT,   SL_SY_BUT,   "Next",   4, False);
}

void ShipCensus (ship)
Ship ship;
{
	int i;
	Sector sct;

	curship = ship;
	CenClr (SL_SY_TYPE);
	CenClr (SL_SY_FERRY);
	CenClr (SL_SY_CARGO);
	CenClr (SL_SY_NAME);
	CenClr (SL_SY_OWNER);

	ClearCols (SL_SY_STATS, 3 + (int) (2*land_units) + (int) chainsaw_version);
	ClearCols (SL_SY_COM, 4);

	if (ship == (Ship) 0)
		return;

	curfleet = sh_fleet (ship);

	CenPutVal (0, SL_SY_TYPE, Fmt ("%s (#%d, %c)", ShipName (ship),
					sh_nr (ship), sh_fleet (ship)));

	if (* sh_name (ship) != '\0')
	{
		CenPuts (0, SL_SY_NAME, "Name: ");
		CenPutVal (6, SL_SY_NAME, Fmt ("%-20.20s", sh_name (ship)));
	}
	else if (KSUOption (SHIPNAMES))
		CenPuts (0, SL_SY_NAME, "Not named.");

	if (! deity && ! sh_owned (ship))
	{
		CenPuts (0, SL_SY_OWNER, "Owner: ");
		CenPutVal (7, SL_SY_OWNER, CountryName (sh_owner (ship)));
	}

	for (i = 0; i < SCM_MAX; i ++)
		ship_censenable [i] = False;
	
	if (! sh_owned (ship) && ! deity)
	{
			/*
			 *	Enemy ship
			 */

		ship_censenable [SCM_BOARD] = True;
		DrawCensusButtons (ship_functions, SCM_MAX, ship_censenable);

		for (i = 0; i < 4 + (int) land_units; i ++)
			CenClr (SL_SY_STATS + i);

		if (sh_time (ship) != (time_t) 0)
		{
			CenPutVal (0, SL_SY_STATS, Fmt ("Old position: %d,%d",
					sh_oldx (ship), sh_oldy (ship)));
			CenPutVal (0, SL_SY_STATS + 1, Fmt ("Dated: %s",
					DateFmt (sh_time (ship))));
			CenPutVal (0, SL_SY_STATS + 2, Fmt ("Now:   %s",
					DateFmt (time ((time_t *) 0))));
		}
		else
			CenPutVal (0, SL_SY_STATS, "No previous position");
			
		return;
	}

	CenPuts (0, SL_SY_STATS,     "Eff      Mob      Tec");
	CenPuts (0, SL_SY_STATS + 1, "Civ      Mil      Pla");
	CenPuts (0, SL_SY_STATS + 2, "Rad      Son      Mov");
	if(chainsaw_version)
		CenPuts (0, SL_SY_STATS + 3, "Hel      Xpl      Fue");
	if (land_units) {
		CenPuts (0, SL_SY_STATS + 4, "Lnd      Mis         ");
		CenPuts (0, SL_SY_STATS + 5, "Ret                  ");
	}

	CenPutVal     (4,  SL_SY_STATS,     Fmt ("%-3d%%", sh_eff (ship)));
	CenPutShort   (13, SL_SY_STATS,     sh_mob (ship));
	CenPutShort   (22, SL_SY_STATS,     sh_tech (ship));
	CenPutShipHas (4,  SL_SY_STATS + 1, sh_civ (ship), ship, 'c');
	CenPutShipHas (13, SL_SY_STATS + 1, sh_mil (ship), ship, 'm');
	CenPutShipHas (22, SL_SY_STATS + 1, sh_pln (ship), ship, 'P');
	CenPutPos     (4,  SL_SY_STATS + 2, sh_radar (ship));
	CenPutPos     (13, SL_SY_STATS + 2, sh_sonar (ship));
	CenPutShort   (22, SL_SY_STATS + 2, sh_moves (ship));
	if(chainsaw_version) {
		CenPutShipHas (4,  SL_SY_STATS + 3, sh_heli (ship), ship, 'z');
		CenPutShipHas (13, SL_SY_STATS + 3, sh_xpln (ship), ship, 'w');
		CenPutShipHas (22, SL_SY_STATS + 3, sh_fuel (ship), ship, 'e');
	}
	if (land_units) {
		CenPutShipHas (4,  SL_SY_STATS + 4, sh_land (ship), ship, 'L');
		CenPutVal     (13, SL_SY_STATS + 4,
			       Fmt (sh_mission(ship) == '\0' ? "None" :
				    "%c", sh_mission(ship)));
		CenPutVal     (4, SL_SY_STATS + 5,
			       sh_retreat(ship) == RETREAT_NONE ? "No " :
			       Fmt ("to %d,%d on %s",
				    ship -> rtrtx, ship -> rtrty,
				    RtrtList (ship -> rtrcond)));
	}

	CenPutShipHas (4,  SL_SY_COM,     sh_uw   (ship), ship, 'u');
	CenPutShipHas (13, SL_SY_COM,     sh_foo  (ship), ship, 'f');
	CenPutShipHas (22, SL_SY_COM,     sh_she  (ship), ship, 's');
	CenPutShipHas (4,  SL_SY_COM + 1, sh_gun  (ship), ship, 'g');
	CenPutShipHas (13, SL_SY_COM + 1, sh_pet  (ship), ship, 'p');
	CenPutShipHas (22, SL_SY_COM + 1, sh_iron (ship), ship, 'i');
	CenPutShipHas (4,  SL_SY_COM + 2, sh_bar  (ship), ship, 'b');
	CenPutShipHas (13, SL_SY_COM + 2, sh_dust (ship), ship, 'd');
	CenPutShipHas (22, SL_SY_COM + 2, sh_oil  (ship), ship, 'o');
	CenPutShipHas (4,  SL_SY_COM + 3, sh_lcm  (ship), ship, 'l');
	CenPutShipHas (13, SL_SY_COM + 3, sh_hcm  (ship), ship, 'h');
	CenPutShipHas (22, SL_SY_COM + 3, sh_rad  (ship), ship, 'r');


	CenClr (SL_SY_FERRY);
	CenClr (SL_SY_CARGO);
	
	if (emp3server) {
		CenPutVal (0, SL_SY_FERRY, ShipHasOrders (ship));
		CenPuts (0, SL_SY_CARGO, "Carg: ");
		CenPutVal (6, SL_SY_CARGO, ShipHasCargo (ship));
	}
	else {
		CenPutVal (0, SL_SY_FERRY, HasFerry ('\0', ship));
	}

	ship_censenable [SCM_RADAR] = sh_radar (ship) > 0;
	ship_censenable [SCM_SONAR] = sh_sonar (ship) > 0;
	ship_censenable [SCM_LOOKOUT] = True;
	ship_censenable [SCM_NAVIGATE] = sh_mob (ship) > 0;
	ship_censenable [SCM_TEND] = SectorHasOwnedShips (cursct, 2);
	ship_censenable [SCM_FIRE] = (ShipMaxGuns (ship) > 0) &&
				(sh_eff (ship) >= 60) &&
				(sh_gun (ship) > 0) && 
				(sh_she (ship) > 0);
	ship_censenable [SCM_MINE] = ShipHas (ship, M_MINE) &&
				(sh_eff (ship) >= 60) &&
				(sh_she (ship) > 0);
	ship_censenable [SCM_TORPEDO] = (ShipHas (ship, M_TORP)) &&
				(sh_eff (ship) >= 60) &&
				(sh_gun (ship) > 0) && 
				(sh_she (ship) >= 3);
	ship_censenable [SCM_SCUTTLE] = True;

	sct = ShipSector (ship);
	if (s_des (sct) == 'h' && s_owned (sct) && s_eff (sct) >= 60)
		ship_censenable [SCM_UPGRADE] =
		ship_censenable [SCM_SCRAP] = True;

	DrawCensusButtons (ship_functions, SCM_MAX, ship_censenable);
	FlushWindow (census_win);
	Refresh ();
}

	/*
	 *	Handle census button
	 */

void ShipCensusBut (x, y)
int x, y;
{
	char * ans;
	char comm;
	int i, num;

	if (y == SL_SY_BUT)
	{
		if (ButtonPressed (x, y, SL_SX_SECTOR, y, 6))
		{
			curship = (Ship) 0;
			Census ();
		}
		else if (ButtonPressed (x, y, SL_SX_FLEET, y, 5))
		{
			CensusFleet (sh_fleet (curship));
		}
		else if (ButtonPressed (x, y, SL_SX_NEXT, y, 4))
		{
			curship = sh_nxtsct (curship);
			if (curship == (Ship) 0)
				curship = s_fship (cursct);
			CensusShip (curship);
		}

		return;
	}

	/*
	 *	Change ferry
	 */

	if (y == SL_SY_FERRY)
	{
		if (emp3server) {
			ChangeOrder (curship);
		}
		else
			ChangeFerry ('\0', curship);
		CensusShip (curship);
		return;
	}
	if (y == SL_SY_CARGO && emp3server) {
		ChangeCargo (curship);
		CensusShip (curship);
		return;
	}

		/*
		 *	Fleetadd
		 */

	if (y == SL_SY_TYPE)
	{
		CensusChangeFleet (curship);
		return;
	}

	if (y == SL_SY_NAME)
	{
		if (! KSUOption (SHIPNAMES))
		{
			KSUNotDefined (SHIPNAMES);
			return;
		}

		CenClr (SL_SY_NAME);
		CenPuts (0, SL_SY_NAME, "Name:");
		ans = GetString (census_win, 6, SL_SY_NAME, 20, GS_TEXT);
		if (ans == (char *) 0 || interrupt || * ans == '\0')
		{
			Message ("Set name cancelled");
			CensusShip (curship);
			return;
		}

		if (index (ans, '#') != (char *) 0)
		{
			Message ("Too dangerous to include a '#' in the name");
			Bell ();
			CensusShip (curship);
			return;
		}

		FeedCommand (Fmt ("name %d", sh_nr (curship)), PRINT);
		FeedCommand (Fmt ("%s", ans), PRINT);
		set_sh_name (curship, ans);
		CensusShip (curship);
	}

	i = WhichCensusButton (ship_functions, SCM_MAX, x, y);
	if (i != -1)
	{
		HandleCensusButtonForShip (i, curship);
		return;
	}

		/*
		 *	Load and unload
		 */

	if (! deity || ! DeityChangeShip (curship, x, y))
	{
		comm = WhichShipCommodity (& x, & y);

		if (comm != '\0')
			ShipLoadUnload (curship, x, y, comm);
	}
}

