/*
    $Header: /a/victor/nexor/user4/jpo/xemp/xemp5.0/lib/census/RCS/fleet.c,v 5.3 1995/09/10 16:23:36 jpo Exp $
    $Date: 1995/09/10 16:23:36 $
    $Author: jpo $
    $Id: fleet.c,v 5.3 1995/09/10 16:23:36 jpo Exp $
    $Locker:  $
    $Log: fleet.c,v $
    Revision 5.3  1995/09/10 16:23:36  jpo
    Supprot for fleet setting of mission, retreat and orders

    Revision 5.2  1995/09/08 06:58:00  jpo
    touch ups

 * Revision 5.1  93/03/14  16:41:36  etienne
 * added/changed some things
 * 
 * Revision 5.0  93/02/06  09:16:27  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.5  1993/02/06  07:48:54  greyhelm
 * Added gnumake mods to allow checkin and Checkout
 *
 * Revision 4.4  1993/02/06  04:21:26  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "main.h"
#include "census.h"
#include "ship.h"
#include "sector.h"

static int nr_atscreen = 0;
static bool cens_more = False;
static Ship cens_ships [FL_MAX_SHIPS + 1];

static bool fleet_censenable [SCM_MAX];

extern struct s_funcbutton ship_functions [];

static void HandleCensusButtonForFleet (button)
int button;
{
	Neighb neighb;
	Sector nxt;
	char * fleet;
	int range;
	int i;

	if (! fleet_censenable [button])
		return;

	fleet = FleetId ();

	UnmarkAllShips ();
	MarkShips (fleet);

	switch (button)
	{

	case SCM_RADAR:
		Message ("Scanning radar");
		range = MaxRadarMarked (& i);
		if (range <= 0)
			break;
		FScanRadar (Fmt (" %i", i));
		DrawMap ();
		break;

	case SCM_SONAR:
		Message ("Scanning sonar");
		range = MaxSonarMarked (& i);
		if (range <= 0)
			return;
		FeedEmpire (Fmt ("sonar %d", i), PRINT);
		ScanLookout ();
		InitNeighbours (cursct, & neighb);
		while (NextNeighbour (& nxt, S_DESIG, neighb))
			(void) UpdateSectorDes (nxt, '.', False);

		DrawMap ();
		break;

	case SCM_LOOKOUT:
		Message ("Scanning lookout");
		range = MaxRadarMarked (& i);
		if (range <= 0)
			break;
		DoLookout (cursct, i, False, PRINT, True);
		DrawMap ();
		break;

	case SCM_NAVIGATE:
		Navigate (fleet);
		break;

	case SCM_MINE:
		Mine (Fmt ("%c", fleet));
		break;

	case SCM_TEND:
	case SCM_BOARD:
		Panic ("FleetCensusBut", "ship/census.c", 
			"Can't have this button in the fleet-census");
		break;

	case SCM_FIRE:
		MFireFromFleet (fleet);
		break;

	case SCM_UPGRADE:
		UpgradeShip (fleet);
		break;

	case SCM_SCRAP:
		ScrapShip (fleet);
		break;

	case SCM_SCUTTLE:
		ScuttleShip (fleet);
		break;

	case SCM_SET:
		Message ("Unable to set a fleet (yet)");
		Bell ();
		break;
		/* SetFleet (fleet); */
	default:
		break;
	}
}

static void CensusMergeFleets ()
{
	char * fleet, * ans;
	Ship ptr;

	CenClr (FL_SY_FLEET);
	ShowFreeFleets ();
	PrintN (census_win, 0, FL_SY_FLEET, "Add to fleet: ");
	ans = GetString (census_win, 15, FL_SY_FLEET, 1, "a-zA-Z~");
	if (ans == (char *) 0 || interrupt || * ans == '\0')
		interrupt = False;
	else
	{
		fleet = FleetId ();
		if (* ans == curfleet)
		{
			Message ("No need to change that");
			Bell ();
			return;
		}

		FeedCommand (Fmt ("fleetadd %c %s", * ans, fleet), PRINT);

		UnmarkAllShips ();
		MarkShips (fleet);
		for ALL_SHIPS (ptr)
			if (sh_marked (ptr))
				set_sh_fleet (ptr, * ans);
			
		Message (Fmt ("Fleet %c added to %c", curfleet, * ans));
		curfleet = * ans;
	}

	CensusFleet (curfleet);
}

void CensusLayFleet ()
{
	/*CenLine (FL_SY_FLEET - 1); ET */
	CenPuts (0, FL_SY_FLEET,  "Fleet:");
	CenPuts (0, FL_SY_POS,  "Pos:");
	if (emp3server)
		CenPuts (0, FL_SY_FERRY, "Ord:");
	CenPuts (0, FL_SY_MISSION,  "Mis:");
	CenPuts (0, FL_SY_RETREAT,  "Ret:");
	CenLine (FL_SY_RETREAT + 1);
	CenPuts (0, FL_SY_HEADER, "Sh#  Ship          Mob Eff");
	CenLine (FL_SY_BUT - 1);
	CenButton (FL_SX_SECTOR,  FL_SY_BUT, "Sector", 6, False);
	CenButton (FL_SX_NEXT,    FL_SY_BUT, "Next",   4, False);
	CenLine (FL_SY_BUT + 1);
}

static void ShowCensusFleet (start, fleet)
Ship start;
char fleet;
{
	int i;
	register Ship ship;

		/* clear more */
	CenPuts (FL_SX_MORE, FL_SY_BUT, "    ");

		/* clear ships */
	for (i = 0; i < FL_MAX_SHIPS; i++)
		CenClr (FL_SY_SHIPS + i);
	
	nr_atscreen = 0;

	for (ship = start; ship != (Ship) 0; ship = sh_next (ship))
	{
			/* same sector ? */
		if ((sh_xcd (ship) != s_xcd (cursct) ||
		     sh_ycd (ship) != s_ycd (cursct)))
			continue;

			/* same fleet ? */
		if (sh_fleet (ship) != fleet)
			continue;

			/* need a more? */
		if (nr_atscreen == FL_MAX_SHIPS)
		{
			cens_ships [nr_atscreen] = ship;
			cens_more = True;
			CenButton (FL_SX_MORE, FL_SY_BUT, "More", 4, False);
			return;
		}

			/* print ship */
		CenPutVal (0, FL_SY_SHIPS + nr_atscreen,
			Fmt ("%-4d %-13.13s %-3d %-3d",
				sh_nr (ship),
				ShipName (ship),
				sh_mob (ship),
				sh_eff (ship)));
		
		cens_ships [nr_atscreen ++] = ship;
	}

	cens_more = False;
}

void FleetCensus (fleet)
char fleet;
{
	Sector sct;
	int i;

	curfleet = fleet;

	CenClr (FL_SY_FLEET);
	CenPuts (0, FL_SY_FLEET, "Fleet: ");
	CenPutVal (7, FL_SY_FLEET, Fmt ("%c%s", fleet,
		FleetColocated (fleet) ? "" : "(not colocated)"));

	CenClr (FL_SY_POS);
	CenClr (FL_SY_FERRY);
	CenClr (FL_SY_MISSION);
	CenClr (FL_SY_RETREAT);

	if (FleetEmpty (fleet))
	{
		CenPutVal (0, FL_SY_POS, "Fleet empty!");
		FlushWindow (census_win);
		Refresh ();
		return;
	}

	CenPuts (0, FL_SY_POS, "Pos: ");
	if (FleetColocated (fleet))
		CenPutVal (5, FL_SY_POS, CrdStr (FleetSector (fleet)));

	if (emp3server) {
		CenPuts (0, FL_SY_FERRY, "Ord:");
		CenPutVal (5, FL_SY_FERRY, FleetHasOrders (fleet));
	}
	else
		CenPutVal (0, FL_SY_FERRY, HasFerry (fleet, (Ship) 0));
	CenPuts (0, FL_SY_MISSION, "Mis: ");
	CenPutVal (5, FL_SY_MISSION, FleetHasMission (fleet));
	CenPuts (0, FL_SY_RETREAT, "Ret: ");
	CenPutVal (5, FL_SY_RETREAT, FleetHasRetreat (fleet));

	CenPuts (0, FL_SY_HEADER, "Sh#  Ship          Mob Eff");

	ShowCensusFleet (shiplist, fleet);
	FlushWindow (census_win);


		/* fleet census, should always be owned */

	for (i = 0; i < SCM_MAX; i ++)
		fleet_censenable [i] = False;

	UnmarkAllShips ();
	MarkShips (Fmt ("%c", curfleet));
	fleet_censenable [SCM_SCUTTLE] = True;
	fleet_censenable [SCM_RADAR] = MaxRadarMarked ((int *) 0) > 0;
	fleet_censenable [SCM_SONAR] = MaxSonarMarked ((int *) 0) > 0;
	fleet_censenable [SCM_LOOKOUT] = True;
	fleet_censenable [SCM_NAVIGATE] = MinMobMarkedShips ((Ship *) 0) > 0;
	fleet_censenable [SCM_MINE] = True;
	fleet_censenable [SCM_FIRE] = True;
	sct = FleetSector (curfleet);
	if (sct != (Sector) 0 && s_owned (sct) && s_des (sct) == 'h'
					       && s_eff (sct) > 60)
	{
		fleet_censenable [SCM_UPGRADE] = True;
		fleet_censenable [SCM_SCRAP] = True;
	}

	DrawCensusButtons (ship_functions, SCM_MAX, fleet_censenable);
	FlushWindow (census_win);
	Refresh ();
}

void FleetCensusBut (x, y)
int x, y;
{
	int i;

	if (y == FL_SY_BUT)
	{
		if (ButtonPressed (x, y, FL_SX_SECTOR, FL_SY_BUT, 6))
		{
			curfleet = '\0';
			curship = (Ship) 0;
			Census ();
		}
		else if (ButtonPressed (x, y, FL_SX_MORE, FL_SY_BUT, 4))
		{
			if (! cens_more)
				return;

			ShowCensusFleet (cens_ships [nr_atscreen], curfleet);
			FlushWindow (census_win);
			Refresh ();
		}
		else if (ButtonPressed (x, y, FL_SX_NEXT, FL_SY_BUT, 4))
		{
			curfleet = GiveNextFleetInSct (cursct, curfleet);
			CensusFleet (curfleet);
		}

		return;
	}

	if (y == FL_SY_FLEET)
	{
		CensusMergeFleets ();
		return;
	}
	else if (y == FL_SY_FERRY)
	{
		if (emp3server)
			ChangeFleetOrder(curfleet);
		else
			ChangeFerry (curfleet, (Ship) 0);
		CensusFleet (curfleet);
	}
	else if (y == FL_SY_MISSION)
		ChangeFleetMission (curfleet);
	else if (y == FL_SY_RETREAT)
		ChangeFleetRetreat (curfleet);

	if (y >= FL_SY_SHIPS && y < FL_SY_SHIPS + nr_atscreen)
	{
		curship = cens_ships [y - FL_SY_SHIPS];
		CensusShip (curship);
		return;
	}

	i = WhichCensusButton (ship_functions, SCM_MAX, x, y);

	if (i != -1)
	{
		HandleCensusButtonForFleet (i);
		return;
	}
}
