/*
	$Header: /nexor/users/jpo/xemp/xemp5.0/include/RCS/xemp.h,v 5.6 1995/10/24 15:51:37 jpo Exp jpo $
	$Date: 1995/10/24 15:51:37 $
	$Author: jpo $
	$Id: xemp.h,v 5.6 1995/10/24 15:51:37 jpo Exp jpo $
	$Locker: jpo $
	$Log: xemp.h,v $
	Revision 5.6  1995/10/24 15:51:37  jpo
	New prototypes

	Revision 5.5  1995/10/09 07:16:56  jpo
	TOuch up

	Revision 5.4  1995/10/09 06:42:38  jpo
	FIxed up X fatal error handler prototype

	Revision 5.3  1995/09/28 07:05:17  jpo
	sync

	Revision 5.2  1995/09/08 06:53:35  jpo
	prototypes everywhere

 * Revision 5.1  1993/03/14  16:40:02  etienne
 *
*/

#include "prototype.h"
#ifdef X_VERSION
#include <X11/Xlib.h>
#endif
	/* ./lib/census/census.c */

extern void                      Census _PROTO((void));
extern void                      CensusArmy _PROTO((char army));
extern void                      CensusButton _PROTO((int x, int y));
extern void                      CensusFleet _PROTO((char fleet));
extern void                      CensusInfo _PROTO((void));
extern void                      CensusLand _PROTO((Land land));
extern void                      CensusLayTop _PROTO((void));
extern void                      CensusNuke _PROTO((Nuke nuke));
extern void                      CensusPlane _PROTO((Plane plane));
extern void                      CensusSct _PROTO((Sector sct));
extern void                      CensusSctShip _PROTO((Sector sct, Ship ship));
extern void                      CensusShip _PROTO((Ship ship));
extern void                      CensusWing _PROTO((char wing));
extern void                      DoCensus _PROTO((Sector sct,
						  Ship ship,
						  char fleet,
						  Plane plane,
						  char wing,
						  Nuke nuke,
						  Land land,
						  char army,
						  int layout));
extern void                      InitCensus _PROTO((void));

	/* ./lib/census/deity.c */

extern void                      CensusDeityButton _PROTO((int x, int y));
extern bool                      DeityChangeShip _PROTO((Ship ship,
							 int x, int y));

	/* ./lib/census/fleet.c */

extern void                      CensusLayFleet _PROTO((void));
extern void                      FleetCensus _PROTO((char fleet));
extern void                      FleetCensusBut _PROTO((int x, int y));

	/* ./lib/census/land.c */

extern void                      CensusLayLand _PROTO((void));
extern void                      LRangeEdit _PROTO((Land land));
extern void                      LandCensus _PROTO((Land land));
extern void                      LandCensusBut _PROTO((int x, int y));
extern void                      MoraleEdit _PROTO((Land land));
extern void			 LoadUnload _PROTO((Land land, int x, int y,
						    char com));
	/* ./lib/census/misc.c */

extern void                      BindCensusMode _PROTO((int x, int y,
							char *str));
extern bool                      ButtonPressed _PROTO((int x, int y,
						       int sx, int sy,
						       int len));
extern void                      CenButton _PROTO((int x, int y,
						   const char *str, int len,
						   bool enabled));
extern void                      CenClr _PROTO((int y));
extern void                      CenLine _PROTO((int y));
extern void                      CenLineText _PROTO((int y, const char *str));
extern void                      CenPutInt _PROTO((int x, int y, int i));
extern void                      CenPutPos _PROTO((int x, int y, int s));
extern void                      CenPutPosit _PROTO((int x, int y, int s));
extern void                      CenPutShort _PROTO((int x, int y, int s));
extern void                      CenPutUnknown _PROTO((int x, int y));
extern void                      CenPutVal _PROTO((int x, int y,
						   const char *str));
extern void                      CenPuts _PROTO((int x, int y,
						 const char *str));
extern void                      ClearCols _PROTO((int startx, int starty));
extern void                      DrawCensusButtons _PROTO((struct s_funcbutton buttons[],
							   int max,
							   bool enabled[]));
extern int                       WhichCensusButton _PROTO((struct s_funcbutton funcbuttons[],
							   int max,
							   int x, int y));

	/* ./lib/census/nuke.c */

extern void                      CensusLayNuke _PROTO((void));
extern void                      NukeCensus _PROTO((Stockp stockp));
extern void                      NukeCensusButton _PROTO((int x, int y));

	/* ./lib/census/plane.c */

extern void                      CensusLayPlane _PROTO((void));
extern void                      PlaneCensus _PROTO((Plane plane));
extern void                      PlaneCensusBut _PROTO((int x, int y));

	/* ./lib/census/sector.c */

extern void                      AdditCensusBut _PROTO((int x, int y));
extern void                      CensusAddit _PROTO((Sector sct));
extern void                      CensusCommodities _PROTO((Sector sct));
extern void                      CensusCrafts _PROTO((Sector sct));
extern void                      CensusLayNormal _PROTO((void));
extern void                      CensusResources _PROTO((Sector sct));
extern void                      CensusTop _PROTO((Sector sct));
extern void                      SectorCensus _PROTO((Sector sct));
extern void                      SectorCensusBut _PROTO((int x, int y));

	/* ./lib/census/ship.c */

extern void                      CensusLayShip _PROTO((void));
extern void                      ShipCensus _PROTO((Ship ship));
extern void                      ShipCensusBut _PROTO((int x, int y));

	/* ./lib/census/wing.c */

extern void                      CensusLayWing _PROTO((void));
extern void                      WingCensus _PROTO((char wing));
extern void                      WingCensusBut _PROTO((int x, int y));

	/* ./lib/census/army.c */

extern void                      ArmyCensus _PROTO((char army));
extern void                      ArmyCensusBut _PROTO((int x, int y));
extern void                      CensusLayArmy _PROTO((void));

	/* ./lib/clients/client.c */

extern void			 AwaitSomething _PROTO((int n));
extern bool                      BufferdCommands _PROTO((void));
extern void                      CloseConnection _PROTO((void));
extern void                      DeleteBufCommands _PROTO((void));
extern int                       EmpireStatus _PROTO((void));
extern void                      FeedBufCommands _PROTO((void));
extern void                      FeedCommand _PROTO((const char *com,
						     int flag));
extern void                      FeedEmpire _PROTO((const char *str,
						    int flag));
extern bool                      HostConnect _PROTO((void));
extern bool                      InitClient _PROTO((char *host, char *port,
						    char *logfile));
extern bool                      IsEmpireMessage _PROTO((char *ptr));
extern int                       Login _PROTO((void));
extern void                      ReadBufCommands _PROTO((FILE *fp));
extern char *                    ReadEmpire _PROTO((int flag));
extern void                      Reconnect _PROTO((void));
extern void                      SaveBufCommands _PROTO((FILE *fp));
extern void                      ShowBufCommands _PROTO((int x, int y));
extern bool                      SkipNLines _PROTO((int n, int flag));
extern char *                    WaitForPrompt _PROTO((int flag));

	/* ./lib/clients/empire.c */

extern bool                      EmpireMore _PROTO((void));
extern void                      InitEmpire _PROTO((int inc_y,
						    int inc_width,
						    int inc_height,
						    int savelines));
extern void                      InputToEmpire _PROTO((void));
extern void                      MessageAtEmpire _PROTO((const char *str));
extern void                      PrintAtEmpire _PROTO((const char *str));
extern void                      PrintAtEmpireMode _PROTO((const char *str,
							   int mode));
extern void                      ReprintAtEmpire _PROTO((const char *str));

	/* ./lib/clients/io.c */

extern void                      Disconnect _PROTO((int i));
extern void                      DoQuit _PROTO((void));
extern void                      FastQuit _PROTO((void));
extern void                      Forceleave _PROTO((int sno));
extern void                      GetSpecialChars _PROTO((void));
extern void                      NoConTimeout _PROTO((void));
extern void                      Panic _PROTO((const char *funcname,
					       const char *filename,
					       const char *mes));
extern void                      ResetConTimeout _PROTO((void));
extern void                      SetSignalsOff _PROTO((void));
extern void                      SetSignalsOn _PROTO((void));
extern int			 getfdtablesize _PROTO((void));
extern void			 _noecho _PROTO((int fd));

	/* ./lib/commands/load.c */

extern void                      LLoadXPlane _PROTO((Land land));
extern void                      LandToShip _PROTO((char *landnr));
extern void                      PlaneToShip _PROTO((char *planenr));
extern void                      SLoadHeli _PROTO((Ship ship));
extern void                      SLoadLand _PROTO((Ship ship));
extern void                      SLoadPlane _PROTO((Ship ship,
						    Mission mission));
extern void                      SLoadXPlane _PROTO((Ship ship));

	/* ./lib/commands/again.c */

extern void                      DoAgain _PROTO((void));
extern void                      SetAgain _PROTO((AgainProc proc));

	/* ./lib/commands/attack.c */

extern void                      Attack _PROTO((void));

	/* ./lib/commands/build.c */

extern void                      BuildBridge _PROTO((void));
extern void                      FScanBuildBridge _PROTO((void));
extern void                      RestoreBridgeData _PROTO((FILE *fp));
extern void                      SaveBridgeData _PROTO((FILE *fp));

	/* ./lib/commands/commands.c */

extern void                      BufferMenu _PROTO((int x, int y));
extern void                      ChangeCommandMode _PROTO((int x, int y));
extern void                      Connections _PROTO((int x, int y));
extern int                       GetSaveMode _PROTO((int x, int y));
extern void                      GlobalCommands _PROTO((int x, int y));
extern void                      HelpOnUtils _PROTO((int x, int y, int i));
extern void                      InfoBufferMenu _PROTO((int x, int y, int i));
extern void                      InfoOnCensusMode _PROTO((int x, int y, int i));
extern void                      SectorCommands _PROTO((int x, int y));

	/* ./lib/commands/convert.c */

extern void                      BindConvert _PROTO((int x, int y, char *str));
extern void                      DoConvert _PROTO((char *realm, int quant,
						   char ch));
extern void                      MultiConvert _PROTO((int x, int y));
extern void                      RedoConvert _PROTO((void));
extern void                      SingleConvert _PROTO((void));

	/* ./lib/commands/deity.c */

extern void                      DeityChange _PROTO((Sector sct));
extern bool                      DeityChangeLand _PROTO((int x, int y,
							 char ch, int *new));
extern void                      DeityEditCountry _PROTO((int x, int y));
extern void                      DeityEditShips _PROTO((int x, int y));
extern void                      EditLand _PROTO((Sector sct, char what,
						  int newv));
extern void                      EditShip _PROTO((Ship ship, char what,
						  int newv));

	/* ./lib/commands/deli.c */

extern void                      Deliver _PROTO((int x, int y));
extern void                      DoDeliver _PROTO((int x, int y,
						   int item, int cutoff));
extern void                      RedoDeliver _PROTO((void));
extern void                      SetDelAgainCutoff _PROTO((int item,
							   int cutoff));

	/* ./lib/commands/demob.c */

extern void                      BindDemob _PROTO((int x, int y, char *str));
extern void                      DoDemob _PROTO((char *realm, int number,
						 char reser));
extern void                      MultiDemob _PROTO((int x, int y));
extern void                      RedoDemob _PROTO((void));
extern void                      SingleDemob _PROTO((void));

	/* ./lib/commands/design.c */

extern bool                      AllowNavigate _PROTO((Sector sct));
extern void                      BindDesignate _PROTO((int x, int y,
						       char *str));
extern char                      CharOfDesigName _PROTO((char *desig));
extern void                      Design _PROTO((Sector sct, int x, int y));
extern const char *              DesignName _PROTO((char mnem));
extern void                      DoDesignate _PROTO((char *realm, char des));
extern double                    EffPathCost _PROTO((Sector sct, char *path));
extern void                      HelpDesignate _PROTO((int x, int y, int i));
extern double                    MoveCost _PROTO((char des, int eff));
extern void                      MultiDesignate _PROTO((int x, int y));
extern double                    RealPathCost _PROTO((Sector sct, char *path));
extern void                      RedoDesignate _PROTO((void));
extern int                       SectorPacking _PROTO((char des));
extern void			 UpdateDstr _PROTO((void));

	/* ./lib/commands/distri.c */

extern void                      Distribute _PROTO((Sector sct,
						    int x, int y));
extern void                      DistributeW _PROTO((WinInfo win, Sector sct,
						     int x, int y));
extern void                      DistributeRealm _PROTO((Sector sct));
extern bool                      ExecSetDistr _PROTO((Sector sct, Sector to,
						      int mode, bool show,
						      bool isrealm));
extern void                      MarkPath _PROTO((Sector sct, char *path));
extern void                      UnmarkPath _PROTO((Sector start, char *path));
extern void                      UtilDist _PROTO((int x, int y));

	/* ./lib/commands/enlist.c */

extern void                      BindEnlist _PROTO((int x, int y, char *str));
extern void                      DoEnlist _PROTO((char *realm, int quant,
						  char ch));
extern void                      MultiEnlist _PROTO((int x, int y));
extern void                      RedoEnlist _PROTO((void));
extern void                      SingleEnlist _PROTO((void));

	/* ./lib/commands/fire.c */

extern void                      DoFireFromShip _PROTO((char *target,
							int guns));
extern void                      DoFireFromSub _PROTO((char *target));
extern void                      FireFromSector _PROTO((void));
extern void                      FireFromShip _PROTO((void));
extern void                      MultiFire _PROTO((void));
extern void                      RedoFireFromSector _PROTO((void));
extern void                      RedoFireFromShip _PROTO((void));
extern void                      RedoFireFromSub _PROTO((void));
extern void                      Torpedo _PROTO((void));

	/* ./lib/commands/grind.c */

extern void                      BindGrind _PROTO((int x, int y, char *str));
extern void                      DoGrind _PROTO((char *realm, int quant,
						 char ch));
extern void                      MultiGrind _PROTO((int x, int y));
extern void                      RedoGrind _PROTO((void));
extern void                      SingleGrind _PROTO((void));

	/* ./lib/commands/market.c */

extern void                      BindSell _PROTO((int x, int y, char *str));
extern void                      DoSell _PROTO((char *realm, char comm,
						int quant, double price));
extern void			 MultiSell _PROTO((int x, int y));
extern void                      RedoSell _PROTO((void));
extern void			 SingleSell _PROTO((int x, int y));

	/* ./lib/commands/mfire.c */

extern void                      DoMFireFromFleet _PROTO((char *target));
extern void                      MFireFromFleet _PROTO((char *fleet));
extern void                      RedoMFireFromFleet _PROTO((void));

	/* ./lib/commands/move.c */

extern void                      BindExplore _PROTO((int x, int y,
						     char *str));
extern void                      BindMove _PROTO((int x, int y, char *str));
extern void                      DoExplore _PROTO((int x, int y,
						   char itemchar, int quant));
extern void                      DoExploreUtil _PROTO((WinInfo win,
						       Sector from,
						       int max_mob,
						       int max_cm,
						       char explore_with,
						       int explore_item));
extern void                      DoMove _PROTO((int x, int y, char comm,
						int quant, char *planeid));
extern bool                      ExecMove _PROTO((Sector from, Sector to,
						  int quant, int item_char));
extern void                      Explore _PROTO((int x, int y));
extern void                      ExploreUtil _PROTO((void));
extern void                      FlushExplore _PROTO((WinInfo win));
extern int                       GiveMaxMove _PROTO((Sector from, Sector to,
						     char item_char,
						     int thr_mob));
extern void                      Move _PROTO((int x, int y));
extern bool                      ParseExploreInfo _PROTO((Sector sct));
extern void                      RedoExplore _PROTO((void));
extern void                      RedoMove _PROTO((void));

	/* ./lib/commands/multi.c */

extern void                      DoMakeMap _PROTO((int x, int y));
extern void                      Multi _PROTO((int x, int y));
extern void                      MultiCommand _PROTO((int x, int y,
						      const char *quest,
						      const char *comname,
						      int def,
						      MultiProc proc,
						      char ch));
extern void                      MultiProg _PROTO((int px, int py));
extern void                      MultiSpy _PROTO((void));
extern void                      SetRealm _PROTO((int x, int y));

	/* ./lib/commands/pemp.c */

extern void                      WMPageCommand _PROTO((int x, int y));

	/* ./lib/commands/shoot.c */

extern void                      BindShoot _PROTO((int x, int y, char *str));
extern void                      DoShoot _PROTO((char *realm, int number,
						 char comm));
extern void                      MultiShoot _PROTO((int x, int y));
extern void                      RedoShoot _PROTO((void));
extern void                      SingleShoot _PROTO((void));

	/* ./lib/commands/territory.c */

extern void                      ExecSetTer _PROTO((char *relam, int number));
extern void                      MultiTerri _PROTO((void));

	/* ./lib/commands/threshold.c */

extern void                      ExecSetThreshold _PROTO((char *realm,
							  char itemchar,
							  int i));
extern void                      MultiThreshold _PROTO((int px, int py));
extern void                      MultiWipe _PROTO((void));

	/* ./lib/data/data.c */

extern void                      CheckDump _PROTO((void));
extern char *                    MakeDataFile _PROTO((const char *suffix));
extern bool                      RetrieveData _PROTO((bool bin_dump));
extern void                      StoreData _PROTO((void));

	/* ./lib/data/dump.c */

extern void                      BinDumpAll _PROTO((void));
extern void                      BinRestAll _PROTO((void));

	/* ./lib/data/help.c */

extern void                      Help _PROTO((int x, int y, char *str));

	/* ./lib/data/xemprc.c */

extern void                      ReadRc _PROTO((void));

	/* ./lib/deity/add.c */

extern void                      AddNation _PROTO((int x, int y));
extern void                      DoNewCap _PROTO((int x, int y));
extern void                      NewCap _PROTO((int country));

	/* ./lib/deity/nation.c */

extern void                      AddCountry _PROTO((int nr, char *name));
extern char *                    AskCountry _PROTO((int x, int y,
						    const char *quest,
						    bool allow_own));
extern int                       CountryId _PROTO((const char *name));
extern char *                    CountryName _PROTO((int nr));
extern bool                      ExistCountry _PROTO((int nr));
extern void                      FindMyCnum _PROTO((void));
extern double                    GiveNatLevel _PROTO((int id));
extern void                      InitNation _PROTO((void));
extern int                       NatCmp _PROTO((char **nat1, char **nat2));
extern void                      NationSetRealm _PROTO((int realmnr,
							char *realm));
extern void                      RestoreCountries _PROTO((FILE *fp));
extern void                      SaveCountries _PROTO((FILE *fp));
extern void                      ShowNation _PROTO((void));

	/* ./lib/land/mine.c */

extern void                      BindLMine _PROTO((int x, int y, char *str));
extern void			 DoLMine _PROTO((char *what, int quant));
extern void                      LMine _PROTO((char *what));
extern void                      RedoLMine _PROTO((void));

        /* ./lib/land/dump.c */
extern void 			 BinDumpLand _PROTO((FILE *fp));
extern bool			 BinRestLand _PROTO((FILE *fp));

	/* ./lib/land/army.c */

extern long                      ArmyAbils _PROTO((char army));
extern bool                      ArmyColocated _PROTO((char army));
extern bool                      ArmyEmpty _PROTO((char army));
extern char *                    ArmyId _PROTO((void));
extern int                       ArmyMinMob _PROTO((char army));
extern Sector                    ArmySector _PROTO((char army));
extern char                      FirstArmyInSct _PROTO((Sector sct));
extern char                      FirstFreeArmy _PROTO((void));
extern char                      GiveNextArmyInSct _PROTO((Sector sct,
							   char army));
extern long                      LandNrAbils _PROTO((int landnr));
extern void                      MoveArmy _PROTO((char army, Sector sct));
extern void                      ShowFreeArmys _PROTO((void));

	/* ./lib/land/land.c */

extern bool                      AddEnemyLand _PROTO((int x, int y,
						      int nr, int owner,
						      char *ptr, int eff,
						      int tech));
extern void                      AddLandToList _PROTO((Land land));
extern void                      AddLandToSector _PROTO((Land land,
							 Sector to));
extern void                      ArmyAdd _PROTO((int x, int y));
extern Land                      AskLand _PROTO((int x, int y,
						 const char *quest,
						 bool allow_others));
extern void                      DeleteEnemyLands _PROTO((void));
extern void                      DeleteLand _PROTO((Land land));
extern void                      DeleteLandFromSector _PROTO((Land land));
extern int                       FindLandTypeByName _PROTO((const char *name,
							    bool must_exist));
extern int                       GiveLandQuant _PROTO((Land land, char item));
extern char *                    GiveLandQuantStr _PROTO((Land land, char id));
extern bool                      LandAtSect _PROTO((Sector sct, char let));
extern bool                      LandAtWith _PROTO((Sector sct, long flag));
extern const char * 		 LandCapNames _PROTO((long flags));
extern const char *              LandCargoNames _PROTO((int cargo[]));
extern char                      LandCharInSector _PROTO((Sector sct));
extern double                    LandFireRange _PROTO((Land land));
extern bool                      LandHas _PROTO((Land land, long flags));
extern bool                      LandHasRadar _PROTO((Land land));
extern int                       LandMaxGuns _PROTO((Land land));
extern const char *              LandName _PROTO((Land land));
extern bool                      LandOnList _PROTO((Land land));
extern Sector                    LandSector _PROTO((Land land));
extern int                       MaxLandCargo _PROTO((Land land, char itemc));
extern void                      MoveLand _PROTO((Land land, Sector to));
extern void                      MoveLandTo _PROTO((Land land, Sector sct));
extern Land                      NrToLand _PROTO((int nr));
extern void                      PageShowLandCSBs _PROTO((void));
extern bool                      PortableLand _PROTO((Land land));
extern bool                      SectorHasOwnedLands _PROTO((Sector sct,
							     int n));
extern void                      SetLandQuant _PROTO((Land land, char item,
						      int value));
extern void                      SetLandValues _PROTO((Land land, char *name));
extern void                      SetSectorLandsNr _PROTO((Sector sct));
extern void                      ShowLandCBStrings _PROTO((Strings strings));

	/* ./lib/land/landbuild.c */

extern void                      BuildLand _PROTO((int x, int y));
extern void                      DoBuildLand _PROTO((int x, int y,
						     int landid, int techn));
extern void                      RedoBuildLand _PROTO((void));

	/* ./lib/land/landlist.c */

extern void                      ListLand _PROTO((int x, int y, int enemy));

	/* ./lib/land/landscan.c */

extern void                      CheckMarkedLands _PROTO((void));
extern int                       DumpLand _PROTO((const char *list, int flag));
extern void                      DumpRealmLands _PROTO((char *realm,
							int flag));
extern void                      DumpSctLands _PROTO((Sector sct, int flag));
extern int                       FScanLand _PROTO((const char *list,
						   int flag));
extern void                      FScanLandCargo _PROTO((const char *list,
							int flag));
extern void                      FScanLandReso _PROTO((void));
extern void                      FScanShowLandBuild _PROTO((void));
extern void                      FScanShowLandCap _PROTO((void));
extern void                      FScanShowLandStats _PROTO((void));
extern void                      FeedRadarLands _PROTO((void));
extern void                      MarkAllLands _PROTO((void));
extern void                      MarkLand _PROTO((Land land));
extern void                      MarkLandsInSct _PROTO((Sector sct));
extern void                      RedumpArmy _PROTO((char army, int flag));
extern void                      RedumpLand _PROTO((Land land, int flag));
extern void                      RestoreShowLand _PROTO((FILE *fp));
extern void                      SaveShowLand _PROTO((FILE *fp));
extern void                      ScanLandCargo _PROTO((int flag));
extern int                       ScanLands _PROTO((int flag));
extern void                      SearchMarkedLands _PROTO((int flag));

	/* ./lib/land/llook.c */

extern void                      DoLLookout _PROTO((Sector sct, int landnr,
						    bool march_in, int print,
						    bool force));

	/* ./lib/land/march.c */

extern void                      BindMarch _PROTO((int x, int y, char *str));
extern void                      DoMarch _PROTO((int x, int y, int how));
extern void                      Mar _PROTO((int x, int y));
extern void                      March _PROTO((char *march_what));
extern void                      RedoMarch _PROTO((void));

	/* ./lib/land/mark.c */

extern bool                      ArmyHasEngineer _PROTO((void));
extern int                       BestMarkedLRadar _PROTO((void));
extern void                      CheckLands _PROTO((char *what));
extern void                      DeleteMarkedEnemyLands _PROTO((void));
extern int                       FirstMarkedLandnr _PROTO((void));
extern bool                      LMarkedColocated _PROTO((void));
extern void                      LMoveMarkedTo _PROTO((Sector sct));
extern void                      MarkLands _PROTO((char *form));
extern int                       MaxLRadarMarked _PROTO((int *lndr));
extern int                       MinMobMarkedLands _PROTO((Land *land));
extern Sector                    SctMarkedLands _PROTO((void));
extern void                      UnmarkAllLands _PROTO((void));

	/* ./lib/land/missing.c */

extern void                      FireFromLand _PROTO((void));
extern void                      MFireFromArmy _PROTO((char *army));
extern void                      MissionLand _PROTO((void));
extern void                      ScuttleLand _PROTO((char *army));

	/* ./lib/land/scrap.c */

extern void                      RedoLScrap _PROTO((void));
extern void                      ScrapLand _PROTO((char *what));

	/* ./lib/land/select.c */

extern char *                    SelectLands _PROTO((int x, int y,
						     LdTask ldtask,
						     const char *quest));

	/* ./lib/land/set.c */

extern void                      SetLand _PROTO((Land land));

	/* ./lib/land/work.c */

extern void                      BindWork _PROTO((int x, int y, char *str));
extern void			 DoWork _PROTO((char *what, int work));
extern void                      RedoWork _PROTO((void));
extern void                      Work _PROTO((char *what));

	/* ./lib/land/supply.c */

extern void                      SupplyLand _PROTO((char *what));

	/* ./lib/land/fort.c */

extern void                      BindFortify _PROTO((int x, int y, char *str));
extern void			 DoFortify _PROTO((char *what, int fort));
extern void                      Fortify _PROTO((char *what));
extern void                      RedoFortify _PROTO((void));

	/* ./lib/land/mission.c */

extern const char		*ArmyHasMission _PROTO((char army));
extern void			 ChangeArmyMission _PROTO((char army));
extern void			 FScanLandMission _PROTO((const char *list,
							  int flag));
extern void                      LMission _PROTO((Land land));
extern void			 ScanLandMission _PROTO((int flag));

	/* ./lib/land/retreat.c */

extern const char		*ArmyHasRetreat _PROTO((char army));
extern void			 ChangeArmyRetreat _PROTO((char army));
extern Sector			 ChooseLandDest _PROTO((Sector sct,
							char **pathp));
extern void			 FScanLandRetreat _PROTO((const char *list,
							  int flag));
extern void                      LRetreat _PROTO((Land land));
extern void			 ScanLandRetreat _PROTO((int flag));

        /* ./lib/misc/budget.c */
extern void			 DoBudget _PROTO((void));
extern void			 ScanBudget _PROTO((void));
extern void 			 ScanNewBudget _PROTO((void));

	/* ./lib/misc/build.c */

extern bool                      BuildCheckAvailable _PROTO((int needed,
							     char *craft));
extern bool                      BuildCheckCommodity _PROTO((char itemchar,
							     int needed,
							     char *craft));

	/* ./lib/misc/check.c */

extern bool                      CheckOwnedCurSct _PROTO((void));

	/* ./lib/misc/dlist.c */

extern void                      DLCall _PROTO((DLISTPTR dlist,
						void (*func)(ENTRYPTR *ep)));
extern void                      DLDelete _PROTO((DLISTPTR dlist,
						  int pos,
						  void (*freefun)(ENTRYPTR *ep)));
extern int                       DLElems _PROTO((DLISTPTR dlist));
extern void                      DLRead _PROTO((DLISTPTR dlst,
						void (*readfnx)(ENTRYPTR *ep)));
extern void                      DLSetCurrent _PROTO((DLISTPTR dlist,
						      int pos));
extern void                      DLWrite _PROTO((DLISTPTR dlist,
						 FILE *fp,
						 void (*writefunc)(ENTRYPTR *ep)));
extern void                      DumpList _PROTO((DLISTPTR dlist));

	/* ./lib/misc/goto.c */

extern void                      GotoCond _PROTO((void));

	/* ./lib/misc/highl.c */

extern void			 ExprHighlist _PROTO((Stack expr));
extern bool                      HighlightSector _PROTO((Sector sct));
extern void                      InitHighlight _PROTO((void));
extern void                      ReadHighlight _PROTO((FILE *fp));
extern void                      SaveHighlight _PROTO((FILE *fp));
extern void                      SetHighlight _PROTO((void));

	/* ./lib/misc/info.c */

extern void                      EmpInfo _PROTO((int x, int y));
extern Strings                   FileToStrings _PROTO((int x, int y,
						       const char *filename));
extern void                      InfoCommands _PROTO((int x, int y));
extern bool                      InfoDir _PROTO((int x, int y, char *dir,
						 char *header));
extern void                      InfoFile _PROTO((int x, int y,
						  const char *file,
						  bool iscom));
extern Strings                   ListDir _PROTO((char *dir));
extern void                      XempInfo _PROTO((int x, int y));

	/* ./lib/misc/item.c */

extern int                       CharToItem _PROTO((char ch));
extern char                      ItemChar _PROTO((int i));
extern const char *              ItemName _PROTO((int i));
extern double                    ItemWeight _PROTO((int i, int pck));
extern int                       SelectAvaItem _PROTO((int x, int y,
						       Sector sct,
						       const char *quest));
extern int                       SelectItem _PROTO((int x, int y,
						    const char *quest));
extern int                       SelectSellItem _PROTO((int x, int y,
							const char *quest));

	/* ./lib/misc/main.c */

extern void                      AbortClient _PROTO((int flag));
extern void                      PrintSaved _PROTO((void));
extern void                      SaveTillPrompt _PROTO((void));
extern void                      leave _PROTO((void));
extern void                      leave0 _PROTO((void));
extern void                      main _PROTO((int argc, char **argv));

	/* ./lib/misc/map.c */

extern bool                      AtScreen _PROTO((int x, int y));
extern void                      BindExpression _PROTO((void));
extern void			 BindHighlightExpression _PROTO((void));
extern void                      BindNormalDisplay _PROTO((void));
extern void                      CenterMap _PROTO((int x, int y));
extern void                      ChangeDisplay _PROTO((int x, int y));
extern void                      ChangeOverlay _PROTO((int x, int y,
						       char *str));
extern void                      ConvMapPosToPixelPos _PROTO((int *px,
							      int *py));
extern bool                      ConvertToSctCrd _PROTO((int *px, int *py));
extern int                       Dist _PROTO((int x1, int x2, int y1, int y2));
extern int                       Distance _PROTO((Sector a, Sector b));
extern void                      DoCenterMap _PROTO((int x, int y));
extern void                      DrawMap _PROTO((void));
extern void                      DrawMapPart _PROTO((int start_x, int start_y,
						     int end_x, int end_y));
extern void                      DrawNeighbours _PROTO((Sector sct));
extern void                      DrawRealm _PROTO((char *realm));
extern void                      DrawSector _PROTO((Sector sct));
extern const char *              FileStr _PROTO((const char *file));
extern Sector                    FindSector _PROTO((int x, int y));
extern void                      GotoSct _PROTO((void));
extern void                      InitMap _PROTO((int incw, int inch));
extern int                       MapSctHeight _PROTO((void));
extern int                       MapSctWidth _PROTO((void));
extern void                      MarkSector _PROTO((Sector sct));
extern void                      ReCenter _PROTO((void));
extern bool                      SaveMap _PROTO((const char *file, int flag,
						 int x1, int x2,
						 int y1, int y2));
extern void                      SetCurrent _PROTO((Sector sct));
extern void                      SetCurrentSctShip _PROTO((Sector sct,
							   Ship ship));
extern void                      ShiftField _PROTO((int dx, int dy));
extern void                      UnmarkSector _PROTO((Sector sct));

	/* ./lib/misc/message.c */

extern void                      ClearMes _PROTO((void));
extern void                      ClearMes2 _PROTO((void));
extern void                      InitMessage _PROTO((int inc_width));
extern char *                    InputAtMessage _PROTO((const char *str,
							int maxlen,
							const char *form));
extern void                      MesBut _PROTO((char *b1, char *b2, char *b3));
extern void                      MesClearBut _PROTO((void));
extern void                      Message _PROTO((const char *str));
extern void                      Message2 _PROTO((const char *str));
extern void                      MessageMore _PROTO((void));
extern void                      SameBut _PROTO((void));
extern void                      Warning _PROTO((const char *str));

	/* ./lib/misc/misc.c */

extern char *                    Centered _PROTO((const char *str, int n));
extern bool                      CharInFormat _PROTO((char ch,
						      const char *format));
extern void                      ClearText _PROTO((void));
extern void                      CloseTextWindow _PROTO((void));
extern char *                    CrdStr _PROTO((Sector sct));
extern char *                    DateFmt _PROTO((time_t tim));
extern char *                    Fmt _PROTO(());
extern void                      FreeFmts _PROTO((void));
extern char *                    MakeFreeString _PROTO((bool upper[],
							bool lower[]));
extern void                      NoNl _PROTO((char *str));
extern void                      OpenTextWindow _PROTO((int x, int y,
							const char *name));
extern double                    PlagueChance _PROTO((Sector sct));
extern char *                    ReadEmpireStrings _PROTO((Strings strings));
extern void                      ShowDone _PROTO((void));
extern void                      ShowStrings _PROTO((Strings strings));
extern void                      ShowText _PROTO((const char *s));
extern char *                    Str _PROTO((const char *s));
extern bool                      StrEQ _PROTO((const char *s1,
					       const char *s2));
extern char *                    StrNl _PROTO((const char *s));
extern double                    TechFact _PROTO((int level, double mult));
extern double                    dmax _PROTO((double n1, double n2));
extern double                    dmin _PROTO((double n1, double n2));
extern char *                    doalloc _PROTO((unsigned size));

	/* ./lib/misc/misc2.c */

extern bool                      Confirm _PROTO((const char *str, bool def));
extern void                      Disabled _PROTO((void));
extern void                      Error _PROTO((const char *str));
extern char *                    GetQuest _PROTO((WinInfo win, int y,
						  const char *quest,
						  int maxlen,
						  const char *fmt));
extern bool                      HandleQuestion _PROTO((const char *quest));
extern void                      SwapInt _PROTO((int *a, int *b));

	/* ./lib/misc/myopt.c */

extern char *                    check_arg _PROTO((void));
extern void                      init_opt _PROTO((int ac, char **av));
extern char *                    next_arg _PROTO((void));
extern char                      next_opt _PROTO((void));

	/* ./lib/misc/path.c */

extern char *                    BestDistPath _PROTO((Sector from, Sector to));
extern char *                    BestLandPath _PROTO((Sector from, Sector to));
extern char *                    BestTmpDistPath _PROTO((Sector from,
							 Sector to));
extern char *                    ReversePath _PROTO((char *path));

	/* ./lib/misc/product.c */

extern int                       GiveProdResource _PROTO((Sector sct, int i));
extern struct pchrstr *          ProdChr _PROTO((char des));
extern int                       ProdCost _PROTO((int item));
extern void                      SetProdResource _PROTO((Sector sct, int i,
							 int q));

	/* ./lib/misc/realm.c */

extern bool                      ConvRealmToCoord _PROTO((const char *realm,
							  int *sx, int *sy,
							  int *ex, int *ey));
extern void                      FreeRealm _PROTO((Realm realm));
extern bool                      InRealm _PROTO((Realm realm, Sector sct));
extern Realm                     InitRealm _PROTO((char *realm, int flag));
extern bool                      NextSctInRealm _PROTO((Realm realm,
							Sector *ret));

	/* ./lib/misc/scan.c */

extern char *                    DelControl _PROTO((char *s));
extern char *                    DelNewline _PROTO((char *s));
extern char *                    DelTabs _PROTO((char *s));
extern void                      FScanBmap _PROTO((const char *part,
						   int flag));
extern void                      FScanCoastWatch _PROTO((const char *where));
extern int                       FScanDump _PROTO((const char *part,
						   int flag));
extern void                      FScanLLookout _PROTO((const char *where));
extern void                      FScanLRadar _PROTO((const char *rad));
extern void                      FScanLookout _PROTO((const char *where));
extern void                      FScanMap _PROTO((const char *part, int flag));
extern void                      FScanNation _PROTO((void));
extern void                      FScanRadar _PROTO((const char *rad));
extern void                      FScanRelations _PROTO((int cnum));
extern void                      FScanReport _PROTO((const char *who));
extern void                      FScanSpy _PROTO((const char *where));
extern void                      FeedSatellite _PROTO((void));
extern bool                      ScanDigit _PROTO((ConstVP pptr,
						   int *num));
extern int                       ScanDump _PROTO((int flag));
extern bool                      ScanFmt _PROTO((const char **ptr, char *word,
						 const char *fmt));
extern void                      ScanLookout _PROTO((void));
extern void                      ScanMap _PROTO((int flag));
extern void                      ScanRadar _PROTO((void));
extern void                      ScanRelations _PROTO((void));
extern void                      ScanReport _PROTO((void));
extern void                      ScanSpy _PROTO((void));
extern bool                      ScanSpyLine _PROTO((char *line,
						     char *oldline));
extern bool                      ScanWord _PROTO((ConstVP pptr,
						  char *word));
extern bool                      ScanWordQuot _PROTO((ConstVP pptr,
						      char *word));
extern bool                      SetOffset _PROTO((char *country));
extern void                      SkipBlank _PROTO((ConstVP pptr));
extern void                      SkipPtr _PROTO((ConstVP pptr,
						 const char *toskip));

	/* ./lib/misc/sector.c */

extern bool                      Adjacent _PROTO((Sector sct1, Sector sct2));
extern void                      Cede _PROTO((Sector sct));
extern void                      ChangeOrigin _PROTO((Sector sct));
extern void                      ChangeOwner _PROTO((Sector sct));
extern void                      Check _PROTO((void));
extern void                      FreeSector _PROTO((Sector sct));
extern int                       GetCutoff _PROTO((Sector sct, char kind));
extern char                      GetDelDir _PROTO((Sector sct, char kind));
extern int                       GetThreshold _PROTO((Sector sct, char kind));
extern char                      GiveDirChar _PROTO((Sector sct1,
						     Sector sct2));
extern int                       GiveQuant _PROTO((Sector sct, char item));
extern void                      Goto _PROTO((Sector sct));
extern void                      GotoStr _PROTO((const char *str));
extern void                      InitNeighbours _PROTO((Sector sct,
							Neighb *neighb));
extern bool                      IsCoast _PROTO((Sector sct));
extern bool                      IsNeighbour _PROTO((Sector sct1,
						     Sector sct2));
extern Sector **                 MallocWorld _PROTO((void));
extern Sector                    MoveInDirection _PROTO((Sector sct, char dir,
							 int flag));
extern void                      MultiChangeOwner _PROTO((void));
extern bool                      NearSeaOrHarbor _PROTO((Sector sct));
extern bool                      NextNeighbour _PROTO((Sector *sct, int known,
						       Neighb neighb));
extern void                      RealmSetThreshold _PROTO((int mx, int my));
extern void                      RedoChangeOwner _PROTO((void));
extern void                      RedumpSector _PROTO((Sector sct, int flag));
extern char *                    SelectRealm _PROTO((const char *mes1,
						     const char *mes2));
extern void                      SetCutoff _PROTO((Sector sct, char item,
						   int value));
extern void                      SetDelDir _PROTO((Sector sct, char kind,
						   char dir));
extern void                      SetDistPath _PROTO((Sector sct, char *path));
extern void                      SetQuant _PROTO((Sector sct, char item,
						  int value));
extern void                      SetSectorTime _PROTO((Sector sct));
extern void                      SetThreshold _PROTO((Sector sct, char item,
						      int value));
extern void                      SingleStart _PROTO((Sector sct));
extern void                      SingleStop _PROTO((Sector sct));
extern bool                      UpdateSectorDes _PROTO((Sector sct, char des, bool force));
extern void                      WipeThreshold _PROTO((void));
extern Sector                    World _PROTO((int x, int y, int known));

	/* ./lib/misc/strings.c */

extern void                      AddSortStringID _PROTO((Strings strings,
							 const char *str,
							 int id));
extern void                      AddString _PROTO((Strings strings,
						   const char *str));
extern void                      AddStringID _PROTO((Strings strings,
						     const char *str,
						     int id));
extern void                      AddStrings _PROTO((Strings strings,
						    const char *str[], int n));
extern void                      AddStringsID _PROTO((Strings strings,
						      ConstVP strs,
						      int n,
						      int i));
extern void                      ChangeString _PROTO((Strings strings, int id,
						      const char *newstr));
extern void                      DeleteFirstString _PROTO((Strings strings));
extern void                      DeleteString _PROTO((Strings strings,
						      int id));
extern void                      DumpStrings _PROTO((Strings strings));
extern Strings                   EditStrings _PROTO((Strings strings,
						     int width, int height));
extern void                      FreeStringIndex _PROTO((Strings strings));
extern void                      FreeStrings _PROTO((Strings strings));
extern const char *              GetFirstString _PROTO((Strings strings));
extern int                       GetNextSelectedId _PROTO((Strings strings));
extern const char *              GetNextSelectedString _PROTO((Strings strings));
extern const char *              GetNextString _PROTO((Strings strings));
extern const char *              GetNextStringFlag _PROTO((Strings,
							   bool *flag));
extern const char *              GetNextStringID _PROTO((Strings strings,
							 int *id));
extern bool                      GiveIdFlag _PROTO((Strings strings, int id));
extern const char *              GiveIdString _PROTO((Strings strings,
						      int id));
extern bool                      GiveIthFlag _PROTO((Strings strings, int i));
extern int                       GiveIthID _PROTO((Strings strings, int i));
extern const char *              GiveIthString _PROTO((Strings strings,
						       int i));
extern bool                      GiveStringFlag _PROTO((Strings strings,
							int id));
extern void                      InitStringList _PROTO((Strings strings));
extern Strings                   InitStrings _PROTO((void));
extern void                      JoinStrings _PROTO((Strings str1,
						     Strings str2));
extern bool                      LoadEditStrings _PROTO((Strings strings,
							 const char *file));
extern bool                      LoadStrings _PROTO((Strings strings,
						     const char *file));
extern void                      MakeStringIndex _PROTO((Strings strings));
extern void                      MarkAllStrings _PROTO((Strings strings));
extern int                       MaxStringLen _PROTO((Strings strings));
extern Strings                   PopenStrings _PROTO((const char *command));
extern Strings                   ReadStrings _PROTO((FILE *fp));
extern void                      SetIthFlag _PROTO((Strings strings, int i,
						    int flag));
extern void                      SetStringFlag _PROTO((Strings strings,
						       int id, bool flag));
extern int                       StringsSize _PROTO((Strings strings));
extern Strings                   StripStrings _PROTO((Strings strings));
extern void                      TmpAddStringID _PROTO((Strings strings,
							const char *str,
							int id,
							bool sortit));
extern void                      ToggleStringFlag _PROTO((Strings strings,
							  int id));
extern bool                      WriteStrings _PROTO((Strings strings,
						      const char *file));

	/* ./lib/misc/version.c */

extern void                      EMPNotDefined _PROTO((long option));
extern bool                      EMPOption _PROTO((long option));
extern void                      EndVersion _PROTO((void));
extern void                      FScanCommandlist _PROTO((void));
extern void                      FScanVersion _PROTO((void));
extern void                      KSUNotDefined _PROTO((long option));
extern bool                      KSUOption _PROTO((long option));
extern void                      RestoreVersion _PROTO((FILE *fp));
extern void                      SaveVersion _PROTO((FILE *fp));
extern void                      ShowVersion _PROTO((void));

	/* ./lib/misc/where.c */

extern void                      TestWhere _PROTO((void));
extern Sector                    Where _PROTO((Sector from,
					       Stack express));

	/* ./lib/nuke/alloc.c */

extern void                      FreeStockPile _PROTO((Stockp stock));
extern Stockp                    NewStockPile _PROTO((void));

	/* ./lib/nuke/build.c */

extern void                      BuildNuke _PROTO((int x, int y));
extern void                      DoBuildNuke _PROTO((int x, int y, int type));
extern void                      RedoBuildNuke _PROTO(());

	/* ./lib/nuke/data.c */

extern void                      LoadNukeShow _PROTO((FILE *fp));
extern void                      SaveNukeShow _PROTO((FILE *fp));

	/* ./lib/nuke/dump.c */

extern void                      AddStockToSct _PROTO((Sector sct,
						       Stockp stock));
extern void                      BinDumpNukes _PROTO((File fp));
extern bool                      BinRestoreNukes _PROTO((File fp));

	/* ./lib/nuke/scan.c */

extern void                      FScanNukes _PROTO((const char *fmt,
						    int flag));

	/* ./lib/nuke/scanshow.c */

extern void                      FScanNukeShowBuild _PROTO((void));
extern void                      FScanNukeShowCap _PROTO((void));

	/* ./lib/nuke/show.c */

extern int                       SelectNuke _PROTO((int x, int y,
						    Stockp stock));
extern int                       SelectNukeType _PROTO((int x, int y,
							int task));

	/* ./lib/nuke/transport.c */

extern void                      TransportNuke _PROTO((int x, int y,
						       char *what));

	/* ./lib/nuke/type.c */

extern int                       FindNukeType _PROTO((const char *name));

	/* ./lib/parse/LLgen.c */

extern void                      LLmessage _PROTO((int msg));
extern char *                    TokenName _PROTO((int value));

	/* ./lib/parse/expr.c */

extern void                      CheckType _PROTO((int *type, int desired,
						   int errcode, int argument));
extern void                      DestroyExpression _PROTO((Stack *expr));
extern Stack	                 ParseExpression _PROTO((const char *str));

	/* ./lib/parse/get_token.c */

extern Nuke                      FirstNuke _PROTO((Sector sct, int src_mod,
						   Plane plane));
extern Plane                     FirstPlane _PROTO((Sector sct, int src_mod,
						    Ship ship));
extern Ship                      FirstShip _PROTO((Sector sct, int src_mod,
						   Plane plane));
extern void                      GetTokenValue _PROTO((Sector sct,
						       int modifier,
						       int token, Ship ship,
						       Plane plane,
						       Nuke nuke,
						       struct _EvalStack *result));
extern Nuke                      NextNuke _PROTO((Nuke nuke, Plane plane));
extern Plane                     NextPlane _PROTO((Plane plane, Ship ship));
extern Ship                      NextShip _PROTO((Ship ship, Plane plane));
extern int                       SectorXCoord _PROTO((Sector sct));
extern int                       SectorYCoord _PROTO((Sector sct));
extern Sector                    WorldSector _PROTO((int x, int y));

	/* ./lib/parse/lex.c */

extern void                      LexInitStrings _PROTO((Strings strings));
extern int                       NextToken _PROTO((void));

	/* ./lib/parse/run_all.c */

extern double                    EvaluateExpression _PROTO((Sector sct,
							    struct _Stack *expr));
extern int                       RunProgram _PROTO((Sector sct, Program prog,
						    Strings outp,
						    Strings sendstr));

	/* ./lib/parse/program.inc */
extern void			 DestroyProgram _PROTO((Program *prog));
extern Program			 ParseProgram _PROTO((Strings strings));

	/* ./lib/plane/arm.c */

extern void                      RedoArm _PROTO((void));
extern void			 Arm _PROTO((int x, int y, char *what));

	/* ./lib/plane/bomb.c */

extern void                      BindBomb _PROTO((int x, int y, char *str));
extern void                      Bomb _PROTO((int x, int y));
extern void                      DoBomb _PROTO((int x, int y, Sector from,
						char *planes, char *escort,
						char *path, char *strat,
						bool confirm));
extern void                      RedoBomb _PROTO((void));

	/* ./lib/plane/build.c */

extern void                      BuildPlane _PROTO((int x, int y));
extern void                      DoBuildPlane _PROTO((int x, int y,
						      int planeid,
						      int techn));
extern void                      RedoBuildPlane _PROTO((void));

	/* ./lib/plane/drop.c */

extern void                      BindDropOff _PROTO((int x, int y, char *str));
extern void                      DoDropOff _PROTO((int x, int y, char *planes,
						   char *escort, char *trans,
						   char *path));
extern void                      DropOff _PROTO((int x, int y));
extern void                      RedoDropOff _PROTO((void));

	/* ./lib/plane/dropmines.c */

extern void                      BindDropOffMines _PROTO((int x, int y,
							  char *str));
extern void                      DoDropOffMines _PROTO((int x, int y,
							char *planes,
							char *escort,
							char *trans,
							char *path));
extern void                      DropOffMines _PROTO((int x, int y));
extern void                      RedoDropOffMines _PROTO((void));

	/* ./lib/plane/dump.c */

extern void                      BinDumpPlanes _PROTO((FILE *fp));
extern bool                      BinRestPlanes _PROTO((FILE *fp));
extern void                      RestoreShowPlane _PROTO((FILE *fp));
extern void                      SaveShowPlane _PROTO((FILE *fp));

	/* ./lib/plane/fly.c */

extern void                      BindFly _PROTO((int x, int y, char *str));
extern void                      DoFly _PROTO((int x, int y, char *planes,
					       char *escrot, char *trans,
					       char *path));
extern bool                      FeedFly _PROTO((const char *command,
						 const char *planes,
						 const char *escorts,
						 const char *strat,
						 const char *assem,
						 const char *path,
						 const char *trans));
extern void                      Fly _PROTO((int x, int y));
extern void                      RedoFly _PROTO((void));

	/* ./lib/plane/harden.c */

extern void                      Harden _PROTO((const char *what));
extern void                      RedoHarden _PROTO((void));

	/* ./lib/plane/launch.c */

extern void                      DoLaunch _PROTO((Plane plane));
extern void                      DoLaunchWing _PROTO((char *wing));
extern void                      LaunchMissile _PROTO((Plane missile));
extern void                      LaunchSatellite _PROTO((Plane plane));
extern void                      LaunchWing _PROTO((char *wing));

	/* ./lib/plane/list.c */

extern void                      ListPlanes _PROTO((int x, int y));

	/* ./lib/plane/mark.c */

extern bool                      AllMarkedPlanesHave _PROTO((int flag));
extern void                      ChargeMobility _PROTO((void));
extern bool                      ChargePetrol _PROTO((void));
extern void                      DeleteMarkedPlanes _PROTO((void));
extern void                      DropMarkedPlanes _PROTO((char item,
							  int mult,
							  Sector sct));
extern void                      FilterPlanesCantBomb _PROTO((void));
extern void                      FilterPlanesHaving _PROTO((int flag));
extern void                      FilterPlanesMob _PROTO((void));
extern void                      FilterPlanesNotHaving _PROTO((int flag));
extern int                       LoadMarked _PROTO((bool bomb_mission));
extern bool                      LoadMarkedPlanes _PROTO((char itemchar,
							  int mult));
extern void                      MarkAs20Mob _PROTO((void));
extern void                      MarkPlanes _PROTO((const char *form));
extern char *                    MarkedPlanesId _PROTO((bool mobcost));
extern int                       MaxRangeMarked _PROTO((Sector sct));
extern void                      MoveMarkedPlanes _PROTO((Sector design, int carrier));
extern void                      MoveMarkedPlanesTo _PROTO((Sector sct));
extern int                       NrMarkedPlanes _PROTO((void));
extern int                       PlaneMobCost _PROTO((Plane plane));
extern void                      UnchargePetrol _PROTO((void));
extern void                      UnloadMarkedPlanes _PROTO((char itemchar,
							    int mult));
extern void                      UnmarkAllPlanes _PROTO((void));

	/* ./lib/plane/paradrop.c */

extern void                      DoParadrop _PROTO((int x, int y));
extern void                      Paradrop _PROTO((int x, int y, char *what));
extern void                      RedoParadrop _PROTO((void));

	/* ./lib/plane/path.c */

extern const char *              AskFlyItem _PROTO((int x, int y,
						    int max_load,
						    Mission mission));
extern char *                    AskFlyRoute _PROTO((Sector start,
						     int max_dist,
						     char *comm));
extern char *                    BestFlyPath _PROTO((int sx, int sy,
						     int ex, int ey));
extern char *                    ConvEff _PROTO((char *eff));
extern Sector                    FollowOwnedPath _PROTO((Sector from,
							 char *path,
							 bool *owned));
extern Sector                    FollowPath _PROTO((Sector sct,
						    char *path));
extern void                      ParseFlyOutput _PROTO((int carrier));
extern bool			 ScanReconLine _PROTO((char *line));

	/* ./lib/plane/plane.c */

extern bool                      AddEnemyPlane _PROTO((int x, int y, int nr,
						       int owner, char *ptr));
extern void                      AddPlaneToList _PROTO((Plane plane));
extern void                      AddPlaneToSector _PROTO((Plane plane,
							  Sector sct));
extern void                      DeletePlane _PROTO((Plane plane));
extern void                      DeletePlaneFromSector _PROTO((Plane plane));
extern void                      DeletePlanes _PROTO((void));
extern int                       MaxPlaneLoad _PROTO((Plane plane));
extern void                      MovePlaneTo _PROTO((Plane plane, Sector sct));
extern Plane                     NrToPlane _PROTO((int nr));
extern void                      PageShowPlaneCBs _PROTO((void));
extern const char *              PlaneCapNames _PROTO((long flags));
extern bool                      PlaneHas _PROTO((Plane plane, long flags));
extern const char *              PlaneName _PROTO((Plane plane));
extern Sector                    PlaneSector _PROTO((Plane plane));
extern bool                      PortablePlane _PROTO((Plane plane));

	/* ./lib/plane/recon.c */

extern void                      BindRecon _PROTO((int x, int y));
extern void                      DoRecon _PROTO((int x, int y));
extern void                      Recon _PROTO((int x, int y, char *what));

	/* ./lib/plane/scan.c */

extern void                      DumpPlanes _PROTO((const char *form,
						    int flag));
extern void			 DumpSctPlanes _PROTO((Sector sct, int flag));
extern int                       FScanPlanes _PROTO((const char *list,
						     int flag));
extern void                      FScanShowPlaneBuild _PROTO((void));
extern void                      FScanShowPlaneCap _PROTO((void));
extern void                      FScanShowPlaneStat _PROTO((void));
extern int                       FindPlaneTypeByName _PROTO((const char *name,
							     bool must_exist));
extern int                       ScanPlanes _PROTO((int flag));

	/* ./lib/plane/scrap.c */

extern void                      RedoScrapPlane _PROTO((void));
extern void                      ScrapPlane _PROTO((const char *what));

	/* ./lib/plane/select.c */

extern char *                    SelectPlanes _PROTO((int x, int y, Sector sct,
						      Mission mission,
						      const char *quest));

	/* ./lib/plane/set.c */

extern bool                      SetPlane _PROTO((Plane plane, int *soldat));
extern void                      SetWing _PROTO((char wing));

	/* ./lib/plane/transport.c */

extern void                      DoTransport _PROTO((int x, int y));
extern void                      Transport _PROTO((int x, int y, char *what));

	/* ./lib/plane/wing.c */

extern char                      FirstFreeWing _PROTO((void));
extern char                      FirstWingInSct _PROTO((Sector sct));
extern char                      GiveEscortWing _PROTO((void));
extern char                      GiveNextWingInSct _PROTO((Sector sct,
							   char wing));
extern char                      NextWingInSct _PROTO((Sector sct, char wing));
extern void                      ShowFreeWings _PROTO((void));
extern bool                      WingColocated _PROTO((char wing));
extern bool                      WingEmpty _PROTO((char wing));
extern char *                    WingId _PROTO((void));
extern void                      WingJoin _PROTO((char from, char to));
extern Sector                    WingSector _PROTO((char wing));

	/* ./lib/plane/wingadd.c */

extern void                      WingAdd _PROTO((int x, int y));

	/* ./lib/plane/mission.c */

extern void			 FScanPlaneMission _PROTO((const char *list,
							   int flag));
extern void                      PMission _PROTO((Plane plane));
extern void			 ScanPlaneMission _PROTO((int flag));

	/* ./lib/ship/assault.c */

extern void                      Assault _PROTO((int x, int y));
extern void                      BindAssault _PROTO((int x, int y, char *str));
extern void                      DoAssault _PROTO((int x, int y,
						   Ship ship, int amils));
extern void                      RedoAssault _PROTO((void));

	/* ./lib/ship/board.c */

extern void                      BindBoard _PROTO((int x, int y, char *str));
extern void                      Board _PROTO((int x, int y));
extern void                      DoBoard _PROTO((int x, int y, Ship fromship));
extern void                      RedoBoard _PROTO((void));

	/* ./lib/ship/build.c */

extern void                      BuildShip _PROTO((int x, int y));
extern void                      DoBuildShip _PROTO((int x, int y,
						     int shipid, int techn));
extern void                      RedoBuildShip _PROTO((void));

	/* ./lib/ship/fleet.c */

extern char                      FirstFleetInSct _PROTO((Sector sct));
extern char                      FirstFreeFleet _PROTO((void));
extern long                      FleetAbils _PROTO((char fleet));
extern bool                      FleetColocated _PROTO((char fleet));
extern bool                      FleetEmpty _PROTO((char fleet));
extern char *                    FleetId _PROTO((void));
extern int                       FleetMinMob _PROTO((char fleet));
extern Sector                    FleetSector _PROTO((char fleet));
extern char                      GiveNextFleetInSct _PROTO((Sector sct,
							    char fleet));
extern void                      MoveFleet _PROTO((char fleet, Sector sct));
extern long                      ShipNrAbils _PROTO((int shipnr));
extern void                      ShowFreeFleets _PROTO((void));

	/* ./lib/ship/list.c */

extern void                      ListShips _PROTO((int x, int y, int enemy));

	/* ./lib/ship/mark.c */

extern int                       BestMarkedRadar _PROTO((void));
extern void                      CheckShips _PROTO((const char *what));
extern bool                      CrewOnMarkedShips _PROTO((Ship *ship));
extern void                      DeleteMarkedEnemyShips _PROTO((void));
extern void                      FScanResoMarked _PROTO((Sector sct));
extern int                       FirstMarkedShipnr _PROTO((void));
extern bool                      LandLockedMarked _PROTO((Ship *ship));
extern void                      MarkShips _PROTO((const char *form));
extern bool                      MarkedColocated _PROTO((void));
extern int                       MaxRadarMarked _PROTO((int *shnr));
extern int                       MaxSonarMarked _PROTO((int *shnr));
extern int                       MinMobMarkedShips _PROTO((Ship *ship));
extern void                      MoveMarkedTo _PROTO((Sector sct));
extern Sector                    SctMarkedShips _PROTO((void));
extern void                      UnmarkAllShips _PROTO((void));

	/* ./lib/ship/mine.c */

extern void                      BindMine _PROTO((int x, int y, char *str));
extern void                      DoMine _PROTO((const char *what, int quant));
extern void                      Mine _PROTO((const char *what));
extern void                      RedoMine _PROTO((void));

	/* ./lib/ship/navigate.c */

extern void                      BindNavigate _PROTO((int x, int y, char *str));
extern void                      DoNavigate _PROTO((int x, int y, int how));
extern void                      Navig _PROTO((int x, int y));
extern void                      Navigate _PROTO((char *nav_what));
extern void                      RedoNavigate _PROTO((void));

	/* ./lib/ship/path.c */

extern void                      AddToSList _PROTO((SList *list, Sector sct,
						    SList from, bool forw));
extern char *                    BestSeaPath _PROTO((Sector from, Sector to));
extern SList                     FirstNotMarked _PROTO((SList list));
extern void                      FreeSList _PROTO((SList *list));
extern char *                    GivePath _PROTO((SList list, Sector sct));
extern bool                      InSList _PROTO((SList list, Sector sct));
extern bool			 NavigOK _PROTO((Sector sct));

	/* ./lib/ship/scrap.c */

extern void                      RedoScrap _PROTO((void));
extern void                      ScrapShip _PROTO((const char *what));

	/* ./lib/ship/select.c */

extern char *                    SelectShips _PROTO((int x, int y,
						     ShTask shtask,
						     const char *quest));

	/* ./lib/ship/set.c */

extern void                      SetShip _PROTO((Ship ship));

	/* ./lib/ship/ship.c */

extern bool                      AddEnemyShip _PROTO((int x, int y,
						      int nr, int owner,
						      char *ptr));
extern void                      AddShipToList _PROTO((Ship ship));
extern void                      AddShipToSector _PROTO((Ship ship,
							 Sector sct));
extern int                       AskCarrier _PROTO((int x, int y,
						    Sector sct,
						    bool heli));
extern Ship                      AskShip _PROTO((int x, int y,
						 const char *quest,
						 bool allow_others));
extern void                      DeleteEnemyShips _PROTO((void));
extern void                      DeleteShip _PROTO((Ship ship));
extern void                      DeleteShipFromSector _PROTO((Ship ship));
extern void                      DoLookout _PROTO((Sector sct, int nr,
						   bool in_nav,
						   int print,
						   bool force));
extern int                       FindShipTypeByName _PROTO((const char *name,
							    bool must_exist));
extern void                      FleetAdd _PROTO((int x, int y));
extern int                       GiveShipQuant _PROTO((Ship ship, char item));
extern const char *              GiveShipQuantStr _PROTO((Ship ship, char id));
extern bool                      KnowsResoShip _PROTO((Ship ship));
extern int                       MaxShipCargo _PROTO((Ship ship, char itemch));
extern void                      MoveShip _PROTO((Ship ship, Sector to));
extern Ship                      NrToShip _PROTO((int nr));
extern void                      PageShowShipCBs _PROTO((void));
extern bool                      SectorHasOwnedShips _PROTO((Sector sct,
							     int n));
extern void                      SetSectorShipsNr _PROTO((Sector sct));
extern void                      SetShipQuant _PROTO((Ship ship, char item,
						      int value));
extern void                      SetShipValues _PROTO((Ship ship,
						       char *ship_name));
extern bool                      ShipAtSect _PROTO((Sector sct, char let));
extern bool                      ShipAtWith _PROTO((Sector sct, long flag));
extern const char *              ShipCapNames _PROTO((long flags));
extern const char *              ShipCargoNames _PROTO((int cargo[]));
extern char                      ShipCharInSector _PROTO((Sector sct));
extern double                    ShipFireRange _PROTO((Ship ship));
extern bool                      ShipHas _PROTO((Ship ship, long flags));
extern bool                      ShipHasRadar _PROTO((Ship ship));
extern bool                      ShipHasSonar _PROTO((Ship ship));
extern int                       ShipMaxGuns _PROTO((Ship ship));
extern const char *              ShipName _PROTO((Ship ship));
extern bool                      ShipOnList _PROTO((Ship ship));
extern Sector                    ShipSector _PROTO((Ship ship));
extern void                      ShowShipCBStrings _PROTO((Strings strings));

	/* ./lib/ship/shipscan.c */

extern void                      CheckMarkedShips _PROTO((void));
extern void                      DumpRealmShips _PROTO((const char *realm,
							int flag));
extern void                      DumpSctShips _PROTO((Sector sct, int flag));
extern int                       DumpShips _PROTO((const char *list,
						   int flag));
extern void                      FScanCargo _PROTO((const char*list,
						    int flag));
extern void                      FScanReso _PROTO((void));
extern int                       FScanShips _PROTO((const char *list,
						    int flag));
extern void                      FScanShowShipBuild _PROTO((void));
extern void                      FScanShowShipCap _PROTO((void));
extern void                      FScanShowShipStats _PROTO((void));
extern void                      FeedRadarShips _PROTO((void));
extern void                      MarkAllShips _PROTO((void));
extern void                      MarkShip _PROTO((Ship ship));
extern void                      MarkShipsInSct _PROTO((Sector sct));
extern void                      RedumpFleet _PROTO((char fleet, int flag));
extern void                      RedumpShip _PROTO((Ship ship, int flag));
extern void                      RestoreShowShip _PROTO((FILE *fp));
extern void                      SaveShowShip _PROTO((FILE *fp));
extern void                      ScanCargo _PROTO((int flag));
extern int                       ScanShips _PROTO((int flag));
extern void                      SearchMarkedShips _PROTO((int flag));

	/* ./lib/ship/tend.c */

extern void                      BindTend _PROTO((int x, int y, char *args));
extern void                      DoTend _PROTO((int x, int y, Ship ship,
						int item, int amount));
extern void                      RedoTend _PROTO((void));
extern void                      Tend _PROTO((int x, int y, Ship ship));

	/* ./lib/ship/upgrade.c */

extern void                      RedoUpgrade _PROTO((void));
extern void                      UpgradeShip _PROTO((const char *what));

	/* ./lib/ship/scuttle.c */

extern void                      RedoScuttle _PROTO((void));
extern void                      ScuttleShip _PROTO((const char *what));

	/* ./lib/ship/mission.c */
extern void			 ChangeFleetMission _PROTO((char fleet));
extern void                      SMission _PROTO((Ship ship));
extern const char 		*FleetHasMission _PROTO((char fleet));
extern void			 FScanShipMission _PROTO((const char *list,
							  int flag));
extern void			 ScanShipMission _PROTO((int flag));

	/* ./lib/ship/order.c */
extern void 			 ChangeCargo _PROTO((Ship ship));
extern void			 ChangeFleetOrder _PROTO((char fleet));
extern void 			 ChangeOrder _PROTO((Ship ship));
extern Sector			 ChooseSeaDest _PROTO((Sector sct,
						       char **path));
extern const char 		*FleetHasOrders _PROTO((char fleet));
extern void			 FScanShipOrders _PROTO((const char *list,
							 int flag));
extern void			 FScanShipQOrders _PROTO((const char *list,
							  int flag));
extern const char 		*ShipHasCargo _PROTO((Ship ship));
extern const char 		*ShipHasOrders _PROTO((Ship ship));
extern void 			 ScanShipOrders _PROTO((int flag));
extern void 			 ScanShipQOrders _PROTO((int flag));

	/* ./lib/ship/retreat.c */
extern void			 ChangeFleetRetreat _PROTO((char fleet));
extern const char		*FleetHasRetreat _PROTO((char fleet));
extern void			 FScanShipRetreat _PROTO((const char *list,
							  int flag));
extern const char 		*RtrtList _PROTO((uchar cond));
extern void			 ScanShipRetreat _PROTO((int flag));
extern void                      SRetreat _PROTO((Ship ship));

	/* ./lib/ship/selectone.c */

extern Ship                    SelectOneShip _PROTO((int x,
						     int y,
						     ShTask shtask,
						     const char *quest));

	/* ./lib/update/census.c */

extern void                      CensusPlanProduce _PROTO((WinInfo win, int y,
							   char des,
							   int civeff,
							   int civwork,
							   Sector sct));
extern void                      CensusProduce _PROTO((Sector sct, int line));

	/* ./lib/update/deliver.c */

extern void                      UpdDeliver _PROTO((Sector from, int item,
						    Strings strings));

	/* ./lib/update/distribute.c */

extern void                      UpdDistribute _PROTO((Sector from,
						       Strings strings,
						       int what));

	/* ./lib/update/human.c */

extern int                       CalcMaxPop _PROTO((void));
extern int			 FeedLandPeople _PROTO((Land land, int etus,
							bool upd));
extern int                       FeedSctPeople _PROTO((Sector sct, int etus,
						       bool upd));
extern int                       FeedShipPeople _PROTO((Ship ship, int etus,
							bool upd));
extern int                       GrowPeople _PROTO((Sector sct, int etus,
						    bool upd,
						    Strings strings));
extern int                       chance _PROTO((double d));
extern int                       roundavg _PROTO((double val));

	/* ./lib/update/main.c */

extern void                      SimulateUpdate _PROTO((char *realm));

	/* ./lib/update/mobility.c */

extern void                      UpdMobLand _PROTO((char *realm, int etus));
extern void                      UpdMobPlane _PROTO((char *realm, int etus));
extern void                      UpdMobSect _PROTO((char *realm, int etus));
extern void                      UpdMobShip _PROTO((char *realm, int etus));

	/* ./lib/update/plane.c */

extern int                       UpdProdPlane _PROTO((char *realm, int etus,
						      Strings strings));

	/* ./lib/update/populace.c */

extern double                    PopulaceSct _PROTO((Sector sct));
extern double                    PopulaceSct2 _PROTO((Sector sct, int etus,
						      int *line));
extern void                      Starvation _PROTO((Sector sct));

	/* ./lib/update/produce.c */

extern int                       UpdProduce _PROTO((Sector sct, int work,
						    Strings strings));
extern int                       materials_charge _PROTO((struct pchrstr *prod,
							  Sector sct,
							  int count));
extern int                       materials_cost _PROTO((struct pchrstr *prod,
							Sector sct,
							int *costp));

	/* ./lib/update/sect.c */

extern int                       BuildEff _PROTO((Sector sct, int work));
extern int                       GrowFood _PROTO((Sector sct, int work,
						  int etus));
extern int                       UpdEnlist _PROTO((Sector sct, int etus,
						   bool upd));
extern void                      UpdProdSect _PROTO((char *realm, int etus,
						     Strings strings));

	/* ./lib/update/ship.c */

extern void                      UpdProdShip _PROTO((char *realm, int etus,
						     Strings strings));
extern bool                      UpdShipRepair _PROTO((Ship ship, int etus));

	/* ./lib/util/f_cargo.c */

extern int                       EditCargo _PROTO((WinInfo win, Ferry ferry,
						   bool init));
extern void                      RunCargoFerry _PROTO((Ferry ferry));

	/* ./lib/util/f_goto.c */

extern int                       EditGoto _PROTO((WinInfo win, Ferry ferry,
						  bool init));
extern void                      RunGotoFerry _PROTO((Ferry ferry));

	/* ./lib/util/ferry.c */

extern void                      ChangeFerry _PROTO((char fleet, Ship ship));
extern char *                    CheckFlSh _PROTO((Ferry ferry));
extern char *                    CheckSector _PROTO((int x, int y, int task));
extern void                      DeleteFerry _PROTO((int id));
extern void                      DoFerry _PROTO((int id));
extern void                      DoFerryUtil _PROTO((char *args));
extern bool                      FerButPressed _PROTO((int x, int sx,
						       int len));
extern void                      FerButton _PROTO((WinInfo win, int x, int y,
						   char *str));
extern int                       FerryMinMob _PROTO((Ferry ferry));
extern char *                    FerryPos _PROTO((Ferry ferry));
extern Sector                    FerrySector _PROTO((Ferry ferry));
extern void                      FerryStat _PROTO((int x, int y, bool towm));
extern void                      FerryUtil _PROTO((int x, int y));
extern void                      GotoFerry _PROTO((void));
extern char *                    HasFerry _PROTO((char fleet, Ship ship));
extern void                      ListComplFerries _PROTO((void));
extern void                      ListSectorFerries _PROTO((void));
extern bool                      NavigPath _PROTO((char fleet, int shipnr,
						   int *x, int *y, Sector to));
extern int                       NrShipsInFerry _PROTO((Ferry ferry));
extern void                      ReadFerries _PROTO((FILE *fp));
extern void                      SaveFerries _PROTO((FILE *fp));
extern bool                      SelSector _PROTO((WinInfo win, int line,
						   char *str, bool def,
						   int *x, int *y));
extern bool                      SelectFlSh _PROTO((WinInfo win, int y,
						    Ferry ferry));
extern void                      SetXAtButton _PROTO((int *x, char ch));

	/* ./lib/util/mail.c */

extern void                      AddMail _PROTO((Strings strings,
						 const char *header));
extern void                      Announce _PROTO((int x, int y));
extern void                      AppendSignature _PROTO((Strings strings));
extern void                      BindReRead _PROTO((int x, int y, char *str));
extern void                      BindRead _PROTO((int x, int y, char *str));
extern void                      BindSend _PROTO((int x, int y, char *str));
extern void                      Commun _PROTO((int x, int y));
extern bool                      FScanReadTels _PROTO((void));
extern bool                      FScanReadWirs _PROTO((void));
extern void                      InfoMailMenu _PROTO((int x, int y, int i));
extern char			*LastProduction _PROTO((void));
extern void                      MailMenu _PROTO((int x, int y));
extern void                      News _PROTO((int x, int y));
extern int                       ParseReadArg _PROTO((char *str));
extern void                      RestoreMail _PROTO((FILE *fp));
extern void                      SaveMail _PROTO((FILE *fp));
extern bool                      SendTelegram _PROTO((int x, int y,
						      char *country));
extern void                      ShowHeadLines _PROTO((int x, int y));
extern void                      ShowMail _PROTO((int x, int y, int types));

	/* ./lib/util/natinfo.c */

extern void                      UtilNatInfo _PROTO((int x, int y));

	/* ./lib/util/plan.c */

extern void                      CensusLayPlan _PROTO((void));
extern Strings                   DoRunPlan _PROTO((Sector sct));
extern bool                      HasPlan _PROTO((Sector sct));
extern void                      InitPlanOptions _PROTO((void));
extern bool                      IsActive _PROTO((Sector sct));
extern void                      LoadPlanInfo _PROTO((Sector sct, FILE *fp));
extern void                      LoadPlanOptions _PROTO((FILE *fp));
extern PlanEntry                 NewPlanEntry _PROTO((int x, int y, char des));
extern void                      PlanCensus _PROTO((Sector sct));
extern void                      PlanCensusButton _PROTO((int x, int y));
extern char                      PlanDesign _PROTO((PlanEntry plan));
extern void                      PlanUtil _PROTO((int wx, int wy));
extern void                      RunPlan _PROTO((void));
extern void                      RunPlanRec _PROTO((Sector sct, DSList from,
						    DSList to, int *civ_from,
						    int *civ_to,
						    Strings strings));
extern void                      SavePlanInfo _PROTO((Sector sct, FILE *fp));
extern void                      SavePlanOptions _PROTO((FILE *fp));
extern void                      UtilPlan _PROTO((char *arg));

	/* ./lib/util/power.c */

extern void			 DisplayPower _PROTO((void));
extern void                      FreePowerList _PROTO((void));
extern void                      PrintPowerEntry _PROTO((WinInfo win,
							 int natid,
							 int start_y));
extern void                      ScanNewPower _PROTO((void));
extern void                      ScanPower _PROTO((void));

	/* ./lib/util/production.c */


extern void			 DumpPlague _PROTO((void));
extern void			 DumpHappines _PROTO((void));
extern int			 HappinesState _PROTO((Sector sct));
extern bool			 IsBadDistr _PROTO((Sector sct));
extern bool			 IsHappy _PROTO((Sector sct));
extern bool			 IsPlague _PROTO((Sector sct));
extern int			 PlagueStage _PROTO((Sector sct));
extern void                      ReadProduction _PROTO((const char *file));
extern void                      UpdateProduction _PROTO((char *string));
extern char *                    alloc_production _PROTO((void));

	/* ./lib/util/prog.c */

extern bool                      FileExists _PROTO((const char *file));
extern int                       ProgChoice _PROTO((int x, int y));
extern const char *              ProgFile _PROTO((const char *file));
extern Program                   SelectProgram _PROTO((int x, int y));
extern char *                    SelectProgramFromDir _PROTO((int x, int y));
extern void                      UtilRunProg _PROTO((char *arg));

	/* ./lib/util/relat.c */

extern void                      FreeRelInfo _PROTO((RelInfo rel));
extern void                      PrintRelations _PROTO((Strings strings,
							RelInfo rel));
extern int                       RelLines _PROTO((RelInfo rel));
extern RelInfo                   ScanRelationsAs _PROTO((int country));

	/* ./lib/util/report.c */

extern void                      FreeReportInfo _PROTO((RepInfo info));
extern void                      PrintRepInfo _PROTO((Strings strings,
						      RepInfo info));
extern RepInfo                   ScanReportAs _PROTO((int country));

	/* ./lib/util/strstr.c */

extern char *                    StrStr _PROTO((char *string,
						const char *sub));

	/* ./lib/util/ve.c */

extern void                      VeUtil _PROTO((char *args));

#ifdef TERMC_VERSION
	/* ./termc/bind.c */

extern char *                    AddBindingKey _PROTO((char *key, char *bind));
extern void                      BindKeys _PROTO((int x, int y));
extern void                      GlobalKey _PROTO((char ch));

	/* ./termc/dummy.c */

extern void                      ReverseCursor _PROTO((void));
extern void                      SetDefaultCursor _PROTO((WinInfo win,
							  int curs));

	/* ./termc/event.c */

extern int                       CharToButton _PROTO(());
extern WinInfo                   EventWindow _PROTO(());
extern void                      MainLoop _PROTO(());
extern void                      NextEvent _PROTO(());
extern bool                      SelButtonAtWin _PROTO(());
extern void                      SelectButtonChar _PROTO(());
extern bool                      SelectSctCrd _PROTO(());
extern Sector                    SelectSector _PROTO(());
extern bool                      StandardChar _PROTO(());
extern bool                      StandardEvent _PROTO(());
extern void                      WaitButtonPress _PROTO(());

	/* ./termc/misc.c */

extern void                      BusyCursor _PROTO(());
extern void                      DrawArrow _PROTO(());
extern void                      DrawHorizontal _PROTO(());
extern char *                    GetString _PROTO(());
extern void                      ResetCursor _PROTO(());

	/* ./termc/pager.c */

extern void                      AddPagerFunc _PROTO(());
extern void                      AddPagerToWMList _PROTO(());
extern void                      ChangePagerString _PROTO(());
extern void                      DumpPager _PROTO(());
extern void                      DumpPagerScreen _PROTO(());
extern bool                      EditPager _PROTO(());
extern void                      FpDumpPager _PROTO(());
extern void                      FreePager _PROTO(());
extern Pager                     InitPager _PROTO(());
extern char *                    InputPagerLine _PROTO(());
extern void                      MapPager _PROTO(());
extern void                      MapPagerFromBot _PROTO(());
extern void                      MapPagerFromTop _PROTO(());
extern int                       PagerMenu _PROTO(());
extern int                       PagerMenuFunc _PROTO(());
extern char *                    PagerMulti _PROTO(());
extern Strings                   PagerStrings _PROTO(());
extern void                      RemapPager _PROTO(());
extern void                      SetEditPager _PROTO(());
extern void                      SetInfoOnPager _PROTO(());
extern void                      SetPagerButtonIDs _PROTO(());
extern void                      SetPagerButtons _PROTO(());
extern void                      SetPagerSelect _PROTO(());
extern int                       ShowPager _PROTO(());
extern void                      ShowPagerLine _PROTO(());
extern void                      ShowStringsInPager _PROTO(());

	/* ./termc/realm.c */

extern char *                    MySelRealm _PROTO(());

	/* ./termc/tinit.c */

extern void                      InitTermcap _PROTO(());
extern int                       put _PROTO(());

	/* ./termc/window.c */

extern char **                   AllocScreen _PROTO(());
extern bool                      AtBottum _PROTO(());
extern void                      Bell _PROTO(());
extern void                      ClearLine _PROTO(());
extern void                      ClearWindow _PROTO(());
extern void                      CursorUp _PROTO(());
extern void                      DestroyWindow _PROTO(());
extern void                      DrawScrollBar _PROTO(());
extern void                      DumpLine _PROTO(());
extern void                      DumpWindow _PROTO(());
extern WinInfo                   FindWindow _PROTO(());
extern void                      FlashWindow _PROTO(());
extern void                      FlushWindow _PROTO(());
extern void                      HideCursor _PROTO(());
extern void                      InitTermc _PROTO(());
extern void                      LowerAll _PROTO(());
extern void                      LowerEmpWin _PROTO(());
extern void                      LowerWindow _PROTO(());
extern WinInfo                   OpenRelToRoot _PROTO(());
extern WinInfo                   OpenWindow _PROTO(());
extern void                      Pause _PROTO(());
extern void                      Print _PROTO(());
extern void                      PrintB _PROTO(());
extern void                      PrintMarked _PROTO(());
extern void                      PrintMarkedB _PROTO(());
extern void                      PrintMarkedN _PROTO(());
extern void                      PrintN _PROTO(());
extern void                      QuitTermc _PROTO(());
extern void                      RaiseAll _PROTO(());
extern void                      RaiseEmpWin _PROTO(());
extern void                      RaiseWindow _PROTO(());
extern void                      Redraw _PROTO(());
extern void                      Refresh _PROTO(());
extern void                      RefreshWindow _PROTO(());
extern void                      RefreshWindowPart _PROTO(());
extern void                      Scroll _PROTO(());
extern void                      ScrollDown _PROTO(());
extern void                      ScrollUp _PROTO(());
extern void                      SetMode _PROTO(());
extern void                      SetToBot _PROTO(());
extern void                      SetToTop _PROTO(());
extern void                      ShowCursor _PROTO(());
extern void                      SiPut _PROTO(());
extern void                      WdPut _PROTO(());
#endif

#ifdef X_VERSION
	/* ./x/pager.c */

extern void                      AddPagerFunc _PROTO((Pager pager,
						      const char *name,
						      int id));
extern void                      AddPagerToWMList _PROTO((Pager pager));
extern void                      ChangePagerString _PROTO((Pager pager,
							   int id,
							   char *newstr));
extern int			 ChooseMenu _PROTO((Strings strings,
						    const char *title,
						    WinInfo parent,
						    int x, int y,
						    InfoProc proc));
extern Strings			 EditText _PROTO((const char *title,
						  Strings strings,
						  const char *action,
						  WinInfo parent,
						  int x, int y));
extern bool                      EditPager _PROTO((Pager pager));
extern void                      FreePager _PROTO((Pager pager));
extern Pager			 InitMenu _PROTO((Strings strings,
						  const char *title));
extern Pager                     InitPager _PROTO((Strings strings,
						   const char *header));
extern void                      InitWMPager _PROTO((Strings string,
						     const char *name));
extern char *                    InputPager _PROTO((Pager pager, int y,
						    int xs, int xe,
						    const char *form));
extern char *                    InputPagerLine _PROTO((Pager pager, int y));
extern void                      LoadPagerText _PROTO((Pager pager));
extern int			 MakePickDialog _PROTO((Strings strings,
							const char *title,
							FuncList fnxs[],
							void *data,
							WinInfo parent,
							int x, int y,
							bool multi));
extern void                      MapPager _PROTO((Pager pager, WinInfo win,
						  int x, int y,
						  bool fromtop, bool towm));
extern void                      MapPagerFromBot _PROTO((Pager pager,
							 WinInfo win,
							 int x, int y));
extern void                      MapPagerFromTop _PROTO((Pager pager,
							 WinInfo win,
							 int x, int y));
extern int			 MultiSelectPager _PROTO((Strings strings,
							  const char *title,
							  const char *middle,
							  int mfunc,
							  InfoProc proc));
extern bool                      PagerEvent _PROTO((XEvent *pevent));
extern int                       PagerMenu _PROTO((Pager pager));
extern int                       PagerMenuFunc _PROTO((Pager pager,
						       int *ret,
						       int *pcols));
extern char *                    PagerMulti _PROTO((Pager pager, int *pfunc));
extern void                      RemapPager _PROTO((Pager pager));
extern void                      RemapPagerToWM _PROTO((Pager pager));
extern void                      SetEditPager _PROTO((Pager pager));
extern void                      SetInfoOnPager _PROTO((Pager pager,
							InfoProc proc));
extern void                      SetPagerButtonIDs _PROTO((Pager pager,
							   int left,
							   int middle,
							   int right));
extern void                      SetPagerButtons _PROTO((Pager pager,
							 const char *left,
							 const char *middle,
							 const char *right));
extern void                      SetPagerSelect _PROTO((Pager pager));
extern int                       ShowPager _PROTO((Pager pager));
extern void                      ShowPagerLine _PROTO((Pager pager, int y));
extern void			 ShowStringsInPager _PROTO((Strings strings,
							    const char *header));
extern Strings                   StringsFromPager _PROTO((Pager pager));
extern void			 ViewPagerStrings _PROTO((const char *title,
							  Strings strings,
							  WinInfo parent,
							  int x, int y));

	/* ./x/realm.c */

extern char *                    MySelRealm _PROTO((void));
extern void                      ShowBox _PROTO((int sx, int sy,
						 int ex, int ey));

	/* ./x/xbind.c */

extern char *                    AddBindingKey _PROTO((char *key, char *bind));
extern void                      BindKeys _PROTO((int x, int y));
extern void                      GlobalKey _PROTO((XEvent *pevent));

	/* ./x/xevents.c */

extern void                      CheckRefreshEvents _PROTO((void));
extern void                      HandelWaitingEvents _PROTO((void));
extern void                      MainLoop _PROTO((void));
extern bool                      StandardEvent _PROTO((XEvent *pevent));

	/* ./x/xicons.c */

extern void                      InitIcons _PROTO((void));
extern void                      ReverseCursor _PROTO((int type, bool rev));
extern void                      SetDefaultCursor _PROTO((WinInfo win,
							  int type));
extern void                      SetScrollbarCursor _PROTO((Drawable win));

	/* ./x/xinit.c */

extern int                       CharToPixelX _PROTO((int x));
extern int                       CharToPixelY _PROTO((int y));
extern int                       CharToPixelYB _PROTO((int y));
extern void                      InitX _PROTO((const char *font,
					       const char *bfont));
extern int			 OurErrorHandler _PROTO((Display *disp,
							 XErrorEvent *event));
extern int                       OurFatalErrorHandler _PROTO((Display *display));
extern int                       PixelToCharX _PROTO((int x));
extern int                       PixelToCharY _PROTO((int y));
extern int                       PixelToCharYB _PROTO((int y));
extern void                      QuitX _PROTO((void));
extern void                      Refresh _PROTO((void));
extern void                      WaitRefresh _PROTO((bool discard));

	/* ./x/xmisc.c */

extern void                      Pause _PROTO((void));
extern bool                      SelButtonAtWin _PROTO((WinInfo win,
							int *x, int *y,
							int *button));
extern bool                      SelectSctCrd _PROTO((int *x, int *y,
						      int *button));
extern Sector                    SelectSector _PROTO((int *button));
extern bool                      SetInterrupt _PROTO((XEvent *pevent));
extern void                      WaitButtonPress _PROTO((int *button));

	/* ./x/xwindow.c */

extern void                      Bell _PROTO((void));
extern void                      BusyCursor _PROTO((void));
extern void                      ChangeWindowBase _PROTO((WinInfo win,
							  int base));
extern void                      ClearLine _PROTO((WinInfo win, int y));
extern void                      ClearWindow _PROTO((WinInfo win));
extern void                      DestroyWindow _PROTO((WinInfo win));
extern void                      DrawArrow _PROTO((WinInfo win,
						   int x, int y,
						   char dir));
extern void                      DrawHorizontal _PROTO((WinInfo win,
							int pos));
extern void                      DrawRect _PROTO((WinInfo win,
						  int x, int y,
						  int width, int height));
extern WinInfo                   EventWindow _PROTO((XEvent *event));
extern void                      FlashWindow _PROTO((WinInfo win));
extern void                      FlushWindow _PROTO((WinInfo win));
extern int                       GetPixmapPosX _PROTO((WinInfo win, int x));
extern int                       GetPixmapPosY _PROTO((WinInfo win, int y));
extern char *                    GetString _PROTO((WinInfo win,
						   int x, int y,
						   int maxlen,
						   const char *form));
extern void			 InitXIcon _PROTO((WinInfo win));
extern void                      Line _PROTO((WinInfo win,
					      int sx, int sy,
					      int ex, int ey));
extern void                      LowerAll _PROTO((void));
extern void                      LowerWindow _PROTO((WinInfo win));
extern void                      MapWindow _PROTO((WinInfo win));
extern WinInfo			 OpenBaseWindow _PROTO((int x, int y,
							int width,
							int height));
extern WinInfo			 OpenCensusWindow _PROTO((WinInfo win));
extern WinInfo			 OpenEmpireWindow _PROTO((WinInfo win,
							  int inc_y,
							  int inc_width,
							  int inc_height,
							  int savelines,
							  int *widthp,
							  int *heightp));
extern WinInfo			 OpenMapWindow _PROTO((WinInfo parent,
						       int x, int y,
						       int iw, int ih,
						       int *widthp,
						       int *heightp));
extern WinInfo			 OpenMessageWindow _PROTO((WinInfo parent,
							   int iwidth,
							   int *mwidth));
extern WinInfo                   OpenRelToRoot _PROTO((WinInfo from,
						       int x, int y,
						       int width, int height,
						       int base,
						       int savelines));
extern WinInfo			 OpenVersionWindow _PROTO((WinInfo parent,
							   int width,
							   int height));
extern WinInfo                   OpenWinForWM _PROTO((const char *name,
						      int x, int y,
						      int width, int height,
						      int base,
						      int savelines));
extern WinInfo                   OpenWindow _PROTO((WinInfo win,
						    int x, int y,
						    int width, int height,
						    int base, int box,
						    int savelines));
extern void                      Print _PROTO((WinInfo win,
					       int x, int y,
					       const char *text, int mode));
extern void                      PrintAtPixmapB _PROTO((WinInfo win,
							int x, int y,
							const char *text));
extern void                      PrintAtPixmapN _PROTO((WinInfo win,
							int x, int y,
							const char *text));
extern void                      PrintB _PROTO((WinInfo win, int x, int y,
						const char *text));
extern void                      PrintMarked _PROTO((WinInfo win,
						     int x, int y,
						     const char *text,
						     int mode));
extern void                      PrintMarkedAtPixmap _PROTO((WinInfo win,
							     int x, int y,
							     const char *text,
							     int mode));
extern void                      PrintN _PROTO((WinInfo win,
						int x, int y,
						const char *text));
extern void                      PrintPixmap _PROTO((WinInfo win,
						     int x, int y,
						     Pixmap pixmap));
extern void                      PrintR _PROTO((WinInfo win,
						int x, int y,
						const char *text));
extern void                      RaiseAll _PROTO((void));
extern void                      RaiseWindow _PROTO((WinInfo win));
extern void                      RefreshEvent _PROTO((XEvent *event));
extern void                      ResetCursor _PROTO((void));
extern void                      ReverseWindow _PROTO((WinInfo win));
extern void                      Scroll _PROTO((WinInfo win, int lines));
extern bool                      ScrollEvent _PROTO((XEvent *pevent));
extern void                      ScrollHorz _PROTO((WinInfo win, int cols));
extern void                      SelectEvents _PROTO((WinInfo win,
						      unsigned long events));
extern void                      SetCursor _PROTO((WinInfo win,
						   Cursor cursor));
extern void                      SetScrollRegion _PROTO((WinInfo win,
							 int sx, int sy,
							 int ex, int ey));
extern void                      SetToBot _PROTO((WinInfo win));
extern void                      SetToTop _PROTO((WinInfo win));
extern void                      UnmapWindow _PROTO((WinInfo win));
extern void                      WarpPointer _PROTO((WinInfo win,
						     int x, int y));
extern bool                      WinHasScrollBar _PROTO((WinInfo win));
extern int                       WinHeight _PROTO((WinInfo win));
extern int                       WinWidth _PROTO((WinInfo win));
extern void                      XorBox _PROTO((WinInfo win,
						int psx, int psy,
						int pex, int pey));
extern void                      XorLine _PROTO((WinInfo win,
						 int psx, int psy,
						 int pex, int pey));

#endif
