/*
    $Header: /a/victor/nexor/user4/jpo/xemp/xemp5.0/x/RCS/xwindow.c,v 5.3 1995/10/24 15:50:48 jpo Exp $
    $Date: 1995/10/24 15:50:48 $
    $Author: jpo $
    $Id: xwindow.c,v 5.3 1995/10/24 15:50:48 jpo Exp $
    $Locker:  $
    $Log: xwindow.c,v $
    Revision 5.3  1995/10/24 15:50:48  jpo
    Changed the way InitIcons works

    Revision 5.2  1995/09/08 07:51:45  jpo
    const

 * Revision 5.1  93/03/14  16:35:54  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:26:31  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:00:52  greyhelm
 * Add RCS logging - Karl Hagen
 *

*/
	/*
	 *	Emptool				<file: xwindow.c>
	 *	
	 *	Written by Hj Visscher.
	 *
	 *	OpenWindow (WinInfo from, x, y, width, height, base, popup)
	 *		Opens a new window at window x, y. If it's a popup 
	 *		window, the color's will be reversed, the save_under
	 *		flag will be set and it will be added to the list.
	 *		It retuns a pointer to a (new allocated) structure,
	 *		which must be used by all drawing operations. If base
	 *		equals CHARS (<-> PIXELS) the coordinates are converted
	 *		to pixels.
	 *
	 *	DestroyWindow (WinInfo win)
	 *		Frees all resources used by the window, destroyes it
	 *		and removes it from the list.
	 *
	 *	SelectEvents (WinInfo win, events)
	 *		Set the events for the window in win.
	 *
	 *	SetCursor (WinInfo win, Cursor cursor)
	 *		Defines the cursor for the window of win.
	 *
	 *	BusyCursor ()
	 *		Set cursor in all windows to the busy_cursor. Also
	 *		disables all events.
	 *
	 *	ResetCursor ()
	 *		Reset all cursors. Reset all events.
	 */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <X11/keysymdef.h>

#include "type.h"
#include "xextern.h"
#include "main.h"
#include "sector.h"
#include "xemp_icon.h"


struct region
{
	int low_x, low_y, high_x, high_y;
	int width, height;
};

char windowname[BUFSIZ];

struct s_wininfo
{
	Window window;
	Window scrollwindow;
	Pixmap pixmap;
	GC normal_gc;
	GC bold_gc;
	GC rev_gc;
	Cursor cursor;
	unsigned long events;
	int menuflag;
	int pixsavelines;	/* in pixels */
	int charsavelines;	/* in chars */
	int curline;		/* in pixels, only defined when savelines > 0 */
	double mult;
	int base;		/* currently in pixel or char mode */
	struct region pix_dim;
	struct region char_dim;
	struct region scroll;
	struct s_wininfo *next;
};

static WinInfo first_window = (WinInfo) 0;
static const char * window_name;

extern Cursor cr_busy;	/* from xicons.c */

#define SCROLLBAR_WIDTH	CharToPixelX (1)

void InitXIcon(w)
WinInfo w;
{

	XWMHints wmhints;

	bzero ((char *)&wmhints, sizeof wmhints);
	wmhints.flags = IconPixmapHint;
	wmhints.icon_pixmap = XCreateBitmapFromData(display,
						    w->window,
						    xemp_icon_bits, 64, 48);
	XSetWMHints(display, w->window, &wmhints);
}

static void DrawScrollBar (win)
WinInfo win;
{
 	int height_marked, start_marked;
 
 	if (win-> pixsavelines <= 0)
 		return;
 
 	height_marked = (int) (win-> mult * win-> pix_dim.height);
	start_marked = (int) (win-> mult * win-> curline);

		/* clear-window */
 	XFillRectangle (
 		display,
 		win-> scrollwindow,
 		XOR (win-> menuflag == MENU, reversed)?gc_normal:gc_inv_normal,
 		1, 0,
 		SCROLLBAR_WIDTH - 2,  win-> pix_dim.height);
 
		/* fill part */
 	XFillRectangle (
 		display,
 		win-> scrollwindow,
 		XOR (win-> menuflag == MENU, reversed)?gc_inv_normal:gc_normal,
 		1, start_marked,
 		SCROLLBAR_WIDTH - 2, height_marked + 1);
}

void ClearWindow (win)
WinInfo win;
{
	XFillRectangle (
		display,
		win-> pixmap,
		XOR (win-> menuflag == MENU, reversed)?gc_normal:gc_inv_normal,
		0, 0,
		win-> pix_dim.width, win-> pix_dim.height + win-> pixsavelines);
}

WinInfo OpenBaseWindow (x, y, width, height)
int x, y;
int width, height;
{
	WinInfo base;

	/* 
	 *	initialize the X-server with the fonts (normal & bold)
	 */

	InitIcons ();
	base = OpenWindow ((WinInfo) 0,
			   x, y,
			   width, height,
			   CHARS, FIXED, 0);
	InitXIcon (base);
	return base;
}

WinInfo OpenWindow (from, x, y, width, height, base, menuflag, savelines)
WinInfo from;
int x, y, width, height;
int menuflag, base;
{
	WinInfo new;
	Window parent;
	XSizeHints hints;
	XWMHints wmhints;
	int addx, addy, pixx, pixy, pixwidth, pixheight, pixsavelines;
	int bwidth;
	bool wm, adjust_pos;

	adjust_pos = True;
	wm = False;

	if (menuflag == WM_MENU)
	{
		wm = True;
		menuflag = MENU;
	}
	else if (menuflag == SUBWINDOW)
	{
		adjust_pos = False;
		menuflag = MENU;
	}

	new = (WinInfo) doalloc ((unsigned) sizeof (struct s_wininfo));

	if (base == CHARS)
	{
		new-> charsavelines = savelines;
		new-> pixsavelines = pixsavelines = CharToPixelY (savelines);
		pixx = CharToPixelX (x);
		pixy = CharToPixelY (y);
		pixwidth = CharToPixelX (width);
		pixheight = CharToPixelY (height);
	}
	else
	{
		new-> pixsavelines = pixsavelines = savelines;
		new-> charsavelines = savelines = PixelToCharY (savelines);
		pixx = x;
		pixy = y;
		pixwidth = width;
		pixheight = height;
		x = PixelToCharX (x);
		y = PixelToCharY (y);
		width = PixelToCharX (width);
		height = PixelToCharY (height);
	}

	/*	Check if the window is visible	*/

	parent = (from == (WinInfo) 0 || wm) ? root_window : from -> window;

	if (menuflag == MENU && ! wm && adjust_pos)
	{
		XGetNormalHints (display, root_win-> window, &hints);

		if (pixx + pixwidth > hints. width)
			pixx = hints. width - pixwidth - 20;

		if (pixy + pixheight > hints. height)
			pixy = hints. height - pixheight - 20;
	}

	new-> base = base;
	new-> cursor = None;
	new-> menuflag = menuflag;
	new-> curline = new-> pixsavelines;
	new-> char_dim.low_x = PixelToCharX (pixx);
	new-> char_dim.low_y = PixelToCharY (pixy);
	new-> char_dim.high_x = x + width;
	new-> char_dim.high_y = y + height;
	new-> char_dim.width = width;
	new-> char_dim.height = height;
	new-> pix_dim.low_x = pixx;
	new-> pix_dim.low_y = pixy;
	new-> pix_dim.high_x = pixx + pixwidth;
	new-> pix_dim.high_y = pixy + pixheight;
	new-> pix_dim.width = pixwidth;
	new-> pix_dim.height = pixheight;

	if (base == CHARS)
		SetScrollRegion (new, 0, 0, width - 1, height + savelines - 1);
	else
		SetScrollRegion (new, 0, 0, pixwidth - 1,
						pixheight + pixsavelines - 1);

	if (first_window == (WinInfo) 0)
		new-> next = (WinInfo) 0;
	else
		new-> next = first_window;

	first_window = new;

	addx = CharToPixelX (1) / 2;
	addy = CharToPixelY (1) / 2;

	bwidth = (menuflag == MENU ? 1 : BORDER_WIDTH),
	new-> window = XCreateSimpleWindow (
		display,
		parent,
		(savelines > 0 ? pixx + SCROLLBAR_WIDTH + bwidth : pixx) + addx,
		pixy + addy,
		pixwidth  - (savelines > 0 ? 2 * bwidth : 0), pixheight,
		bwidth,
		XOR (menuflag == FIXED, reversed) ? black_pixel : white_pixel,
		XOR (menuflag == FIXED, reversed) ? white_pixel : black_pixel);

	XSelectInput (display, new-> window, ExposureMask |
					     KeyPressMask |
					     ButtonPressMask);

	new-> events = ExposureMask | KeyPressMask | ButtonPressMask;

	bzero ((char *)&wmhints, sizeof wmhints);
	wmhints. input = True;
	wmhints. flags = InputHint;
	XSetWMHints (display, new-> window, & wmhints);

	bzero ((char *)&hints, sizeof hints);
	hints. flags = wm ? PSize : PPosition | PSize;
	hints. x = pixx;
	hints. y = pixy;
	hints. width = pixwidth;
	hints. height = pixheight;

	if (from == (WinInfo) 0 || wm)
	{
		extern Pixmap pm_icon;	/* xicons.c */

		if (wm)
			XSetStandardProperties (display, new-> window,
				window_name, window_name, pm_icon,
					(char **) 0, 0, & hints);
		else
			XSetStandardProperties (display, new-> window,
				windowname, windowname, pm_icon,
				(char **) 0, 0, & hints);
	}
	else
	{
		XSetNormalHints (display, new-> window, & hints);
	}

	new-> pixmap = XCreatePixmap (
		display,
		parent,
		pixwidth  + (savelines > 0 ? 2 * bwidth : 0),
		pixheight + pixsavelines,
		depth);
	
	/* create scrollbar */

	if (savelines > 0)
	{
		new-> scrollwindow = XCreateSimpleWindow (
			display,
			parent,
			pixx + addx, pixy + addy, SCROLLBAR_WIDTH, pixheight,
			bwidth,
			XOR (menuflag == FIXED, reversed) ? black_pixel
							  : white_pixel,
			XOR (menuflag == FIXED, reversed) ? white_pixel
							  : black_pixel);

		XSelectInput (display, new-> scrollwindow,
				ExposureMask |
				Button2MotionMask |
				ButtonReleaseMask |
				ButtonPressMask);

		XMapWindow (display, new-> scrollwindow);

		SetScrollbarCursor (new-> scrollwindow);

		new-> mult = (double) ((double) pixheight /
				 (double) (pixsavelines + pixheight));
	}
	else
	{
		new-> mult = 0.0;
		new-> scrollwindow = (Drawable) 0;
	}

	ClearWindow (new);

	new-> normal_gc = (menuflag == MENU) ? gc_inv_normal : gc_normal;
	new-> rev_gc = (menuflag == MENU) ? gc_normal : gc_inv_normal;
	new-> bold_gc   = (menuflag == MENU) ? gc_inv_bold   : gc_bold;

		
	XMapWindow (display, new-> window);
	return new;
}

void ChangeWindowBase (win, base)
WinInfo win;
int base;
{
	win-> base = base;
}

	/*
	 *	amount < 0 ==> scroll down
	 *	amount > 0 ==> scroll up
	 *
	 *	Test is made if 'win' has a savebuffer
	 *	and if window can still scroll (that many pixels !)
	 */

bool ScrollEvent (pevent)
XEvent *pevent;
{
	WinInfo win, found;
	int button;
	bool cont;
	int newcurline;


	found = (WinInfo) 0;
	for (win = first_window; win != (WinInfo) 0; win = win-> next)
		if (win-> scrollwindow == pevent-> xany. window)
			found = win;

	if (found == (WinInfo) 0)
		return False;

	if (pevent-> xany. type != ButtonPress)
		return False;

	win = found;

	cont = True;

	do
	{
		newcurline = win-> curline;
		for (;;)
		{
			switch (pevent-> xany. type)
			{

			case Expose:
				RefreshEvent (pevent);
				break;
			case MotionNotify:
				newcurline = (int) ((double)
						pevent-> xbutton. y /
						win-> mult);
				break;
			case ButtonRelease:
				cont = False;
				break;
			case ButtonPress:
				if (pevent-> xany. window != win-> scrollwindow)
					break;

				button = pevent-> xbutton. button;

				if (button == RIGHT_BUTTON)
				{
					newcurline = win-> curline - 
							pevent-> xbutton. y;
					cont = False;
				}
				else if (button == LEFT_BUTTON)
				{
					newcurline = win-> curline + 
							pevent-> xbutton. y;
					cont = False;
				}
				else 
				{
					newcurline = (int) ((double)
							pevent-> xbutton. y /
							win-> mult);
				}
				break;
			}

			if (cont && XEventsQueued (display, QueuedAlready) > 0)
				XNextEvent (display, pevent);
			else
				break;
		}

		if (win-> base == CHARS)
			newcurline = CharToPixelY (PixelToCharY (newcurline +
						     CharToPixelY (1)/2));
		if (newcurline < 0)
			newcurline = 0;
		else if (newcurline > win-> pixsavelines)
			newcurline = win-> pixsavelines;

		if (newcurline != win-> curline)
		{

			win-> curline = newcurline;
			DrawScrollBar (win);

			FlushWindow (win);
			WaitRefresh (False);
		}

		if (cont)
			XNextEvent (display, pevent);

	} while (cont);

	return True;
}

void DestroyWindow (win)
WinInfo win;
{
	WinInfo prev, curr;
	int found;

	prev = (WinInfo) 0;
	curr = first_window;
	found = False;

	while (! found && curr != (WinInfo) 0)
		if (curr == win)
		{
			found = True;
			if (prev == (WinInfo) 0)
				first_window = win -> next;
			else
				prev-> next = win -> next;
		} else {
			prev = curr;
			curr = curr-> next;
		}

	if (! found) {
		(void) fprintf (stderr,
			"DestroyWindow, error: wininfo not found\n");
		leave ();
	}

	XDestroyWindow (display, win-> window);
	XFreePixmap (display, win-> pixmap);
	(void) free ((char *) win);
}
	
	 /*	WinInfo XFindWindow (Window win)
	  *		Finds the WinInfo structure of win.
	  */

static WinInfo FindWindow (window)
Window window;
{
	WinInfo win;

	for (win = first_window; win != (WinInfo) 0; win = win-> next)
		if (win-> window == window) 
			return win;

	return (WinInfo) 0;
}

WinInfo EventWindow (event)
XEvent *event;
{
	return FindWindow (event-> xany. window);
}

void SelectEvents (win, events)
WinInfo win;
unsigned long events;
{
	win-> events = events;
	XSelectInput (display, win-> window, events);
}

void SetCursor (win, cursor)
WinInfo win;
Cursor cursor;
{
	win-> cursor = cursor;
	XDefineCursor (display, win-> window, cursor);
}

void BusyCursor ()
{
	
	register WinInfo ptr;

	if (! xstarted)
		return;

	for (ptr = first_window; ptr != (WinInfo) 0; ptr = ptr-> next) {
		XDefineCursor (display, ptr-> window, cr_busy);
		/* XSelectInput (display, ptr-> window, ExposureMask); */
	}

	Refresh ();
}

void ResetCursor ()
{
	register WinInfo ptr;

	if (! xstarted)
		return;

	for (ptr = first_window; ptr != (WinInfo) 0; ptr = ptr-> next) {
		XDefineCursor (display, ptr-> window, ptr-> cursor);
		/* XSelectInput (display, ptr-> window, ptr-> events); */
	}

	Refresh ();
}

	 /*
	  *	RefreshWindow (Wininfo win, x, y, width, height)
	  *		Draws the given area at the window (from the pixmap).
	  */

static void RefreshWindow (win, x, y, width, height)
WinInfo win;
int x, y, width, height;
{
	XCopyArea (
		display,
		win-> pixmap,
		win-> window,
		gc_copy,
		x, y + win-> curline,
		width, height,
		x, y);

	Refresh ();
}

void RefreshEvent (event)
XEvent *event;
{
	WinInfo win;

	if ((win = FindWindow (event-> xany. window)) == (WinInfo) 0)
		return;
	
	RefreshWindow (
		win,
		event-> xexpose. x,
		event-> xexpose. y,
		event-> xexpose. width,
		event-> xexpose. height);

	DrawScrollBar (win);
}

void PrintMarkedAtPixmap (win, x, y, text, mode)
WinInfo win;
int x, y;
const char * text;
int mode;
{
	XDrawImageString (
		display,
		win-> pixmap,
		mode == NORMAL ? win-> normal_gc : win-> bold_gc,
		CharToPixelX (x),
		CharToPixelYB (y),
		text,
		strlen (text));
	
	XDrawRectangle (
		display,
		win-> pixmap,
		win-> normal_gc,
		CharToPixelX (x),
		CharToPixelY (y),
		CharToPixelX (strlen (text)) - 1,
		CharToPixelY (1) - 1);
}

void PrintAtPixmapN (win, x, y, text)
WinInfo win;
int x, y;
const char *text;
{
	XDrawImageString (
		display,
		win-> pixmap,
		win-> normal_gc,
		CharToPixelX (x),
		CharToPixelYB (y),
		text,
		strlen (text));
}

void PrintAtPixmapB (win, x, y, text)
WinInfo win;
int x, y;
const char *text;
{
	XDrawImageString (
		display,
		win-> pixmap,
		win-> bold_gc,
		CharToPixelX (x),
		CharToPixelYB (y),
		text,
		strlen (text));
}

int GetPixmapPosY (win, y)
WinInfo win;
int y;
{
	return PixelToCharY (y + win-> curline);
}

	/* ARGSUSED */
int GetPixmapPosX (win, x)
WinInfo win;
int x;
{
	return PixelToCharX (x);
}

void ClearLine (win, y)
WinInfo win;
int y;
{
	Print (win, 0, y, Fmt ("%*s", win-> char_dim.width, ""), NORMAL);
}

void Print (win, x, y, text, mode)
WinInfo win;
int x,y;
const char *text;
int mode;
{
	if (! xstarted)
		return;

	win-> curline = win-> pixsavelines;

	XDrawImageString (
		display,
		win-> pixmap,
		mode == NORMAL ? win-> normal_gc : 
			mode == REVERSED ?
				win-> rev_gc :
				win-> bold_gc,

		CharToPixelX (x),
	        CharToPixelYB (y) + win-> pixsavelines,
		text,
		strlen (text));
}

void SetToBot (win)
WinInfo win;
{
	win-> curline = win-> pixsavelines;
}

void SetToTop (win)
WinInfo win;
{
	win-> curline = 0;
}

void PrintB (win, x, y, text)
WinInfo win;
int x,y;
const char *text;
{
	Print (win, x, y, text, BOLD);
}

void PrintN (win, x, y, text)
WinInfo win;
int x,y;
const char *text;
{
	Print (win, x, y, text, NORMAL);
}

void PrintR (win, x, y, text)
WinInfo win;
int x, y;
const char * text;
{
	if (bold_is_reversed)
		Print (win, x, y, text, REVERSED);
	else
		Print (win, x, y, text, BOLD);
}

void ReverseWindow (win)
WinInfo win;
{
	if (! xstarted)
		return;

	XCopyArea (
		display,
		win-> pixmap, 
		win-> window,
		gc_inv_copy,
		0, win-> curline,
		win-> pix_dim.width, win-> pix_dim.height,
		0, 0);

	DrawScrollBar (win);

	Refresh ();
}

void FlushWindow (win)
WinInfo win;
{
	if (! xstarted)
		return;

	XCopyArea (
		display,
		win-> pixmap, 
		win-> window,
		gc_copy,
		0, win-> curline,
		win-> pix_dim.width, win-> pix_dim.height,
		0, 0);

	DrawScrollBar (win);

	Refresh ();
}

void DrawRect (win, x, y, width, height)
WinInfo win;
int x, y, width, height;
{
	win-> curline = win-> pixsavelines;

	XDrawRectangle (
		display,
		win-> pixmap,
		win-> normal_gc,
		x, y + win-> pixsavelines,
		width, height);
}

void PrintPixmap (win, x, y, pixmap)
WinInfo win;
int x, y;
Pixmap pixmap;
{
	win-> curline = win-> pixsavelines;

	XCopyArea (
		display,
		pixmap,
		win-> pixmap,
		reversed ? gc_inv_small : gc_small,
		0, 0,
		DESPIX_WIDTH,
		DESPIX_HEIGHT,
		x, y + win-> pixsavelines);
}

void PrintMarked (win, x, y, text, mode)
WinInfo win;
int x, y;
const char *text;
int mode;
{
	Print (win, x, y, text, mode);

	DrawRect (win, CharToPixelX (x), CharToPixelY (y),
		CharToPixelX (strlen (text)) - 1, CharToPixelY (1) - 1);
}

void Line (win, sx, sy, ex, ey)
WinInfo win;
int sx, sy, ex, ey;
{
	win-> curline = win-> pixsavelines;

	XDrawLine (
		display,
		win-> pixmap,
		win-> normal_gc,
		sx, sy + win-> pixsavelines, ex, ey + win-> pixsavelines);
}

void DrawHorizontal (win, pos)
WinInfo win;
int pos;
{
	int y;

	y = CharToPixelY (pos) + CharToPixelY (1) / 2;

	Line (win, 0, y - 3, win-> pix_dim.width, y - 3);
	Line (win, 0, y - 2, win-> pix_dim.width, y - 2);
	Line (win, 0, y, win-> pix_dim.width, y);
	Line (win, 0, y + 2, win-> pix_dim.width, y + 2);
	Line (win, 0, y + 3, win-> pix_dim.width, y + 3);
}

void SetScrollRegion (win, startx, starty, endx, endy)
WinInfo win;
int startx, starty, endx, endy;
{
	win-> scroll.width = endx - startx + 1;
	win-> scroll.height = endy - starty + 1;

	if (win-> base == CHARS)
	{
		win-> scroll.low_x = CharToPixelX (startx);
		win-> scroll.low_y = CharToPixelY (starty);
		win-> scroll.high_x = CharToPixelX (endx);
		win-> scroll.high_y = CharToPixelY (endy);
		win-> scroll.width = CharToPixelX (win-> scroll.width);
		win-> scroll.height = CharToPixelY (win-> scroll.height);
	}
	else
	{
		win-> scroll.low_x = startx;
		win-> scroll.low_y = starty;
		win-> scroll.high_x = endx;
		win-> scroll.high_y = endy;
	}
}

void Scroll (win, lines)
WinInfo win;
int lines;
{
	int fromy, toy;
	struct region *scr;


	scr = &win-> scroll;
	if (! xstarted)
		return;

	win-> curline = win-> pixsavelines;

	if (win-> base == CHARS)
		lines = CharToPixelY (lines);

	if (lines < 0)
	{
		fromy = scr->low_y;
		toy = scr->low_y + -lines;
	}
	else
	{
		fromy = scr->low_y + lines;
		toy = scr->low_y;
	}
	XCopyArea (
		display,
		win-> pixmap,
		win-> pixmap,
		gc_copy,
		scr-> low_x, fromy,
		scr-> width, scr-> height - ABS(lines),
		scr-> low_x, toy);

	if (win-> base == CHARS)
		toy =  scr-> high_y - lines + CharToPixelY (1);
	else
		toy =  scr-> high_y - lines + 1;

	XFillRectangle (
		display,
		win-> pixmap,
		XOR (win-> menuflag == MENU, reversed)?gc_normal:gc_inv_normal,
		scr-> low_x, lines > 0 ? toy : scr-> low_y,
		scr-> width, ABS (lines));
}

void ScrollHorz (win, cols)
WinInfo win;
int cols;
{
	int fromx, tox;
	struct region *scr;

	scr = &win-> scroll;

	if (win-> base == CHARS)
		cols = CharToPixelX (cols);

	if (cols < 0)
	{
		fromx = scr->low_x;
		tox = scr->low_x + -cols;
	}
	else
	{
		fromx = scr->low_x + cols;
		tox = scr->low_x;
	}

	XCopyArea (
		display,
		win-> pixmap,
		win-> pixmap,
		gc_copy,
		fromx, scr->low_y,
		scr->width - ABS(cols), scr->height,
		tox, scr->low_y);
	
	if (win-> base == CHARS)
		tox =  scr-> high_x - cols + CharToPixelX (1);
	else
		tox =  scr-> high_x - cols + 1;

	XFillRectangle (
		display,
		win-> pixmap,
		XOR (win-> menuflag == MENU, reversed)?gc_normal:gc_inv_normal,
		cols > 0 ? tox : scr->low_x, scr->low_y,
		ABS (cols), scr-> height);
}

char * GetString (win, x, y, maxlen, form)
WinInfo win;
int x, y, maxlen;
const char * form;
{
	extern char erasechar, eraseword, eraseline, intrchar;
	int len = 0;
	static char ret [BUFSIZ];
	XEvent event;
	Sector sct;
	char *ptr;
	int cont;
	char ch;
	char buffer [BUFSIZ];
	KeySym keysym;
	XComposeStatus comp_status;
	extern WinInfo map_win;

	if (maxlen + x > win-> char_dim.width)
		maxlen = win-> char_dim.width - x;

	cont = True;
	Print (win, x, y, "_", BOLD);
	FlushWindow (win);
	*ret = '\0';

	while (cont)
	{
		
		XNextEvent (display, &event);

		if (StandardEvent (& event))
		{
			if (interrupt)
			{
				*ret = '\0';
				cont = False;
			}
			continue;
		}

		switch (event. type)
		{

		case KeyPress:
			if (XLookupString (
				& (event. xkey),
				buffer,
				BUFSIZ - 1,
				&keysym,
				&comp_status) == 0) break;

			ch = buffer [0];

			if (ch == erasechar)
			{
				if (len != 0)
				{
					len --;
					ret [ len ] = '\0';
					PrintB (win, x, y, Fmt ("%s_ ", ret));
				}
				break;
			}

			cont = (keysym != XK_Return &&
				keysym != XK_KP_Enter &&
				keysym != XK_Escape);

			if (!cont)
				break;

			if (ch == eraseword)
			{
				int j;

				j = len;

				while (j > 0 && isspace (ret [--j]))
					ret [j] = '\0';

				while (j > 0 && !isspace (ret [--j]))
					ret [j] = '\0';

				if (j > 0) j++;

				if  (j == len)
					break;

				PrintN (win, x, y, Fmt ("%*s ", maxlen, ""));
				len = j;
				break;
			}
			else if (ch == eraseline)
			{
				len = 0;
				ret [len] = '\0';
				PrintN (win, x, y, Fmt ("%*s ", maxlen, ""));
				break;
			}
			else if (CharInFormat (ch, form) && len < maxlen)
			{
				ret [len] = ch;
				ret [++ len] = '\0';
			}
			break;

		case ButtonPress:

			if (EventWindow (& event) == map_win)
				sct = FindSector (event. xbutton. x,
						event. xbutton. y);
			else
				sct = (Sector) 0;

			switch (event. xbutton. button)
			{

			case LEFT_BUTTON:
				if (sct == (Sector) 0 || NO_INFO (sct))
					break;

				CensusSct (sct);
				break;

/* 
 * 			case MIDDLE_BUTTON:
 * 				if (! CharInFormat (',', form))
 * 					break;
 * 				if (sct == (Sector) 0 || NO_INFO (sct))
 * 					break;
 * 				if (sct != cursct && ! Adjacent (sct, cursct))
 * 					break;
 * 				
 * 				if (sct == cursct)
 * 				{
 * 					ret [len ++] = 'h';
 * 					ret [len ++] = ' ';
 * 					ret [len] = '\0';
 * 				}
 * 				else
 * 				{
 * 					ret [len ++] = GiveDirChar (cursct,
 * 									sct);
 * 					ret [len] = '\0';
 * MJH : ik wil geen SetCurrents mee op vreemde plaatsen dit maak deze
 * toch al niet bruikbare feature totaal onmogenlijk. (mischien laatste
 * onthouden ?)
 * 					SetCurrent (sct);
 * 				}
 * 				break;
 */

			case RIGHT_BUTTON:
				if (sct == (Sector) 0 || NO_INFO (sct))
					sct = cursct;

				ptr = CrdStr (sct);
				if (len > 0 && ret [len - 1] != ' ')
					ret [len ++] = ' ';
				while (*ptr != '\0')
					ret [len ++] = *ptr ++;
				ret [len ++] = ' ';
				ret [len] = '\0';
				break;
			}
			break;
		}

		if (cont && (event. type == KeyPress ||
			     event. type == ButtonPress))
	     	{

			PrintB (win, x, y, Fmt ("%s_", ret));
			FlushWindow (win);
		}

	}

	if (interrupt || keysym == XK_Escape)
	{
		PrintN (win, x, y, Fmt ("%*s ", maxlen, ""));
		FlushWindow (win);
		return (char *) 0;
	}
	else
	{
		PrintB (win, x, y, Fmt ("%s ", ret));
		FlushWindow (win);
		return ret;
	}
}

void DrawArrow (win, x, y, dir)
WinInfo win;
int x, y;
char dir;
{
	int deltx, delty;

	x = CharToPixelX (x);
	y = CharToPixelY (y);

	deltx = CHAR_WIDTH / 2;
	delty = CHAR_HEIGHT / 2;

	/*		y   u
	 *	      g   .   j
	 *		b   n
	 */

	if (dir == 'b' || dir == 'u')
	{
		Line (win, x + CHAR_WIDTH - 2, y + 1,
			x + 1, y + CHAR_HEIGHT - 2);
		if (dir == 'b')
		{
			Line (win, x + 1, y + CHAR_HEIGHT - 2,
				x + 1 + deltx, y + CHAR_HEIGHT - 2);
			Line (win, x + 1, y + CHAR_HEIGHT - 2,
				x + 1, y + CHAR_HEIGHT - 1 - delty);
			return;
		}
		else
		{
			Line (win, x + CHAR_WIDTH - 2, y + 1,
				x + CHAR_WIDTH - 2 - deltx, y + 1);
			Line (win, x + CHAR_WIDTH - 2, y + 1,
				x + CHAR_WIDTH - 2, y + 1 + delty);
			return;
		}
	}
	else if (dir == 'y' || dir == 'n')
	{
		Line (win, x + 1, y + 1,
			x + CHAR_WIDTH - 2, y + CHAR_HEIGHT - 2);
		if (dir == 'y')
		{
			Line (win, x + 1, y + 1,
				x + 1 + deltx, y + 1);
			Line (win, x + 1, y + 1,
				x + 1, y + 1 + delty);
			return;
		}
		else
		{
			Line (win, x + CHAR_WIDTH - 2, y + CHAR_HEIGHT - 2,
				x + CHAR_WIDTH - 2 - deltx,
				y + CHAR_HEIGHT - 2);
			Line (win, x + CHAR_WIDTH - 2, y + CHAR_HEIGHT - 2,
				x + CHAR_WIDTH - 2,
				y + CHAR_HEIGHT - 2 - delty);
			return;
		}
	}
	else if (dir == 'g')
	{
		Line (win, x + 1, y + CHAR_HEIGHT / 2,
			x + CHAR_WIDTH - 1, y + CHAR_HEIGHT / 2);
		Line (win, x + 1, y + CHAR_HEIGHT / 2,
			x + 1 + deltx, y + CHAR_HEIGHT / 2 + delty);
		Line (win, x + 1, y + CHAR_HEIGHT / 2,
			x + 1 + deltx, y + CHAR_HEIGHT / 2 - delty);
		return;
	}
	else if (dir == 'j')
	{
		Line (win, x + 1, y + CHAR_HEIGHT / 2,
			x + CHAR_WIDTH - 1, y + CHAR_HEIGHT / 2);
		Line (win, x + CHAR_WIDTH - 2, y + CHAR_HEIGHT / 2,
			x + CHAR_WIDTH - 2 - deltx,
			y + CHAR_HEIGHT / 2 - delty);
		Line (win, x + CHAR_WIDTH - 2, y + CHAR_HEIGHT / 2,
			x + CHAR_WIDTH - 2 - deltx,
			y + CHAR_HEIGHT / 2 + delty);
	}
	else
		return;
}

void WarpPointer (win, x, y)
WinInfo win;
int x, y;
{
	XWarpPointer (
		display,
		root_window,
		win-> window,
		0, 0, 0, 0,
		x, y);
}

WinInfo OpenWinForWM (name, x, y, width, height, base, savelines)
const char * name;
int x, y, width, height, savelines;
int base;
{
	int addx, addy;

	window_name = name;

	if (base == CHARS)
	{
		addx = map_win-> char_dim.low_x;
		addy = map_win-> char_dim.low_y;
	}
	else
	{
		addx = map_win-> pix_dim.low_x;
		addy = map_win-> pix_dim.low_y;
	}

	return OpenWindow (
		(WinInfo) 0,
		x + addx,
		y + addy,
		width,
		height,
		base,
		WM_MENU,
		savelines);
}

WinInfo OpenRelToRoot (from, x, y, width, height, base, savelines)
WinInfo from;
int x, y, width, height, savelines;
int base;
{
	extern WinInfo root_win;	/* main.c */
	int addx, addy;

	if (base == CHARS)
	{
		addx = from-> char_dim.low_x;
		addy = from-> char_dim.low_y;
	}
	else
	{
		addx = from-> pix_dim.low_x;
		addy = from-> pix_dim.low_y;
	}

	return OpenWindow (
		root_win,
		x + addx,
		y + addy,
		width,
		height,
		base,
		MENU,
		savelines);
}

#define TIMES 4

void FlashWindow (win)
WinInfo win;
{
	int i;

	if (! xstarted)
		return ;

	win-> curline = win-> pixsavelines;

	i = TIMES;

	while (i-- != 0) {

		ReverseWindow (win);
		FlushWindow (win);
	}
}
	
void Bell ()
{
	if (xstarted)
		XBell (display, 0);
}

bool WinHasScrollBar (win)
WinInfo win;
{
	return (win-> pixsavelines > 0);
}

void RaiseWindow (win)
WinInfo win;
{
	XRaiseWindow (display, win-> window);

	CheckRefreshEvents ();
}

void LowerWindow (win)
WinInfo win;
{
	XLowerWindow (display, win-> window);
}

void XorLine (win, psx, psy, pex, pey)
WinInfo win;
int psx, psy, pex, pey;
{
	XDrawLine (
		display,
		win-> pixmap,
		gc_xor,
		psx, psy, pex, pey);
}

void XorBox (win, psx, psy, pex, pey)
WinInfo win;
int psx, psy, pex, pey;
{
		/*
		 *	Should be done with XDrawLines
		 *
		 *
		 *	sx,sy		ex,sy
		 *
		 *
		 *
		 *	sx,ey		ex,ey
		 */

	XDrawRectangle (
		display,
		win-> pixmap,
		gc_xor,
		psx, psy + win-> pixsavelines,
		pex - psx + 1, pey - psy + 1);
}

int WinHeight (win)
WinInfo win;
{
	return win-> pix_dim. height;
}

int WinWidth (win)
WinInfo win;
{
	return win-> pix_dim. width;
}

void UnmapWindow (win)
WinInfo win;
{
	XUnmapWindow (display, win-> window);
}

void MapWindow (win)
WinInfo win;
{
	XMapWindow (display, win-> window);
}

void LowerAll ()
{
	LowerWindow (empire_win);
	LowerWindow (map_win);
	LowerWindow (census_win);
	LowerWindow (mes_win);
}

void RaiseAll ()
{
	RaiseWindow (empire_win);
	RaiseWindow (map_win);
	RaiseWindow (census_win);
	RaiseWindow (mes_win);
}


WinInfo OpenEmpireWindow (win, inc_y, inc_width, inc_height, savelines,
			  widthp, heightp)
WinInfo win;
int inc_y, inc_width, inc_height;
int savelines;
int *widthp, *heightp;
{
	WinInfo w;

	w = OpenWindow (win, 0,
			CharToPixelY (EMPIRE_STARTY + inc_y),
			CharToPixelX (ROOT_WIDTH + inc_width - 1 -
				      (savelines > 0 ? 1 : 0)) - BORDER_WIDTH,
			CharToPixelY (EMPIRE_HEIGHT + inc_height),
			PIXELS, FIXED, CharToPixelY (savelines));

	*heightp = EMPIRE_HEIGHT + inc_height;
	*widthp = ROOT_WIDTH + inc_width - (savelines > 0 ? 1 : 0);
	return w;
}

