/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/util/RCS/plan.c,v 5.2 1995/09/08 07:48:58 jpo Exp $
    $Date: 1995/09/08 07:48:58 $
    $Author: jpo $
    $Id: plan.c,v 5.2 1995/09/08 07:48:58 jpo Exp $
    $Locker:  $
    $Log: plan.c,v $
    Revision 5.2  1995/09/08 07:48:58  jpo
    const

 * Revision 5.1  93/03/14  16:52:57  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:24:11  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:45:54  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
	/*
	 *	civmin	- civilians that must be move in to activate the sct
	 *	civmax  - try to move in civmax civilians
	 *	civaft  - civaft < civmax == 100% -> move all but civaft out
	 *					     of this sector
	 *	          otherwise -> move all civilians above "civaft" out
	 *			       of this sector.
	 */

#include "main.h"
#include "var.h"
#include "census.h"
#include "sector.h"

#define		PLAN_MIL_NONE		0
#define		PLAN_MIL_ENLIST		1
#define		PLAN_MIL_IMPORT		2

#define		PLAN_MODE_SILENT	0
#define		PLAN_MODE_TERSE		1
#define		PLAN_MODE_VERBOSE	2

#define		PLAN_NR_DESIGN		25

#define		PLAN_CIV_MIN		0
#define		PLAN_CIV_MAX		1
#define		PLAN_CIV_AFT		2

#define		PLAN_CIV_N		3

#define		PLAN_NR_THRESH		12

#define		PLAN_THR_UW		0
#define		PLAN_THR_FOO		1
#define		PLAN_THR_SHE		2
#define		PLAN_THR_GUN		3
#define		PLAN_THR_PET		4
#define		PLAN_THR_IRO		5
#define		PLAN_THR_BAR		6
#define		PLAN_THR_DUS		7
#define		PLAN_THR_OIL		8
#define		PLAN_THR_LCM		9
#define		PLAN_THR_HCM		10
#define		PLAN_THR_RAD		11

static char plan_thresh [] = "ufsgpibdolhr";
static char plan_design [] = "cupdimghw*aojkftrnl+)#b%e";
			/*    0123456789012345678901234 */
static char plan_edit_thresh [] = "mogaujkdi%ltrp*hnfb?";

static int PlanDesToIndex _PROTO((char des));

#define		PLAN_IND_MINE	5
#define		PLAN_IND_OIL	11
#define		PLAN_IND_GOLD	6
#define		PLAN_IND_AGRI	10
#define		PLAN_IND_URAN	1
#define		PLAN_IND_LCM	12
#define		PLAN_IND_HCM	13
#define		PLAN_IND_DEF	3
#define		PLAN_IND_SHEL	4
#define		PLAN_IND_PET	23
#define		PLAN_IND_LIBR	18
#define		PLAN_IND_TECH	15
#define		PLAN_IND_RESE	16
#define		PLAN_IND_PARK	2
#define		PLAN_IND_AIRF	9
#define		PLAN_IND_HARB	7
#define		PLAN_IND_NUCL	17
#define		PLAN_IND_FORT	14
#define		PLAN_IND_BANK	22

struct s_planentry
{
	int plan_x, plan_y;
	char plandes;
	bool active;
	bool done;
	int priority;
	int civmin, civmax, civaft;
	int mil_how;
	int miln, milx, mily;
	int thresh [PLAN_NR_THRESH];
};

struct s_planoptions
{
	char done_file [100];
	int mode;
	int min_to_move;
	bool set_thresholds;
	int def_thresh [PLAN_NR_DESIGN] [PLAN_NR_THRESH];
	int def_civ [PLAN_NR_DESIGN] [PLAN_CIV_N];
};

static struct s_planoptions plan_options;

static void PlanSetThresholds (plan)
PlanEntry plan;
{
	int i, ind;

	if (! plan_options. set_thresholds)
	{
		for (i = 0; i < PLAN_NR_THRESH; i ++)
			plan-> thresh [i] = 0;
		plan-> civmax = plan-> civmin = plan-> civaft = 300;
	}
	else
	{
		ind = PlanDesToIndex (plan-> plandes);

		for (i = 0; i < PLAN_NR_THRESH ; i ++)
			plan-> thresh [i] = plan_options. def_thresh [ind] [i];
		
		plan-> civmin = plan_options. def_civ [ind] [PLAN_CIV_MIN];
		plan-> civmax = plan_options. def_civ [ind] [PLAN_CIV_MAX];
		plan-> civaft = plan_options. def_civ [ind] [PLAN_CIV_AFT];
	}
}

PlanEntry NewPlanEntry (x, y, des)
int x, y;
char des;
{
	PlanEntry new;
	int i;

	new = (PlanEntry) doalloc (sizeof (struct s_planentry));
	new-> plan_x = x;
	new-> plan_y = y;
	new-> plandes = des;
	PlanSetThresholds (new);
	new-> active = False;
	new-> priority = 100;
	new-> mil_how = PLAN_MIL_NONE;
	new-> miln = new-> milx = new-> mily = 0;

	return new;
}

/*****************************************************************************
 *				CENSUS					     *
 *****************************************************************************/

void CensusLayPlan ()
{
	CenLine (SL_PLAN_START - 1);
	CenPuts (0, SL_PLAN_START, "Plan:");
	CenPuts (0, SL_PLAN_START + 1, "Des:");
	CenPuts (0, SL_PLAN_START + 2, "Active:");
	CenPuts (0, SL_PLAN_START + 3, "Priority:");

	CenLine (SL_PLAN_CIVS - 1);
	CenPuts (0, SL_PLAN_CIVS,     "Civ min:");
	CenPuts (0, SL_PLAN_CIVS + 1, "    max:");
	CenPuts (0, SL_PLAN_CIVS + 2, "    aft:");
	CenPuts (0, SL_PLAN_CIVS + 3, "Mils:");

	CenLine (SL_PLAN_THRESH - 1);
	CenPuts (0, SL_PLAN_THRESH, "Thresholds:");
	CenPuts (0, SL_PLAN_THRESH + 1, "uw       foo      she");
	CenPuts (0, SL_PLAN_THRESH + 2, "gun      pet      iro");
	CenPuts (0, SL_PLAN_THRESH + 3, "bar      dus      oil");
	CenPuts (0, SL_PLAN_THRESH + 4, "lcm      hcm      rad");
	CenLine (SL_PLAN_THRESH + 5);
}

static void ClearCensusPlan ()
{
	CenPuts (0, SL_PLAN_START, "                       ");
	CenPuts (4, SL_PLAN_START + 1, "                      ");
	CenPuts (7, SL_PLAN_START + 2, "         ");
	CenPuts (9, SL_PLAN_START + 3, "            ");
	CenPuts (8, SL_PLAN_CIVS,     "     ");
	CenPuts (8, SL_PLAN_CIVS + 1, "     ");
	CenPuts (8, SL_PLAN_CIVS + 2, "     ");
	CenPuts (5, SL_PLAN_CIVS + 3, "                       ");

	ClearCols (SL_PLAN_THRESH + 1, 4);
	CenClr (SL_PLAN_THRESH + 6);
	CenClr (SL_PLAN_THRESH + 7);
}

void PlanCensus (sct)
Sector sct;
{
	PlanEntry plan;
	int x, y, i;

	ClearCensusPlan ();

	plan = s_owned (sct) ? s_plan (sct) : (PlanEntry) 0;

	if (plan == (PlanEntry) 0)
	{
		CenPuts (9, SL_PLAN_START, "No plan");
		return;
	}
	CenPuts (0, SL_PLAN_START, "      * P L A N *");

	CenPutVal (5,  SL_PLAN_START + 1, DesignName (plan-> plandes));
	CenPutVal (8,  SL_PLAN_START + 2, plan-> active ? "Yes" : "No");
	CenPutVal (10, SL_PLAN_START + 3, Fmt ("%d/%d",
				(int) plan-> priority / 100,
				plan-> priority % 100));
	CenPutInt (9,  SL_PLAN_CIVS,     plan-> civmin);
	CenPutInt (9,  SL_PLAN_CIVS + 1, plan-> civmax);
	CenPutInt (9,  SL_PLAN_CIVS + 2, plan-> civaft);

	CenPuts (0, SL_PLAN_CIVS + 3, "Mils: ");
	switch (plan-> mil_how)
	{

	case PLAN_MIL_NONE:
		CenPutVal (6, SL_PLAN_CIVS + 3, "None");
		break;

	case PLAN_MIL_ENLIST:
		CenPutVal (6, SL_PLAN_CIVS + 3, Fmt ("Enlist %d", plan-> miln));
		break;

	case PLAN_MIL_IMPORT:
		CenPutVal (6, SL_PLAN_CIVS + 3, Fmt ("Import from %d,%d",
				plan-> milx, plan-> mily));
		break;
	}

	i = 0;
	for (y = 0; y <= 3; y ++)
		for (x = 4; x <= 22; x += 9)
			if (plan-> thresh [i ++] > 0)
				CenPutInt (x, SL_PLAN_THRESH + y + 1,
							plan-> thresh [i - 1]);

	CensusPlanProduce (census_win, SL_PLAN_THRESH + 6,
		plan-> plandes, plan-> civmin, plan-> civmax, sct);
}

void PlanCensusButton (x, y)
int x, y;
{
	PlanEntry plan;
	char * ans, * ptr;
	int i, j;

	plan = s_owned (cursct) ? s_plan (cursct) : (PlanEntry) 0;

	if (plan == (PlanEntry) 0 && y == SL_PLAN_START)
	{
		if (! s_owned (cursct))
		{
			Message ("You can only plan owned sectors!");
			Bell ();
			return;
		}

		if (s_pat (cursct) == (char *) 0 || * s_pat (cursct) == '_')
		{
			Message ("This sector doesn't have a warehouse!");
			Bell ();
		}

		plan = NewPlanEntry (s_xcd (cursct), s_ycd (cursct),
						s_nds (cursct));
		set_plan (cursct, plan);
		PlanCensus (cursct);
		return;
	}

	if (plan == (PlanEntry) 0)
		return;
	
	if (y == SL_PLAN_START)
	{
		if (! Confirm ("Delete plan", True))
			return;
		
		(void) free ((char *) s_plan (cursct));
		set_plan (cursct, (PlanEntry) 0);
		PlanCensus (cursct);
		return;
	}

	if (y == SL_PLAN_START + 1)
	{
		CenPuts (5, y, "                     ");
		ans = GetString (census_win, 5, y, 1, plan_design);
		
		if (ans == (char *) 0 || interrupt || * ans == '\0')
		{
			PlanCensus (cursct);
			return;
		}

		plan-> plandes = * ans;
		PlanSetThresholds (plan);
		PlanCensus (cursct);
		return;
	}

	if (y == SL_PLAN_START + 2)
	{
		plan-> active = ! plan-> active;
		PlanCensus (cursct);
		return;
	}

	if (y == SL_PLAN_START + 3)
	{
		CenPuts (10, y, "       ");
		ans = GetString (census_win, 10, y, 5, "0-9/");
		if (ans == (char *) 0 || interrupt || * ans == '\0')
		{
			PlanCensus (cursct);
			return;
		}

		ptr = index (ans, '/');
		if (ptr == (char *) 0)
			plan-> priority = 100 * atoi (ans);
		else
			plan-> priority = atoi (ans) * 100 + atoi (ptr + 1);
		
		PlanCensus (cursct);
		return;
	}

	if (y >= SL_PLAN_CIVS && y <= SL_PLAN_CIVS + 2)
	{
		CenPuts (9, y, "     ");
		ans = GetString (census_win, 9, y, 3, "0-9");
		if (ans == (char *) 0 || interrupt || * ans == '\0')
		{
			PlanCensus (cursct);
			return;
		}

		switch (y - SL_PLAN_CIVS)
		{

		case 0:	plan-> civmin = atoi (ans);
			break;
		case 1:	plan-> civmax = atoi (ans);
			break;
		case 2:	plan-> civaft = atoi (ans);
			break;
		}

		PlanCensus (cursct);
		return;
	}
	
	if (y == SL_PLAN_CIVS + 3)
	{
		CenPutVal (0, y, "[e]nl, [i]mp, [n]one: ");
		ans = GetString (census_win, 22, y, 1, "ein");
		if (ans == (char *) 0 || interrupt || * ans == '\0')
		{
			PlanCensus (cursct);
			return;
		}

		switch (* ans)
		{

		case 'n':
			plan-> mil_how = PLAN_MIL_NONE;
			break;
		
		case 'e':
			CenPutVal (0, y, "# mils to enlist:         ");
			ans = GetString (census_win, 18, y, 5, "0-9");
			if (ans == (char *) 0 || interrupt || * ans == '\0')
			{
				PlanCensus (cursct);
				return;
			}
			plan-> mil_how = PLAN_MIL_ENLIST;
			plan-> miln = atoi (ans);
			break;
		
		case 'i':
			CenPutVal (0, y, "# mils to import:         ");
			ans = GetString (census_win, 18, y, 5, "0-9");
			if (ans == (char *) 0 || interrupt || * ans == '\0')
			{
				PlanCensus (cursct);
				return;
			}
			plan-> miln = atoi (ans);
			CenPutVal (0, y, "Import from:              ");
			ans = GetString (census_win, 12, y, 9, GS_SECTOR);
			if (ans == (char *) 0 || interrupt || * ans == '\0')
			{
				PlanCensus (cursct);
				return;
			}

			if (sscanf (ans, "%d,%d", & i, & j) != 2)
			{
				Message ("Illegal sector format");
				Bell ();
				PlanCensus (cursct);
				return;
			}

			plan-> milx = i;
			plan-> mily = j;
			plan-> mil_how = PLAN_MIL_IMPORT;
		}

		PlanCensus (cursct);
		return;
	}

	if (y >= SL_PLAN_THRESH + 1 && y <= SL_PLAN_THRESH + 4)
	{
		i = y - (SL_PLAN_THRESH + 1);
		if (x < 9)
			j = 0;
		else if (x < 18)
			j = 1;
		else
			j = 2;
		
		x = 4 + 9 * j;

		i = 3 * i + j;

		CenPuts (x, y, "    ");
		ans = GetString (census_win, x, y, 4, "0-9");
		if (ans == (char *) 0 || interrupt || * ans == '\0')
		{
			PlanCensus (cursct);
			return;
		}
		plan-> thresh [i] = atoi (ans);
		PlanCensus (cursct);
		return;
	}
}


/*****************************************************************************
 *				DATA FILES				     *
 *****************************************************************************/

void SavePlanInfo (sct, fp)
Sector sct;
FILE * fp;
{
	if (fwrite ((char *) s_plan (sct), sizeof (struct s_planentry), 1, fp)
			!= 1)
		perror ("fwrite");
}

void LoadPlanInfo (sct, fp)
Sector sct;
FILE * fp;
{
	PlanEntry plan;

	plan = NewPlanEntry (s_xcd (sct), s_ycd (sct), s_des (sct));
	set_plan (sct, plan);

	if (fread ((char *) plan, sizeof (struct s_planentry), 1, fp) != 1)
		perror ("fread");
}

/*****************************************************************************
 *				OPTIONS					     *
 *****************************************************************************/

void InitPlanOptions ()
{
	int i, j;

	plan_options. mode = PLAN_MODE_TERSE;
	plan_options. min_to_move = 5;
	plan_options. set_thresholds = False;
	plan_options. done_file [0] = '\0';
	for (i = 0; i < PLAN_NR_DESIGN; i ++)
	{
		for (j = 0; j < PLAN_NR_THRESH; j ++)
			plan_options. def_thresh [i] [j] = 0;

		plan_options. def_thresh [i] [PLAN_THR_FOO] = 50;

		for (j = 0; j < PLAN_CIV_N; j ++)
			plan_options. def_civ [i] [j] = 100;
	}

	plan_options. def_thresh [PLAN_IND_MINE] [PLAN_THR_IRO] = 1;
	plan_options. def_thresh [PLAN_IND_OIL]  [PLAN_THR_OIL] = 1;
	plan_options. def_thresh [PLAN_IND_GOLD] [PLAN_THR_DUS] = 1;
	plan_options. def_thresh [PLAN_IND_URAN] [PLAN_THR_RAD] = 1;
	plan_options. def_thresh [PLAN_IND_LCM]  [PLAN_THR_LCM] = 1;
	plan_options. def_thresh [PLAN_IND_LCM]  [PLAN_THR_IRO] = 250;
	plan_options. def_thresh [PLAN_IND_HCM]  [PLAN_THR_HCM] = 1;
	plan_options. def_thresh [PLAN_IND_HCM]  [PLAN_THR_IRO] = 250;
	plan_options. def_thresh [PLAN_IND_DEF]  [PLAN_THR_HCM] = 100;
	plan_options. def_thresh [PLAN_IND_DEF]  [PLAN_THR_LCM] = 50;
	plan_options. def_thresh [PLAN_IND_DEF]  [PLAN_THR_OIL] = 10;
	plan_options. def_thresh [PLAN_IND_DEF]  [PLAN_THR_GUN] = 1;
	plan_options. def_thresh [PLAN_IND_SHEL] [PLAN_THR_LCM] = 200;
	plan_options. def_thresh [PLAN_IND_SHEL] [PLAN_THR_HCM] = 100;
	plan_options. def_thresh [PLAN_IND_SHEL] [PLAN_THR_SHE] = 1;
	plan_options. def_thresh [PLAN_IND_PET]  [PLAN_THR_OIL] = 50;
	plan_options. def_thresh [PLAN_IND_PET]  [PLAN_THR_PET] = 1;
	plan_options. def_thresh [PLAN_IND_LIBR] [PLAN_THR_LCM] = 250;
	plan_options. def_thresh [PLAN_IND_TECH] [PLAN_THR_LCM] = 200;
	plan_options. def_thresh [PLAN_IND_TECH] [PLAN_THR_OIL] = 100;
	plan_options. def_thresh [PLAN_IND_TECH] [PLAN_THR_DUS] = 20;
	plan_options. def_thresh [PLAN_IND_RESE] [PLAN_THR_LCM] = 200;
	plan_options. def_thresh [PLAN_IND_RESE] [PLAN_THR_OIL] = 100;
	plan_options. def_thresh [PLAN_IND_RESE] [PLAN_THR_DUS] = 20;
	plan_options. def_thresh [PLAN_IND_PARK] [PLAN_THR_LCM] = 250;
	plan_options. def_thresh [PLAN_IND_AIRF] [PLAN_THR_LCM] = 200;
	plan_options. def_thresh [PLAN_IND_AIRF] [PLAN_THR_HCM] = 100;
	plan_options. def_thresh [PLAN_IND_AIRF] [PLAN_THR_PET] = 500;
	plan_options. def_thresh [PLAN_IND_AIRF] [PLAN_THR_SHE] = 100;
	plan_options. def_thresh [PLAN_IND_HARB] [PLAN_THR_LCM] = 200;
	plan_options. def_thresh [PLAN_IND_HARB] [PLAN_THR_HCM] = 100;
	plan_options. def_thresh [PLAN_IND_HARB] [PLAN_THR_SHE] = 100;
	plan_options. def_thresh [PLAN_IND_HARB] [PLAN_THR_GUN] = 20;
	plan_options. def_thresh [PLAN_IND_NUCL] [PLAN_THR_LCM] = 200;
	plan_options. def_thresh [PLAN_IND_NUCL] [PLAN_THR_HCM] = 200;
	plan_options. def_thresh [PLAN_IND_NUCL] [PLAN_THR_OIL] = 100;
	plan_options. def_thresh [PLAN_IND_NUCL] [PLAN_THR_RAD] = 100;
	plan_options. def_thresh [PLAN_IND_FORT] [PLAN_THR_SHE] = 100;
	plan_options. def_thresh [PLAN_IND_FORT] [PLAN_THR_GUN] = 10;
	plan_options. def_thresh [PLAN_IND_BANK] [PLAN_THR_DUS] = 25;
}

void SavePlanOptions (fp)
FILE * fp;
{
	int i, j;

	fprintf (fp, "%d %d %d '%s'\n",
		plan_options. mode,
		plan_options. min_to_move,
		plan_options. set_thresholds,
		plan_options. done_file);
	
	for (i = 0; i < PLAN_NR_DESIGN; i ++)
	{
		for (j = 0; j < PLAN_NR_THRESH; j ++)
			fprintf (fp, "%d ", plan_options. def_thresh [i] [j]);
		for (j = 0; j < PLAN_CIV_N; j ++)
			fprintf (fp, "%d ", plan_options. def_civ [i] [j]);
		fprintf (fp, "\n");
	}

	fprintf (fp, "END OF PLAN OPTIONS\n");
}

void LoadPlanOptions (fp)
FILE * fp;
{
	int i, j;
	char buffer [200];
	char * ptr;

	(void) fgets (buffer, 200, fp);
	sscanf (buffer, "%d %d %d '%[^']'\n",
		& plan_options. mode,
		& plan_options. min_to_move,
		& plan_options. set_thresholds,
		plan_options. done_file);
	
	for (i = 0; i < PLAN_NR_DESIGN; i ++)
	{
		if (fgets (buffer, 200, fp) == (char *) 0)
			return;

		ptr = buffer;

		for (j = 0; j < PLAN_NR_THRESH; j ++)
			ScanDigit ((ConstVP)& ptr,
				   & plan_options. def_thresh [i] [j]);
		for (j = 0; j < PLAN_CIV_N; j ++)
			ScanDigit ((ConstVP)& ptr,
				   & plan_options. def_civ [i] [j]);
	}

	(void) fgets (buffer, 200, fp);
}

static char PlanYToDes (y)
int y;
{
	if (y < 1 || y > strlen (plan_edit_thresh))
		return '\0';

	return plan_edit_thresh [y - 1];
}

static int PlanDesToIndex (des)
char des;
{
	char * ptr;

	ptr = index (plan_design, des);
	if (ptr == (char *) 0)
		return 0;
	else
		return (int) (ptr - plan_design);
}

static void EditPlanThreshold ()
{
	WinInfo win;
	char * ptr;
	int x, y;
	int ind, i;
	char * ans, des;
	int button;

#ifdef TERMC_VERSION
	win = OpenWindow (map_win, 2, 2, 77, 22, 0, FULL_BOX, 0);
#else
	win = OpenRelToRoot (census_win, 12, 10, 70, 22, CHARS, 0);
#endif

	PrintN (win, 0, 0,
"    uw  foo she gun pet iro bar dus oil lcm hcm rad    min max aft");
	y = 0;
	for (ptr = plan_edit_thresh; * ptr != '\0'; ptr ++)
	{
		PrintN (win, 0, ++ y, Fmt ("%c", * ptr));
		PrintN (win, 53, y, Fmt ("%c", * ptr));
		PrintN (win, 68, y, Fmt ("%c", * ptr));
	}
	
	y = 0;
	for (ptr = plan_edit_thresh; * ptr != '\0'; ptr ++, y ++)
	{
		ind = PlanDesToIndex (* ptr);
		for (i = 0; i < PLAN_NR_THRESH; i ++)
			if (plan_options. def_thresh [ind] [i] > 0)
				PrintB (win, (1 + i) * 4, y + 1, Fmt ("%d",
					plan_options. def_thresh [ind] [i]));
		
		for (i = 0; i < PLAN_CIV_N; i ++)
			if (plan_options. def_civ [ind] [i] > 0)
				PrintB (win, 55 + i * 4, y + 1, Fmt ("%d", 
					plan_options. def_civ [ind] [i]));
	}

	for (;;)
	{
		FlushWindow (win);

		if (! SelButtonAtWin (win, & x, & y, & button))
			break;

		if (button == MIDDLE_BUTTON)
			break;

		des = PlanYToDes (y);
		if (des == '\0')
			continue;
		
		ind = PlanDesToIndex (des);

		if (x >= 4 && x <= 50)
		{
			i = (int) (x - 4) / 4;
			x = 4 + i * 4;
			PrintN (win, x, y, "   ");
			ans = GetString (win, x, y, 3, "0-9");
			if (ans == (char *) 0 || interrupt || * ans == '\0')
			{
				PrintN (win, x, y, "   ");
				if (plan_options. def_thresh [ind] [i] > 0)
					PrintB (win, x, y, Fmt ("%d",
						plan_options. def_thresh
							[ind] [i]));
				continue;
			}
		
			plan_options. def_thresh [ind] [i] = atoi (ans);
			if (atoi (ans) == 0)
				PrintN (win, x, y, "   ");
			
			if (button == RIGHT_BUTTON)
			{
				for (y = 1, ptr = plan_edit_thresh;
				     * ptr != '\0';
				     ptr ++, y ++)
				{
					ind = PlanDesToIndex (* ptr);
					plan_options. def_thresh [ind] [i] =
							atoi (ans);
					if (atoi (ans) > 0)
						PrintB (win, 4 * i + 4, y,
						    Fmt ("%-3d", atoi (ans)));
				}
			}
				
			continue;
		}

		if (x >= 55 && x <= 65)
		{
			i = (int) (x - 55) / 4;
			x = 55 + i * 4;

			PrintN (win, x, y, "   ");
			ans = GetString (win, x, y, 3, "0-9");
			if (ans == (char *) 0 || interrupt || * ans == '\0')
			{
				PrintB (win, x, y, Fmt ("%-3d",
					plan_options. def_civ [ind] [i]));
				continue;
			}

			plan_options. def_civ [ind] [i] = atoi (ans);
			continue;
		}
	}

	DestroyWindow (win);
}

#define		PLAN_NO_FUNC		-1

#define		PLAN_RUN_FUNC		0
#define		PLAN_CHANGE_FUNC	1
#define		PLAN_OUTPUT_FUNC	2
#define		PLAN_DONE_FUNC		3
#define		PLAN_MINCIV_FUNC	4
#define		PLAN_THRESH_FUNC	5
#define		PLAN_EXIT_FUNC		6

#define		PLAN_RUN_Y		3
#define		PLAN_CHANGE_Y		4
#define		PLAN_OUTPUT_Y		6
#define		PLAN_DONE_Y		7
#define		PLAN_MINCIV_Y		8
#define		PLAN_THRESH_Y		9
#define		PLAN_EXIT_Y		11

void PlanUtil (wx, wy)
int wx, wy;
{
	WinInfo win;
	bool cont;
	int button;
	int func;
	int x, y;
	char * ans, ch;
	int i;

#ifdef TERMC_VERSION
	win = OpenWindow (map_win, 2, 8, 70, 12, 0, FULL_BOX, 0);
#else
	win = OpenRelToRoot (census_win, 10, 2, 70, 15, MENU, 0);
#endif

	PrintB (win, 1, 1, "Plan utility");

#ifdef X_VERSION
	PrintB (win, 1, 3, "* Run plan utility");
	PrintB (win, 1, 4, "* Change default thresholds");

	PrintB (win, 1, 6, Fmt ("* Plan output mode: %s",
		plan_options. mode == PLAN_MODE_SILENT ? "Silent" :
		plan_options. mode == PLAN_MODE_TERSE  ? "Terse" : "Verbose"));
	PrintB (win, 1, 7, Fmt ("* Done file: %s",
		plan_options. done_file [0] == '\0' ? "None" :
				plan_options. done_file));
	PrintB (win, 1, 8, Fmt ("* Min civs to move: %d",
		plan_options. min_to_move));
	PrintB (win, 1, 9, Fmt ("* Set defaults: %s",
		plan_options. set_thresholds ? "Yes" : "No"));
	
	PrintB (win, 1, 11, "* Exit");

#else	/* TERMC_VERSION */
	PrintB (win, 1, 3, "[R] Run plan utility");
	PrintB (win, 1, 4, "[C] Change default thresholds");

	PrintB (win, 1, 6, Fmt ("[O] Plan output mode: %s",
		plan_options. mode == PLAN_MODE_SILENT ? "Silent" :
		plan_options. mode == PLAN_MODE_TERSE  ? "Terse" : "Verbose"));
	PrintB (win, 1, 7, Fmt ("[D] Done file: %s",
		plan_options. done_file [0] == '\0' ? "None" :
				plan_options. done_file));
	PrintB (win, 1, 8, Fmt ("[M] Min civs to move: %d",
		plan_options. min_to_move));
	PrintB (win, 1, 9, Fmt ("[S] Set defaults: %s",
		plan_options. set_thresholds ? "Yes" : "No"));

	PrintB (win, 1, 11, "[X] Exit");
#endif

	cont = True;
	while (cont)
	{

		FlushWindow (win);

#ifdef X_VERSION
		if (! SelButtonAtWin (win, & x, & y, & button) ||
				button == MIDDLE_BUTTON)
		{
			cont = False;
			break;
		}

		func = PLAN_NO_FUNC;
#else
		SelectButtonChar (& button, & ch, & x, & y, "RCODMSX\033");
                if (interrupt || ch != '\0')
                {
                        if (interrupt)
                        {
                                interrupt = False;
                                cont = False;
				break;
                        }
                        else
                        {
				if (ch == '\033')
				{
					cont = False;
					break;
				}

				switch (ch)
				{

				case 'R':
					func = PLAN_RUN_FUNC;
					y = PLAN_RUN_Y;
					break;

				case 'C':
					func = PLAN_CHANGE_FUNC; 
					break;

				case 'O':
					func = PLAN_OUTPUT_FUNC; 
					y = PLAN_OUTPUT_Y;
					x = 21;
					break;

				case 'D':
					func = PLAN_DONE_FUNC; 
					y = PLAN_DONE_Y;
					x = 14;
					break;

				case 'M':
					func = PLAN_MINCIV_FUNC; 
					y = PLAN_MINCIV_Y;
					x = 21;
					break;

				case 'S':
					func = PLAN_THRESH_FUNC; 
					y = PLAN_THRESH_Y;
					x = 17;
					break;

				case 'X':
					func = PLAN_EXIT_FUNC; 
					break;

				default:
					func = PLAN_NO_FUNC; 
					break;


				}
                        }
                }
		else if (button == MIDDLE_BUTTON)
		{
			cont = False;
			break;
		}

#endif /* TERMC_VERSION */


		if (func == PLAN_NO_FUNC)
			switch (y)
			{

			case PLAN_RUN_Y:
				func = PLAN_RUN_FUNC;
				break;
			
			case PLAN_CHANGE_Y:
				func = PLAN_CHANGE_FUNC;
				break;
			
			case PLAN_OUTPUT_Y:
				func = PLAN_OUTPUT_FUNC;
				x = 21;
				break;
			
			case PLAN_DONE_Y:
				func = PLAN_DONE_FUNC;
				x = 14;
				break;
			
			case PLAN_MINCIV_Y:
				func = PLAN_MINCIV_FUNC;
				x = 21;
				break;

			case PLAN_THRESH_Y:
				func = PLAN_THRESH_FUNC;
				x = 17;
				break;
			
			case PLAN_EXIT_Y:
				func = PLAN_EXIT_FUNC;
				break;

			default:
				func = PLAN_NO_FUNC;
				break;
			}
#ifdef TERMC_VERSION
		x += 2;
#endif
		
		switch (func)
		{

		case PLAN_RUN_FUNC:
			Message ("Running plan");
			RunPlan ();
			break;

		case PLAN_CHANGE_FUNC:
			EditPlanThreshold ();
			break;
			
		case PLAN_OUTPUT_FUNC:
			switch (plan_options. mode)
			{

			case PLAN_MODE_SILENT:
				i = PLAN_MODE_TERSE;
				ans = "Terse   ";
				break;

			case PLAN_MODE_TERSE:
				i = PLAN_MODE_VERBOSE;
				ans = "Verbose";
				break;

			case PLAN_MODE_VERBOSE:
				i = PLAN_MODE_SILENT;
				ans = "Silent ";
				break;
			}

			PrintB (win, x, y, ans);
			plan_options. mode = i;
			break;

		case PLAN_DONE_FUNC:
			PrintB (win, x, y,
				"                                       ");
			ans = GetString (win, x, y, 40, GS_TEXT);
			if (ans == (char *) 0 || interrupt)
			{
				PrintB (win, x, y,
					plan_options. done_file [0] == '\0'
						? "None"
						: plan_options. done_file);
				continue;
			}
			if (* ans == '\0')
			{
				plan_options. done_file [0] = '\0';
				PrintB (win, x, y, "None");
			}
			else
				(void) strcpy (plan_options. done_file, ans);
			
			continue;

		case PLAN_MINCIV_FUNC:
			PrintB (win, x, y, "    ");
			ans = GetString (win, x, y, 3, "0-9");
			if (ans != (char *) 0 && ! interrupt && * ans != '\0')
				plan_options. min_to_move = atoi (ans);

			PrintB (win, x, y, Fmt ("%d",
					plan_options. min_to_move));
			continue;

		case PLAN_THRESH_FUNC:
			plan_options. set_thresholds =
				plan_options. set_thresholds ? False : True;
			PrintB (win, x, y, plan_options. set_thresholds ?
					"Yes " : "No ");
			break;

		case PLAN_EXIT_FUNC:
			cont = False;
			break;
		}
	}

	DestroyWindow (win);
}

/*****************************************************************************
 *				RUN PLAN				     *
 *****************************************************************************/

struct s_sctinfo
{
	int x, y;
	int civs;
	int priority;
	Sector sct;
	PlanEntry plan;
};

typedef struct s_sctinfo * SctInfo;

#undef DLISTPTR
#undef ENTRYPTR

#define	DLISTPTR	DSList
#define ENTRYPTR	SctInfo

#include "dlist.h"

	/*
	 *	Returns (char *) 0 if everything went ok.
	 *	Otherwise an error message
	 */

static void PlanCheckMils (sct, strings)
Sector sct;
Strings strings;
{
	PlanEntry plan;
	int quant;
	Sector mils;

	plan = s_plan (sct);

	if (s_mil (sct) >= plan-> miln)
		return;

	switch (plan-> mil_how)
	{

	case PLAN_MIL_NONE:
		return;
	
	case PLAN_MIL_ENLIST:
		if (s_occ (sct) == '*')
		{
			AddString (strings,
				Fmt ("Couldn't enlist mil in %s",
					CrdStr (sct)));
			AddString (strings, "-> sector is occupied.");
		
			return;
		}

		FeedCommand (Fmt ("enlist %s -%d", CrdStr (sct), 
				plan-> miln), PRINT);
		set_mil (sct, plan-> miln);
		if (plan_options. mode == PLAN_MODE_VERBOSE)
			AddString (strings, Fmt ("%d enlisted in %s",
				plan-> miln, CrdStr (sct)));

		return;
	
	case PLAN_MIL_IMPORT:
		mils = World (plan-> milx, plan-> mily, S_EXIST);
		if (mils == (Sector) 0 || ! s_owned (mils))
		{
			AddString (strings,
				Fmt ("Couldn't import %d mil to %s.",
					plan-> miln, CrdStr (sct)));
			AddString (strings,
				Fmt ("-> You don't own %d,%d",
					plan-> milx, plan-> mily));
			return;
		}

		quant = plan-> miln - s_mil (sct);
		if (! ExecMove (mils, sct, quant, 'm'))
		{
			AddString (strings,
				Fmt ("Couldn't import %d mil to %s.",
					plan-> miln, CrdStr (sct)));
			AddString (strings, "-> move failed.");
			return;
		}

		if (plan_options. mode == PLAN_MODE_VERBOSE)
			AddString (strings,
				Fmt ("%d mil moved from %s to %s",
					quant, CrdStr (mils),
					CrdStr (sct)));
	}
}

static bool PlanActivateSector (sct, strings)
Sector sct;
Strings strings;
{
	PlanEntry plan;
	Sector wareh;
	int wx, wy;
	int quant;
	int i, j, k;
	char item;

	plan = s_plan (sct);

	/*	1 - Import food		*/

	wareh = (Sector) 0;
	if (s_pat (sct) != (char *) 0 && * s_pat (sct) != '_')
	{
		wx = s_dxc (sct);
		wy = s_dyc (sct);

		wareh = World (wx, wy, S_EXIST);
		if (! s_owned (wareh))
			wareh = (Sector) 0;
	}

	quant = (plan-> civmax + plan-> miln + q_uw (sct)) *
						etu_per_update * eatrate;
		/* hope 5 is enough for the new babies */
	quant += 5;
	quant -= q_foo (sct);
	if (quant > 0)
	{
		if (wareh == (Sector) 0)
		{
			AddString (strings,
				Fmt ("Couldn't activate sector %d,%d",
					s_xcd (sct), s_ycd (sct)));
			AddString (strings,
				"-> Doesn't have a warehouse. Needs food");

			return False;
		}
		
		if (! ExecMove (wareh, sct, quant, 'f'))
		{
			AddString (strings, 
				Fmt ("Couldn't activate sector %s",
					CrdStr (sct)));
			AddString (strings,
				Fmt ("-> Couldn't import %d food from %s",
					quant, CrdStr (wareh)));
			return False;
		}

		if (plan_options. mode == PLAN_MODE_VERBOSE)
			AddString (strings,
				Fmt ("Moved %d food to %s (from %s)",
					quant, CrdStr (sct), CrdStr (wareh)));
	}

	/*	2 - Set Thresholds	*/

	for (i = 0; i < PLAN_NR_THRESH; i ++)
	{
		item = plan_thresh [i];
		j = GetThreshold (sct, item);
		k = plan-> thresh [i];
		if (j != k)
		{
			FeedCommand (Fmt ("threshold %c %s %d",
				item, CrdStr (sct), k), PRINT);
			SetThreshold (sct, item, k);

			if (plan_options. mode != PLAN_MODE_SILENT)
				AddString (strings,
					Fmt ("Set threshold %s to %d in %s",
						ItemName (CharToItem (item)),
						k, CrdStr (sct)));
		}
	}

	/*	3 - Check mils		*/
			
	PlanCheckMils (sct, strings);

	return True;
}

void RunPlanRec (sct, from, to, civ_from, civ_to, strings)
Sector sct;
DSList from, to;
int * civ_from, * civ_to;
Strings strings;
{
	SctInfo sinfo, ptr;
	Sector sect;
	PlanEntry plan;
	Neighb neighb;

	int civs;

	plan = s_plan (sct);
	plan-> done = True;

		/* Check if sct is active */
	if (! plan-> active && s_civ (sct) > 10)
	{
		if (s_nds (sct) == plan-> plandes)
		{
			if (PlanActivateSector (sct, strings))
			{
				if (plan_options. mode == PLAN_MODE_VERBOSE)
					AddString (strings,
					     Fmt ("Activated %s [no civ move]",
							CrdStr (sct)));
				plan-> active = True;
			}

		}
	}

	civs = 0;
	if (plan-> active)
	{
		if (plan-> civaft < plan-> civmax)
		{
			if (s_eff (sct) == 100)
			{
				civs = s_civ (sct) - plan-> civaft;
				if (civs >= plan_options. min_to_move)
				{
					sinfo = DLAddElem (from, TAIL);
					sinfo-> civs = civs;
					sinfo-> sct = sct;
					sinfo-> plan = plan;
					* civ_from += civs;
				}
			}
			else if (plan-> civmax > s_civ (sct))
			{
				civs = s_civ (sct) - plan-> civmax;
			}

		}
		else
		{
			civs = s_civ (sct) - plan-> civaft;
			if (civs > plan_options. min_to_move)
			{
				sinfo = DLAddElem (from, TAIL);
				sinfo-> civs = civs;
				sinfo-> sct = sct;
				sinfo-> plan = plan;

				* civ_from += civs;
			}

			civs = s_civ (sct) - plan-> civmax;
		}
	}

	if (civs < 0 || ! plan-> active)
	{

		if (! plan-> active)
			civs = plan-> civmax - s_civ (sct);
		else
			civs = - civs;

		sinfo = (SctInfo) 0;
		for (ptr = DLGet (to, HEAD);
		     ptr != (SctInfo) 0;
		     ptr = DLGet (to, NEXT))
		{
			if (ptr-> priority > plan-> priority)
			{
				sinfo = DLInsElem (to, CURRENT);
				break;
			}
		}

		if (sinfo == (SctInfo) 0)
			sinfo = DLAddElem (to, TAIL);
		
		sinfo-> priority = plan-> priority;
		sinfo-> plan = plan;
		sinfo-> sct = sct;
		sinfo-> civs = civs;

		* civ_to += civs;
	}

	InitNeighbours (sct, & neighb);
	while (NextNeighbour (& sect, S_EXIST, neighb))
		if (sect != (Sector) 0 && s_owned (sect))
		{
			plan = s_plan (sect);
			if (plan != (PlanEntry) 0)
				if (! plan-> done)
					RunPlanRec (sect, from , to,
						civ_from, civ_to, strings);
		}
}

static int PlanMove (from, tsct, i, strings)
DSList from;
Sector tsct;	/* read as to sct */
int i;
Strings strings;
{
	Sector best_from, fsct;
	SctInfo sinfo, best, ptr;
	double cost, best_cost;
	int mob_allows, quant;
	char * path;

	best_cost = 9999.9;
	best_from = (Sector) 0;
	fsct = (Sector) 0;

	for (sinfo = DLGet (from, HEAD);
	     sinfo != (SctInfo) 0;
	     sinfo = DLGet (from, NEXT))
	{
		fsct = sinfo-> sct;
		path = BestLandPath (fsct, tsct);
		if (path == (char *) 0)	/* can not happen, but .. */
			continue;
		
		cost = RealPathCost (fsct, path);

		if (strlen (path) == 1 || cost == 0.0)
			break;

		if (cost < best_cost)
		{
			best_cost = cost;
			best_from = fsct;
			best = sinfo;
		}
	}

	if (sinfo == (SctInfo) 0)
	{
		cost = best_cost;
		fsct = best_from;
		sinfo = best;
	}

	if (fsct == (Sector) 0)
		return 0;		/* Error ? */

	if (cost == 0.0)
		mob_allows = 99999;
	else
		mob_allows = (int) (s_mob (fsct) /
				(cost * ItemWeight (V_CIVIL, NPKG)));

	if (mob_allows == 0)
		return 0;

	quant = i;
	if (quant > sinfo-> civs)
		quant = sinfo-> civs;
	
	if (quant > mob_allows)
		quant = mob_allows;

	if (! ExecMove (fsct, tsct, quant, 'c'))
	{
		AddString (strings, Fmt (
			"Move (%d civ from %s to %s) failed",
				quant, CrdStr (fsct),
				CrdStr (tsct)));
		return 0;
	}

	if (plan_options. mode != PLAN_MODE_TERSE)
		AddString (strings,
			Fmt ("Moved %d civilians from %s to %s",
				quant, CrdStr (fsct), CrdStr (tsct)));

	if (quant == sinfo-> civs)
	{
		if (plan_options. mode == PLAN_MODE_VERBOSE)
			AddString (strings, Fmt ("Sector %s exhausted",
				CrdStr (sinfo-> sct)));
		for (ptr = DLGet (from, HEAD);
		     ptr != (SctInfo) 0;
		     ptr = DLGet (from, NEXT))
			if (ptr == sinfo)
				DLDelete (from, CURRENT, FREE);
	}
	else
		sinfo-> civs -= quant;
	
	if (quant < i)
		return quant + PlanMove (from, tsct, i - quant,
					strings);
	else
		return quant;
}

Strings DoRunPlan (sct)
Sector sct;
{
	PlanEntry plan;
	DSList from, to;
	int civ_from, civ_to;
	int x, y, i, j;
	Sector sect;
	Strings strings;
	SctInfo sinfo;

	from = DLNew (0, sizeof (struct s_sctinfo));
	to   = DLNew (0, sizeof (struct s_sctinfo));

	civ_from = 0;
	civ_to = 0;

	for (x = 0; x < MAX_X; x ++) 
		for (y = 0; y < MAX_Y; y++)
		{
			sect = World (x, y, S_EXIST);
			if (sect == (Sector) 0 || ! s_owned (sect))
				continue;
			
			plan = s_plan (sect);
			if (plan == (PlanEntry) 0)
				continue;
			
			plan-> done = False;
		}

	strings = InitStrings ();

	RunPlanRec (sct, from, to, & civ_from, & civ_to, strings);

	if (plan_options. mode == PLAN_MODE_VERBOSE)
	{
		AddString (strings,
			Fmt ("Civilians to distribute: %d", civ_from));
		AddString (strings,
			Fmt ("Civilians needed: %d", civ_to));

		AddString (strings, "");

		AddString (strings, Fmt ("To sector list (%d sectors):",
				DLElems (to)));
		for (sinfo = DLGet (to, HEAD);
		     sinfo != (SctInfo) 0;
		     sinfo = DLGet (to, NEXT))
			AddString (strings, Fmt ("%-10s %c needs %-3d civs",
				CrdStr (sinfo-> sct),
				sinfo-> plan-> plandes,
				sinfo-> civs));
		AddString (strings, "");

		AddString (strings, Fmt ("From sector list (%d sectors):",
				DLElems (from)));
		for (sinfo = DLGet (from, HEAD);
		     sinfo != (SctInfo) 0;
		     sinfo = DLGet (from, NEXT))
			AddString (strings, Fmt ("%-10s %c spends %-3d civs",
				CrdStr (sinfo-> sct),
				sinfo-> plan-> plandes,
				sinfo-> civs));
		AddString (strings, "");
	}

	for (sinfo = DLGet (to, HEAD);
	     sinfo != (SctInfo) 0 && civ_from > 0 && DLElems (from) > 0;
	     sinfo = DLGet (to, NEXT))
	{
		plan = sinfo-> plan;
		sct = sinfo-> sct;

		if (civ_from < plan-> civmin && ! plan-> active)
			continue;
		
		i = plan-> civmax;
		if (i > civ_from)
			i = civ_from;
		
		if (! PlanActivateSector (sct, strings))
		{
			AddString (strings, Fmt ("Sector %s skipped",
					CrdStr (sct)));
			continue;
		}

		if (plan_options. mode != PLAN_MODE_SILENT)
			AddString (strings, Fmt ("Activated %s",
					CrdStr (sct)));
		plan-> active = True;
		
		j = PlanMove (from, sct, sinfo-> civs , strings);

		if (plan-> plandes != s_nds (sct))
		{
			DoDesignate (CrdStr (sct), plan-> plandes);
			if (plan_options. mode == PLAN_MODE_VERBOSE)
				AddString (strings,
					Fmt ("Redesignated %s to a %s",
						CrdStr (sct),
						DesignName (plan-> plandes)));
		}
		civ_from -= j;
	}

	return strings;
}

void RunPlan ()
{
	Sector sct;
	int x, y;
	Strings strings;
	SctInfo sinfo;
	char * ans;

	ans = InputAtMessage ("Start at which sector: ", 9, GS_SECTOR);
	if (ans == (char *) 0 || interrupt || * ans == '\0')
	{
		Message ("Run plan cancelled.");
		return;
	}

	if (sscanf (ans, "%d,%d", & x, & y) != 2)
	{
		Bell ();
		Message ("Illegal sector format !");
		return;
	}

	sct = World (x, y, S_EXIST);
	if (sct == (Sector) 0 || ! s_owned (sct))
	{
		Message ("You can only run plan from a sector you own!");
		Bell ();
		return;
	}

	if (s_plan (sct) == (PlanEntry) 0)
	{
		Message ("This sector doesn't have a plan!");
		Bell ();
		return;
	}

	strings = DoRunPlan (sct);
	Message ("plan run completed");

#ifdef X_VERSION
	InitWMPager (strings, "Output of running plan");
#else
	ShowStringsInPager (strings, "Output of running plan");
#endif

}

/*****************************************************************************
 *			PARSER FUNCTIONS				     *
 *****************************************************************************/

bool HasPlan (sct)
Sector sct;
{
	return (sct != (Sector) 0 &&
		s_owned (sct) &&
		s_plan (sct) != (PlanEntry) 0);
}

bool IsActive (sct)
Sector sct;
{
	PlanEntry plan;

	if (sct == (Sector) 0 || ! s_owned (sct))
		return False;
	
	plan = s_plan (sct);
	if (s_plan (sct) == (PlanEntry) 0)
		return False;

	return plan-> active;
}

void UtilPlan (arg)
char * arg;
{
	int x, y;
	Sector sct;
	PlanEntry plan;
	Strings strings;

	if (* arg == '\0' || sscanf (arg, ":%d,%d", & x, & y) != 2)
		x = y = 0;
	
	printf ("Running plan utility [start = %d,%d]\n", x, y);
	sct = World (x, y, S_EXIST);
	if (sct == (Sector) 0)
	{
		printf ("No information about %d,%d\n", x, y);
		return;
	}
	
	if (! s_owned (sct))
	{
		printf ("You don't own %d,%d\n", x, y);
		return;
	}

	plan = s_plan (sct);
	if (plan == (PlanEntry) 0)
	{
		printf ("Sector %d,%d doesn't have a a plan.\n", x, y);
		return;
	}

	strings = DoRunPlan (sct);
	DumpStrings (strings);
	if (plan_options. done_file [0] != '\0')
		(void) creat (plan_options, 0644);
}

char PlanDesign (plan)
PlanEntry plan;
{
	return plan-> plandes;
}
