/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/util/RCS/f_cargo.c,v 5.3 1995/09/28 12:13:53 jpo Exp $
    $Date: 1995/09/28 12:13:53 $
    $Author: jpo $
    $Id: f_cargo.c,v 5.3 1995/09/28 12:13:53 jpo Exp $
    $Locker:  $
    $Log: f_cargo.c,v $
    Revision 5.3  1995/09/28 12:13:53  jpo
    Change load syntax - just in case.

    Revision 5.2  1995/09/08 07:48:13  jpo
    touch up

 * Revision 5.1  93/03/14  16:52:53  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:24:11  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:45:54  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "main.h"
#include "ferry.h"
#include "sector.h"
#include "ship.h"

static void PrintCargoLine (win, ferry, item)
WinInfo win;
Ferry ferry;
int item;
{
	bool used;

	used = IS_A_TO_B (ferry-> dir [item]) |
	       IS_B_TO_A (ferry-> dir [item]);

	PrintN (win, 1,
#ifdef X_VERSION
		LINE_ITEMS + item,
#else
		LINE_ITEMS + item - 1,
#endif 
			Fmt ("%-16s   %-6s        %-5s %-6s  %-6s  %-6s",

		ItemName (item),

		IS_A_TO_B (ferry-> dir [item]) ? "A to B" :
			IS_B_TO_A (ferry-> dir [item]) ? "B to A" : "  --",

		used ? Fmt ("%d", ferry-> thr_ship [item]) : "",

		used ? Fmt ("%c:%d",
			IS_A_TO_B (ferry-> dir [item]) ? 'A' : 'B',
			ferry-> thr_sct [item]) : "",

		used ? Fmt ("%d", ferry-> max_ship [item]) : "",

		used ? Fmt ("%c:%s",
			IS_A_TO_B (ferry-> dir [item]) ? 'A' : 'B',
			IMPORT (ferry-> dir [item]) ? "Yes" : "No") : ""));

	FlushWindow (win);
	Refresh ();
}

int EditCargo (win, ferry, init)
WinInfo win;
Ferry ferry;
bool init;
{
	int item;
	char * ptr, * ans;
	int x, y;
	int i;
	char ch;
	bool first_pass;
	bool err;
	bool cont;

	ClearWindow (win);
#ifdef TERMC_VERSION

	PrintN (win, 1, 0, Centered (Fmt (
			"-=[ Ferry Utility : Cargo ferry #%d ]=-",
				ferry-> id), F_MAX_X));
	
	Refresh ();

#else /* X_VERSION */

	PrintB (win, 1, 1, Centered ("-=[ Ferry Utility : Cargo ]=-",
					F_MAX_X));

	PrintB (win, 1, 3, Fmt ("Ferry# %d", ferry-> id));

#endif /* VERSION */

#ifdef lint
	x = y = 0;
#endif

			/*
			 *	Initialize ferry
			 */

	if (init)
	{
		ferry-> goto_a = False;

		for (i = 1; i < V_MAX; i ++)
		{
			ferry-> dir [i] = 0;
			SET_NOMOVE (ferry-> dir [i]);
			if (i == V_CIVIL)
			{
				SET_IMPORT (ferry-> dir [i]);
				ferry-> thr_ship [i] = 1;
				ferry-> thr_sct [i] = 200;
				ferry-> max_ship [i] = 9999;
			}
			else if (i == V_FOOD)
			{
				SET_IMPORT (ferry-> dir [i]);
				ferry-> thr_ship [i] = 50;
				ferry-> max_ship [i] = 200;
				ferry-> thr_sct [i] = 200;
			}
			else
			{
				SET_NOIMP (ferry-> dir [i]);
				ferry-> thr_ship [i] = 0;
				ferry-> thr_sct [i] = 0;
				ferry-> max_ship [i] = 9999;
			}
		}
	}

	y = 0;
	first_pass = True;
	err = False;
	cont = True;
	do 
	{
		item = y - LINE_ITEMS;

#ifdef TERMC_VERSION
		item ++;
#endif

			/* 
			 * 	Fleet / Ship
			 */

		if (first_pass || y == LINE_FLEET)
		{
			ClearLine (win, LINE_FLEET);

			if (y == LINE_FLEET || init)
			{
				if (! SelectFlSh (win, LINE_FLEET, ferry))
				{
					Bell ();

					if (init)
					{
						Message ("Add Ferry cancelled");
						DeleteFerry (ferry-> id);
						return RET_DONE;
					}
				}
			}

			if ((ptr = CheckFlSh (ferry)) != (char *) 0)
			{
				if (first_pass && ! init)
					err = True;
				else
					Bell ();
			}

			PrintN (win, 1, LINE_FLEET, Fmt ("%-10s %-40s",
				ferry-> fleet == '\0' ?
					Fmt ("Ship %d", ferry-> shipnr) :
					Fmt ("Fleet %c", ferry-> fleet),
				ptr == (char *) 0 ?
					Fmt ("[now @ %s]", FerryPos (ferry)) :
					Fmt ("[Warning: %s !]", ptr)));
		}

			/*
			 *	Sector A
			 */

		if (first_pass || y == LINE_SECTA)
		{
			ClearLine (win, LINE_SECTA);

			if (y == LINE_SECTA || init)
			{
				if (! SelSector (win, LINE_SECTA,
						 "Sector A", True,
						 & (ferry-> ax),
						 & (ferry-> ay)))
				{
					Bell ();

					if (init)
					{
						Message ("Add Ferry cancelled");
						DeleteFerry (ferry-> id);
						return RET_DONE;
					}
				}

			}

			ptr = CheckSector (ferry-> ax, ferry-> ay, TASK_CARGO);
				
			if (ptr == (char *) 0 && s_pat (World (ferry-> ax,
					    ferry-> ay, S_EXIST)) == (char *) 0)
				ptr = "No warehouse";

			if (ptr  != (char *) 0)
				if (first_pass && ! init)
					err = True;
				else
					Bell ();

			PrintN (win, 1, LINE_SECTA, Fmt ("%-20s %-35s",
				Fmt ("Sector A: %d,%d", ferry-> ax, ferry-> ay),
				ptr == (char *) 0 ?
					"[OK]" :
					Fmt ("[Warning: %s !]", ptr)));
		}

			/*
			 *	Sector B
			 */

		if (first_pass || y == LINE_SECTB)
		{
			ClearLine (win, LINE_SECTB);

			if (y == LINE_SECTB || init)
			{
				if (! SelSector (win, LINE_SECTB, "Sector B",
					False, & (ferry-> bx), & (ferry-> by)))
				{
					Bell ();

					if (init)
					{
						Message ("Add Ferry cancelled");
						DeleteFerry (ferry-> id);
						return RET_DONE;
					}
				}

			}

			ptr = CheckSector (ferry-> bx, ferry-> by, TASK_CARGO);

			if (ptr == (char *) 0 && s_pat (World (ferry-> bx,
					    ferry-> by, S_EXIST)) == (char *) 0)
				ptr = "No warehouse";

			if (ptr  != (char *) 0)
				if (first_pass && ! init)
					err = True;
				else
					Bell ();

			PrintN (win, 1, LINE_SECTB, Fmt ("%-20s %-35s",
				Fmt ("Sector B: %d,%d", ferry-> bx, ferry-> by),
				ptr == (char *) 0 ?
					"[OK]" :
					Fmt ("[Warning: %s !]", ptr)));
		}


			/*
			 *	Mobility warehouse
			 */

		if (first_pass || y == LINE_WAREH)
		{
			PrintN (win, 0, LINE_WAREH, Fmt ("%-32s", ""));

			if (y == LINE_WAREH || init)
			{
				ans = GetQuest (win, LINE_WAREH,
					"Threshold mob warehouse [50]: ",
					3, GS_PNUMBER);
				
				if (ans == (char *) 0 || interrupt)
				{
					interrupt = False;
					Bell ();

					if (init)
					{
						Message ("Add Ferry cancelled");
						DeleteFerry (ferry-> id);
						return RET_DONE;
					}
				}

				if (ans == (char *) 0);
				else if (* ans == '\0')
					ferry-> waremob = 50;
				else
				{
					ferry-> waremob = atoi (ans);
					if (ferry-> waremob > MAX_SECTMOB)
					{
						Bell ();
						ferry-> waremob = MAX_SECTMOB;
					}
				}
			}

			PrintN (win, 1, LINE_WAREH,
				Fmt ("Threshold mob warehouse: %-10d",
				ferry-> waremob));
		}
						
		if (y == LINE_ACTIVE || first_pass)
		{
			if (! init && y == LINE_ACTIVE)
				ferry-> active = ! ferry-> active;

			ClearLine (win, LINE_ACTIVE);
			PrintN (win, 1, LINE_ACTIVE, Fmt ("Ferry is %sactive",
				ferry-> active ? "": "NOT "));
		}

		if (y == LINE_DIR || first_pass)
		{
			if (! init && y == LINE_DIR)
				ferry-> goto_a = ! ferry-> goto_a;

			PrintN (win, 1, LINE_DIR, Fmt ("Now moving to %c",
				ferry-> goto_a ? 'A' : 'B'));
		}
				
		if (item >= 1 && item < V_MAX && ! first_pass)
		{
			if (x > 18 && x < 28)	/* direction */
			{
				if (IS_A_TO_B (ferry-> dir [item]))
					SET_B_TO_A (ferry-> dir [item]);
				else if (IS_B_TO_A (ferry-> dir [item]))
					SET_NOMOVE (ferry-> dir [item]);
				else 
					SET_A_TO_B (ferry-> dir [item]);
				
				PrintCargoLine (win, ferry, item);
			}
			else if (IS_NOMOVE (ferry-> dir [item]))
			{
				Bell ();
			}
			else if (x > 33 && x < 38)
			{
				PrintN (win, 34, y, "      ");
				ans = GetString (win, 34, y, 4, GS_PNUMBER);

				if (interrupt)
					interrupt = False;

				if (ans != (char *) 0 && * ans != '\0')
					ferry-> thr_ship [item] = atoi (ans);
			}
			else if (x > 39 && x < 46)	/* threshold sct */
			{
				PrintN (win, 42, y, "      ");
				ans = GetString (win, 42, y, 4, GS_PNUMBER);

				if (interrupt)
					interrupt = False;

				if (ans != (char *) 0 && * ans != '\0')
					ferry-> thr_sct [item] = atoi (ans);
			}
			else if (x > 47 && x < 52)	/* max ship quant */
			{
				PrintN (win, 48, y, "    ");
				ans = GetString (win, 48, y, 4, GS_PNUMBER);

				if (interrupt)
					interrupt = False;
				
				if (ans != (char *) 0 && * ans != '\0')
					ferry-> max_ship [item] = atoi (ans);

			}			
			else if (x > 55 && x < 60)	/* import */
			{
				if (IMPORT (ferry-> dir [item]))
					SET_NOIMP (ferry-> dir [item]);
				else
					SET_IMPORT (ferry-> dir [item]);
			}

			PrintCargoLine (win, ferry, item);
		}

		/* XXX */

		if (! first_pass && y == LINE_LOW)
		{
			if (FerButPressed (x, F_SX_DONE, 4))
				return RET_DONE;
			else if (FerButPressed (x, F_SX_PREV, 4))
				return RET_PREV;
			else if (FerButPressed (x, F_SX_RUN, 3))
			{
				DoFerry (ferry-> id);
				return RET_DONE;
			}
			else if (FerButPressed (x, F_SX_NEXT, 4))
				return RET_NEXT;
			else if (FerButPressed (x, F_SX_DELETE, 6))
				if (Confirm ("Delete this ferry ?", True))
					return RET_DELE;
		}

		if (first_pass)
		{
			if (err && ! init)
				Bell ();

			first_pass = False;

			PrintN (win, 36, LINE_HEADER -1, "Threshold");
			PrintN (win, 1, LINE_HEADER,
	"Item              Direction      Ship  Sector  Max     Import");

			for (item = 1; item < V_MAX; item ++)
				PrintCargoLine (win, ferry, item);

			FerButton (win, F_SX_DONE,   LINE_LOW, "Done");
			FerButton (win, F_SX_PREV,   LINE_LOW, "Prev");
			FerButton (win, F_SX_RUN,    LINE_LOW, "Run");
			FerButton (win, F_SX_NEXT,   LINE_LOW, "Next");
			FerButton (win, F_SX_DELETE, LINE_LOW, "Delete");

			if (init)
				init = False;
		}

		FlushWindow (win);
		Refresh ();
#ifdef X_VERSION
		cont = SelButtonAtWin (win, & x, & y, (int *) 0);
#else
		SelectButtonChar ((int *) 0, & ch, & x, & y, "DPNRP\033");
		if (interrupt || ch != '\0')
		{
			if (interrupt)
			{
				interrupt = False;
				cont = False;
			}
			else
			{
				y = LINE_LOW;
				SetXAtButton (& x, ch);
			}
		}
#endif
	}
	while (cont);
					
	return RET_DONE;
}

static void CargoLoad (ship, item, sct, ferry)
Ship ship;
int item;
Sector sct;
Ferry ferry;
{
	char itemchar;
	char * ptr;
	int quant, in_sect, in_ship, imp_quant;
	int in_ware = 0;
	int max;
	char * path;
	Sector wareh = (Sector) 0;
	double move_cost, item_cost;
	int ware_mob;
	bool tomuch;
	int thresh, thr_mob;
	bool import;
	int flag;

	thresh = ferry-> thr_sct [item];
	thr_mob = ferry-> waremob;
	import = IMPORT (ferry-> dir [item]);

	itemchar = ItemChar(item);

	flag = util_mode ? DONT_PRINT : PRINT;

	if (s_pat (sct) != (char *) 0)
	{
		wareh = World (s_dxc (sct), s_dyc (sct), S_EXIST);

		in_ware = GiveQuant (wareh, itemchar);

		if ((itemchar == 'c' && GiveQuant (wareh, 'm') == 0) ||
		    (itemchar == 'm' && GiveQuant (wareh, 'c') == 0))
			in_ware--;
		ware_mob = s_mob (wareh);
	}

	in_ship = GiveShipQuant (ship, itemchar);
	in_sect = GiveQuant (sct, itemchar);

	max = MaxShipCargo (ship, itemchar);
	if (max > ferry-> max_ship [item])
		max = ferry-> max_ship [item];

	quant = max - in_ship;

	if (quant > (in_sect - thresh) && wareh != (Sector) 0 && in_ware > 0
					&& ware_mob > thr_mob && import)
	{
		/* move goods from warehouse to harbor */

		imp_quant = quant - (in_sect - thresh);

		if (imp_quant > in_ware)
			imp_quant = in_ware;
			
		path = ReversePath (s_pat (sct));
		move_cost = RealPathCost (wareh, path);
		item_cost = ItemWeight (item, WPKG);

		tomuch = False;
		if (((double) (ware_mob - thr_mob)) <
					imp_quant * move_cost * item_cost)
		{
			imp_quant = (int) (((double) (ware_mob - thr_mob)) /
					(move_cost * item_cost));
			tomuch = True;
		}

		FeedEmpire (Fmt ("move %c %s %d %s", itemchar, CrdStr (wareh),
			imp_quant, path), flag);

		ptr = ReadEmpire (flag);

		if (sscanf (ptr, "<%d.%*d", & ware_mob) == 1)
		{
			(void) WaitForPrompt (flag);
			FeedEmpire ("h", flag);
			(void) WaitForPrompt (flag);

			ShowText (Fmt (
				"Imported %s%d %s from warehouse @ %s",
				tomuch ? "(only) " : "",
				imp_quant,
				ItemName (item),
				CrdStr (wareh)));

			set_mob (wareh, ware_mob);
			SetQuant (wareh, itemchar, in_ware - imp_quant);
			SetQuant (sct, itemchar, in_sect + imp_quant);
			in_sect += imp_quant;
		}
		else
		{
			ShowText (
				Fmt (
				"Importing %d %s from %s (via \"%s\") failed !",
					imp_quant, ItemName (item),
					CrdStr (wareh), path));

			(void) WaitForPrompt (flag);
			FeedEmpire ("h", flag);
			(void) WaitForPrompt (flag);
		}
	}

	if (quant > (in_sect - thresh))
		quant = (in_sect - thresh);

	if (quant <= 0)
		return;

	if (emp3server == 2)
		FeedEmpire (Fmt ("load %c %d %d",
				 itemchar, ship -> nr, quant), flag);   
	else
		FeedEmpire (Fmt ("load %d %d %c", ship-> nr,
				 quant, itemchar), flag);
	ShowText (Fmt ("%s #%d loaded %s%d %s in %s",
		ShipName (ship),
		ship-> nr,
		tomuch ? "(only) " : "",
		quant,
		ItemName (item),
		CrdStr (sct)));

	while (EmpireStatus () != E_COMMAND)
	{
		ptr = ReadEmpire (flag);
		if (EmpireStatus () == E_COMMAND && flag == PRINT)
			PrintAtEmpire (ptr);

		if (StrEQ (ptr, "No ships affected") ||
						EmpireStatus () == E_QUESTION)
		{
			ShowText ("Something went wrong while loading ship !!");
			(void) WaitForPrompt (flag);
			while (EmpireStatus () != E_COMMAND)
			{
				FeedEmpire ("aborted", flag);
				(void) WaitForPrompt (flag);
			}
			return;
		}
	}

	SetQuant (sct, itemchar, in_sect - quant);
	SetShipQuant (ship, itemchar, in_ship + quant);
}

static void CargoUnload (ship, item, sct, ferry)
Ship ship;
int item;
Sector sct;
Ferry ferry;
{
	char * ptr;
	int quant;
	char itemchar;
	int in_sect, in_ship;
	bool tomuch;
	int flag;

	itemchar = ItemChar (item);

	flag = util_mode ? DONT_PRINT : PRINT;

	in_ship = GiveShipQuant (ship, itemchar);

	if (in_ship <= ferry-> thr_ship [item])
		return;
	
	in_sect = GiveQuant (sct, itemchar);
	quant = in_ship - ferry-> thr_ship [item];

	if (in_sect == MAX_TO_LOAD)
		ShowText (Fmt (
			"%s #%d: unable to unload %s, sector %s already full",
				ShipName (ship),
				ship-> nr,
				ItemName (item),
				CrdStr (sct)));

	tomuch = False;

	if (quant + in_sect > MAX_TO_LOAD)
	{
		tomuch = True;
		quant = MAX_TO_LOAD - in_sect;
	}

	if (quant <= 0)
		return;

	if (emp3server == 2)
		FeedEmpire (Fmt ("unload %c %d %d", itemchar, ship-> nr,
				 quant), flag);
	else
		FeedEmpire (Fmt ("unload %d %d %c", ship-> nr,
				 quant, itemchar), flag);
	ShowText (Fmt ("%s #%d: unloaded %s%d %s in %s",
		ShipName (ship),
		ship-> nr,
		tomuch ? "(only) " : "",
		quant,
		ItemName (item),
		CrdStr (sct)));

	while (EmpireStatus () != E_COMMAND)
	{
		ptr = ReadEmpire (flag);
		if (EmpireStatus () == E_COMMAND && flag == PRINT)
			PrintAtEmpire (ptr);

		if (StrEQ (ptr, "No ships affected") ||
						EmpireStatus () == E_QUESTION)
		{
			ShowText ("Something went wrong while unloading ship!");

			(void) WaitForPrompt (flag);
			while (EmpireStatus () != E_COMMAND)
			{
				FeedEmpire ("aborted", flag);
				(void) WaitForPrompt (flag);
			}
			return;
		}
	}

	SetQuant (sct, itemchar, in_sect + quant);
	SetShipQuant (ship, itemchar, in_ship - quant);
}

	/*
	 *	Checks if the ferry is moving in the right
	 *	direction. Returns True when moving the wrong way
	 */

static bool CheckCargo (ship, ferry, i)
Ship ship;
Ferry ferry;
int i;
{
	
	int in_ship, max_ship;
	char itemchar;

		/*
		 *	geretourneerd wordt indien er voor dit item
		 *	een positief getal uit komt, dan moet de ferry
		 *	naar A.
		 */

	if (IS_NOMOVE (ferry-> dir [i]))
		return False;

	itemchar = ItemChar (i);
	in_ship = GiveShipQuant (ship, itemchar);
	max_ship = MaxShipCargo (ship, itemchar);

	if (max_ship > ferry-> max_ship [i])
		max_ship = ferry-> max_ship [i];

	if (ferry-> goto_a == (IS_A_TO_B (ferry-> dir [i]) ? True : False))
		return (in_ship < max_ship) ? True : False;
	else
		return (in_ship - ferry-> thr_ship [i]) > 0;
}

static bool CheckCargoDir (ferry)
Ferry ferry;
{
	int i;
	Ship ship;

	if (ferry-> fleet == '\0')
	{
		ship = NrToShip (ferry-> shipnr);
		for (i = 1; i < V_MAX; i ++)
			if (CheckCargo (ship, ferry, i))
				return True;
	}
	else
	{
		for (ship = shiplist; ship != (Ship) 0; ship = ship-> next)
			if (ship-> fleet == ferry-> fleet)
				for (i = 1; i < V_MAX; i ++)
					if (CheckCargo (ship, ferry, i))
						return True;
	}

	return False;
}
	
void RunCargoFerry (ferry)
Ferry ferry;
{
	char * ptr;
	Ship ship;
	Sector csct, old_sct;
	bool is_at_a, is_at_b;
	bool mob_left;
	int x, y;
	Sector to;
	int i;

	old_sct = csct = FerrySector (ferry);
	mob_left = True;

	for (;;)
	{
		is_at_a = (s_xcd (csct) == ferry-> ax && 
		           s_ycd (csct) == ferry-> ay);

		is_at_b = (s_xcd (csct) == ferry-> bx &&
			   s_ycd (csct) == ferry-> by);

		if (is_at_a && is_at_b)
		{
			ShowText ("Internal error ?? sect a == sect b");
			ShowText ("Aborted");
			if (! util_mode)
			{
				DrawSector (old_sct);
				if (old_sct != csct)
					DrawSector (csct);
			}
			return;
		}

		if (is_at_a || is_at_b)
		{
			ptr = CheckSector (s_xcd (csct),
					   s_ycd (csct),
					   TASK_CARGO);

			if (ptr != (char *) 0)
			{
				ShowText (Fmt ("Error, sct %d,%d: %s !",
					s_xcd (csct),
					s_ycd (csct),
					ptr));
				ShowText ("Aborted");
				if (! util_mode)
				{
					DrawSector (old_sct);
					if (old_sct != csct)
						DrawSector (csct);
				}
				return;
			}

			ShowText (Fmt ("(Un)loading in sector %c (%s)",
				is_at_a ? 'A' : 'B',
				CrdStr (csct)));

			for (i = 1; i < V_MAX; i ++)
			{
			    if ((is_at_a && IS_B_TO_A (ferry-> dir [i])) ||
				(is_at_b && IS_A_TO_B (ferry-> dir [i])))
			    {
			    	/* unloading */

			    	if (ferry-> fleet == '\0')
			    	    CargoUnload (NrToShip (ferry-> shipnr),
					i, csct, ferry);
				else
				    for (ship = shiplist; ship != (Ship) 0;
							     ship = ship-> next)
					if (ship-> fleet == ferry-> fleet)
					    CargoUnload (ship, i, csct,
							 ferry);
			    }
			    else if ((is_at_a && IS_A_TO_B (ferry-> dir [i])) ||
				     (is_at_b && IS_B_TO_A (ferry-> dir [i])))
			    {
				/* loading */

				if (ferry-> fleet == '\0')
				    CargoLoad (NrToShip (ferry-> shipnr),
					i, csct, ferry);
				else
				    for (ship = shiplist; ship != (Ship) 0;
							     ship = ship-> next)
					if (ship-> fleet == ferry-> fleet)
					    CargoLoad (ship, i, csct,
								ferry);
			    }
			}

			if (is_at_a)
				ferry-> goto_a = False;
			else
				ferry-> goto_a = True;
		}

		if (! mob_left)
		{
			ShowText ("Done");

			if (! util_mode)
			{
				DrawSector (old_sct);
				if (old_sct != csct)
					DrawSector (csct);
			}
			return;
		}

		if (! CheckCargoDir (ferry))
		{
			ShowText ("Turning ferry around");
			ferry-> goto_a = ! ferry-> goto_a;
		}

		x = ferry-> goto_a ? ferry-> ax : ferry-> bx;
		y = ferry-> goto_a ? ferry-> ay : ferry-> by;

		to = World (x, y, S_DESIG);
		if (to == FerrySector (ferry))
		{
			ShowText (Fmt ("Nothing to do. Staying @ %s",
							CrdStr (to)));
			ShowText ("Aborted");

			if (! util_mode)
			{
				DrawSector (old_sct);
				if (old_sct != csct)
					DrawSector (csct);
			}
			return;
		}

		ShowText (Fmt ("Moving to sector %c (%s)",
			ferry-> goto_a ? 'A' : 'B',
			CrdStr (to)));

		x = s_xcd (csct);
		y = s_ycd (csct);

		mob_left = NavigPath (
			ferry-> fleet,
			ferry-> shipnr,
			& x, & y,
			to);

		
		csct = World (x, y, S_DESIG);

		if (! mob_left)
			if (csct == to)
				ShowText ("Just made it");
		else if (csct == to)
			ShowText ("Got there.");
	}
}
