/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/update/RCS/sect.c,v 5.2 1995/09/08 07:47:04 jpo Exp $
    $Date: 1995/09/08 07:47:04 $
    $Author: jpo $
    $Id: sect.c,v 5.2 1995/09/08 07:47:04 jpo Exp $
    $Locker:  $
    $Log: sect.c,v $
    Revision 5.2  1995/09/08 07:47:04  jpo
    bits and pieces

 * Revision 5.1  93/03/14  16:52:37  etienne
 * 
 * 
 * Revision 5.0  93/02/06  09:23:58  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:44:42  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "var.h"
#include "sector.h"
#include "nation.h"
#include "version.h"

extern long upd_enlist;
extern long upd_totalciv;
extern long upd_totalmil;
extern long upd_totaluw;
extern double upd_bankint;
extern long upd_buildeff;
extern double upd_civ_taxes;

static void UpdDoDeliver(sct, strings)
Sector sct;
Strings strings;
{
	register int i;

	if (s_mob (sct) <= 0)
		return;

	for (i = 1; i <= V_MAX; i++)
	{
	        if ((i == V_CIVIL) || (i == V_MILIT))
			continue;
		UpdDeliver (sct, i, strings);
		if (s_mob (sct) <= 0)
			break;
	}
}

static void UpdateSector (sct, etus, strings)
Sector sct;
int etus;
Strings strings;
{
	extern	double eatrate;
	extern	double bankint;
	int	people;
	int	work, wor;
	int	n;
	int	starved;

	if (s_civ (sct) == 0 && s_mil (sct) == 0 && s_land (sct) == 0)
	{
		AddString (strings, Fmt ("You lost sector %d (no population)",
					CrdStr (sct)));
		set_owner (sct, 0); /* changed from unknow to deity ET */
		return;
	}

	if (!(land_units && EMPOption (BUDGET))) {

		work = roundavg((etus * PopulaceSct (sct)) / 100.0);

		if (s_eff (sct) < 100 || s_nds (sct) != s_des (sct))
		{
			n = BuildEff (sct, work/2);
			upd_buildeff -= (long) n;
			work -= n;
		}
	}

	people = s_civ (sct) + s_mil (sct) + q_uw (sct);

	if (s_des (sct) != 's')
	{
		if (land_units) {
			if (s_occ (sct) != '*')
				upd_totalciv += s_civ (sct);

			upd_totalmil += s_mil (sct);
			upd_totaluw += q_uw (sct);
		}

		if (!EMPOption (NOFOOD)) {
			if (q_foo (sct) < 1 + etus * people * eatrate)
				work -= GrowFood(sct, work, etus);

			starved = FeedSctPeople(sct, etus, True);

			if (starved > 0)
				AddString (strings,
					Fmt ("%d starved in %s.\n",
							starved, CrdStr (sct)));
		}

		if (starved > 0)
			Starvation(sct);
		else
		{
			wor = s_wor (sct);
			if (wor < 100)
				wor += 8 + (random () % 15);
			if (wor > 100)
				wor = 100;
			set_wor (sct, wor);

			(void) GrowPeople (sct, etus, True, strings);
		}

		if (land_units && EMPOption (BUDGET)) { 
			work = roundavg((etus * PopulaceSct (sct)) / 100.0);

			if (s_eff (sct) < 100 || s_nds (sct) != s_des (sct)) {
				n = BuildEff (sct, work/2);
				upd_buildeff -= (long) n;
				work -= n;
			}
		}
	}

		/*
		 *	XXX: Xemp doesn't handle plague (yet)
		 */

	if (s_des (sct) == 'e' && s_eff (sct) > 60 && s_occ (sct) != '*')
		upd_enlist -= UpdEnlist (sct, etus, True);

	if (s_des (sct) == 'b' && s_eff (sct) > 60)
		upd_bankint += q_bar (sct) * etus * bankint;

	if (s_eff (sct) > 60)
	{
			/*
			 *	Xemp doesn't update money (bank & capital)
			 */

		if (ProdChr (s_des (sct)) != (struct pchrstr *) 0)
			work -= UpdProduce (sct, work, strings);
	}

	if (s_civ (sct) == 0 && s_mil (sct) == 0)
	{
		AddString (strings, Fmt ("You lost sector %d (no population)",
					CrdStr (sct)));
		set_owner (sct, 0); /* changed from unknow to deity ET */
		return;
	}

	if (! land_units) {
		if (s_occ (sct) != '*')
			upd_totalciv += s_civ (sct);

		upd_totalmil += s_mil (sct);
		upd_totaluw += q_uw (sct);
	}

	set_ava (sct, work);
}

void UpdProdSect(realm, etus, strings)
char * realm;
int etus;
Strings strings;
{
	int x, y;
	Sector sct;
	extern	int pops[];
	int sx, sy, ex, ey;

	(void) ConvRealmToCoord (realm, & sx, & sy, & ex, & ey);

	/*
	 * first produce everything, then do deliveries
	 * and distributes
	 */

	for (y = sy; y <= ey; y ++)
		for (x = sx; x <= ex; x ++)
		{
			sct = World (x, y, S_EXIST);
			if (sct == (Sector) 0 || ! s_owned (sct))
				continue;

				/*
				 *	XXX: Xemp doesn't handle guerrilla (yet)
				 */

			/* taxes based on sector efficiency -- krf 19/02/92 */
			upd_civ_taxes += s_civ(sct)*s_eff(sct)/100.0*etus*money_civ;
			UpdateSector (sct, etus, strings);
		}
			
	for (y = sy; y <= ey; y ++)
		for (x = sx; x <= ex; x ++)
		{
			sct = World (x, y, S_EXIST);
			if (sct == (Sector) 0 || ! s_owned (sct))
				continue;
			
			UpdDoDeliver (sct, strings);
			
			if (!(land_units && EMPOption(BUDGET)))
				UpdDistribute (sct, strings, DBOTH);
		}
	if (land_units && EMPOption (BUDGET)) {
		for (y = sy; y <= ey; y ++)
			for (x = sx; x <= ex; x ++)
			{
				sct = World (x, y, S_EXIST);
				if (sct == (Sector) 0 || ! s_owned (sct))
					continue;

				UpdDistribute (sct, strings, DEXPORT);
			}
		for (y = sy; y <= ey; y ++)
			for (x = sx; x <= ex; x ++)
			{
				sct = World (x, y, S_EXIST);
				if (sct == (Sector) 0 || ! s_owned (sct))
					continue;

				UpdDistribute (sct, strings, DIMPORT);
			}
	}
}

int BuildEff (sct, work)
Sector sct;
int work;
{
	register int work_cost;
	int	total_cost;
	int	n;

	work_cost = 0;
	total_cost = 0;

	if (s_off (sct))
		return;

	if (s_des (sct) != s_nds (sct))
	{
		/*
		 * Tear down existing sector.
		 * Easier to destroy than to build.
		 */

		work_cost = (s_eff (sct) + 3) / 4;
		if (work_cost > work)
			work_cost = work;
		n = s_eff (sct) - work_cost * 4;
		if (n <= 0)
		{
			n = 0;
			set_des (sct, s_nds (sct));
		}

		set_eff (sct, n);
		work -= work_cost;
		total_cost += work_cost;
	}

	if (s_des (sct) == s_nds (sct))
	{
		work_cost = 100 - s_eff (sct);
		if (work_cost > work)
			work_cost = work;
		set_eff (sct, s_eff (sct) + work_cost);
		total_cost += work_cost;
	}

	return total_cost;
}

int GrowFood(sct, work, etus)
Sector sct;
int work;
int etus;
{
	double	food_fertil;
	double	food_workers;
	double	food;
	int	work_used;

/* I'm being very nice and commenting out this so players
 * won't whine about starvation
	if (sp->sct_fertil == 0 || work == 0)
		return 0;
 */
	food_workers = work * fcrate;
	food_fertil = etus * s_fer (sct) * fgrate;
	food = food_fertil;
	if (food > food_workers)
		food = food_workers;
	/*
	 * be nice; grow minimum one food unit.
	 * This makes life simpler for the player.
	 */

	set_q_foo (sct, q_foo (sct) + food);
	if (q_foo (sct) == 0)
		set_q_foo (sct, 1);
	if (q_foo (sct) > max_comm)
		set_q_foo (sct, max_comm);

	work_used = (int) food / fcrate;
	return work_used;
}

int UpdEnlist (sct, etus, upd)
Sector sct;
int etus;
bool upd;
{
	int	maxmil;
	int	enlisted;

	enlisted = 0;
	maxmil = (s_civ (sct) / 2) - s_mil (sct);
	if (maxmil > 0)
	{
		enlisted = (etus * (10 + s_mil (sct)) * 0.05);
		if (enlisted > maxmil)
			enlisted = maxmil;

		if (upd)
		{
			set_civ (sct, s_civ (sct) - enlisted);
			set_mil (sct, s_mil (sct) + enlisted);
		}
	}

	return enlisted;
}
