/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/update/RCS/plane.c,v 5.2 1995/09/08 07:46:44 jpo Exp $
    $Date: 1995/09/08 07:46:44 $
    $Author: jpo $
    $Id: plane.c,v 5.2 1995/09/08 07:46:44 jpo Exp $
    $Locker:  $
    $Log: plane.c,v $
    Revision 5.2  1995/09/08 07:46:44  jpo
    touch ups

 * Revision 5.1  93/03/14  16:52:31  etienne
 * 
 * 
 * Revision 5.0  93/02/06  09:23:58  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:44:42  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "sector.h"
#include "plane.h"
#include "nation.h"
#include "ship.h"
#include "version.h"

extern double upd_plane_eff;
extern double upd_plane_main;
extern double upd_milcost;

	/* ARGSUSED */
int UpdProdPlane(realm, etus, strings)
char * realm;
int etus;
Strings strings;
{
	Plane ptr;
	Sector sct;
	int	delta;
	int	mult;
	int	avail;
	int	w_p_eff;
	int	left;
	int	used;
	int sx, sy, ex, ey;

	(void) ConvRealmToCoord (realm, & sx, & sy, & ex, & ey);

	for ALL_PLANES (ptr)
	{
		if (! pl_owned (ptr) ||
		    pl_xcd (ptr) < sx || pl_xcd (ptr) > ex ||
		    pl_ycd (ptr) < sy || pl_ycd (ptr) > ey)
			continue;


			/*
			 *	Some checks deleted:
			 *
			 *	---	eff < 10
			 *	---	aircraft carrier still exists?
			 */

		upd_milcost += etus * (planetypes [pl_type (ptr)]. crew *
					money_mil * 5);
		
		mult = 1;
		if (n_tech (nation) < 0.85 * pl_tech (ptr))
			mult = 2;

		upd_plane_main += (double) mult * etus * dmin (-1.0,
				planetypes [pl_type (ptr)]. cost * money_plane);

		if (pl_launc (ptr))
			continue;

		left = 100 - pl_eff (ptr);
		if (left <= 0)
			continue;

		sct = PlaneSector (ptr);
		if (sct == (Sector) 0 || ! s_owned (sct))
			if (!(EMPOption (CARRIER_WORK) && s_des (sct) == '.'))
				continue;

		avail = s_ava (sct) * 100;

		if (EMPOption (CARRIER_WORK) && pl_shipnr (ptr) >= 0) 
			avail += (etus * sh_mil (NrToShip (pl_shipnr (ptr)))/2);

		w_p_eff = 20 +
			planetypes [pl_type (ptr)]. lcm +
			2 * planetypes [pl_type (ptr)]. hcm;

		delta = roundavg((double) avail / w_p_eff);

		if (delta <= 0)
			continue;
		if (delta > plane_eff_gain)
			delta = plane_eff_gain;
		if (delta > left)
			delta = left;
		used = delta * w_p_eff;

		avail = (s_ava (sct) * 100 - used) / 100;
		if (avail < 0)
			avail = 0;
		set_ava (sct, avail);
		if (s_des (sct) != '*')
			delta /= 3;

		upd_plane_eff -= (double) mult * delta *
				planetypes [pl_type (ptr)]. cost / 100.0;

		set_pl_eff (ptr, pl_eff (ptr) + delta);
	}
}
