/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/update/RCS/mobility.c,v 5.2 1995/09/08 07:46:39 jpo Exp $
    $Date: 1995/09/08 07:46:39 $
    $Author: jpo $
    $Id: mobility.c,v 5.2 1995/09/08 07:46:39 jpo Exp $
    $Locker:  $
    $Log: mobility.c,v $
    Revision 5.2  1995/09/08 07:46:39  jpo
    touch ups

 * Revision 5.1  93/03/14  16:52:29  etienne
 * 
 * 
 * Revision 5.0  93/02/06  09:23:58  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:44:42  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "sector.h"
#include "var.h"
#include "ship.h"
#include "plane.h"
#include "land.h"
#include "version.h"

void UpdMobSect (realm, etus)
char * realm;
int etus;
{
	register int x;
	register int y;
	Sector sct;
	int value;
	int sx, sy, ex, ey;

	(void) ConvRealmToCoord (realm, & sx, & sy, & ex, & ey);

	for (x = - MAX_X / 2; x < MAX_X / 2; x ++)
		for (y = - MAX_Y / 2 + (x % 2); y < MAX_Y / 2; y += 2)
		{
			if (x < sx || x > ex || y < sy || y > ey)
				continue;

			sct = World (x, y, S_EXIST);
			if (sct == (Sector) 0 || ! s_owned (sct))
				continue;
			
			value = s_mob (sct) + sect_mob_gain;
			if (value > sect_mob_max)
				value = sect_mob_max;
			set_mob (sct, value);
		}
}

void UpdMobShip (realm, etus)
char * realm;
int etus;
{
	Ship ptr;
	int value;
	int sx, sy, ex, ey;

	(void) ConvRealmToCoord (realm, & sx, & sy, & ex, & ey);

	for (ptr = shiplist; ptr != (Ship) 0; ptr = sh_next (ptr))
	{
		if (! sh_owned (ptr))
			continue;
		
		if (sh_xcd (ptr) < sx || sh_xcd (ptr) > ex ||
		    sh_ycd (ptr) < sy || sh_ycd (ptr) > ey)
			continue;

		value = sh_mob (ptr) + ship_mob_gain;
		if (value > ship_mob_max)
			value = ship_mob_max;

		/* TODO add fuel */
		set_sh_mob (ptr, value);
	}
}

void UpdMobLand (realm, etus)
char * realm;
int etus;
{
	Land ptr;
	int value;
	int sx, sy, ex, ey;

	(void) ConvRealmToCoord (realm, & sx, & sy, & ex, & ey);

	for (ptr = landlist; ptr != (Land) 0; ptr = ld_next (ptr))
	{
		if (! ld_owned (ptr))
			continue;
		
		if (ld_xcd (ptr) < sx || ld_xcd (ptr) > ex ||
		    ld_ycd (ptr) < sy || ld_ycd (ptr) > ey)
			continue;

		value = ld_mob (ptr) + land_mob_gain;
		if (value > land_mob_max)
			value = land_mob_max;

		/* TODO add fuel */
		set_ld_mob (ptr, value);
	}
}

void UpdMobPlane (realm, etus)
char * realm;
int etus;
{
	Plane ptr;
	int value;
	int sx, sy, ex, ey;

	(void) ConvRealmToCoord (realm, & sx, & sy, & ex, & ey);

	for ALL_PLANES (ptr)
	{
		if (! pl_owned (ptr))
			continue;
		
		if (pl_xcd (ptr) < sx || pl_xcd (ptr) > ex ||
		    pl_ycd (ptr) < sy || pl_ycd (ptr) > ey)
			continue;

		value = pl_mob (ptr) + plane_mob_gain;
		if (value > plane_mob_max)
			value = plane_mob_max;
		
		set_pl_mob (ptr, value);
	}
}
