/*
	$Header: /nexor/users/jpo/xemp/xemp5.0/lib/ship/RCS/selectone.c,v 1.3 1995/09/08 07:43:51 jpo Exp $
	$Date: 1995/09/08 07:43:51 $
	$Author: jpo $
	$Id: selectone.c,v 1.3 1995/09/08 07:43:51 jpo Exp $
	$Locker:  $
	$Log: selectone.c,v $
	Revision 1.3  1995/09/08 07:43:51  jpo
	const

	Revision 1.2  1995/08/15 08:01:58  jpo
	fixed up prototype

 * Revision 1.1  93/03/14  16:51:42  etienne
 * Initial revision
 * 
*/

#include "type.h"
#include "main.h"
#include "var.h"
#include "ship.h"
#include "land.h"
#include "sector.h"
#include "nation.h"

Ship SelectOneShip (x, y, shtask, quest)
int x, y;
ShTask shtask;
const char * quest;
{
	static char buffer [200];

	Strings strings;
	Pager pager;
	Ship ptr, ship;
	int func;
	int i;
	int nr, select;

	strings = InitStrings ();
	AddStringID (strings, 
		      Fmt ("Ship                   Fl Eff  Mob Civ Mil Pln%s%s Foo Tec",
			chainsaw_version ? " Hel Xpl" : "",
			land_units ? " Lnd" : ""), -1);

	for (ptr = s_fship (cursct); ptr != (Ship) 0; ptr = sh_nxtsct (ptr))
	{
		if (! sh_owned (ptr))
			continue;

		if (shtask == ST_LOADXPLANE && (sh_xpln (ptr) <= shiptypes [sh_type (ptr)] .xpl))
			continue;

		if (shtask == ST_LOADPLANE &&  (sh_pln (ptr) == shiptypes [sh_type (ptr)]. pla))
			continue;

		if (shtask == ST_LOADHELI && (sh_heli (ptr) == shiptypes [sh_type (ptr)]. hel))
			continue;

		if (shtask == ST_LOADLAND && (sh_land (ptr) == shiptypes [sh_type (ptr)] .land))
			continue;


		AddStringID (strings, Fmt (
			"%-4d %-16.16s  %c  %-3d%% %-3d %-3d %-3d %-3d%s%s %-3d %-4d",
				sh_nr (ptr),
				ShipName (ptr),
				sh_fleet (ptr),
				sh_eff (ptr),
				sh_mob (ptr),
				sh_civ (ptr),
				sh_mil (ptr),
				sh_pln (ptr),
				chainsaw_version ? Fmt (" %-3d %-3d", sh_xpln (ptr), sh_heli (ptr)) : "",
				land_units? Fmt (" %-3d", sh_land (ptr)) : "",
				sh_foo (ptr),
				sh_tech (ptr)),
			sh_nr (ptr));

		nr = sh_nr (ptr);
	}

	if (StringsSize (strings) == 1)
	{
		FreeStrings (strings);
		Message ("No available ships.");
		Bell ();
		return NULL;
	}

	pager = InitPager (strings, quest);
	MapPagerFromTop (pager, map_win, x, y);
	select = PagerMenu (pager);
	FreePager (pager);
	FreeStrings (strings);

	if (select < 0) {
		Message ("No Ship selected");
		Bell ();
		return;
	}
	return NrToShip (select);
}
