/*
	$Header: /nexor/users/jpo/xemp/xemp5.0/lib/ship/RCS/retreat.c,v 1.4 1995/09/10 17:44:03 jpo Exp $
	$Date: 1995/09/10 17:44:03 $
	$Author: jpo $
	$Id: retreat.c,v 1.4 1995/09/10 17:44:03 jpo Exp $
	$Locker:  $
	$Log: retreat.c,v $
	Revision 1.4  1995/09/10 17:44:03  jpo
	added prototype and made conditions more generic

	Revision 1.3  1995/09/10 16:25:28  jpo
	Generic support
	added fleet mode settings

	Revision 1.2  1995/09/08 07:43:36  jpo
	retreat stuff

	Revision 1.1  1993/03/14 16:51:38  etienne
	Initial revision

*/

#include "main.h"
#include "sector.h"
#include "ship.h"
#include "func.h"

const char *retreatcond[] = {
	"When damaged",
	"When torpedoed",
	"When 	bombed",
	"When sonar is detected",
	"When depth-charged",
	"When helpless",
	(char *)0
};


const char retreat_n2cond[] = "ITBSDH";

static bool ShipsRetreat _PROTO((const char *ships, uchar cond,
				 Sector sct, short *rtrxp, short *rtryp,
				 uchar *condp));

static bool ShipsRetreat (ships, cond, sct, rtrxp, rtryp, condp)
const char *ships;
uchar cond;
Sector sct;
short *rtrxp, *rtryp;
uchar *condp;
{
	Strings strings;
	Pager pager;
	char buf[10];
	char *cp;
	int nr;
	Sector to;
	int i;
	char *path;

	strings = InitStrings ();
	AddStringsID (strings, retreatcond,  RETREAT_MAXSTR, 0);
	MakeStringIndex (strings);
	for (i = 0; i < RETREAT_MAX; i++)
		if (cond & (1 << i))
			SetIthFlag (strings, i, 1);
	
	pager = InitPager (strings, "Retreat Conditions");
	AddPagerFunc (pager, "Cancel", CANCELFUNC);
	SetPagerButtons (pager, "Toggle", "Delete", "Done");
	SetPagerButtonIDs (pager, TOGGLEFUNC, DELETEFUNC, DONEFUNC);
	SetPagerSelect (pager);

	MapPagerFromTop (pager, map_win, 5, 5);
	for (;;) {
		int func;
		int i = PagerMenuFunc (pager, &func, (int *)0);
		if (i < 0 || interrupt || i == CANCELFUNC) {
			interrupt = False;
			FreePager (pager);
			FreeStrings (strings);
			return False;
		}
		switch (func) {
		    case TOGGLEFUNC:
			ToggleStringFlag (strings, i);
			RemapPager (pager);
			continue;

		    case DELETEFUNC:
			FreePager (pager);
			FreeStrings (strings);
			FeedCommand ( Fmt ("retreat %s h C", ships),
				     PRINT);
			*condp = RETREAT_NONE;
			*rtrxp = *rtryp = 0;
			return True;

		    case DONEFUNC:
			break;
		}
		break;
	}
	FreePager (pager);
	InitStringList (strings);
	cp = buf;
	cond = RETREAT_NONE;
	while ((nr = GetNextSelectedId (strings)) != -1) {
		*cp ++ = retreat_n2cond[nr];
		cond |= (1 << nr);
	}
	*cp = '\0';
	FreeStrings (strings);

	Message (Fmt ("Retreat %s to sector?", ships));
	to = ChooseSeaDest (sct, &path);
	if (to == NULL) {
		return;
	}
	*condp = cond;
	*rtrxp = s_xcd (to);
	*rtryp = s_ycd (to);
	FeedCommand ( Fmt ("retreat %s %s %s", ships, path, buf),
		     PRINT);
	return True;
}

void SRetreat (ship)
Ship ship;
{
	Strings strings;
	Pager pager;
	char buf[10];
	char *cp;
	int nr;
	Sector sct, to;
	int i;
	char *path;
	uchar cond;

	if (!sh_owned (ship)) {
		Message ("Not your ship !!");
		return;
	}

	sct = World (sh_xcd(ship), sh_ycd(ship), S_DESIG);

	(void) ShipsRetreat (Fmt ("%d", sh_nr(ship)),
			     ship -> rtrcond,
			     sct,
			     &ship -> rtrtx, &ship -> rtrty,
			     &ship -> rtrcond);
}

void FScanShipRetreat (list, flag)
const char *list;
int flag;
{
	FeedEmpire (Fmt ("retreat %s", list), flag);

	ScanShipRetreat (flag);
	(void) WaitForPrompt (flag);
}

void ScanShipRetreat (flag)
int flag;
{
	char *ptr, *ind;
	Ship ship;
	int sno;
	int flagoff, pathoff;
	int x, y;

	if (EmpireStatus () != E_PRINTING)
		return;
	if (flag == PRINT)
		PrintAtEmpire ("Empiretool: scanning ship retreats");
	
	ptr = ReadEmpire (DONT_PRINT);
	if ((ind = StrStr (ptr, "ship type")) == NULL) {
		PrintAtEmpire (Fmt ("Order scan failed on %s", ptr));
		return;
	}
	if ((ind = StrStr (ptr, "path")) == NULL) {
		PrintAtEmpire (Fmt ("No path in %s", ptr));
		return;
	}
	pathoff = ind - ptr;

	if ((ind = StrStr (ptr, "flags")) == NULL) {
		PrintAtEmpire (Fmt ("No flags in %s", ptr));
		return;
	}
	flagoff = ind - ptr;
	for (;;) {
		Sector to;
		ind = ptr = ReadEmpire (DONT_PRINT);

		if (EmpireStatus () != E_PRINTING) {
			if (flag == PRINT)
				PrintAtEmpire (ptr);
			return;
		}
		
		if (ScanDigit ((ConstVP)&ind, &sno)) /* ship name? */
			continue;
		if (strncmp (ind, "ship", 4) == 0) /* %d ships */
			break;
		if (strlen(ptr) < flagoff)
			continue;
		if ((ship = NrToShip (sno)) == (Ship)0) {
			PrintAtEmpire (Fmt ("#%d Unknown ship (rescan ships!)",
					    sno));
			Bell ();
			(void) EmpireMore ();
			continue;
		}
		ship -> rtrcond = RETREAT_NONE;
		for (ind = &ptr[flagoff]; *ind; ind ++) {
			char *cp;
			if ((cp = index (retreat_n2cond, *ind)) == NULL)
				continue;
			ship -> rtrcond |= (1 << (cp - retreat_n2cond));
		}
		ind = &ptr[pathoff];
		to = FollowPath (World(sh_xcd(ship), sh_ycd(ship), S_DESIG),
				 ind);
		ship -> rtrtx = s_xcd (to);
		ship -> rtrty = s_ycd (to);
	}
}

const char *RtrtList (cond)
uchar cond;
{
	static char buf[10], *cp;
	int i;

	for (cp = buf, i = 0; i < RETREAT_MAX; i++)
		if (cond & (1 << i))
			*cp++ = retreat_n2cond[i];
	*cp = '\0';
	return buf;
}

const char *FleetHasRetreat (fleet)
char fleet;
{
	Ship ptr;
	uchar rcond = 0;
	int first = 0;

	for (ptr = shiplist; ptr != (Ship) 0; ptr = ptr-> next)
		if (ptr-> fleet == fleet) {
			if (first++ == 0) 
				rcond = sh_retreat(ptr);
			else if (rcond != sh_retreat(ptr))
				return "Mixed";
		}
	
	if (rcond == RETREAT_NONE)
		return "No";
	return RtrtList (rcond);
}

void ChangeFleetRetreat (fleet)
char fleet;
{
	Sector sct;
	uchar rcond, cond;
	short rx, ry;
	Ship ptr;
	int first = 0;

	if (FleetEmpty (fleet)) {
		Message ("Empty fleet");
		return;
	}
	for (ptr = shiplist; ptr != (Ship) 0; ptr = ptr-> next)
		if (ptr-> fleet == fleet) {
			if (first++ == 0) 
				rcond = sh_retreat(ptr);
			else if (rcond != sh_retreat(ptr)) {
				rcond = 0;
				break;
			}
		}
	
	if ((sct = FleetSector (fleet)) == NULL)
		return;

	if (ShipsRetreat (Fmt ("%c", fleet),
			  rcond,
			  sct,
			  &rx, &ry,
			  &cond) == True) {
		for (ptr = shiplist; ptr != (Ship) 0; ptr = ptr-> next)
			if (ptr-> fleet == fleet) {
				ptr -> rtrcond = cond;
				ptr -> rtrtx = rx;
				ptr -> rtrty = ry;
			}
		CensusFleet (fleet);
	}
}
