/*
    $Header: /a/victor/nexor/user4/jpo/xemp/xemp5.0/lib/parse/RCS/run_all.c,v 5.3 1995/09/16 15:43:21 jpo Exp $
    $Date: 1995/09/16 15:43:21 $
    $Author: jpo $
    $Id: run_all.c,v 5.3 1995/09/16 15:43:21 jpo Exp $
    $Locker:  $
    $Log: run_all.c,v $
    Revision 5.3  1995/09/16 15:43:21  jpo
    Added missing break - and choose the right sector!

    Revision 5.2  1995/09/08 07:37:03  jpo
    clean up of types and names

 * Revision 5.1  93/03/14  16:50:41  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:23:02  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:40:53  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
/*
 * run_all.c
 */
				/* Don't link file in stand_alone version */
#include <string.h>

#include "main.h"
#include "parser.h"
#include "symtab.h"
#include "stack.h"
#include "Lpars.h"
#include "prog_defs.h"
#include "eval_stack.h"


#define FL_TEST_MOVE		0	/* Check how much one can move */
#define FL_RUN_MOVE		1	/* Perform actual move         */
#define THRESHOLD_MOBILITY	10	/* Save to move while mob > [#define] */

static EVALSTACK stack[STACK_SIZE];
static int sp;

extern double floor();
extern double ceil();

#define APPLY_OPERATOR(op, field) \
	stack[sp].e_value = \
		(stack[sp].field op stack[sp + 1].field) ? D1 : D0
#define STRING_COMPARE(field) \
	stack[sp].e_value = \
		(strcmp(stack[sp].field, stack[sp + 1].field) == 0) ? D1 : D0

/*
 * Local functions.
 */
static int ExecuteActionStatement _PROTO((Sector sct, Action action,
					  Strings outstr, Strings sendstr));
static int ExecMoveStatement _PROTO((Sector sct, Sector from_sct, Sector dest,
				     int *maxq, int comm, ExprList via,
				     int status));
static void ExecOutputStatement _PROTO((Sector sct, Output outlist,
					Strings strings));

static void RunExpression _PROTO((Sector sct, Stack expr, bool issub));
static void RunExpressionStack _PROTO((Sector sct, Stack expr, bool issub,
				       Ship ship, Plane plane, Nuke nuke));
static void RunTimeError _PROTO((...));
static Sector ParseFindSector _PROTO((Sector default_sct, Stack sector_expr));


double EvaluateExpression(sct, expr)
Sector sct;
Stack expr;
{
#if ! defined(STAND_ALONE)
	if (expr == NULL)
		return D0;

	RunExpression(sct, expr, False);

	return stack[0].e_value;
#endif
}


int RunProgram(sct, program, outp_str, send_str)
Sector sct;
Program program;
Strings outp_str, send_str;
{
#if ! defined(STAND_ALONE)
	Instruction instr;

	if (program == (Program) 0)
		return P_EMPTY;
	
	instr = (Instruction) program;

	if (instr->type != I_EXECUTE) {
		RunTimeError("Internal: Invalid program type %d", instr->type);
		return P_ERROR;
	}

	instr = instr->link;

	while (instr->type != I_STOP_PROGRAM && instr->type != I_ABORT) {
		if (instr->type == I_EVAL) {
			if (EvaluateExpression(sct, instr->expression) != D0)
				instr = instr->true_address;
			else
				instr = instr->false_address;
		}
		else if (instr->type == I_ACTION) {
			switch (ExecuteActionStatement(sct, instr->action,
					outp_str, send_str)) {
			case S_OK:
				instr = instr->next_address;
				break;
			case S_FAIL:
				instr = instr->fail_address;
				break;
			case S_ERROR:
				instr = instr->false_address;
				break;
			default:
				RunTimeError("Internal: action return value.");
				break;
			}
		}
		else if (instr->type == I_SET_COUNT) {
			*instr->loop_count = instr->number;
			instr = instr->next_address;
		}
		else if (instr->type == I_TEST_COUNT) {
			if (instr->number == 0)
				instr = instr->false_address;
			else {
				if (instr->number > 0)
					instr->number--;
				instr = instr->next_address;
			}
		}
		else {
			RunTimeError("Internal: Invalid program type %d",
				       instr->type);
			return P_ERROR;
		}
	}

	if (instr->type == I_ABORT)
		return P_ABORTED;
	
	return P_OK;
#endif
}

static Sector ParseFindSector(default_sct, sector_expr)
Sector default_sct;
Stack sector_expr;
{
#if ! defined(STAND_ALONE)
	if (sector_expr != (Stack) 0) {
		RunExpression(default_sct, sector_expr, False);
		return stack[0].e_sector;
	}

	return default_sct;
#endif
}

static Sector FindLocation(sct, loc)
Sector sct;
Location loc;
{
#if ! defined (STAND_ALONE)
	ExprList l;
	Sector w_sct;

	switch(loc->type) {
	case LOC_NONE:
		return sct;
	case LOC_SECTOR:
		return ParseFindSector(sct, loc->l_sector_expr);
	case LOC_WHERE:
		for(l = loc->l_where_list->next; l != NULL; l = l->next)
			if ((w_sct = Where(sct, loc->l_sector_expr)) != (Sector)0)
				return w_sct;
	}

	return NULL;
#endif
}


static int ExecuteActionStatement(sct, action, output_str, send_str)
Sector sct;
Action action;
Strings output_str, send_str;
{
#if ! defined(STAND_ALONE)
	Sector from_sct, dest_sct;
	int quantity, status;

	switch (action->type) {
	case SET_DISTRIBUTE:
		from_sct = ParseFindSector(sct, action->u_distribute->sector_expr);
		dest_sct = FindLocation(sct, &action->u_distribute->to_loc);

		if (from_sct == NULL)
			return S_FAIL;

		if (dest_sct == NULL)
			return S_FAIL;

		ExecSetDistr(from_sct, dest_sct, 1, False, True);
		break;
	case SET_DELIVER:
		RunTimeError("DELIVER statement not yet implemented.\n");
		break;
	case MOVE:
		from_sct = FindLocation(sct, &action->u_move->from_loc);
		if (from_sct == NULL)
			return S_FAIL;

		dest_sct = FindLocation(sct, &action->u_move->to_loc);
		if (dest_sct == NULL)
			return S_FAIL;

		quantity = (int) EvaluateExpression(from_sct,
						    action->u_move->quantity);

		status = ExecMoveStatement(sct, from_sct, dest_sct,
					   &quantity,
					   action->u_move->commodity,
					   action->u_move->via_list,
					   FL_TEST_MOVE);
		
		if (status != S_OK)
			return status;
		
		(void) ExecMoveStatement(sct, from_sct, dest_sct,
					 &quantity,
					 action->u_move->commodity,
					 action->u_move->via_list,
					 FL_RUN_MOVE);
		break;
	case PRINTIT:
		ExecOutputStatement(sct, action->u_output, output_str);
		break;
	case SEND:
		ExecOutputStatement(sct, action->u_send, send_str);
		break;
	default:
		from_sct = ParseFindSector(sct, action->u_simple->sector_expr);
		quantity = (int) EvaluateExpression(from_sct,
						    action->u_simple->quantity);

		if (from_sct == NULL)
			return S_FAIL;

		switch (action->type) {
		case SET_DESIGNATION:
			DoDesignate (CrdStr(from_sct),
				     action->u_designate->flag);
			break;
		case DEMOBILIZE:
			DoDemob (CrdStr(from_sct), quantity,
				 action->u_demobilize->flag);
			break;
		case ENLIST:
			DoEnlist(CrdStr(from_sct), quantity, '\0');
			break;
		case CONVERT:
			DoConvert(CrdStr(from_sct), quantity, '\0');
			break;
		case SHOOT:
			DoShoot(CrdStr(from_sct), quantity,
				action->u_shoot->flag);
			break;
		case SET_THRESHOLD:
			ExecSetThreshold(CrdStr(from_sct),
				action->u_threshold->flag, quantity);
			break;
		case SET_CUTOFF:
			RunTimeError("CUTOFF statement not yet implemented.\n");
			break;
		case TERRITORY:
			ExecSetTer(CrdStr(from_sct), quantity);
			break;
		default:
			RunTimeError("Internal: invalid action type %d\n",
				action->type);
		}
	}

	return S_OK;
#endif
}

static int ExecMoveStatement(sct, from_sct, dest_sct, max_quantity, commodity,
			    via_list, status)
Sector sct, from_sct, dest_sct;
int commodity, *max_quantity;
ExprList via_list;
int status;
{
#if ! defined(STAND_ALONE)
	Sector next_sct;
	int quantity;

	next_sct = from_sct;

	do {
		from_sct = next_sct;
		if (via_list != NULL) {
			next_sct = ParseFindSector(sct, via_list->e_expr);
			via_list = via_list->next;
		}
		else
			next_sct = dest_sct;

		if (status == FL_TEST_MOVE) {
			quantity = GiveMaxMove(from_sct, next_sct, commodity,
					       THRESHOLD_MOBILITY);

			if (quantity < 0)  return S_ERROR;
			if (quantity == 0) return S_FAIL;

			if (quantity < *max_quantity)
				*max_quantity = quantity;
		}
		else if (ExecMove(from_sct, next_sct, *max_quantity,
				  commodity) == False)
			return S_ERROR;
	} while (next_sct != dest_sct);

	return S_OK;
#endif
}

static void ExecOutputStatement(sct, output_list, strings)
Sector sct;
Output output_list;
Strings strings;
{
#if ! defined(STAND_ALONE)
	char buffer[512];
	char sector_buffer[50];

	if (output_list != NULL)
		output_list = output_list->next;

	buffer[0] = '\0';
	while (output_list != NULL) {
		RunExpression(sct, output_list->o_expr, False);

		switch (stack[0].type) {
		case T_NUMERIC:
		case T_BOOLEAN:
		case T_PLAGUE:
			if (output_list->format)
				strcat(buffer, Fmt("%*.1lf",
						   output_list->format,
						   stack[0].e_value));
			else
				strcat(buffer, Fmt("%.1lf", stack[0].e_value));
			break;
		case T_CHARACTER:
			if (output_list->format)
				strcat(buffer, Fmt("%*c",
						   output_list->format,
						   stack[0].e_character));
			else
				strcat(buffer, Fmt("%c", stack[0].e_character));
			break;
		case T_SECTOR:
			if (stack[0].e_sector == NULL)
				strcpy(sector_buffer, "[BAD SECTOR]");
			else
				strcpy(sector_buffer,
				       Fmt("[%d, %d]",
					   SectorXCoord(stack[0].e_sector),
					   SectorYCoord(stack[0].e_sector)));
			if (output_list->format)
				strcat(buffer, Fmt("%*s", output_list->format,
							  sector_buffer));
			else
				strcat(buffer, sector_buffer);
			break;
		case T_STRING:
			if (output_list->format)
				strcat(buffer, Fmt("%*s", output_list->format,
							  stack[0].e_text));
			else
				strcat(buffer, stack[0].e_text);
			break;
		}

		output_list = output_list->next;
	}

	AddString(strings, buffer);
#endif
}


static void RunExpression(sct, expr, is_subexpr)
Sector sct;
Stack expr;
bool is_subexpr;
{
	sp = -1;

	RunExpressionStack(sct, expr, is_subexpr, (Ship) 0, (Plane) 0, (Nuke)0);

#if defined(PARSE_DEBUG)
	if (sp != -1 && sp != 0)
		printf("Stack ptr not -1/0 after expression eval (%d)\n", sp);
#endif
}

static void RunExpressionStack(sct, expr, is_subexpr, ship, plane, nuke)
Sector sct;
Stack expr;
bool is_subexpr;
Ship ship;
Plane plane;
Nuke nuke;
{
	const char *ptr1, *ptr2;
	Stack subexpr;
	Ship  s_ship;
	Plane s_plane;
	Nuke  s_nuke;
	int   modifier;
#if defined(PARSE_DEBUG)
	int save_sp;
#endif

#if ! defined(STAND_ALONE)
	for (expr = expr->next; expr != NULL; expr = expr->next) {
		if (expr->type == S_SUBEXPREND && is_subexpr == True)
			return;

		if (expr->type == S_SUBEXPRSTART) {
		    if (expr->e_new_modifier == MP_SHIP) {
			stack[++sp].e_value = D0;
#if defined(PARSE_DEBUG)
			save_sp = sp;
#endif
                	for (s_ship = FirstShip(sct,
						expr->e_old_modifier, plane);
					s_ship != (Ship) 0;
					s_ship = NextShip(s_ship, plane)) {

				RunExpressionStack(sct, expr, True, s_ship,
						   plane, nuke);
				sp--;
#if defined(PARSE_DEBUG)
				if (save_sp != sp)
					printf ("SP changed! from %d to %d\n",
						save_sp, sp);
#endif
				stack[sp].e_value += stack[sp + 1].e_value;
			}
		    }
		    else if (expr->e_new_modifier == MP_PLANE) {
			stack[++sp].e_value = D0;
			for (s_plane = FirstPlane(sct,
						  expr->e_old_modifier, ship);
					s_plane != (Plane) 0;
					s_plane = NextPlane(s_plane, ship)) {

				RunExpressionStack(sct, expr, True, ship,
						   s_plane, nuke);
				sp--;
				stack[sp].e_value += stack[sp + 1].e_value;
			}
		    }
		    else if (expr->e_new_modifier == MP_NUKE) {
			stack[++sp].e_value = D0;
			for (s_nuke = FirstNuke(sct,
						expr->e_old_modifier, plane);
					s_nuke != (Nuke) 0;
					s_nuke = NextNuke(s_nuke, plane)) {
				RunExpressionStack(sct, expr, True, ship,
						   plane, s_nuke);
				sp--;
				stack[sp].e_value += stack[sp + 1].e_value;
			}
		    }

		    while (expr->type != S_SUBEXPREND)
			expr = expr->next;

		    continue;
		}

/* Push */
		if (expr->type == S_PUSH) {
			stack[++sp].type = expr->p_type;

			switch (expr->p_type) {
			case T_TOKEN:
				GetTokenValue(sct,
					      expr->p_modifier, expr->p_token,
					      ship, plane, nuke, &stack[sp]);
				break;
			case T_NUMERIC:
				stack[sp].e_value = expr->p_constant;
				break;
			case T_STRING:
				stack[sp].e_text  = expr->p_text;
				break;
			case T_CHARACTER:
				stack[sp].e_character = expr->p_character;
				break;
			}

			continue;
		}

/* Calculate */
		switch (expr->c_operator) {
		case LEFT_OR:
			sp--;
			if (stack[sp + 1].e_value == D1)
				return;
			break;
		case RIGHT_OR:
			sp--;
			if (stack[sp + 1].e_value == D1) {
				stack[sp].e_value = D1;
				return;
			}
			break;
		case LEFT_AND:
			sp--;
			if (stack[sp + 1].e_value == D0)
				return;
			break;
		case RIGHT_AND:
			sp--;
			if (stack[sp + 1].e_value == D0) {
				stack[sp].e_value = D0;
				return;
			}
			break;
		case NEGATE:
			stack[sp].e_value = -stack[sp].e_value;
			break;
		case ROUND_FUNC:
			stack[sp].e_value =
				floor(stack[sp].e_value + (double) 0.5);
			break;
		case FLOOR_FUNC:
			stack[sp].e_value = floor(stack[sp].e_value);
			break;
		case CEIL_FUNC:
			stack[sp].e_value = ceil(stack[sp].e_value);
			break;
		case SECTOR_FUNC:
			sp--;
			stack[sp].e_sector = WorldSector(
						(int) stack[sp + 1].e_value,
						(int) stack[sp + 2].e_value);
			stack[sp].type = T_SECTOR;
			break;
		case NOT:
			stack[sp].e_value = stack[sp].e_value ? D0 : D1;
			break;
		case MINUS:
			sp--;
			stack[sp].e_value -= stack[sp + 1].e_value;
			break;
		case PLUS:
			sp--;
			stack[sp].e_value += stack[sp + 1].e_value;
			break;
		case TIMES:
			sp--;
			stack[sp].e_value *= stack[sp + 1].e_value;
			break;
		case DIVIDE:
			sp--;
			if (stack[sp + 1].e_value == D0)
				stack[sp].e_value = D0;
			else
				stack[sp].e_value /=stack[sp+1].e_value;
			break;
		default:
			sp--;
			stack[sp].type = T_BOOLEAN;

			switch(expr->c_operator) {
			case SMALLER:
				APPLY_OPERATOR(<, e_value);
				break;
			case LARGER:
				APPLY_OPERATOR(>, e_value);
				break;
			case SMALLER_EQ:
				APPLY_OPERATOR(<=, e_value);
				break;
			case LARGER_EQ:
				APPLY_OPERATOR(>=, e_value);
				break;
			case MATCHES:
				ptr1 = stack[sp].e_text;
				ptr2 = stack[sp + 1].e_text;

				if (ptr1 == NULL) ptr1 = "";
				if (ptr2 == NULL) ptr2 = "";

				while (*ptr1 == *ptr2 && *ptr1 != '\0') {
					ptr1++;
					ptr2++;
				}

				if (*ptr1 == '\0' || *ptr2 == '\0')
					stack[sp].e_value = D1;
				else
					stack[sp].e_value = D0;
				break;
			case UNEQUALS:
			case EQUALS:
				switch (expr->c_calctype) {
				case T_NUMERIC:
				case T_BOOLEAN:
				case T_PLAGUE:
					APPLY_OPERATOR(==, e_value);
					break;
				case T_CHARACTER:
					APPLY_OPERATOR(==, e_character);
					break;
				case T_SECTOR:
					APPLY_OPERATOR(==, e_sector);
					break;
				case T_STRING:
					if (stack[sp].e_text == NULL)
						stack[sp].e_text = "";
					if (stack[sp + 1].e_text == NULL)
						stack[sp + 1].e_text = "";
					STRING_COMPARE(e_text);
					break;
				default:
#if defined(PARSE_DEBUG)
					printf("Bad type in EQ/UNEQ: %d\n",
						expr->c_calctype);
#endif
					break;
				}
				if (expr->c_operator == UNEQUALS)
					stack[sp].e_value = stack[sp].e_value ?
							    D0 : D1;
				break;
			default:
#if defined(PARSE_DEBUG)
				printf("Bad type for calc: %d\n",
					expr->c_operator);
#endif
				break;
			}
		}
	}
#endif
}

#include <varargs.h>

/*VARARGS0*/
static void RunTimeError(va_alist)
va_dcl
{
#if ! defined(STAND_ALONE)
	char msg_buf[100];
	va_list arglist;
	char *fmt;

	va_start(arglist);
	fmt = va_arg(arglist, char *);

	vsprintf(msg_buf, fmt, arglist);
	va_end(arglist);

	Error(msg_buf);
#endif
}
