/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/parse/RCS/get_token.c,v 5.2 1995/09/08 07:36:14 jpo Exp $
    $Date: 1995/09/08 07:36:14 $
    $Author: jpo $
    $Id: get_token.c,v 5.2 1995/09/08 07:36:14 jpo Exp $
    $Locker:  $
    $Log: get_token.c,v $
    Revision 5.2  1995/09/08 07:36:14  jpo
    NEW_DESIG fix

 * Revision 5.1  93/03/14  16:50:38  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:23:02  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:40:53  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
/*
 * get_token.c
 */

#include "main.h"
#include "production.h"
#include "sector.h"
#include "func.h"

#undef OIL
#undef PRINT

#include "parser.h"
#include "Lpars.h"
#include "symtab.h"
#include "ship.h"
#include "plane.h"
#include "nuke.h"
#include "eval_stack.h"

#undef doalloc

#define D0	(double) 0.0
#define D1	(double) 1.0

#define SCT_POPULATION(sct)	(s_civ(sct) + s_mil(sct) + q_uw(sct))
#define SHIP_POPULATION(ship)	(sh_civ(ship) + sh_mil(ship) + sh_uw(ship))
#define FOOD_USAGE(population)	((population) * eatrate * etu_per_update)

static int src_modifier;
static Plane plane_list_ptr;

Sector WorldSector(x, y)
int x, y;
{
#if ! defined(STAND_ALONE)
	return World(x, y, S_EXIST);
#endif
}

/*
 * Function interface to XEMP's #defines
 */
int SectorXCoord(sct)
Sector sct;
{
	return s_xcd(sct);
}

int SectorYCoord(sct)
Sector sct;
{
	return s_ycd(sct);
}

Ship FirstShip(sct, src_mod, plane)
Sector sct;
int src_mod;
Plane plane;
{
#if ! defined(STAND_ALONE)
	src_modifier = src_mod;

	if (src_modifier == MP_SECT)
		return s_fship(sct);
	
	return (plane == (Plane) 0) ? (Ship) 0 : NrToShip(pl_shipnr(plane));
#endif
}

Ship NextShip(ship, plane)
Ship ship;
Plane plane;
{
#if ! defined(STAND_ALONE)
	if (src_modifier != MP_SECT)
		return (Ship) 0;

	return sh_nxtsct(ship);
#endif
}

Plane FirstPlane(sct, src_mod, ship)
Sector sct;
int src_mod;
Ship ship;
{
#if ! defined(STAND_ALONE)
	src_modifier = src_mod;

	if (src_modifier == MP_SECT)
		return s_fplane(sct);
	
	if (ship == (Ship) 0)
		return (Plane) 0;

	plane_list_ptr = first_plane;

	return (pl_shipnr(plane_list_ptr) == sh_nr(ship)) ?
						plane_list_ptr : (Plane) 0;
#endif
}

Plane NextPlane(plane, ship)
Plane plane;
Ship ship;
{
#if ! defined(STAND_ALONE)
	if (src_modifier == MP_SECT)
		return pl_nxtsct(plane);
	
	while ((plane_list_ptr = pl_next(plane_list_ptr)) != (Plane) 0)
		if (pl_shipnr(plane_list_ptr) == sh_nr(ship))
			return plane_list_ptr;
	
	return (Plane) 0;
#endif
}

Nuke FirstNuke(sct, src_mod, plane)
Sector sct;
int src_mod;
Plane plane;
{
#if ! defined(STAND_ALONE)
	NukeData nuke_data;

	src_modifier = src_mod;

	if (src_modifier == MP_PLANE) {
#if defined(PARSE_DEBUG)
#endif
		printf ("PLANE --> NUKE MODIFIER NOT YET IMPLEMENTED.\n");
		return (Nuke) 0;
	}

	if (s_stock(sct) == NULL)
		return (Nuke) 0;

	nuke_data            = (NukeData) doalloc(sizeof(NUKEDATA));
	nuke_data->type      = 0;
	nuke_data->stockpile = (Stockp) s_stock(sct);

	return (Nuke) nuke_data;
#endif
}

Nuke NextNuke(nuke, plane)
Nuke nuke;
Plane plane;
{
#if ! defined(STAND_ALONE)
	NukeData nuke_data = (NukeData) nuke;

	if (++nuke_data->type >= MAX_NUKETYPES) {
		dofree(nuke_data);
		return (Nuke) 0;
	}
	
	nuke_data->type++;

	return nuke;
#endif
}


void GetTokenValue(sct, modifier, token, ship, plane, nuke, result)
Sector sct;
Ship ship;
Plane plane;
Nuke nuke;
int modifier, token;
EvalStack result;
{
	double food_usage;
	NukeData nuke_data;
	Nuke stockpile;

#if ! defined(STAND_ALONE)
	result->type    = T_NUMERIC;
	result->e_value = D0;

	switch (modifier) {
	case MP_THRES:
		if (! KNOW_ALL(sct))
			return;

		switch (token) {
		case FOOD:
			result->e_value = (double) t_foo(sct); return;
		case DUST:
			result->e_value = (double) t_dus(sct); return;
		case OIL:
			result->e_value = (double) t_oil(sct); return;
		case IRON:
			result->e_value = (double) t_iro(sct); return;
		case UW:
			result->e_value = (double) t_uw(sct);  return;
		case GUNS:
			result->e_value = (double) t_gun(sct); return;
		case BARS:
			result->e_value = (double) t_bar(sct); return;
		case PETROL:
			result->e_value = (double) t_pet(sct); return;
		case LCMS:
			result->e_value = (double) t_lcm(sct); return;
		case HCMS:
			result->e_value = (double) t_hcm(sct); return;
		case SHELLS:
			result->e_value = (double) t_she(sct); return;
		case RADS:
			result->e_value = (double) t_rad(sct); return;
		}

		break;
	case MP_RESO:
		if (! KNOW_RES(sct))
			return;

		switch(token) {
		case URANIUM:
			result->e_value = (double) s_ura(sct); return;
		case FOOD:
			result->e_value = (double) s_fer(sct); return;
		case DUST:
			result->e_value = (double) s_gol(sct); return;
		case OIL:
			result->e_value = (double) s_oil(sct); return;
		case IRON:
			result->e_value = (double) s_min(sct); return;
		}

	case MP_SHIP:
		if (ship == (Ship) 0)
			return;

		switch (token) {
		case XLOC:
			result->e_value = (double) sh_xcd(ship); return;
		case YLOC:
			result->e_value = (double) sh_ycd(ship); return;
		case OWNER:
			result->type   = T_STRING;
			result->e_text = CountryName(sh_owner(ship));
			return;
		case OWNED:
			result->type = T_BOOLEAN;
			if (sh_owned(ship))
				result->e_value = D1;
			return;
		case NAME:
			result->type   = T_STRING;
			result->e_text = ShipName(ship);
			return;
		case TYPE:
			result->e_value = (double) sh_type(ship);
			return;
		}

		if (!sh_owned(ship))
			return;

		switch (token) {
		case EFFICIENCY:
			result->e_value = (double) sh_eff(ship);   return;
		case MOBILITY:
			result->e_value = (double) sh_mob(ship);   return;
		case CIVILIANS:
			result->e_value = (double) sh_civ(ship);   return;
		case MILITARY:
			result->e_value = (double) sh_mil(ship);   return;
		case TECH:
			result->e_value = (double) sh_tech(ship);  return;
		case NUMBER:
			result->e_value = (double) sh_nr(ship);    return;
		case RADAR:
			result->e_value = (double) sh_radar(ship); return;
		case SONAR:
			result->e_value = (double) sh_sonar(ship); return;
		case MOVES:
			result->e_value = (double) sh_moves(ship); return;
		case FOOD:
			result->e_value = (double) sh_foo(ship);   return;
		case DUST:
			result->e_value = (double) sh_dust(ship);  return;
		case OIL:
			result->e_value = (double) sh_oil(ship);   return;
		case IRON:
			result->e_value = (double) sh_iron(ship);  return;
		case UW:
			result->e_value = (double) sh_uw(ship);    return;
		case GUNS:
			result->e_value = (double) sh_gun(ship);   return;
		case BARS:
			result->e_value = (double) sh_bar(ship);   return;
		case PETROL:
			result->e_value = (double) sh_pet(ship);   return;
		case LCMS:
			result->e_value = (double) sh_lcm(ship);   return;
		case HCMS:
			result->e_value = (double) sh_hcm(ship);   return;
		case SHELLS:
			result->e_value = (double) sh_she(ship);   return;
		case RADS:
			result->e_value = (double) sh_rad(ship);   return;
		case POPULATION:
			result->e_value = (double) SHIP_POPULATION(ship);
			return;
		case FOOD_USED:
			result->e_value = (double)
					   FOOD_USAGE(SHIP_POPULATION(ship));
			return;
		case STARVATION:
			result->type = T_BOOLEAN;
			if (FOOD_USAGE(SHIP_POPULATION(ship)) > sh_foo(ship))
				result->e_value = D1;
			return;
		case FLEET:
			result->type        = T_CHARACTER;
			result->e_character = sh_fleet(ship);
			return;
		}

		break;
	case MP_PLANE:
		if (plane == (Plane) 0)
			return;

		switch (token) {
		case XLOC:
			result->e_value = (double) pl_xcd(plane); return;
		case YLOC:
			result->e_value = (double) pl_ycd(plane); return;
		case EFFICIENCY:
			result->e_value = (double) pl_eff(plane);  return;
		case MOBILITY:
			result->e_value = (double) pl_mob(plane);  return;
		case TECH:
			result->e_value = (double) pl_tech(plane); return;
		case NUMBER:
			result->e_value = (double) pl_nr(plane);   return;
		case NAME:
			result->type   = T_STRING;
			result->e_text = PlaneName(plane);
			return;
		case TYPE:
			result->e_value = (double) pl_type(plane); return;
		case WING:
			result->type        = T_CHARACTER;
			result->e_character = pl_wing(plane);
			return;
		case RANGE:
			result->e_value = (double) pl_range(plane);    return;
		case MAXRANGE:
			result->e_value = (double) pl_maxrange(plane); return;
		case ATTACK:
			result->e_value = (double) pl_att(plane);      return;
		case DEFENSE:
			result->e_value = (double) pl_def(plane);      return;
		case HARDEN:
			result->e_value = (double) pl_hard(plane);     return;
		case LOAD:
			result->e_value = (double) MaxPlaneLoad(plane);
			return;
		}
		
		break;
	case MP_NUKE:
		if (nuke == (Nuke) 0)
			return;
		
		nuke_data = (NukeData) nuke;
		stockpile = nuke_data->stockpile;

		switch (token) {
		case XLOC:
			result->e_value = (double) sp_x(stockpile);  return;
		case YLOC:
			result->e_value = (double) sp_y(stockpile);  return;
		case NAME:
			result->type   = T_STRING;
			result->e_text = nt_name(nuke_data->type);
			return;
		case TYPE:
			result->e_value = (double) nuke_data->type;  return;
		case STOCKPILE:
			result->e_value = (double) sp_nr(stockpile); return;
		}

		break;
	case MP_SSECT:
	case MP_SECT:
		switch (token) {
		case CURRENT:
			result->type = T_SECTOR;
			result->e_sector = sct;		  	  return;
		case BAD_SECTOR:
			result->type = T_SECTOR;
			result->e_sector = (Sector) 0;		  return;
		case HAS_PLAN:
			result->type  = T_BOOLEAN;
			result->e_value = (double) HasPlan(sct);  return;
			break;
		case IS_ACTIVE:
			result->type  = T_BOOLEAN;
			result->e_value = (double) IsActive(sct); return;
			break;
		case XLOC:
			result->e_value = (double) s_xcd(sct);    return;
		case YLOC:
			result->e_value = (double) s_ycd(sct);    return;
		case PLAGUE_HEALTHY:
			result->e_value = (double) PLG_HEALTHY;   return;
		case PLAGUE_INFECTED:
			result->e_value = (double) PLG_INFECT;    return;
		case PLAGUE_DYING:
			result->e_value = (double) PLG_DYING;     return;
		case HAPPY_LOYAL:
			result->e_value = (double) HP_LOYAL;      return;
		case HAPPY_UNREST:
			result->e_value = (double) HP_UNREST;     return;
		case HAPPY_REVOL:
			result->e_value = (double) HP_REVOLUTIONARIES;
			return;
		case HAPPY_TERROR:
			result->e_value = (double) HP_TERRORISTS; return;
		case HAPPY_GUERRE:
			result->e_value = (double) HP_GUERRILLAS; return;
		}

		if (NO_INFO(sct))
			return;

		switch (token) {
		case OWNER:
			result->type   = T_STRING;
			result->e_text = CountryName(s_owner(sct));
			return;
		case DESIGNATION:
			result->type        = T_CHARACTER;
			result->e_character = s_des(sct);
			return;
		case OWNED:
			result->type = T_BOOLEAN;
			if (s_owned(sct))
				result->e_value = D1;
			return;
		case COAST:
			result->type = T_BOOLEAN;
			if (IsCoast(sct))
				result->e_value = D1;
			return;
		case MINES:
			result->e_value = (double) s_mines(sct);
			return;
		}

		if (!KNOW_LOO(sct))
			return;

		switch (token) {
		case EFFICIENCY:
			result->e_value = (double) s_eff(sct); return;
		case CIVILIANS:
			result->e_value = (double) s_civ(sct); return;
		case MILITARY:
			result->e_value = (double) s_mil(sct); return;
		case FOOD:
			result->e_value = (double) q_foo(sct); return;
		case POPULATION:
			result->e_value = (double)
					    (s_civ(sct) + s_mil(sct));
			if (KNOW_ALL(sct))
				result->e_value += (double) q_uw(sct);
			return;
		}

		if (!KNOW_SPY(sct))
			return;

		switch (token) {
		case IRON:
			result->e_value = (double) q_iro(sct); return;
		case GUNS:
			result->e_value = (double) q_gun(sct); return;
		case PETROL:
			result->e_value = (double) q_pet(sct); return;
		case SHELLS:
			result->e_value = (double) q_she(sct); return;
		}

		if (!KNOW_ALL(sct))
			return;

		switch (token) {
		case DUST:
			result->e_value = (double) q_dus(sct); return;
		case OIL:
			result->e_value = (double) q_oil(sct); return;
		case UW:
			result->e_value = (double) q_uw(sct);  return;
		case BARS:
			result->e_value = (double) q_bar(sct); return;
		case LCMS:
			result->e_value = (double) q_lcm(sct); return;
		case HCMS:
			result->e_value = (double) q_hcm(sct); return;
		case RADS:
			result->e_value = (double) q_rad(sct); return;
		case NEW_DESIG:
			result->type        = T_CHARACTER;
			result->e_character = s_nds(sct);
			return;
		case WORK:
			result->e_value = (double) s_wor(sct); return;
		case AVAILABLE:
			result->e_value = (double) s_ava(sct); return;
		case MOBILITY:
			result->e_value = (double) s_mob(sct); return;
		case PLANES:
			result->e_value = (double) s_pla(sct); return;
		case SHIPS:
			result->e_value = (double) s_shi(sct); return;
		case LANDS:
			result->e_value = (double) s_land(sct); return;
		case NUKES:
			result->e_value = (double) s_nuk(sct); return;
		case WAREHOUSE:
			result->type = T_SECTOR;
			if (s_pat(sct) == (char *) NULL ||
			    *s_pat(sct) == '\0')
				result->e_sector = (Sector) 0;
			else
				result->e_sector = World(s_dxc(sct),
							 s_dyc(sct), S_EXIST);
			return;
		case OCCUPIED:
			result->type = T_BOOLEAN;
			if (s_occ(sct) == '*')
				result->e_value = D1;
			return;
		case FOOD_USED:
			result->e_value = (double)
					  FOOD_USAGE(SCT_POPULATION(sct));
			return;
		case STARVATION:
			result->type = T_BOOLEAN;
			food_usage   = FOOD_USAGE(SCT_POPULATION(sct));
			if (food_usage > q_foo(sct) && food_usage > D1)
				result->e_value = D1;
			return;
		case TERRITORY:
			result->e_value = (double) s_ter(sct);
			return;
		case PLAGUE:
			result->e_value = (double) PlagueChance(sct);
			return;
		case PLAGUE_STAGE:
			result->e_value = (double) PlagueStage(sct);
			return;
		case HAPPY:
			result->e_value = (double) IsHappy(sct);
			return;
		case HAPPY_STATE:
			result->e_value = (double) HappinesState(sct);
			return;
		}

		break;
	default /* MP_NONE */:
		switch (token) {
		case SPE:
			result->e_value = (double) sec_per_etu;    return;
		case EPU:
			result->e_value = (double) etu_per_update; return;
		case IRATE:
			result->e_value = (double) bankint;	   return;
		case CTRATE:
			result->e_value = (double) money_civ;	   return;
		case UTRATE:
			result->e_value = (double) money_uw;	   return;
		case AMCRATE:
			result->e_value = (double) money_mil;	   return;
		case RMCRATE:
			result->e_value = (double) money_res;	   return;
		case FRATE:
			result->e_value = (double) fgrate;	   return;
		case HRATE:
			result->e_value = (double) fcrate;	   return;
		case CBRATE:
			result->e_value = (double) obrate;	   return;
		case UBRATE:
			result->e_value = (double) uwbrate;	   return;
		case ERATE:
			result->e_value = (double) eatrate;	   return;
		case BERATE:
			result->e_value = (double) babyeat;	   return;
		}
	}

#if defined(PARSE_DEBUG)
	printf ("Unknown token combination %d(%d)\n", modifier, token);
#endif
	return;
#endif
}

DisplayParseErrors()
{
#if defined(STAND_ALONE)
	char *str;

	InitStringList(parse_errors);

	while ((str = GetNextString(parse_errors)) != NULL)
		printf ("%s\n", str);

	FreeStrings(parse_errors);
#else
	Pager pager;
	int func;

	pager = InitPager(parse_errors, "Compiler errors");
	AddPagerFunc(pager, "Write", WRITEFUNC);
#ifdef X_VERSION
	AddPagerFunc(pager, "To WM", TOWMFUNC);
#endif /* X_VERSION */
	AddPagerFunc(pager, "Done", DONEFUNC);
	MapPagerFromTop(pager, map_win, 10, 10);

	ShowPager(pager);
	FreePager(pager);
#endif
}
