/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/misc/RCS/where.c,v 5.2 1995/09/08 07:33:32 jpo Exp $
    $Date: 1995/09/08 07:33:32 $
    $Author: jpo $
    $Id: where.c,v 5.2 1995/09/08 07:33:32 jpo Exp $
    $Locker:  $
    $Log: where.c,v $
    Revision 5.2  1995/09/08 07:33:32  jpo
    types

 * Revision 5.1  93/03/14  16:50:04  etienne
 * 
 * 
 * Revision 5.0  93/02/06  09:18:49  greyhelm
 * y
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:37:47  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "sector.h"
#include "parser.h"

/* 
 *	I don't understand
 *
 * #ifdef mta
 * #define FirstNotMarked mtaFirstNotMarked
 * #endif
 *
 */

typedef struct s_ent * WhEnt;

struct s_ent
{
	Sector sct;
	int mcost;
	bool marked;
	WhEnt next;
};

static WhEnt head;

static Add (sct, mcost)
Sector sct;
double mcost;
{
	WhEnt new;
	WhEnt ptr, prev;

	new = (WhEnt) doalloc ((unsigned) sizeof (struct s_ent));
	new-> sct = sct;
	new-> mcost = mcost;
	new-> marked = False;

	prev = (WhEnt) 0;
	for (ptr = head; ptr != (WhEnt) 0; ptr = ptr-> next)
	{
		if (ptr-> mcost < mcost)
			break;

		prev = ptr;
	}

	if (prev == (WhEnt) 0)
	{
		new-> next = head;
		head = new;
	}
	else
	{
		new-> next = prev-> next;
		prev-> next = new;
	}
}

static WhEnt GetFirstNotMarked ()
{
	WhEnt ptr;

	for (ptr = head; ptr != (WhEnt) 0; ptr = ptr-> next)
		if (! ptr-> marked)
		{
			ptr-> marked = True;
			return ptr;
		}

	return (WhEnt) 0;
}
		
static bool InList (sct)
Sector sct;
{
	register WhEnt ptr;

	for (ptr = head; ptr != (WhEnt) 0; ptr = ptr-> next)
		if (ptr-> sct == sct)
			return True;
	
	return False;
}
	
static void FreeList ()
{
	WhEnt ptr;

	while (head != (WhEnt) 0)
	{
		ptr = head-> next;
		free ((char *) head);
		head = ptr;
	}
}

Sector Where (from, expres)
Sector from;
Stack expres;
{
	Sector sct, cur_sct;
	WhEnt ent;
	bool found;
	double mcost, cur_mcost = 0.0;
	Neighb neighb;

	if (from == (Sector) 0 || ! s_owned (from))
		return (Sector) 0;

	head = (WhEnt) 0;
	Add (from, 0.0);
	cur_sct = (Sector) 0;
	found = False;
	
	while ((ent = GetFirstNotMarked ()) != (WhEnt) 0)
	{
		if (found && ent-> mcost >= cur_mcost)
			continue;
		
		InitNeighbours (ent-> sct, & neighb);
		while (NextNeighbour (& sct, S_EXIST, neighb))
		{
			if (sct == (Sector) 0 || ! s_owned (sct))
				continue;
			
			if (InList (sct))
				continue;
			
			/*

			path = BestLandPath (from, sct, False);
			if (path == (char *) 0)
			{
				Panic ("where", "misc/where.c",
					"couldn't find a path !");
				continue;
			}

			mcost = RealPathCost (from, path);

			*/

			mcost = ent-> mcost +
					MoveCost (s_des (sct), s_eff (sct));

			if (found && mcost >= cur_mcost)
				continue;

			if (EvaluateExpression (sct, expres) == 0.0)
			{
				Add (sct, mcost);
				continue;
			}

			cur_mcost = mcost;
			cur_sct = sct;
			found = True;
		}
	}

	FreeList ();
	return cur_sct;
}

void TestWhere ()
{
	char * ans;
	Stack expr;
	Sector sct;

	do {
		ans = InputAtMessage ("Cond:", 20, GS_TEXT);
		if (ans == (char *) 0 || interrupt || * ans == '\0')
		{
			Message ("Test where cancelled");
			return;
		}

		expr = ParseExpression (ans);
	}
	while (expr == (Stack) 0);

	sct = Where (cursct, expr);
	if (sct == (Sector) 0)
		Message ("No such sector found");
	else
		Goto (sct);
}
