/*
    $Header: /a/victor/nexor/user4/jpo/xemp/xemp5.0/lib/misc/RCS/budget.c,v 1.4 1995/09/28 08:28:15 jpo Exp $
    $Date: 1995/09/28 08:28:15 $
    $Author: jpo $
    $Id: budget.c,v 1.4 1995/09/28 08:28:15 jpo Exp $
    $Locker:  $
 *  $Log: budget.c,v $
 *  Revision 1.4  1995/09/28 08:28:15  jpo
 *  new format.. sigh.
 *
 *  Revision 1.3  1995/09/21 07:52:19  jpo
 *  Make budget a little more bomb proof.
 *
 *  Revision 1.2  1995/09/20 07:39:38  jpo
 *  Add more bits to parsing...
 *
 *  Revision 1.1  1995/09/18 17:02:37  jpo
 *  Initial revision
 *
 *
*/

#include "main.h"
#include "func.h"


typedef struct _budgetline {
	char *line;
	struct _budgetline *next;
} BudgetLine;

static BudgetLine *budget_head;

static void DoScanBudget _PROTO((bool force));
static void FreeBudget _PROTO((void));

void DoBudget ()
{
	Strings strings;
	BudgetLine *bp;

	ScanBudget ();

	strings = InitStrings ();
	for (bp = budget_head; bp; bp = bp -> next)
		AddString (strings, bp -> line);

	InitWMPager (strings, "budget");
	return;
}

void ScanBudget ()
{
	DoScanBudget (False);
}

void ScanNewBudget ()
{
	DoScanBudget (True);
}

static void DoScanBudget (force)
bool force;
{
	char *line;
	BudgetLine **bpp;

	if (force == False && budget_head != NULL)
		return;
	if (budget_head) FreeBudget ();

	bpp = &budget_head;

	FeedEmpire ("budget", PRINT);
	PrintAtEmpire ("xemp: scanning budget output");

	for (;;) {
		line = ReadEmpire (DONT_PRINT);
		if (EmpireStatus () == E_COMMAND) {
			PrintAtEmpire (line);
			return;
		}
		if (EmpireStatus () != E_PRINTING)
		{
			Message ("Sync error");
			Bell ();
			continue;
		}
		*bpp = (BudgetLine *) doalloc(sizeof **bpp);
		(*bpp) -> line = Str(line);
		(*bpp) -> next = NULL;
		bpp = &(*bpp) -> next;
	}		
}

static void FreeBudget ()
{
	BudgetLine *bi, *bi2;

	if (budget_head == NULL)
		return;

	for (bi = budget_head; bi; bi = bi2) {
		bi2 = bi -> next;
		if (bi -> line) free (bi->line);
		free ((char *)bi);
	}
	budget_head = NULL;
}
