/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/lib/land/RCS/scrap.c,v 5.1 1993/03/14 16:48:35 etienne Exp $
    $Date: 1993/03/14 16:48:35 $
    $Author: etienne $
    $Id: scrap.c,v 5.1 1993/03/14 16:48:35 etienne Exp $
    $Locker:  $
    $Log: scrap.c,v $
    Revision 5.1  1993/03/14 16:48:35  etienne
    *** empty log message ***

 * Revision 5.0  93/02/06  09:18:30  greyhelm
 * y
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:47:37  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "sector.h"
#include "var.h"
#include "land.h"

extern void ScrapLand ();

void RedoLScrap ()
{
	Land next;
	char nextfl;

	if (last_layout == LAND_MODE)
	{
		next = ld_nxtsct (curland);
		ScrapLand (Fmt ("%d", ld_nr (curland)));
		curland = next;
		if (curland != (Land) 0)
			CensusLand (curland);
		else
			Census ();
		DrawSector (cursct);
	}
	else if (last_layout == ARMY_MODE)
	{
		nextfl = GiveNextArmyInSct (cursct, curarmy);
		ScrapLand (ArmyId ());
		if (nextfl != ' ' && nextfl != '\0')
		{
			curarmy = '\0';
			Census ();
		}
		else
		{
			curarmy = nextfl;
			CensusArmy (curarmy);
		}
		DrawSector (cursct);
	}
	else
	{
		Message ("No current unit/army selected");
		Bell ();
	}
}
	

	/*
	 *	There is no binding to scrap.
	 *	This routine should only be called with owned lands
	 */

void ScrapLand (what)
char * what;
{
	Land ptr, next;
	int i, j;
	int inc_lcm, inc_hcm;
	int nr;
	char itemchar;

	UnmarkAllLands ();
	MarkLands (what);

	Message (Fmt ("Scrapping %s", what));

	if (! Confirm (Fmt ("Scrap %s", what), True))
	{
		Message ("Scrap unit cancelled");
		return;
	}

	FeedCommand (Fmt ("scrap land %s", what), PRINT);
	SetAgain (RedoLScrap);

	ptr = landlist;
	nr = inc_lcm = inc_hcm = 0;
	while (ptr != (Land) 0)
		if (ld_marked (ptr))
		{
			next = ld_next (ptr);

			for (i = 1; i < V_MAX; i ++)
			{
				itemchar = ItemChar (i);
				j = GiveLandQuant (ptr, itemchar);
				if (j > 0)
					SetQuant (cursct, itemchar,
					      GiveQuant (cursct, itemchar) + j);
			}

			inc_lcm += (landtypes [ld_type (ptr)]. lcm * 2) / 3;
			inc_hcm += (landtypes [ld_type (ptr)]. hcm * 2) / 3;
			nr ++;

			DeleteLand (ptr);
			ptr = next;
		}
		else
			ptr = ld_next (ptr);
	
	if (nr == 0)
	{
		Message ("No units scrapped");
		Bell ();
		return;
	}

	set_q_lcm (cursct, q_lcm (cursct) + inc_lcm);
	set_q_hcm (cursct, q_hcm (cursct) + inc_hcm);
	Message (Fmt ("%d units scrapped", nr));
	Census ();
	DrawSector (cursct);
}
