/*
	$Header: /nexor/users/jpo/xemp/xemp5.0/lib/land/RCS/fort.c,v 5.2 1995/09/08 07:18:16 jpo Exp $
	$Date: 1995/09/08 07:18:16 $
	$Author: jpo $
	$Id: fort.c,v 5.2 1995/09/08 07:18:16 jpo Exp $
	$Locker:  $
	$Log: fort.c,v $
	Revision 5.2  1995/09/08 07:18:16  jpo
	nothing new

 * Revision 5.1  93/03/14  16:47:13  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/09  21:33:56  etienne
 * initial revision
 * 
*/

#include "type.h"
#include "main.h"
#include "sector.h"
#include "var.h"
#include "land.h"

static int last_fort = 0;

#define DEF_FORT 64

void Fortify (what)
char * what;
{
	DoFortify (what, 0);
}

void RedoFortify ()
{
	if (last_layout == LAND_MODE)
		DoFortify (Fmt ("%d", ld_nr (curland)), last_fort);
	else if (last_layout == ARMY_MODE)
		DoFortify (Fmt ("%c", curarmy), last_fort);
	else
	{
		Message ("No current land/army selected");
		Bell ();
		return;
	}
}

	/* ARGSUSED */
void BindFortify (x, y, str)
int x, y;
char * str;
{
	int fort;

	if (str != (char *) 0 && sscanf (str, " ( %d )", & fort) == 1)
		last_fort = fort;
	
	RedoFortify ();
}

void DoFortify (what, fort)
char * what;
int fort;
{
	char * ans;
	register Land ptr;
	int nr, n;
	int total;

	if (s_des (cursct) == '.')
	{
		Message ("You can't fortify here!");
		Bell ();
		return;
	}

	UnmarkAllLands ();
	MarkLands (what);

	nr = 0;
	for ALL_LANDS (ptr)
		if (ld_marked (ptr))
		{
			if (! ld_owned (ptr) || ld_mob (ptr) == 0) 
				set_ld_marked (ptr, False);
			else
				nr ++;
		}

	if (nr == 0)
	{
		Message ("No selected units with mobility");
		Bell ();
		return;
	}

	if (fort <= 0)
	{
		ans = InputAtMessage (Fmt ("How much fortification%s %s:",
				nr == 1 ? "" : " from each unit",
#ifndef lint
				DEF_FORT < 0 ? "" :
#endif
					Fmt ("[%d]", DEF_FORT)),
			3, GS_PNUMBER);

		if (ans == (char *) 0 || interrupt ||
					(* ans == '\0' && DEF_FORT < 0))
		{
			Message ("fortify cancelled");
			Bell ();
			return;
		}

		if (* ans == '\0')
			fort = DEF_FORT;
		else
			fort = atoi (ans);
	}

	SetAgain (RedoFortify);
	last_fort = fort;
	
	if (fort == 0)
	{
		Message ("fortify cancelled");
		Bell ();
		return;
	}

	total = 0;
	for ALL_LANDS (ptr)
		if (ld_marked (ptr))
		{
			n = ld_mob (ptr);
			if (n == 0)
				continue;

			if (n > fort)
				n = fort;
			
			total += n;
		}
	
	if (total == 0)
	{
		Message ("No fortifycation done");
		Bell ();
		return;
	}

	/* inc_mines (cursct, total); */ /* to be replaced with fortification */
	if (command_state < FORCE_BUF_STATE)
	{
		FeedEmpire (Fmt ("fortify %s %d", what, fort), PRINT);
		(void) WaitForPrompt (PRINT);
	}
	else if (command_state == FORCE_BUF_STATE)
		FeedCommand (Fmt ("fortify %s %d", what, fort), PRINT);

	Message (Fmt ("%d fortification done", total));
	Census ();
}
