/*
    $Header: /a/victor/nexor/user4/jpo/xemp/xemp5.0/lib/clients/RCS/io.c,v 5.3 1995/09/14 19:40:06 jpo Exp $
    $Date: 1995/09/14 19:40:06 $
    $Author: jpo $
    $Id: io.c,v 5.3 1995/09/14 19:40:06 jpo Exp $
    $Locker:  $
    $Log: io.c,v $
    Revision 5.3  1995/09/14 19:40:06  jpo
    Default characters

    Revision 5.2  1995/09/08 07:02:49  jpo
    lots of fun with configuration

 * Revision 5.1  93/03/14  16:42:32  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:17:27  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.5  1993/02/06  07:55:46  greyhelm
 * Test of GNUmake checkin
 *
 * Revision 4.4  1993/02/06  04:34:59  greyhelm
 * Added RCS header - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include <signal.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#ifdef HAVE_SYS_IOCTL_H
#include <sys/ioctl.h>
#endif

#ifdef HAVE_TERMIOS_H
#include <termios.h>
#endif

#ifdef HAVE_TERMIO_H
#include <termio.h>
#endif


char intrchar, erasechar, eraseword, eraseline;
unsigned con_timeout = 0;
bool silent_con = False;

static void SignalHandler ();

int
getfdtablesize()
{
        return getdtablesize();
}

#ifdef HAVE_SIGSETMASK
void sigrelease ()
{
    sigsetmask (0);
}
#else
void sigrelease ()
{
    int i;
    for (i = 0; i < NSIG; i++)
	sigrelse (i);
}
#endif	

#ifdef HAVE_TERMIOS_H

static int echomode = 1;
void _noecho(fd)
        int     fd;
{
        struct  termios io;

        echomode = 0;
        tcgetattr(fd, &io);
        io.c_lflag |= ECHO;
        tcsetattr(fd, TCSANOW, &io);
}

_echo(fd)
        int     fd;
{
        struct  termios io;

        if (echomode)
                return;
        tcgetattr(fd, &io);
        io.c_lflag &= ~ECHO;
        tcsetattr (fd, TCSANOW, &io);
        echomode++;
}
#else
#ifdef HAVE_TERMIO_H
static int echomode = 1;
void _noecho(fd)
        int     fd;
{
        struct  termio io;

        echomode = 0;
        (void) ioctl(fd, TCGETA, &io);
        io.c_lflag |= ECHO;
        (void) ioctl(fd, TCSETA, &io);
}

_echo(fd)
        int     fd;
{
        struct  termio io;

        if (echomode)
                return;
        (void) ioctl(fd, TCGETA, &io);
        io.c_lflag &= ~ECHO;
        (void) ioctl(fd, TCSETA, &io);
        echomode++;
}
#endif
#endif

#if defined(HAVE_TERMIOS_H) || defined(HAVE_TERMIO_H)

void GetSpecialChars ()
{
#ifdef HAVE_TERMIOS_H
	struct termios tt;
#else
        struct termio tt;
#endif
	
#ifdef HAVE_TERMIOS_H
	if (tcgetattr (0, &tt) < 0)
#else
	if (ioctl (0, TCGETA, &tt) < 0)
#endif 
	    
	{
		intrchar = '\003';	/* ^C */
		erasechar = '\010';	/* ^H */
		eraseword = '\027';	/* ^W */
		eraseline = '\025';	/* ^U */
	}
	else
	{
		intrchar = tt.c_cc[VINTR];
		erasechar = tt.c_cc[VERASE];
#ifdef VWERASE
		eraseword = tt.c_cc[VWERASE];
#else
		eraseword = '\027';
#endif
		eraseline = tt.c_cc[VKILL];
	}
	if (intrchar == 0)
		intrchar = '\003';	/* ^C */
	if (erasechar == 0)
		erasechar = '\010';	/* ^H */
	if (eraseword == 0)
		eraseword = '\027';	/* ^W */
	if (eraseline == 0)
		eraseline = '\025';	/* ^U */
}

#else
#ifdef HAVE_SGTTY_H
void GetSpecialChars ()
{
	struct tchars tc;
	struct ltchars ltc;
	struct sgttyb mode;

	if ((ioctl(1, TIOCGETP, &mode) < 0) || 
	    (ioctl(0, TIOCGLTC, &ltc) < 0) || 
	    (ioctl(0, TIOCGETC, &tc) < 0 )) 
	{   
		intrchar = CINTR;
		erasechar = CERASE;
		eraseword = CWERASE;
		eraseline = CKILL;
	}
	else
	{
		intrchar = tc.t_intrc;
		erasechar = mode.sg_erase;
		eraseword = ltc.t_werasc;
		eraseline = mode.sg_kill;
	}
}
#endif
#endif

void Forceleave (sno)
int sno;
{
	static int sig = 0;

	if (sig++ != 0) {
		if (EmpireStatus () != E_DEAD) {
			fprintf (stderr, "Aborting connection\n");
			sigrelease();
			leave0 ();
		}
		else  {
			fprintf (stderr, "Closing Down be patient\n");
			return;
		}
	}

	fprintf (stderr, "Closing connection\n");
	sigrelease();
	leave ();
}

void SetSignalsOn ()
{
	void Disconnect ();

	signal (SIGHUP,  SignalHandler);
	signal (SIGILL,  SignalHandler);
	signal (SIGFPE,  SignalHandler);
	signal (SIGBUS,  SignalHandler);
	signal (SIGSEGV, SignalHandler);
	signal (SIGQUIT, SignalHandler);
	signal (SIGTERM, SignalHandler);
	signal (SIGINT, Forceleave);

	if (con_timeout > MIN_CONTIMEOUT)
		signal (SIGALRM, Disconnect);
	else
		signal (SIGALRM, SIG_IGN);
}

void SetSignalsOff ()
{
	signal (SIGINT, SIG_IGN);
	signal (SIGQUIT, SIG_IGN);

	if (con_timeout > MIN_CONTIMEOUT)
		signal (SIGALRM, SIG_IGN);
}

static char * SignalName (i)
int i;
{
	switch (i)
	{

	case SIGHUP:
		return "Hang Up Signal (SIGHUP)";

	case SIGILL:
		return "Illegal instruction (SIGILL)";

	case SIGFPE:
		return "Floating point exception (SIGFPE)";
	
	case SIGBUS:
		return "Bus error (SIGBUS)";

	case SIGSEGV:
		return "Segmentation violation (SIGSEGV)";

	case SIGQUIT:
		return "Quit Signal";
	
	case SIGTERM:
		return "Software signal";

	default:
		return Fmt ("Unexpected signal (%d)", i);
	
	}
}

bool dump_core = False;

static void SaveDataDumpCore (win, starty)
WinInfo win;
int starty;
{
	char * ans;

	do {
		interrupt = False;
		ans = GetQuest (win, starty, "Save Data [y]: ", 1, "yn");
	}
	while (ans == (char *) 0 || interrupt);

	if (* ans == 'n')
		command_state = FASTQUIT_STATE;

	do {
		interrupt = False;
		ans = GetQuest (win, starty + 1, "Dump Core [n]: ", 1, "yn");
	}
	while (ans == (char *) 0 || interrupt);

	dump_core = * ans == 'y' ? True : False;
	
	sigrelease ();
	leave ();
}

void Panic (funcname, filename, mes)
const char * funcname, * filename, * mes;
{
	WinInfo win;
	char * ans;

	win = OpenRelToRoot (map_win, 2, 2, 80, 13, CHARS, 0);

	PrintN (win, 1, 1, "Panic: Internal Error !");
	PrintN (win, 1, 3, Fmt ("Function: %s", funcname));
	PrintN (win, 1, 4, Fmt ("File: %s", filename));
	PrintB (win, 1, 6, mes);

	do {
		interrupt = False;
		ans = GetQuest (win, 8, "Continue [y]: ", 1, GS_YN);
	}
	while (ans == (char *) 0 || interrupt);
	
	if (* ans == '\0' || * ans == 'y' || * ans == 'Y')
	{
		DestroyWindow (win);
		return;
	}

	SaveDataDumpCore (win, 10);
}

static void SignalHandler (i)
int i;
{
	WinInfo win;
	static int sig = 0;

	if (sig++ != 0) {
		if (i == SIGQUIT) {
			if (EmpireStatus () != E_DEAD) {
				fprintf (stderr, "Aborting connection\n");
				sigrelease ();
				leave0 ();
			}
			fprintf (stderr, "Closing Down be patient\n");
			return;
		}

		CloseConnection ();
		exit (-1);
	}

#ifdef TERMC_VERSION
	win = OpenRelToRoot (map_win, 2, 2, 60, 7, FULL_BOX, 0);
#else
	win = OpenRelToRoot (map_win, 2, 2, 80, 7, CHARS, 0);
#endif /* TERMC_VERSION */

	PrintN (win, 1, 1, "-=[ SIGNAL CAUGHT ]=-");

	PrintN (win, 1, 3, Fmt ("---> %s", SignalName (i)));

	if (i == SIGHUP)
		leave ();

	SaveDataDumpCore (win, 4);
}

void ResetConTimeout ()
{
	if (con_timeout > MIN_CONTIMEOUT) alarm (con_timeout);
}

void NoConTimeout ()
{
	if (con_timeout > MIN_CONTIMEOUT) alarm (0);
}

bool disconnecting = False;

void Disconnect (i)
int i;
{

	signal(SIGALRM, Disconnect);

	NoConTimeout ();

	if (EmpireStatus () != E_COMMAND) {
		alarm (con_timeout);
		return;
	}

	if (! silent_con && i == SIGALRM)
		Message ("Timesaver timeout, disconnecting....");

	disconnecting = True;

	AbortClient (silent_con ? DONT_PRINT : PRINT);

	disconnecting = False;
}

void FastQuit ()
{
	command_state = FASTQUIT_STATE;
	leave ();
}

void DoQuit ()
{
	if (BufferdCommands ())
		if (! Confirm (
		  	    "You still have buffered commands, really quit ?",
			    False))
			return;
	
	leave ();
}
