/*
    $Header: /a/victor/nexor/user4/jpo/xemp/xemp5.0/lib/clients/RCS/empire.c,v 5.3 1995/10/24 15:52:20 jpo Exp $
    $Date: 1995/10/24 15:52:20 $
    $Author: jpo $
    $Id: empire.c,v 5.3 1995/10/24 15:52:20 jpo Exp $
    $Locker:  $
    $Log: empire.c,v $
    Revision 5.3  1995/10/24 15:52:20  jpo
    Removed some termcap dependencies

    Revision 5.2  1995/09/08 07:02:37  jpo
    few consts

 * Revision 5.1  93/03/14  16:42:30  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:17:27  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.5  1993/02/06  07:55:46  greyhelm
 * Test of GNUmake checkin
 *
 * Revision 4.4  1993/02/06  04:34:59  greyhelm
 * Added RCS header - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"

WinInfo empire_win;

int empire_height, empire_width;

static char last [1024];

bool enable_empire_more = False;

#ifdef	TERMC_VERSION

#	define	AT_Y	empire_height - 1

#else

#	define	AT_Y	empire_height - 2

#endif

void InitEmpire (inc_y, inc_width, inc_height, savelines)
int inc_y, inc_width, inc_height, savelines;
{
	empire_win = OpenEmpireWindow (root_win,
				       inc_y,
				       inc_width, inc_height,
				       savelines,
				       &empire_width,
				       &empire_height);
}

void PrintAtEmpireMode (str, mode)
const char *str;
int mode;
{
	if (! xstarted)
		return;

#ifdef X_VERSION

	Scroll (empire_win, CharToPixelY (1));

#else

	Scroll (empire_win, 1);
	Refresh ();

#endif /* X_VERSION */

	if (str == (char *) 0)
	{
		fprintf (stderr, "PrintAtEmpire char * 0 ??\n");
		return;
	}

	Print (empire_win, 0, AT_Y, Fmt ("%-.*s", empire_width - 1, str), mode);

	(void) strcpy (last, str);

	if (strlen (str) > empire_width)
		PrintAtEmpireMode (str + empire_width - 1, mode);
	else
	{
		FlushWindow (empire_win);
		Refresh ();
	}
}

void PrintAtEmpire (str)
const char * str;
{
	PrintAtEmpireMode (str, NORMAL);
}

void MessageAtEmpire (str)
const char * str;
{
#ifdef TERMC_VERSION
	if (no_empwin)
		Message (Fmt ("tcemp: %s", str));
	else
		PrintAtEmpire (Fmt ("tcemp: %s", str));
#else
	PrintAtEmpire (Fmt ("xemp: %s", str));
#endif /* TERMC_VERSION */
}

void ReprintAtEmpire (str)
const char * str;
{
	int len;

	if (! xstarted)
		return;

	len = strlen (last);
	Print (empire_win, len, AT_Y,
				Fmt ("%-.*s", empire_width - 1 - len, str),
				BOLD);

	if (len + strlen (str) > empire_width - 1)
		PrintAtEmpireMode (str + empire_width - 1 - len, BOLD);
	else
		FlushWindow (empire_win);
	
	Refresh ();
}

void InputToEmpire ()
{
	char *ptr;
	int len;
	extern char *GetString ();

	enable_empire_more = True;
	for (;;)
	{
		FreeFmts ();

		do {
			len = strlen (last);
			ptr = GetString (empire_win, len, AT_Y,
					 empire_width - 1 - len, GS_TEXT);
			if (ptr == (char *) 0 &&
					(EmpireStatus () == E_COMMAND ||
					 EmpireStatus () == E_DEAD)) {
				interrupt = False;
				enable_empire_more = False;
				return;
			}
		} while (!interrupt && ptr == (char *) 0);

		if (interrupt) {
			interrupt = False;
			FeedEmpire ("aborted", PRINT);
		}
		else
			FeedEmpire (ptr, DONT_PRINT);

		(void) WaitForPrompt (PRINT);
		FlushWindow (empire_win);
	}
}

bool EmpireMore ()
{
	extern WinInfo empire_win;
	extern int empire_height;

	if (! xstarted)
		return True;

#ifdef X_VERSION
#	define	EMPIRE_MOREX	30
#else
#	define	EMPIRE_MOREX	20
#endif

	PrintB (empire_win, EMPIRE_MOREX, empire_height - 1, "[ M O R E ]");
	FlushWindow (empire_win);
	Refresh ();
	Pause ();
	PrintN (empire_win, EMPIRE_MOREX, empire_height - 1, "           ");
	FlushWindow (empire_win) ;
	Refresh ();

	if (interrupt) {
		interrupt = False;
		return False;
	}

	return True;
}
