/*
    $Header: /a/victor/nexor/user4/jpo/xemp/xemp5.0/lib/census/RCS/land.c,v 5.6 1995/09/29 07:55:05 jpo Exp $
    $Date: 1995/09/29 07:55:05 $
    $Author: jpo $
    $Id: land.c,v 5.6 1995/09/29 07:55:05 jpo Exp $
    $Locker:  $
    $Log: land.c,v $
    Revision 5.6  1995/09/29 07:55:05  jpo
    Oops - emp3server problem

    Revision 5.5  1995/09/28 12:13:35  jpo
    Fix up load a little more

    Revision 5.4  1995/09/28 08:27:03  jpo
    new load format

    Revision 5.3  1995/09/21 06:21:28  jpo
    Patrick Kenny's fix for lunload

    Revision 5.2  1995/09/08 06:58:12  jpo
    added missions, tidied up functions as a result of prototypes

 * Revision 5.1  93/03/14  16:41:49  etienne
 * added/changed some things
 * 
 * Revision 5.0  93/02/06  09:16:27  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.6  1993/02/06  07:48:54  greyhelm
 * Added gnumake mods to allow checkin and Checkout
 *
 * Revision 4.5  1993/02/06  07:45:26  greyhelm
 * Corrected extern functions - Karl Hagen
 *
 * Revision 4.4  1993/02/06  04:21:26  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "main.h"
#include "census.h"
#include "land.h"
#include "sector.h"
#include "version.h"

extern char comm_chars [];

static bool land_censenable [LND_MAX];

#ifdef TERMC_VERSION

struct s_funcbutton land_functions [] =
{
	{ LND_RADAR,	"Radar", 	1,  LL_SY_FUNCBUT,		5 },
	{ LND_SONAR,	"Sonar",	8,  LL_SY_FUNCBUT,		5 },
	{ LND_LOOKOUT,	"Look",		15, LL_SY_FUNCBUT,		4 },
	{ LND_FIRE,	"Fire",		21, LL_SY_FUNCBUT,		4 },
	{ LND_MARCH,	"March",	1,  LL_SY_FUNCBUT + 1,		5 },
	{ LND_BOARD,	"Board",	8,  LL_SY_FUNCBUT + 1,		5 },
	{ LND_TEND,	"Tend",		15, LL_SY_FUNCBUT + 1,		4 },
	{ LND_SET,	"Set",		21, LL_SY_FUNCBUT + 1,		4 },
	{ LND_SCRAP,	"Scrap",	1,  LL_SY_FUNCBUT + 2,		5 },
	{ LND_UPGRADE,	"Upgra",	8,  LL_SY_FUNCBUT + 2,		5 },
	{ LND_MINE,	"Mine",		15, LL_SY_FUNCBUT + 2,		4 },
	{ LND_TORPEDO,	"Torp",		21, LL_SY_FUNCBUT + 2,		4 }
};

#else	/* X version */

struct s_funcbutton land_functions [] = 
{
	{ LND_RADAR,	"Radar",	2,  LL_SY_FUNCBUT,		5 },
	{ LND_LOOK,	"Look ",	9,  LL_SY_FUNCBUT,		6 },
	{ LND_MARCH,	"March",	17, LL_SY_FUNCBUT,		7 },
	{ LND_FIRE,	"Fire",		2,  LL_SY_FUNCBUT + 1,		5 },
	{ LND_MINE,	"Mine",		9,  LL_SY_FUNCBUT + 1,		6 },
	{ LND_FORT,	"Fortify",	17, LL_SY_FUNCBUT + 1,		7 },
	{ LND_WORK,	"Work",		2,  LL_SY_FUNCBUT + 2,		5 },
	{ LND_SUPPLY,	"Supply",	9,  LL_SY_FUNCBUT + 2,		6 },
	{ LND_BUILD,	"Build",	17, LL_SY_FUNCBUT + 2,		7 },
	{ LND_SET,	"Set",		2,  LL_SY_FUNCBUT + 3,		5 },
	{ LND_SCRAP,	"Scrap",	9,  LL_SY_FUNCBUT + 3,		6 }, 
	{ LND_SCUTTLE,	"Scuttle",	17, LL_SY_FUNCBUT + 3,		7 }
};

#endif 

static void CenPutLandHas (x, y, s, land, c)
int x, y;
int s;
Land land;
char c;
{
	if (MaxLandCargo (land, c) > 0)
		CenPutVal (x, y, Fmt ("%d", s));
	else
		CenPutVal (x, y, "---");
}
	
static void HandleCensusButtonForLand (button, land)
int button;
Land land;
{
	Sector nxt;
	Neighb neighb;

	if (! land_censenable [button])
		return;

	switch (button)
	{

	case LND_RADAR:
		Message ("Scanning radar");
		FScanLRadar (Fmt ("%d", ld_nr (land)));
		DrawMap ();
		break;

	case LND_LOOK:
		Message ("Scanning lookout");
		DoLLookout (cursct, ld_nr (land), False, PRINT, True);
		DrawMap ();
		break;

	case LND_MARCH:
		March (Fmt ("%d", ld_nr (land)));
		CensusLand (land);
		break;

	case LND_FIRE:
		FireFromLand ();
		CensusLand (land);
		break;

	case LND_MINE:
		LMine (Fmt ("%d", ld_nr (land)));
		CensusLand (land);
		break;

		/*
		 *	XXX: should curland not being set
		 *	     to zero? (after scrap)
		 */

	case LND_SCRAP:
		ScrapLand (Fmt ("%d", ld_nr (land)));
		break;

	case LND_SCUTTLE:
		ScuttleLand (Fmt ("%d", ld_nr (land)));
		break;

	case LND_WORK:
		Work (Fmt ("%d", ld_nr (land)));
		CensusLand (land);
		break;

	case LND_FORT:
		Fortify (Fmt ("%d", ld_nr (land)));
		CensusLand (land);
		break;

	case LND_SUPPLY:
		SupplyLand (Fmt ("%d", ld_nr (land)));
		CensusLand (land);
		break;

	case LND_BUILD:
		BuildLand (10,10);
		break;

	case LND_SET:
		SetLand (land);
		break;

	default:
		break;
	}
}

	/*
	 *	This will so set x,y to the start of the commodity
	 */

static char WhichLandCommodity (x, y)
int * x, * y;
{
	if (* y >= LL_SY_STATS && * y <= LL_SY_STATS + 5)
	{
		if (ButtonPressed (* x, * y, 4, * y, 6) &&
		    * y == LL_SY_STATS + 1)
		{
			LRangeEdit (curland);
			CensusLand (curland);
			return '\0';
		}

		if (ButtonPressed (* x, * y, 13, * y, 6) &&
		    * y == LL_SY_STATS + 1)
		{
			MoraleEdit (curland);
			CensusLand (curland);
			return '\0';
		}

		if (ButtonPressed (* x, * y, 18, * y, 6) &&
		    * y == LL_SY_STATS)
		{
			if (LandHas (curland, L_LIGHT)) {
				LandToShip (Fmt ("%d", ld_nr (curland)));
				CensusLand (curland);
			}
			return '\0';
		}

		if (ButtonPressed (* x, * y, 13, * y, 6) &&
		    * y == LL_SY_STATS + 3 &&
		    landtypes [ld_type (curland)]. xpl > 0)
		{
			LLoadXPlane (curland);
			CensusLand (curland);
			return '\0';
		}

		if(ButtonPressed (* x, * y, 18, * y, 6) &&
		   * y == LL_SY_STATS + 3)
		{
			* x = 22;
			if(landtypes [ld_type (curland)]. fcar)
				return 'e';
			else
				return '\0';
		}

		if (ButtonPressed (* x, * y, 4, * y, 6) &&
		    * y == LL_SY_STATS + 4)
		{
			LMission (curland);
			CensusLand (curland);
			return '\0';
		}

		if (ButtonPressed (* x, * y, 0, * y, 10) &&
		    * y == LL_SY_STATS + 5)
		{
			LRetreat (curland);
			CensusLand (curland);
			return '\0';
		}

		return '\0';
	}
	else if (* y >= LL_SY_COM && * y < LL_SY_COM + 4)
	{
		if (ButtonPressed (* x, * y, 0, * y, 7))
		{
			* x = 4;
			return comm_chars [3 * (* y - LL_SY_COM)];
		}

		if (ButtonPressed (* x, * y, 9, * y, 7))
		{
			* x = 13;
			return comm_chars [3 * (* y - LL_SY_COM) + 1];
		}

		if (ButtonPressed (* x, * y, 18, * y, 7))
		{
			* x = 22;
			return comm_chars [3 * (* y - LL_SY_COM) + 2];
		}
	}

	return '\0';
}

void LoadUnload (land, x, y, com)
Land land;
int x, y;
char com;
{
	char * ans;
	int item, petrol_oil;  /* petrol_oil determines which to fuel with */
	int in_sct, at_land, delta, max, new, usedelta;
	bool tomuch;

	if (! ld_owned (land))
	{
		Message ("Not your Unit !!");
		return;
	}

	if ( ! s_owned (cursct)) 
	{
		Message ("You can't (un)load here !!");
		Bell ();
		return;
	}

	item = CharToItem (com);
	max = MaxLandCargo (land, com);

	if (max == 0)
	{
		Message (Fmt ("The captain refuses to take %s with him",
					  ItemName (item)));
		Bell ();
		return;
	}

	PrintN (census_win, x, y, "    ");
	ans = GetString (census_win, x, y, 4, GS_PNUMBER);

	if (interrupt || ans == (char *) 0 || * ans == '\0')
	{
		interrupt = False;
		Message ("(Un)load cancelled");
		CensusLand (land);
		return;
	}

	new = atoi (ans);

	if (new > max)
	{
		tomuch = True;
		new = max;
	}
	else
		tomuch = False;

	if(com == 'e') {
		petrol_oil = 0;	
		in_sct = GiveQuant(cursct,'p');
		if(in_sct == 0) {
			in_sct = GiveQuant(cursct,'o');
			petrol_oil = 1;
		}
                if(in_sct == 0)
		{
			Message ("There is NO Petrol or Oil Here");
			Bell();
			return;
		}
		at_land = GiveLandQuant(land,com);
		if(at_land == MaxLandCargo(land,com)) {
			Message ("Unit is already fueled up");
			Bell();
			return;
		}
		delta = new - at_land;
		if(delta <= 0) {
			CensusLand (land);
			return;
		}
			
		if(petrol_oil) {
			usedelta = (int) (delta / 50 + 0.5);
		} else {
 			usedelta = (int) (delta / 5 + 0.5);
		}
		FeedCommand (Fmt ("fuel land %d %d", ld_nr (land),
				 delta), PRINT);

		Message (Fmt ("%d fuel taken on using %d %s", delta,
				 usedelta, petrol_oil ? "oil" : "petrol"));

		if(petrol_oil) {  /* Use oil */
			/* 1 oil = 50 fuel */
			SetQuant (cursct, 'o', in_sct - usedelta);
		} else {
			/* 1 petrol = 5 fuel */
			SetQuant (cursct, 'p', in_sct - usedelta);
		}
		SetLandQuant (land, com, at_land + delta);
		DrawSector (cursct);
		CensusLand (land);
		return;
	}
	in_sct = GiveQuant (cursct, com);
	at_land = GiveLandQuant (land, com);
	delta = new - at_land;

		/* (un)load nothing */
	if (delta == 0)
	{
		if (tomuch)
		{
			Message (Fmt ("Maximum # of %s already in unit",
					ItemName (item)));
			Bell ();
		}
		else
			Message ("It's already there, sir!");

		CensusLand (land);
		return;
	}
		/* load */
	else if (delta > 0)
	{
		if (in_sct < delta)
		{
			if (in_sct == 0)
			{
				Message ("It ain't there sir!");
				Bell ();
				CensusLand (land);
				return;
			}
			else
			{
				delta = in_sct;
				tomuch = True;
				Message (Fmt ("Only %d left in this sector, sir",
						in_sct));
			}
		}

	}
	else
	{
		if (in_sct - delta > MAX_TO_LOAD)
		{
			delta = in_sct - MAX_TO_LOAD;
			tomuch = True;
			Error (Fmt (
			 "Max Sector capacity reached, unloading %d %s",
				delta, ItemName (item)));
		}
	}

	if (emp3server == 2) 
		FeedCommand (Fmt ("%sload \"%s\" %d %d",
				  (delta > 0) ? "l" : "lun",
				  ItemName (item),
				  ld_nr (land),
				  (delta > 0) ? delta : -delta),
			     PRINT);
	else
		FeedCommand (Fmt ("%sload %d %d %s",
				  (delta > 0) ? "l" : "lun",
				  ld_nr (land),
				  (delta > 0) ? delta : -delta,
				  ItemName (item)),
			     PRINT);
	

	Message (Fmt ("%soaded %s %d %s",
			(delta > 0) ? "L" : "Unl",
			tomuch ? "(only) " : "",
			(delta > 0) ? delta : -delta,
			ItemName (item)));

	SetQuant (cursct, com, in_sct - delta);
	SetLandQuant (land, com, at_land + delta);
	DrawSector (cursct);
	CensusLand (land);
}

static void CensusChangeArmy (land)
Land land;
{
	char * ans;

	PrintN (census_win, 0, AL_SY_ARMY, Fmt ("%26s", ""));
	ShowFreeArmys ();
	PrintN (census_win, 0, AL_SY_ARMY, "Add to army: ");
	ans = GetString (census_win, 14, AL_SY_ARMY, 1, "a-zA-Z~");
	if (ans == (char *) 0 || interrupt || * ans == '\0')
		interrupt = False;
	else
	{
		FeedCommand (Fmt ("army %c %d", * ans,
					ld_nr (land)), PRINT);

		set_ld_army (land, * ans);
		Message (Fmt ("%s #%d added to army '%c'",
			LandName (land), ld_nr (land), * ans));
	}

	CensusLand (land);
}

void CensusLayLand ()
{
	CenLine (LL_SY_TYPE - 1);

	CenPuts (0, LL_SY_OWNER, "Owner");

	CenPuts (0, LL_SY_STATS,     "Eff      Mob      Sh#");
	CenPuts (0, LL_SY_STATS + 1, "Ran      Ret      Frt");
	CenPuts (0, LL_SY_STATS + 2, "Att      Def      Tec");
	CenPuts (0, LL_SY_STATS + 3, "Spy      Xpl      Fue");
	CenPuts (0, LL_SY_STATS + 4, "Mis                  ");
	CenPuts (0, LL_SY_STATS + 5, "Ret                  ");

	CenLineText (LL_SY_COM - 1, "Land Commodities");

	CenPuts (0, LL_SY_COM,     "uw       foo      she");
	CenPuts (0, LL_SY_COM + 1, "gun      pet      iro");
	CenPuts (0, LL_SY_COM + 2, "bar      dus      oil");
	CenPuts (0, LL_SY_COM + 3, "lcm      hcm      rad");

	CenLine (LL_SY_BUT - 1);
	CenButton (LL_SX_SECTOR, LL_SY_BUT, "Sector", 6, False);
	CenLine (LL_SY_BUT + 1);
	CenButton (LL_SX_ARMY,  LL_SY_BUT,  "Army",  5, False);
	CenButton (LL_SX_NEXT,   LL_SY_BUT,   "Next",   4, False);
}

void LandCensus (land)
Land land;
{
	int i;
	Sector sct;

	curland = land;
	CenClr (LL_SY_TYPE);
	CenClr (LL_SY_OWNER);

	ClearCols (LL_SY_STATS, 5);
	ClearCols (LL_SY_COM, 4);

	if (land == (Land) 0)
		return;

	curarmy = ld_army (land);

	CenPutVal (0, LL_SY_TYPE, Fmt ("%s (#%d, %c)", LandName (land),
					ld_nr (land), ld_army (land)));

	if (! deity && ! ld_owned (land))
	{
		CenPuts (0, LL_SY_OWNER, "Owner: ");
		CenPutVal (7, LL_SY_OWNER, CountryName (ld_owner (land)));
	}

	for (i = 0; i < LND_MAX; i ++)
		land_censenable [i] = False;
	
	if (! ld_owned (land) && ! deity)
	{
			/*
			 *	Enemy land
			 */

		DrawCensusButtons (land_functions, LND_MAX, land_censenable);

		for (i = 0; i < 5 ; i ++)
			CenClr (LL_SY_STATS + i);

		if (ld_time (land) != (time_t) 0)
		{
			CenPutVal (0, LL_SY_STATS, Fmt ("Old position: %d,%d",
					ld_oldx (land), ld_oldy (land)));
			CenPutVal (0, LL_SY_STATS + 1, Fmt ("Dated: %s",
					DateFmt (ld_time (land))));
			CenPutVal (0, LL_SY_STATS + 2, Fmt ("Now:   %s",
					DateFmt (time ((time_t *) 0))));
		}
		else
			CenPutVal (0, LL_SY_STATS, "No previous position");
			
		return;
	}

	CenPuts (0, LL_SY_STATS,     "Eff      Mob      Sh#");
	CenPuts (0, LL_SY_STATS + 1, "Ran      Ret      Frt");
	CenPuts (0, LL_SY_STATS + 2, "Att      Def      Tec");
	CenPuts (0, LL_SY_STATS + 3, "Spy      Xpl      Fue");
	CenPuts (0, LL_SY_STATS + 4, "Mis                  ");
	CenPuts (0, LL_SY_STATS + 5, "Ret                  ");

	CenPutVal     (4,  LL_SY_STATS,     Fmt ("%-3d%%", ld_eff (land)));
	CenPutShort   (13, LL_SY_STATS,     ld_mob (land));
	if (PortableLand (land))
	{
		if (ld_shipnr (land) >= 0)
			CenPutShort   (22, LL_SY_STATS,     ld_shipnr (land));
		else
			CenPuts   (22, LL_SY_STATS, "    ");
	}
	else
		CenPutVal (22, LL_SY_STATS, "---");
	CenPutShort   (4,  LL_SY_STATS + 1, ld_arad (land));
	CenPutVal     (13, LL_SY_STATS + 1, Fmt ("%-3d%%", ld_retr (land)));
	CenPutShort   (22, LL_SY_STATS + 1, ld_fort (land));
	CenPutVal     (4,  LL_SY_STATS + 2, Fmt ("%.1f", landtypes [ld_type (land)]. att));
	CenPutVal     (13, LL_SY_STATS + 2, Fmt ("%.1f", landtypes [ld_type (land)]. def));
	CenPutShort   (22, LL_SY_STATS + 2, ld_tech (land));
	CenPutShort   (4,  LL_SY_STATS + 3, landtypes [ld_type (land)]. spy);
	if (landtypes [ld_type (land)]. xpl)
		CenPutLandHas (13, LL_SY_STATS + 3, ld_xpln (land), land, 'w');
	else
		CenPutVal     (13,  LL_SY_STATS + 3, Fmt ("---"));
	CenPutLandHas (22, LL_SY_STATS + 3, ld_fuel (land), land, 'e');
	CenPutVal     (4,  LL_SY_STATS + 4,
		       ld_mission(land) == '\0' ? "None" :
		       Fmt ("%c", ld_mission(land)));
	CenPutVal     (4,  LL_SY_STATS + 5,
		       ld_retreat(land) == RETREAT_NONE ? "No " :
		       Fmt ("to %d,%d on %s",
			    land -> rtrtx, land -> rtrty,
			    RtrtList (land -> rtrcond)));

	CenPutVal     (4 , LL_SY_COM,     "---");  /* can't carry uws */
	CenPutLandHas (13, LL_SY_COM,     ld_foo  (land), land, 'f');
	CenPutLandHas (22, LL_SY_COM,     ld_she  (land), land, 's');
	CenPutLandHas (4,  LL_SY_COM + 1, ld_gun  (land), land, 'g');
	CenPutLandHas (13, LL_SY_COM + 1, ld_pet  (land), land, 'p');
	CenPutLandHas (22, LL_SY_COM + 1, ld_iron (land), land, 'i');
	CenPutLandHas (4,  LL_SY_COM + 2, ld_bar  (land), land, 'b');
	CenPutLandHas (13, LL_SY_COM + 2, ld_dust (land), land, 'd');
	CenPutLandHas (22, LL_SY_COM + 2, ld_oil  (land), land, 'o');
	CenPutLandHas (4,  LL_SY_COM + 3, ld_lcm  (land), land, 'l');
	CenPutLandHas (13, LL_SY_COM + 3, ld_hcm  (land), land, 'h');
	CenPutLandHas (22, LL_SY_COM + 3, ld_rad  (land), land, 'r');


	land_censenable [LND_RADAR] = (landtypes [ld_type (land)]. rad > 0 && LandHas (land, L_RADAR));
	land_censenable [LND_LOOK] = True;
	land_censenable [LND_MARCH] = ld_mob (land) > 0;
	land_censenable [LND_FIRE] = (LandMaxGuns (land) > 0) &&
				(ld_eff (land) >= 60) &&
				(ld_gun (land) > 0) && 
				(ld_she (land) > 0);
	land_censenable [LND_MINE] = LandHas (land, L_ENGINEER) &&
				(ld_eff (land) >= 60) &&
				(ld_she (land) > 0);
	land_censenable [LND_SET] = trade;

	sct = LandSector (land);
	if (s_owned (sct)) {
		land_censenable [LND_SCRAP] = True;
		land_censenable [LND_SCUTTLE] = True;
	}
	land_censenable [LND_FORT] = ld_mob (land) > 0;
	land_censenable [LND_WORK] = (ld_mob (land) > 0 && LandHas (land, L_ENGINEER));
 	if (s_owned (sct) && s_des (sct) == '!' && s_eff (sct) > 59)
		land_censenable [LND_BUILD] = True;

	if (ld_shipnr (land) >=0) {
		for (i = 0; i < LND_MAX; i ++)
			land_censenable [i] = False;
	}

	land_censenable [LND_SUPPLY] = True;

	DrawCensusButtons (land_functions, LND_MAX, land_censenable);
	FlushWindow (census_win);
	Refresh ();
}

	/*
	 *	Handle census button
	 */

void LandCensusBut (x, y)
int x, y;
{
	char * ans;
	char comm;
	int i, num;

	if (y == LL_SY_BUT)
	{
		if (ButtonPressed (x, y, LL_SX_SECTOR, y, 6))
		{
			curland = (Land) 0;
			Census ();
		}
		else if (ButtonPressed (x, y, LL_SX_ARMY, y, 5))
		{
			CensusArmy (ld_army (curland));
		}
		else if (ButtonPressed (x, y, LL_SX_NEXT, y, 4))
		{
			curland = ld_nxtsct (curland);
			if (curland == (Land) 0)
				curland = s_fland (cursct);
			CensusLand (curland);
		}

		return;
	}

		/*
		 *	Armyadd
		 */

	if (y == LL_SY_TYPE)
	{
		CensusChangeArmy (curland);
		return;
	}

	i = WhichCensusButton (land_functions, LND_MAX, x, y);
	if (i != -1)
	{
		HandleCensusButtonForLand (i, curland);
		return;
	}

		/*
		 *	Load and unload
		 */

	if (! deity || ! DeityChangeLand (x, y, curland, &i))
	{
		comm = WhichLandCommodity (& x, & y);

		if (comm != '\0')
			LoadUnload (curland, x, y, comm);
	}
}

void LRangeEdit (land)
Land land;
{
	int new_range;
	char * ans, * ptr, * ptri;

	CenPuts (4, LL_SY_STATS + 1, "   ");
	ans = GetString (census_win, 4, LL_SY_STATS + 1, 3, GS_PNUMBER);

	if (ans == (char *) 0 || interrupt || * ans == 0)
	{
		Message ("Range edit cancelled");
		return;
	}

	FeedEmpire (Fmt ("lrange %d %s", ld_nr (land), ans), PRINT);
	ptr = ReadEmpire (PRINT);
	ptri = index (ptr, '#');
	if (sscanf (ptri, "#%*d reaction radius changed to %d", & new_range) != 1) {
		(void) WaitForPrompt (PRINT);
		Message ("Range edit failed");
		return;
	}

	(void) WaitForPrompt (PRINT);
	Message (Fmt ("Range of unit #%d set to %d", ld_nr (land), new_range));
	set_ld_arad (land, new_range);
}

void MoraleEdit (land)
Land land;
{
	int new_morale;
	char * ans, * ptr;

	CenPuts (13, LL_SY_STATS + 1, "   ");
	ans = GetString (census_win, 13, LL_SY_STATS + 1, 3, GS_PNUMBER);

	if (ans == (char *) 0 || interrupt || * ans == 0)
	{
		Message ("Retreat edit cancelled");
		return;
	}

	FeedEmpire (Fmt ("morale %d %s", ld_nr (land), ans), PRINT);
	ptr = ReadEmpire (PRINT);
	if (sscanf (ptr, "Unit %*d retreat percentage changed to %d", & new_morale) != 1)
	{
	(void) WaitForPrompt (PRINT);
	Message ("Retreat edit failed");
	return;
	}

	(void) WaitForPrompt (PRINT);
	Message (Fmt ("Retreat percentage of unit #%d set to %d", ld_nr (land), new_morale));
	set_ld_retr (land, new_morale);
}
