/*
    $Header: /nexor/users/jpo/xemp/xemp5.0/x/RCS/realm.c,v 5.1 1993/03/14 16:35:47 etienne Exp $
    $Date: 1993/03/14 16:35:47 $
    $Author: etienne $
    $Id: realm.c,v 5.1 1993/03/14 16:35:47 etienne Exp $
    $Locker:  $
    $Log: realm.c,v $
    Revision 5.1  1993/03/14 16:35:47  etienne
    *** empty log message ***

 * Revision 5.0  93/02/06  09:26:31  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:00:52  greyhelm
 * Add RCS logging - Karl Hagen
 *

*/
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <X11/keysymdef.h>

#include "type.h"
#include "xextern.h"
#include "main.h"
#include "sector.h"
#include "nation.h"

void ShowBox (sx, sy, ex, ey)
int sx, sy, ex, ey;
{

	int x1, y1, x2, y2;

	x1 = sx;
	x2 = ex;
	y1 = sy;
	y2 = ey;

	ConvMapPosToPixelPos (& sx, & sy);
	ConvMapPosToPixelPos (& ex, & ey);

	if (x1 > x2)
	{
		XorLine (map_win, -1, sy, ex + MapSctWidth () - 1, sy);
		XorLine (map_win, -1, ey + MapSctHeight () - 1,
			ex + MapSctWidth () - 1, ey + MapSctHeight () - 1);
		XorLine (map_win, sx, sy, 1200, sy);
		XorLine (map_win, sx, ey + MapSctHeight () - 1, 1200,
			ey + MapSctHeight () - 1);
	}
	else
	{
		XorLine (map_win, sx, sy, ex + MapSctWidth () - 1, sy);
		XorLine (map_win, sx, ey + MapSctHeight () - 1,
			ex + MapSctWidth () - 1, ey + MapSctHeight () - 1);
	}

	if (y1 > y2)
	{
		XorLine (map_win, sx, -1, sx, ey + MapSctHeight () - 1);
		XorLine (map_win, ex + MapSctWidth () - 1, -1, 
			ex + MapSctWidth () - 1, ey + MapSctHeight () - 1);
		XorLine (map_win, sx, sy, sx, 1200);
		XorLine (map_win, ex + MapSctWidth () - 1, sy,
			ex + MapSctWidth () - 1, 1200);
	}
	else
	{
		XorLine (map_win, sx, sy, sx, ey + MapSctHeight () -1);
		XorLine (map_win, ex + MapSctWidth () - 1, sy,
			ex + MapSctWidth () - 1, ey + MapSctHeight () - 1);
	}
		
	FlushWindow (map_win);
}


		/*
		 *	initial state:
		 *
		 *	left: view
		 *	middle: cancel
		 *	right: tracking state
		 *	0-9: showing state
		 *	escape: cancel
		 *
		 *	showing state:
		 *
		 *	left: do
		 *	middle: cancel show
		 *	right:
		 *		when at start/end sector, continue tracking
		 *		else delete marking and start tracking
		 *	0-9:    show new realm
		 *	escape: cancel show
		 *
		 *	tracking:
		 *
		 *	leave window: initial state
		 *	button release: if right button, showing state
		 *	left button: view
		 *	middle button: cancel tracking, initial state
		 *	escape: ^^
		 *	rest ignore
		 */

typedef enum
{
	ST_INIT,
	ST_SHOW,
	ST_TRACK
} State;

char *  MySelRealm ()
{
	XEvent event;
	Sector sct;
	State state;
	char * realm;
	char buffer [BUFSIZ];
	KeySym keysym;
	int sx, sy;
	int cx, cy;
	int nx, ny;
	int n;
	int button;
	XComposeStatus comp_status;
#ifdef lint
	sx = sy = cx = cy = 0;
#endif

	SelectEvents (map_win,
		ExposureMask |
	     	KeyPressMask |
	     	ButtonPressMask |
		ButtonReleaseMask |
		LeaveWindowMask |
		Button3MotionMask );

	MesBut ("View", "Done", "Set");
	UnmarkSector (cursct);
	state = ST_INIT;

	for (;;)
	{
		XNextEvent (display, & event);

		if (event. type == KeyPress && state != ST_INIT)
		{
			ShowBox (sx, sy, cx, cy);

			if (StandardEvent (& event))
			{
				if (interrupt)
				{
					MesClearBut ();
					MarkSector (cursct);
					return (char *) 0;
				}

				ShowBox (sx, sy, cx, cy);
				continue;
			}

			ShowBox (sx, sy, cx, cy);
		}
		else if (StandardEvent (& event))
		{
			if (interrupt)
			{
				MesClearBut ();
				MarkSector (cursct);
				return (char *) 0;
			}

			continue;
		}

		if (EventWindow (& event) != map_win)
			continue;

		switch (event. type)
		{

		case KeyPress:

			n = XLookupString (
				& (event. xkey),
				buffer,
				BUFSIZ - 1,
				& keysym,
				& comp_status);

			if (keysym == XK_Escape)
			{
				switch (state)
				{

				case ST_INIT:
					MesClearBut ();
					MarkSector (cursct);
					return (char *) 0;
				
				case ST_TRACK:
				case ST_SHOW:
					MesBut ("View", "Done", "Set");
					ShowBox (sx, sy, cx, cy);
					state = ST_INIT;
					continue;
				}
			}

			if (state == ST_TRACK)
				continue;

			if (n != 1 || buffer [0] < '0' || buffer [0] > '9')
				continue;
			
			if (state == ST_SHOW)
			{
				ShowBox (sx, sy, cx, cy);
				state = ST_INIT;
			}
			
			realm = n_realm (nation, buffer [0] - '0');

			if (! ConvRealmToCoord (realm, & sx, & sy, & cx, & cy))
			{
				MesBut ("View", "Done", "Set");
				Message (Fmt ("Warning: realm %d illegal",
							buffer [0] - '0'));
				continue;
			}

			state = ST_SHOW;
			MesBut ("Do", "Cancel", "Set");
			ShowBox (sx, sy, cx, cy);
			break;
		

		case ButtonPress:

			button = event. xbutton. button;

			if (button == LEFT_BUTTON && state == ST_SHOW)
			{
				ShowBox (sx, sy, cx, cy);
				MesClearBut ();

				MarkSector (cursct);
				return Fmt ("%s,%s",
					sx == cx ? Fmt ("%d", sx)
						 : Fmt ("%d:%d", sx, cx),
					sy == cy ? Fmt ("%d", sy)
						 : Fmt ("%d:%d", sy, cy));
			}
				
			if (button == LEFT_BUTTON)
			{
				sct = FindSector (event. xbutton. x,
						  event. xbutton. y);

				if (sct != (Sector) 0 && ! NO_INFO (sct))
					CensusSct (sct);

				continue;
			}

			if (button == MIDDLE_BUTTON)
			{
				switch (state)
				{

				case ST_INIT:
					MesClearBut ();
					MarkSector (cursct);
					return (char *) 0;

				case ST_SHOW:
				case ST_TRACK:
					MesBut ("View", "Done", "Set");
					ShowBox (sx, sy, cx, cy);
					state = ST_INIT;
					continue;
				}
			}

				/* a mouse can have more than 3 buttons */

			if (button != RIGHT_BUTTON)
				continue;

				/* 
				 *	start tracking at the upper-left
				 *	corner of the sector
				 */

			if (state == ST_TRACK)
			{
				/* impossible */

				Bell ();
				continue;
			}

			nx = event. xbutton. x;
			ny = event. xbutton. y;

			if (! ConvertToSctCrd (& nx, & ny))
				continue;

				/*
				 *	Optimalizeer state = ST_TRACK
				 */

			if (state == ST_SHOW)
			{
				ShowBox (sx, sy, cx, cy);

				/* determine if we take one of the corners
				 *
				 *	sx,sy  cx,sy
				 *
				 *      sx,cy  cx,cy
				 */

				if (nx == sx && ny == sy)
				{
					sx = cx;
					sy = cy;
					cx = nx;
					cy = ny;
					state = ST_TRACK;
					ShowBox (sx, sy, cx, cy);
					continue;
				}
				else if (nx == cx && ny == sy)
				{
					sx = sx;
					sy = cy;
					cy = ny;
					state = ST_TRACK;
					ShowBox (sx, sy, cx, cy);
					continue;
				}
				else if (nx == sx && ny == cy)
				{
					sx = cx;
					sy = sy;
					cx = nx;
					ShowBox (sx, sy, cx, cy);
					state = ST_TRACK;
					continue;
				}
				else if (nx == cx && ny == cy)
				{
					ShowBox (sx, sy, cx, cy);
					state = ST_TRACK;
					continue;
				}

				/* no, then start all over */

				sx = cx = nx;
				sy = cy = ny;
				ShowBox (sx, sy, cx, cy);

				state = ST_TRACK;
				continue;
			}
				/* state == ST_INIT */

			cx = sx = nx;
			cy = sy = ny;

			state = ST_TRACK;
			ShowBox (sx, sy, cx, cy);
			MesBut ("Do", "Cancel", "Set");
			break;


		case ButtonRelease:
			
				/* Optimalizeer */

			if (state == ST_INIT || state == ST_SHOW)
				continue;

			if (button != RIGHT_BUTTON)
				continue;

			if (sx == cx && sy == cy)
			{
				ShowBox (sx, sy, cx, cy);
				MesClearBut ();
				MarkSector (cursct);
				return Fmt ("%d,%d", sx, sy);
			}

			state = ST_SHOW;
			continue;


		case MotionNotify:

				/* Optimalizeer */
			if (state == ST_SHOW || state == ST_INIT)
				continue;

			while (XCheckTypedEvent (display, MotionNotify,
					& event) == True)
				;

			nx = event. xbutton. x;
			ny = event. xbutton. y;

			if (! ConvertToSctCrd (& nx, & ny))
				continue;

			if (nx == cx && ny == cy)
				continue;

			ShowBox (sx, sy, cx, cy);

			cx = nx;
			cy = ny;

			ShowBox (sx, sy, cx, cy);
			continue;


		case LeaveNotify:

				/* Optimalizeer */

			if (state == ST_INIT || state == ST_SHOW)
				continue;

			state = ST_SHOW;
			continue;
		}
	}
}
